/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.dashboard.tree;

import com.intellij.execution.Executor;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.dashboard.DashboardNode;
import com.intellij.execution.dashboard.DashboardRunConfigurationNode;
import com.intellij.execution.dashboard.DashboardRunConfigurationStatus;
import com.intellij.execution.dashboard.RunDashboardContributor;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManagerImpl;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.content.Content;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class RunConfigurationNode
extends AbstractTreeNode<Pair<RunnerAndConfigurationSettings, RunContentDescriptor>>
implements DashboardRunConfigurationNode {
    public RunConfigurationNode(Project project2, @NotNull Pair<RunnerAndConfigurationSettings, RunContentDescriptor> value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/execution/dashboard/tree/RunConfigurationNode", "<init>"));
        }
        super(project2, value);
    }

    @NotNull
    public RunnerAndConfigurationSettings getConfigurationSettings() {
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = (RunnerAndConfigurationSettings)((Pair)this.getValue()).getFirst();
        if (runnerAndConfigurationSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/dashboard/tree/RunConfigurationNode", "getConfigurationSettings"));
        }
        return runnerAndConfigurationSettings;
    }

    @Nullable
    public RunContentDescriptor getDescriptor() {
        return (RunContentDescriptor)((Pair)this.getValue()).getSecond();
    }

    protected void update(PresentationData presentation) {
        RunnerAndConfigurationSettings configurationSettings = this.getConfigurationSettings();
        boolean isStored = RunManager.getInstance((Project)this.getProject()).getAllConfigurationsList().contains(configurationSettings.getConfiguration());
        presentation.addText(configurationSettings.getName(), isStored ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.GRAY_ATTRIBUTES);
        RunDashboardContributor contributor = RunDashboardContributor.getContributor((ConfigurationType)configurationSettings.getType());
        Icon icon = null;
        if (contributor != null) {
            DashboardRunConfigurationStatus status = contributor.getStatus((DashboardRunConfigurationNode)this);
            if (DashboardRunConfigurationStatus.STARTED.equals(status)) {
                icon = this.getExecutorIcon();
            } else if (DashboardRunConfigurationStatus.FAILED.equals(status)) {
                icon = status.getIcon();
            }
        }
        if (icon == null) {
            icon = RunManagerEx.getInstanceEx(this.getProject()).getConfigurationIcon(configurationSettings);
        }
        presentation.setIcon(isStored ? icon : IconLoader.getDisabledIcon(icon));
        if (contributor != null) {
            contributor.updatePresentation(presentation, (DashboardNode)this);
        }
    }

    @NotNull
    public Collection<? extends AbstractTreeNode> getChildren() {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/dashboard/tree/RunConfigurationNode", "getChildren"));
        }
        return list;
    }

    @Nullable
    private Icon getExecutorIcon() {
        Executor executor;
        Content content = this.getContent();
        if (content != null && !RunContentManagerImpl.isTerminated(content) && (executor = RunContentManagerImpl.getExecutorByContent(content)) != null) {
            return executor.getIcon();
        }
        return null;
    }
}

