/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.process.ProcessInfo;
import com.intellij.execution.process.RunnerWinProcess;
import com.intellij.execution.process.UnixProcessManager;
import com.intellij.execution.process.WinProcessManager;
import com.intellij.execution.process.impl.ProcessListUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.pty4j.windows.WinPtyProcess;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jvnet.winp.WinProcess;

public class OSProcessUtil {
    private static final Logger LOG = Logger.getInstance(OSProcessUtil.class);

    @NotNull
    public static ProcessInfo[] getProcessList() {
        ProcessInfo[] processInfoArray = ProcessListUtil.getProcessList();
        if (processInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/OSProcessUtil", "getProcessList"));
        }
        return processInfoArray;
    }

    public static boolean killProcessTree(@NotNull Process process2) {
        if (process2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/execution/process/OSProcessUtil", "killProcessTree"));
        }
        if (SystemInfo.isWindows) {
            try {
                if (process2 instanceof WinPtyProcess) {
                    boolean res = WinProcessManager.kill(((WinPtyProcess)process2).getChildProcessId(), true);
                    process2.destroy();
                    return res;
                }
                if (Registry.is((String)"disable.winp")) {
                    return WinProcessManager.kill(process2, true);
                }
                OSProcessUtil.createWinProcess(process2).killRecursively();
                return true;
            }
            catch (Throwable e) {
                LOG.info("Cannot kill process tree", e);
            }
        } else if (SystemInfo.isUnix) {
            return UnixProcessManager.sendSigKillToProcessTree((Process)process2);
        }
        return false;
    }

    public static void killProcess(@NotNull Process process2) {
        if (process2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/execution/process/OSProcessUtil", "killProcess"));
        }
        OSProcessUtil.killProcess(OSProcessUtil.getProcessID(process2));
    }

    public static void killProcess(int pid) {
        block6: {
            if (SystemInfo.isWindows) {
                try {
                    if (Registry.is((String)"disable.winp")) {
                        WinProcessManager.kill(pid, false);
                        break block6;
                    }
                    OSProcessUtil.createWinProcess(pid).kill();
                }
                catch (Throwable e) {
                    LOG.info("Cannot kill process", e);
                }
            } else if (SystemInfo.isUnix) {
                UnixProcessManager.sendSignal((int)pid, (int)9);
            }
        }
    }

    public static int getProcessID(@NotNull Process process2) {
        if (process2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/execution/process/OSProcessUtil", "getProcessID"));
        }
        if (SystemInfo.isWindows) {
            try {
                if (Registry.is((String)"disable.winp")) {
                    return WinProcessManager.getProcessPid(process2);
                }
                return OSProcessUtil.createWinProcess(process2).getPid();
            }
            catch (Throwable e) {
                throw new IllegalStateException("Cannot get PID from instance of " + process2.getClass() + ", OS: " + SystemInfo.OS_NAME, e);
            }
        }
        if (SystemInfo.isUnix) {
            return UnixProcessManager.getProcessPid((Process)process2);
        }
        throw new IllegalStateException("Unknown OS: " + SystemInfo.OS_NAME);
    }

    @NotNull
    private static WinProcess createWinProcess(@NotNull Process process2) {
        if (process2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/execution/process/OSProcessUtil", "createWinProcess"));
        }
        if (process2 instanceof RunnerWinProcess) {
            process2 = ((RunnerWinProcess)process2).getOriginalProcess();
        }
        WinProcess winProcess = new WinProcess(process2);
        if (winProcess == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/OSProcessUtil", "createWinProcess"));
        }
        return winProcess;
    }

    @NotNull
    private static WinProcess createWinProcess(int pid) {
        WinProcess winProcess = new WinProcess(pid);
        if (winProcess == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/OSProcessUtil", "createWinProcess"));
        }
        return winProcess;
    }

    @Nullable
    public static List<String> getCommandLinesOfRunningProcesses() {
        ArrayList<String> result2 = new ArrayList<String>();
        for (ProcessInfo each : OSProcessUtil.getProcessList()) {
            result2.add(each.getCommandLine());
        }
        return Collections.unmodifiableList(result2);
    }
}

