/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Location;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.Filter;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.execution.testframework.TestStatusListener;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.wm.AppIconScheme;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.ui.AppIcon;
import com.intellij.ui.SystemNotifications;
import com.intellij.util.config.AbstractProperty;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestsUIUtil {
    public static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.logOnlyGroup((String)"Test Runner");
    public static final Color PASSED_COLOR = new Color(0, 128, 0);
    private static final String TESTS = "tests";

    private TestsUIUtil() {
    }

    @Nullable
    public static Object getData(AbstractTestProxy testProxy, String dataId, TestFrameworkRunningModel model) {
        RunProfile configuration;
        TestConsoleProperties properties = model.getProperties();
        Project project2 = properties.getProject();
        if (testProxy == null) {
            return null;
        }
        if (AbstractTestProxy.DATA_KEY.is(dataId)) {
            return testProxy;
        }
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            return TestsUIUtil.getOpenFileDescriptor(testProxy, model);
        }
        if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            Location location = testProxy.getLocation(project2, properties.getScope());
            if (location != null) {
                PsiElement element = location.getPsiElement();
                return element.isValid() ? element : null;
            }
            return null;
        }
        if (Location.DATA_KEY.is(dataId)) {
            return testProxy.getLocation(project2, properties.getScope());
        }
        if (RunConfiguration.DATA_KEY.is(dataId) && (configuration = properties.getConfiguration()) instanceof RunConfiguration) {
            return configuration;
        }
        return null;
    }

    public static boolean isMultipleSelectionImpossible(DataContext dataContext) {
        TreePath[] selectionPaths;
        Component component = (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(dataContext);
        return component instanceof JTree && ((selectionPaths = ((JTree)component).getSelectionPaths()) == null || selectionPaths.length <= 1);
    }

    public static Navigatable getOpenFileDescriptor(AbstractTestProxy testProxy, TestFrameworkRunningModel model) {
        TestConsoleProperties testConsoleProperties = model.getProperties();
        return TestsUIUtil.getOpenFileDescriptor(testProxy, testConsoleProperties, TestConsoleProperties.OPEN_FAILURE_LINE.value((AbstractProperty.AbstractPropertyContainer)testConsoleProperties));
    }

    private static Navigatable getOpenFileDescriptor(AbstractTestProxy proxy, TestConsoleProperties testConsoleProperties, boolean openFailureLine) {
        Project project2 = testConsoleProperties.getProject();
        if (proxy != null) {
            OpenFileDescriptor openFileDescriptor;
            Location location = proxy.getLocation(project2, testConsoleProperties.getScope());
            if (openFailureLine) {
                return proxy.getDescriptor(location, testConsoleProperties);
            }
            OpenFileDescriptor openFileDescriptor2 = openFileDescriptor = location == null ? null : location.getOpenFileDescriptor();
            if (openFileDescriptor != null && openFileDescriptor.getFile().isValid()) {
                return openFileDescriptor;
            }
        }
        return null;
    }

    public static void notifyByBalloon(@NotNull Project project2, boolean started, AbstractTestProxy root, TestConsoleProperties properties, @Nullable String comment) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/testframework/TestsUIUtil", "notifyByBalloon"));
        }
        TestsUIUtil.notifyByBalloon(project2, root, properties, new TestResultPresentation(root, started, comment).getPresentation());
    }

    public static void notifyByBalloon(@NotNull Project project2, AbstractTestProxy root, TestConsoleProperties properties, TestResultPresentation testResultPresentation) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/testframework/TestsUIUtil", "notifyByBalloon"));
        }
        if (project2.isDisposed()) {
            return;
        }
        if (properties == null) {
            return;
        }
        TestStatusListener.notifySuiteFinished(root, properties.getProject());
        String testRunDebugId = properties.isDebug() ? ToolWindowId.DEBUG : ToolWindowId.RUN;
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)project2);
        String title = testResultPresentation.getTitle();
        String text = testResultPresentation.getText();
        String balloonText = testResultPresentation.getBalloonText();
        MessageType type = testResultPresentation.getType();
        if (!Comparing.strEqual((String)toolWindowManager.getActiveToolWindowId(), (String)testRunDebugId)) {
            toolWindowManager.notifyByBalloon(testRunDebugId, type, balloonText, null, null);
        }
        NOTIFICATION_GROUP.createNotification(balloonText, type).notify(project2);
        SystemNotifications.getInstance().notify("TestRunner", title, text);
    }

    public static String getTestSummary(AbstractTestProxy proxy) {
        return new TestResultPresentation(proxy).getPresentation().getBalloonText();
    }

    public static String getTestShortSummary(AbstractTestProxy proxy) {
        return new TestResultPresentation(proxy).getPresentation().getText();
    }

    public static void showIconProgress(Project project2, int n, int maximum, int problemsCounter, boolean updateWithAttention) {
        AppIcon icon = AppIcon.getInstance();
        if (n < maximum || !updateWithAttention) {
            if ((!updateWithAttention || icon.setProgress(project2, TESTS, AppIconScheme.Progress.TESTS, (double)n / (double)maximum, problemsCounter == 0)) && problemsCounter > 0) {
                icon.setErrorBadge(project2, String.valueOf(problemsCounter));
            }
        } else if (icon.hideProgress(project2, TESTS)) {
            if (problemsCounter > 0) {
                icon.setErrorBadge(project2, String.valueOf(problemsCounter));
                icon.requestAttention(project2, false);
            } else {
                icon.setOkBadge(project2, true);
                icon.requestAttention(project2, false);
            }
        }
    }

    public static void clearIconProgress(Project project2) {
        AppIcon.getInstance().hideProgress(project2, TESTS);
        AppIcon.getInstance().setErrorBadge(project2, null);
    }

    public static class TestResultPresentation {
        private AbstractTestProxy myRoot;
        private boolean myStarted;
        private String myComment;
        private String myTitle;
        private String myText;
        private String myBalloonText;
        private MessageType myType;

        public TestResultPresentation(AbstractTestProxy root, boolean started, String comment) {
            this.myRoot = root;
            this.myStarted = started;
            this.myComment = comment;
        }

        public TestResultPresentation(AbstractTestProxy root) {
            this(root, true, null);
        }

        public String getTitle() {
            return this.myTitle;
        }

        public String getText() {
            return this.myText;
        }

        public String getBalloonText() {
            return this.myBalloonText;
        }

        public MessageType getType() {
            return this.myType;
        }

        public TestResultPresentation getPresentation() {
            List<? extends AbstractTestProxy> allTests = Filter.LEAF.select(this.myRoot.getAllTests());
            List<? extends AbstractTestProxy> failed = Filter.DEFECTIVE_LEAF.select(allTests);
            List<? extends AbstractTestProxy> notStarted = Filter.NOT_PASSED.select(allTests);
            notStarted.removeAll(failed);
            List<? extends AbstractTestProxy> ignored = Filter.IGNORED.select(allTests);
            notStarted.removeAll(ignored);
            failed.removeAll(ignored);
            int failedCount = failed.size();
            int notStartedCount = notStarted.size() + ignored.size();
            int passedCount = allTests.size() - failedCount - notStartedCount;
            return this.getPresentation(failedCount, passedCount, notStartedCount, ignored.size());
        }

        public TestResultPresentation getPresentation(int failedCount, int passedCount, int notStartedCount, int ignoredCount) {
            if (this.myRoot == null) {
                this.myTitle = this.myStarted ? "Tests were interrupted" : ExecutionBundle.message((String)"test.not.started.progress.text", (Object[])new Object[0]);
                this.myBalloonText = this.myTitle;
                this.myText = "";
                this.myType = MessageType.WARNING;
            } else {
                if (failedCount > 0) {
                    this.myTitle = ExecutionBundle.message((String)"junit.runing.info.tests.failed.label", (Object[])new Object[0]);
                    this.myText = passedCount + " passed, " + failedCount + " failed" + (notStartedCount > 0 ? ", " + notStartedCount + " not started" : "");
                    this.myType = MessageType.ERROR;
                } else if (notStartedCount > 0) {
                    this.myTitle = ignoredCount > 0 ? "Tests Ignored" : ExecutionBundle.message((String)"junit.running.info.failed.to.start.error.message", (Object[])new Object[0]);
                    this.myText = passedCount + " passed, " + notStartedCount + (ignoredCount > 0 ? " ignored" : " not started");
                    this.myType = ignoredCount > 0 ? MessageType.WARNING : MessageType.ERROR;
                } else {
                    this.myTitle = ExecutionBundle.message((String)"junit.runing.info.tests.passed.label", (Object[])new Object[0]);
                    this.myText = passedCount + " passed";
                    this.myType = MessageType.INFO;
                }
                if (this.myComment != null) {
                    this.myText = this.myText + " " + this.myComment;
                }
                this.myBalloonText = this.myTitle + ": " + this.myText;
            }
            return this;
        }
    }
}

