/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.statistics;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.internal.statistic.AbstractApplicationUsagesCollector;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class FrameworkUsagesCollector
extends AbstractApplicationUsagesCollector {
    public static final String GROUP_ID = "frameworks";

    @Override
    @NotNull
    public GroupDescriptor getGroupId() {
        GroupDescriptor groupDescriptor = GroupDescriptor.create(GROUP_ID, 100.0);
        if (groupDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/impl/statistics/FrameworkUsagesCollector", "getGroupId"));
        }
        return groupDescriptor;
    }

    @Override
    @NotNull
    public Set<UsageDescriptor> getProjectUsages(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/facet/impl/statistics/FrameworkUsagesCollector", "getProjectUsages"));
        }
        HashSet facets = new HashSet();
        for (Module module2 : ModuleManager.getInstance((Project)project2).getModules()) {
            for (Facet facet2 : FacetManager.getInstance((Module)module2).getAllFacets()) {
                facets.add(facet2.getType().getStringId());
            }
        }
        Set set2 = ContainerUtil.map2Set((Collection)facets, facet -> new UsageDescriptor((String)facet, 1));
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/impl/statistics/FrameworkUsagesCollector", "getProjectUsages"));
        }
        return set2;
    }
}

