/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.impl;

import com.intellij.find.FindBundle;
import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindSettings;
import com.intellij.find.impl.FindDialog;
import com.intellij.find.impl.FindManagerImpl;
import com.intellij.find.impl.FindPopupPanel;
import com.intellij.find.impl.FindUI;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JRootPane;
import org.jetbrains.annotations.NotNull;

public class FindUIHelper
implements Disposable {
    @NotNull
    private final Project myProject;
    @NotNull
    private FindModel myModel;
    FindModel myPreviousModel;
    @NotNull
    private Runnable myOkHandler;
    private FindUI myUI;

    public FindUIHelper(@NotNull Project project2, @NotNull FindModel model, @NotNull Runnable okHandler) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/find/impl/FindUIHelper", "<init>"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/find/impl/FindUIHelper", "<init>"));
        }
        if (okHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "okHandler", "com/intellij/find/impl/FindUIHelper", "<init>"));
        }
        this.myProject = project2;
        this.myModel = model;
        this.myOkHandler = okHandler;
        this.myUI = this.getOrCreateUI();
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public void dispose() {
                if (!Disposer.isDisposed((Disposable)FindUIHelper.this.myUI.getDisposable())) {
                    Disposer.dispose((Disposable)FindUIHelper.this.myUI.getDisposable());
                }
            }
        });
        Disposer.register((Disposable)this.myUI.getDisposable(), (Disposable)new Disposable(){

            public void dispose() {
                if (!Disposer.isDisposed((Disposable)this)) {
                    Disposer.dispose((Disposable)FindUIHelper.this);
                }
            }
        });
    }

    protected FindUI getOrCreateUI() {
        if (Registry.is((String)"ide.find.as.popup")) {
            if (this.myUI instanceof FindPopupPanel) {
                return this.myUI;
            }
            this.myUI = new FindPopupPanel(this);
            return this.myUI;
        }
        FindDialog findDialog = new FindDialog(this);
        this.registerAction("ReplaceInPath", true, findDialog);
        this.registerAction("FindInPath", false, findDialog);
        return findDialog;
    }

    private void registerAction(String actionName, final boolean replace, final FindDialog findDialog) {
        AnAction action = ActionManager.getInstance().getAction(actionName);
        JRootPane findDialogRootComponent = ((JDialog)findDialog.getWindow()).getRootPane();
        new AnAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/find/impl/FindUIHelper$3", "actionPerformed"));
                }
                FindUIHelper.this.myModel.setReplaceState(replace);
                findDialog.updateReplaceVisibility();
            }
        }.registerCustomShortcutSet(action.getShortcutSet(), (JComponent)findDialogRootComponent);
    }

    boolean canSearchThisString() {
        return this.myUI != null && (!StringUtil.isEmpty((String)this.myUI.getStringToFind()) || !this.myModel.isReplaceState() && !this.myModel.isFindAllEnabled() && this.myUI.getFileTypeMask() != null);
    }

    @NotNull
    public Project getProject() {
        Project project2 = this.myProject;
        if (project2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindUIHelper", "getProject"));
        }
        return project2;
    }

    @NotNull
    public FindModel getModel() {
        FindModel findModel = this.myModel;
        if (findModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindUIHelper", "getModel"));
        }
        return findModel;
    }

    public void setModel(@NotNull FindModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/find/impl/FindUIHelper", "setModel"));
        }
        this.myModel = model;
        this.myUI.initByModel();
        this.myUI.updateReplaceVisibility();
    }

    public void setOkHandler(@NotNull Runnable okHandler) {
        if (okHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "okHandler", "com/intellij/find/impl/FindUIHelper", "setOkHandler"));
        }
        this.myOkHandler = okHandler;
    }

    public void showUI() {
        this.myUI = this.getOrCreateUI();
        this.myUI.showUI();
    }

    public void dispose() {
        this.myUI = null;
    }

    void updateFindSettings() {
        FindSettings findSettings = FindSettings.getInstance();
        findSettings.setCaseSensitive(this.myModel.isCaseSensitive());
        if (this.myModel.isReplaceState()) {
            findSettings.setPreserveCase(this.myModel.isPreserveCase());
        }
        findSettings.setWholeWordsOnly(this.myModel.isWholeWordsOnly());
        boolean saveContextBetweenRestarts = false;
        findSettings.setInStringLiteralsOnly(saveContextBetweenRestarts && this.myModel.isInStringLiteralsOnly());
        findSettings.setInCommentsOnly(saveContextBetweenRestarts && this.myModel.isInCommentsOnly());
        findSettings.setExceptComments(saveContextBetweenRestarts && this.myModel.isExceptComments());
        findSettings.setExceptStringLiterals(saveContextBetweenRestarts && this.myModel.isExceptStringLiterals());
        findSettings.setExceptCommentsAndLiterals(saveContextBetweenRestarts && this.myModel.isExceptCommentsAndStringLiterals());
        findSettings.setRegularExpressions(this.myModel.isRegularExpressions());
        if (!this.myModel.isMultipleFiles()) {
            findSettings.setForward(this.myModel.isForward());
            findSettings.setFromCursor(this.myModel.isFromCursor());
            findSettings.setGlobal(this.myModel.isGlobal());
        } else {
            String directoryName = this.myModel.getDirectoryName();
            if (directoryName != null && !directoryName.isEmpty()) {
                findSettings.setWithSubdirectories(this.myModel.isWithSubdirectories());
            } else if (StringUtil.isEmpty((String)this.myModel.getModuleName()) && this.myModel.getCustomScopeName() != null) {
                findSettings.setCustomScope(this.myModel.getCustomScopeName());
            }
        }
        findSettings.setFileMask(this.myModel.getFileFilter());
    }

    boolean isUseSeparateView() {
        return FindSettings.getInstance().isShowResultsInSeparateView();
    }

    boolean isSkipResultsWithOneUsage() {
        return FindSettings.getInstance().isSkipResultsWithOneUsage();
    }

    void setUseSeparateView(boolean separateView) {
        if (this.myModel.isOpenInNewTabEnabled()) {
            this.myModel.setOpenInNewTab(separateView);
        }
        FindSettings.getInstance().setShowResultsInSeparateView(separateView);
    }

    void setSkipResultsWithOneUsage(boolean skip) {
        if (!this.isReplaceState()) {
            FindSettings.getInstance().setSkipResultsWithOneUsage(skip);
        }
    }

    String getTitle() {
        if (this.myModel.isReplaceState()) {
            if (this.myModel.isMultipleFiles()) {
                return FindBundle.message("find.replace.in.project.dialog.title", new Object[0]);
            }
            return FindBundle.message("find.replace.text.dialog.title", new Object[0]);
        }
        if (this.myModel.isMultipleFiles()) {
            return FindBundle.message("find.in.path.dialog.title", new Object[0]);
        }
        return FindBundle.message("find.text.dialog.title", new Object[0]);
    }

    public boolean isReplaceState() {
        return this.myModel.isReplaceState();
    }

    @NotNull
    public Runnable getOkHandler() {
        Runnable runnable2 = this.myOkHandler;
        if (runnable2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindUIHelper", "getOkHandler"));
        }
        return runnable2;
    }

    public void doOKAction() {
        ((FindManagerImpl)FindManager.getInstance((Project)this.myProject)).changeGlobalSettings(this.myModel);
        this.myOkHandler.run();
    }
}

