/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.customize;

import com.intellij.CommonBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.customize.AbstractCustomizeWizardStep;
import com.intellij.ide.customize.CustomizePluginsStepPanel;
import com.intellij.ide.customize.PluginGroups;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.internal.statistic.ideSettings.IdeInitialConfigButtonUsages;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NotNull;

public class CustomizeFeaturedPluginsStepPanel
extends AbstractCustomizeWizardStep {
    private static final int COLS = 3;
    private static final ExecutorService ourService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"CustomizeFeaturedPluginsStepPanel pool", (int)4);
    public final AtomicBoolean myCanceled = new AtomicBoolean(false);
    private final PluginGroups myPluginGroups;
    private final JLabel myInProgressLabel;

    public CustomizeFeaturedPluginsStepPanel(PluginGroups pluginGroups) {
        this.setLayout(new GridLayout(1, 1));
        this.myInProgressLabel = new JLabel("Loading...", 0);
        this.add(this.myInProgressLabel);
        this.myPluginGroups = pluginGroups;
        this.myPluginGroups.setLoadingCallback(() -> this.onPluginGroupsLoaded());
    }

    private void onPluginGroupsLoaded() {
        List<IdeaPluginDescriptor> pluginsFromRepository = this.myPluginGroups.getPluginsFromRepository();
        if (pluginsFromRepository.isEmpty()) {
            this.myInProgressLabel.setText("Cannot get featured plugins description online.");
            return;
        }
        this.removeAll();
        JPanel gridPanel = new JPanel(new GridLayout(0, 3));
        JBScrollPane scrollPane = CustomizePluginsStepPanel.createScrollPane(gridPanel);
        Map<String, String> config = this.myPluginGroups.getFeaturedPlugins();
        for (Map.Entry<String, String> entry : config.entrySet()) {
            JPanel groupPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = 1;
            gbc.anchor = 17;
            gbc.gridwidth = 0;
            gbc.weightx = 1.0;
            String title = entry.getKey();
            String s = entry.getValue();
            int i2 = s.indexOf(58);
            String topic = s.substring(0, i2);
            int j = s.indexOf(58, i2 + 1);
            String description = s.substring(i2 + 1, j);
            String pluginId = s.substring(j + 1);
            IdeaPluginDescriptor foundDescriptor = null;
            for (IdeaPluginDescriptor descriptor : pluginsFromRepository) {
                if (!descriptor.getPluginId().getIdString().equals(pluginId) || PluginManagerCore.isBrokenPlugin(descriptor)) continue;
                foundDescriptor = descriptor;
                break;
            }
            if (foundDescriptor == null) continue;
            final IdeaPluginDescriptor descriptor = foundDescriptor;
            boolean isVIM = "IdeaVIM".equals(descriptor.getPluginId().getIdString());
            boolean isCloud = "#Cloud".equals(topic);
            if (isCloud) {
                title = descriptor.getName();
                description = StringUtil.defaultIfEmpty((String)descriptor.getDescription(), (String)"No description available");
                topic = StringUtil.defaultIfEmpty((String)descriptor.getCategory(), (String)"Unknown");
            }
            JLabel titleLabel = new JLabel("<html><body><h2 style=\"text-align:left;\">" + title + "</h2></body></html>");
            JLabel topicLabel = new JLabel("<html><body><h4 style=\"text-align:left;color:#808080;font-weight:bold;\">" + topic + "</h4></body></html>");
            JLabel descriptionLabel = CustomizeFeaturedPluginsStepPanel.createHTMLLabel(description);
            JLabel warningLabel = null;
            if (isVIM || isCloud) {
                if (isCloud) {
                    warningLabel = CustomizeFeaturedPluginsStepPanel.createHTMLLabel("From your JetBrains account");
                    warningLabel.setIcon(AllIcons.General.BalloonInformation);
                } else {
                    warningLabel = CustomizeFeaturedPluginsStepPanel.createHTMLLabel("Recommended only if you are<br> familiar with Vim.");
                    warningLabel.setIcon(AllIcons.General.BalloonWarning);
                }
                if (!SystemInfo.isWindows) {
                    UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.SMALL, (Component)warningLabel);
                }
            }
            final CardLayout wrapperLayout = new CardLayout();
            final JPanel buttonWrapper = new JPanel(wrapperLayout);
            final JButton installButton = new JButton(isVIM ? "Install and Enable" : "Install");
            final JProgressBar progressBar = new JProgressBar(0, 100);
            progressBar.setStringPainted(true);
            JPanel progressPanel = new JPanel((LayoutManager)new VerticalFlowLayout(true, false));
            progressPanel.add(progressBar);
            LinkLabel cancelLink = new LinkLabel("Cancel", AllIcons.Actions.Cancel);
            JPanel linkWrapper = new JPanel(new FlowLayout(1, 0, 0));
            linkWrapper.add((Component)cancelLink);
            progressPanel.add(linkWrapper);
            JPanel buttonPanel = new JPanel((LayoutManager)new VerticalFlowLayout(0, 0));
            buttonPanel.add(installButton);
            buttonWrapper.add((Component)buttonPanel, "button");
            buttonWrapper.add((Component)progressPanel, "progress");
            wrapperLayout.show(buttonWrapper, "button");
            final AbstractProgressIndicatorExBase indicator = new AbstractProgressIndicatorExBase(true){

                @Override
                public void start() {
                    CustomizeFeaturedPluginsStepPanel.this.myCanceled.set(false);
                    super.start();
                    SwingUtilities.invokeLater(() -> wrapperLayout.show(buttonWrapper, "progress"));
                }

                @Override
                public void processFinish() {
                    super.processFinish();
                    SwingUtilities.invokeLater(() -> {
                        wrapperLayout.show(buttonWrapper, "button");
                        installButton.setEnabled(false);
                        installButton.setText("Installed");
                    });
                }

                @Override
                public void setFraction(double fraction) {
                    super.setFraction(fraction);
                    SwingUtilities.invokeLater(() -> {
                        int value = (int)(100.0 * fraction + 0.5);
                        progressBar.setValue(value);
                        progressBar.setString(value + "%");
                    });
                }

                @Override
                public void cancel() {
                    this.stop();
                    CustomizeFeaturedPluginsStepPanel.this.myCanceled.set(true);
                    super.cancel();
                    SwingUtilities.invokeLater(() -> {
                        wrapperLayout.show(buttonWrapper, "button");
                        progressBar.setValue(0);
                        progressBar.setString("0%");
                    });
                }
            };
            installButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    wrapperLayout.show(buttonWrapper, "progress");
                    ourService.execute(new Runnable(){

                        @Override
                        public void run() {
                            block2: {
                                try {
                                    indicator.start();
                                    IdeInitialConfigButtonUsages.addDownloadedPlugin(descriptor.getPluginId().getIdString());
                                    PluginDownloader downloader = PluginDownloader.createDownloader(descriptor);
                                    downloader.prepareToInstall(indicator);
                                    downloader.install();
                                    indicator.processFinish();
                                }
                                catch (Exception ignored) {
                                    if (CustomizeFeaturedPluginsStepPanel.this.myCanceled.get()) break block2;
                                    this.onFail();
                                }
                            }
                        }

                        void onFail() {
                            SwingUtilities.invokeLater(() -> {
                                indicator.stop();
                                wrapperLayout.show(buttonWrapper, "progress");
                                progressBar.setString("Cannot download plugin");
                            });
                        }
                    });
                }
            });
            cancelLink.setListener(new LinkListener(){

                public void linkSelected(LinkLabel aSource, Object aLinkData) {
                    indicator.cancel();
                }
            }, null);
            gbc.insets.left = installButton.getInsets().left / 2;
            gbc.insets.right = installButton.getInsets().right / 2;
            gbc.insets.bottom = -5;
            groupPanel.add((Component)titleLabel, gbc);
            gbc.insets.bottom = 10;
            groupPanel.add((Component)topicLabel, gbc);
            groupPanel.add((Component)descriptionLabel, gbc);
            gbc.weighty = 1.0;
            groupPanel.add(Box.createVerticalGlue(), gbc);
            gbc.weighty = 0.0;
            if (warningLabel != null) {
                Insets insetsBefore = gbc.insets;
                gbc.insets = new Insets(0, -10, 10, -10);
                gbc.insets.left += insetsBefore.left;
                gbc.insets.right += insetsBefore.right;
                JPanel warningPanel = new JPanel(new BorderLayout());
                warningPanel.setBorder(new EmptyBorder(5, 10, 5, 10));
                warningPanel.add(warningLabel);
                groupPanel.add((Component)warningPanel, gbc);
                gbc.insets = insetsBefore;
            }
            gbc.insets.right = 0;
            gbc.insets.left = 0;
            gbc.insets.bottom = 0;
            groupPanel.add((Component)buttonWrapper, gbc);
            gridPanel.add(groupPanel);
        }
        while (gridPanel.getComponentCount() < 4) {
            gridPanel.add(Box.createVerticalBox());
        }
        int cursor = 0;
        Component[] components = gridPanel.getComponents();
        int rowCount = components.length / 3;
        for (Component component : components) {
            ((JComponent)component).setBorder(new CompoundBorder((Border)new CustomLineBorder(ColorUtil.withAlpha((Color)JBColor.foreground(), (double)0.2), 0, 0, cursor / 3 < rowCount && !(component instanceof Box) ? 1 : 0, cursor % 3 != 2 && !(component instanceof Box) ? 1 : 0){

                protected Color getColor() {
                    return ColorUtil.withAlpha((Color)JBColor.foreground(), (double)0.2);
                }
            }, BorderFactory.createEmptyBorder(0, 10, 0, 10)));
            ++cursor;
        }
        this.add((Component)scrollPane);
        this.revalidate();
        this.repaint();
    }

    @NotNull
    private static JLabel createHTMLLabel(String text) {
        JLabel jLabel = new JLabel("<html><body>" + text + "</body></html>"){

            @Override
            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                size.width = Math.min(size.width, 200);
                return size;
            }
        };
        if (jLabel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/customize/CustomizeFeaturedPluginsStepPanel", "createHTMLLabel"));
        }
        return jLabel;
    }

    @Override
    public String getTitle() {
        return "Featured plugins";
    }

    @Override
    public String getHTMLHeader() {
        return "<html><body><h2>Download featured plugins</h2>We have a few plugins in our repository that most users like to download. Perhaps, you need them too?</body></html>";
    }

    @Override
    public String getHTMLFooter() {
        return "New plugins can also be downloaded in " + CommonBundle.settingsTitle() + " | Plugins";
    }
}

