/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.impl;

import com.intellij.ide.fileTemplates.impl.DefaultTemplate;
import com.intellij.ide.fileTemplates.impl.FTManager;
import com.intellij.ide.fileTemplates.impl.UrlUtil;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.cl.PluginClassLoader;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.ex.FileTypeManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.project.ProjectKt;
import com.intellij.util.lang.UrlClassLoader;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileTemplatesLoader {
    private static final Logger LOG = Logger.getInstance((String)("#" + FileTemplatesLoader.class.getName()));
    static final String TEMPLATES_DIR = "fileTemplates";
    private static final String DEFAULT_TEMPLATES_ROOT = "fileTemplates";
    public static final String DESCRIPTION_FILE_EXTENSION = "html";
    private static final String DESCRIPTION_EXTENSION_SUFFIX = ".html";
    private final FTManager myDefaultTemplatesManager;
    private final FTManager myInternalTemplatesManager;
    private final FTManager myPatternsManager;
    private final FTManager myCodeTemplatesManager;
    private final FTManager myJ2eeTemplatesManager;
    private final Map<String, FTManager> myDirToManagerMap;
    private final FTManager[] myAllManagers;
    private static final String INTERNAL_DIR = "internal";
    private static final String INCLUDES_DIR = "includes";
    private static final String CODE_TEMPLATES_DIR = "code";
    private static final String J2EE_TEMPLATES_DIR = "j2ee";
    private final FileTypeManagerEx myTypeManager;
    private URL myDefaultTemplateDescription;
    private URL myDefaultIncludeDescription;

    protected FileTemplatesLoader(@NotNull FileTypeManagerEx typeManager, @Nullable Project project2) {
        if (typeManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeManager", "com/intellij/ide/fileTemplates/impl/FileTemplatesLoader", "<init>"));
        }
        this.myDirToManagerMap = new HashMap<String, FTManager>();
        this.myTypeManager = typeManager;
        File configDir = project2 == null || project2.isDefault() ? new File(PathManager.getConfigPath(), "fileTemplates") : new File(ProjectKt.getStateStore(project2).getDirectoryStorePath(true) + "/" + "fileTemplates");
        this.myDefaultTemplatesManager = new FTManager("Default", configDir);
        this.myInternalTemplatesManager = new FTManager("Internal", new File(configDir, INTERNAL_DIR), true);
        this.myPatternsManager = new FTManager("Includes", new File(configDir, INCLUDES_DIR));
        this.myCodeTemplatesManager = new FTManager("Code", new File(configDir, CODE_TEMPLATES_DIR));
        this.myJ2eeTemplatesManager = new FTManager("J2EE", new File(configDir, J2EE_TEMPLATES_DIR));
        this.myAllManagers = new FTManager[]{this.myDefaultTemplatesManager, this.myInternalTemplatesManager, this.myPatternsManager, this.myCodeTemplatesManager, this.myJ2eeTemplatesManager};
        this.myDirToManagerMap.put("", this.myDefaultTemplatesManager);
        this.myDirToManagerMap.put("internal/", this.myInternalTemplatesManager);
        this.myDirToManagerMap.put("includes/", this.myPatternsManager);
        this.myDirToManagerMap.put("code/", this.myCodeTemplatesManager);
        this.myDirToManagerMap.put("j2ee/", this.myJ2eeTemplatesManager);
        this.loadDefaultTemplates();
        for (FTManager manager : this.myAllManagers) {
            manager.loadCustomizedContent();
        }
    }

    @NotNull
    protected FTManager[] getAllManagers() {
        if (this.myAllManagers == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/impl/FileTemplatesLoader", "getAllManagers"));
        }
        return this.myAllManagers;
    }

    @NotNull
    FTManager getDefaultTemplatesManager() {
        FTManager fTManager = new FTManager(this.myDefaultTemplatesManager);
        if (fTManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/impl/FileTemplatesLoader", "getDefaultTemplatesManager"));
        }
        return fTManager;
    }

    @NotNull
    FTManager getInternalTemplatesManager() {
        FTManager fTManager = new FTManager(this.myInternalTemplatesManager);
        if (fTManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/impl/FileTemplatesLoader", "getInternalTemplatesManager"));
        }
        return fTManager;
    }

    FTManager getPatternsManager() {
        return new FTManager(this.myPatternsManager);
    }

    FTManager getCodeTemplatesManager() {
        return new FTManager(this.myCodeTemplatesManager);
    }

    FTManager getJ2eeTemplatesManager() {
        return new FTManager(this.myJ2eeTemplatesManager);
    }

    public URL getDefaultTemplateDescription() {
        return this.myDefaultTemplateDescription;
    }

    public URL getDefaultIncludeDescription() {
        return this.myDefaultIncludeDescription;
    }

    private void loadDefaultTemplates() {
        HashSet<URL> processedUrls = new HashSet<URL>();
        for (IdeaPluginDescriptor plugin : PluginManagerCore.getPlugins()) {
            ClassLoader loader;
            if (!(plugin instanceof IdeaPluginDescriptorImpl) || !((IdeaPluginDescriptorImpl)plugin).isEnabled() || (loader = plugin.getPluginClassLoader()) instanceof PluginClassLoader && ((PluginClassLoader)((Object)loader)).getUrls().isEmpty()) continue;
            try {
                Enumeration<URL> systemResources = loader.getResources("fileTemplates");
                if (!systemResources.hasMoreElements()) continue;
                while (systemResources.hasMoreElements()) {
                    URL url = systemResources.nextElement();
                    if (processedUrls.contains(url)) continue;
                    processedUrls.add(url);
                    this.loadDefaultsFromRoot(url);
                }
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    private void loadDefaultsFromRoot(URL root) throws IOException {
        List<String> children2 = UrlUtil.getChildrenRelativePaths(root);
        if (children2.isEmpty()) {
            return;
        }
        HashSet<String> descriptionPaths = new HashSet<String>();
        for (String path : children2) {
            if (path.equals("default.html")) {
                this.myDefaultTemplateDescription = UrlClassLoader.internProtocol((URL)new URL(root.toExternalForm() + "/" + path));
                continue;
            }
            if (path.equals("includes/default.html")) {
                this.myDefaultIncludeDescription = UrlClassLoader.internProtocol((URL)new URL(root.toExternalForm() + "/" + path));
                continue;
            }
            if (!path.endsWith(DESCRIPTION_EXTENSION_SUFFIX)) continue;
            descriptionPaths.add(path);
        }
        block1: for (String path : children2) {
            for (Map.Entry<String, FTManager> entry : this.myDirToManagerMap.entrySet()) {
                URL descriptionUrl;
                String prefix = entry.getKey();
                if (!FileTemplatesLoader.matchesPrefix(path, prefix)) continue;
                if (!path.endsWith(".ft")) continue block1;
                String filename = path.substring(prefix.length(), path.length() - ".ft".length());
                String extension = this.myTypeManager.getExtension(filename);
                String templateName = filename.substring(0, filename.length() - extension.length() - 1);
                URL templateUrl = UrlClassLoader.internProtocol((URL)new URL(root.toExternalForm() + "/" + path));
                String descriptionPath = FileTemplatesLoader.getDescriptionPath(prefix, templateName, extension, descriptionPaths);
                URL uRL = descriptionUrl = descriptionPath != null ? UrlClassLoader.internProtocol((URL)new URL(root.toExternalForm() + "/" + descriptionPath)) : null;
                assert (templateUrl != null);
                entry.getValue().addDefaultTemplate(new DefaultTemplate(templateName, extension, templateUrl, descriptionUrl));
                continue block1;
            }
        }
    }

    private static boolean matchesPrefix(String path, String prefix) {
        if (prefix.length() == 0) {
            return !path.contains("/");
        }
        return FileUtil.startsWith((String)path, (String)prefix) && !path.substring(prefix.length()).contains("/");
    }

    @Nullable
    private static String getDescriptionPath(String pathPrefix, String templateName, String templateExtension, Set<String> descriptionPaths) {
        String descPath;
        Locale locale = Locale.getDefault();
        String descName = MessageFormat.format("{0}.{1}_{2}_{3}.html", templateName, templateExtension, locale.getLanguage(), locale.getCountry());
        String string = descPath = pathPrefix.length() > 0 ? pathPrefix + descName : descName;
        if (descriptionPaths.contains(descPath)) {
            return descPath;
        }
        descName = MessageFormat.format("{0}.{1}_{2}.html", templateName, templateExtension, locale.getLanguage());
        String string2 = descPath = pathPrefix.length() > 0 ? pathPrefix + descName : descName;
        if (descriptionPaths.contains(descPath)) {
            return descPath;
        }
        descName = templateName + "." + templateExtension + DESCRIPTION_EXTENSION_SUFFIX;
        String string3 = descPath = pathPrefix.length() > 0 ? pathPrefix + descName : descName;
        if (descriptionPaths.contains(descPath)) {
            return descPath;
        }
        return null;
    }
}

