/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl.dataRules;

import com.intellij.ide.impl.dataRules.GetDataRule;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;

public class VirtualFileRule
implements GetDataRule {
    @Override
    public Object getData(DataProvider dataProvider) {
        VirtualFile[] virtualFiles;
        PsiElement[] psiElements = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(dataProvider);
        if (psiElements != null) {
            for (PsiElement elem : psiElements) {
                VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)elem);
                if (virtualFile == null) continue;
                return virtualFile;
            }
        }
        if ((virtualFiles = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataProvider)) != null && virtualFiles.length == 1) {
            return virtualFiles[0];
        }
        PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataProvider);
        if (psiFile != null) {
            return psiFile.getVirtualFile();
        }
        PsiElement elem = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataProvider);
        if (elem == null) {
            return null;
        }
        return PsiUtilCore.getVirtualFile((PsiElement)elem);
    }
}

