/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.actions;

import com.intellij.CommonBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ImportModuleFromImlFileAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.projectView.actions.ImportModuleFromImlFileAction");

    public void actionPerformed(AnActionEvent e) {
        VirtualFile[] files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        Project project2 = ImportModuleFromImlFileAction.getEventProject((AnActionEvent)e);
        if (files == null || project2 == null) {
            return;
        }
        try {
            ModifiableModuleModel model = ModuleManager.getInstance((Project)project2).getModifiableModel();
            for (VirtualFile file2 : files) {
                model.loadModule(file2.getPath());
            }
            WriteAction.run(() -> model.commit());
        }
        catch (Exception ex) {
            LOG.info((Throwable)ex);
            Messages.showErrorDialog((Project)project2, (String)("Cannot import module: " + ex.getMessage()), (String)CommonBundle.getErrorTitle());
        }
    }

    public void update(AnActionEvent e) {
        List<VirtualFile> modules = ImportModuleFromImlFileAction.getModuleNames(e);
        Presentation presentation = e.getPresentation();
        boolean visible = !modules.isEmpty();
        presentation.setVisible(visible);
        presentation.setEnabled(visible);
        String text = modules.size() > 1 ? "Import " + modules.size() + " Modules" : (modules.size() == 1 ? "Import '" + modules.get(0).getNameWithoutExtension() + "' Module" : this.getTemplatePresentation().getText());
        presentation.setText(text);
    }

    private static List<VirtualFile> getModuleNames(AnActionEvent e) {
        VirtualFile[] files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        Project project2 = ImportModuleFromImlFileAction.getEventProject((AnActionEvent)e);
        if (project2 == null || files == null || files.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<VirtualFile> modulesFiles = new ArrayList<VirtualFile>();
        for (VirtualFile file2 : files) {
            if (!file2.getFileType().equals(StdFileTypes.IDEA_MODULE)) {
                return Collections.emptyList();
            }
            modulesFiles.add(file2);
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project2);
        for (Module module2 : moduleManager.getModules()) {
            modulesFiles.remove(module2.getModuleFile());
        }
        return modulesFiles;
    }
}

