/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.LibrariesElement;
import com.intellij.ide.projectView.impl.nodes.PackageUtil;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PlatformIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PackageViewLibrariesNode
extends ProjectViewNode<LibrariesElement> {
    public PackageViewLibrariesNode(Project project2, Module module2, ViewSettings viewSettings) {
        super(project2, (Object)new LibrariesElement(module2, project2), viewSettings);
    }

    public boolean contains(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/projectView/impl/nodes/PackageViewLibrariesNode", "contains"));
        }
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)this.getProject()).getFileIndex();
        if (!index.isInLibrarySource(file2) && !index.isInLibraryClasses(file2)) {
            return false;
        }
        return this.someChildContainsFile(file2, false);
    }

    @NotNull
    public Collection<AbstractTreeNode> getChildren() {
        Collection collection = (Collection)ProjectViewDirectoryHelper.calculateYieldingToWriteAction(() -> {
            ArrayList<VirtualFile> roots = new ArrayList<VirtualFile>();
            Module myModule = ((LibrariesElement)this.getValue()).getModule();
            if (myModule == null) {
                Module[] modules;
                for (Module module2 : modules = ModuleManager.getInstance((Project)this.getProject()).getModules()) {
                    PackageViewLibrariesNode.addModuleLibraryRoots(ModuleRootManager.getInstance((Module)module2), roots);
                }
            } else {
                PackageViewLibrariesNode.addModuleLibraryRoots(ModuleRootManager.getInstance((Module)myModule), roots);
            }
            return PackageUtil.createPackageViewChildrenOnFiles(roots, this.getProject(), this.getSettings(), null, true);
        });
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/nodes/PackageViewLibrariesNode", "getChildren"));
        }
        return collection;
    }

    public boolean someChildContainsFile(VirtualFile file2) {
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)this.getProject()).getFileIndex();
        if (!index.isInLibrarySource(file2) && !index.isInLibraryClasses(file2)) {
            return false;
        }
        return super.someChildContainsFile(file2);
    }

    private static void addModuleLibraryRoots(ModuleRootManager moduleRootManager, List<VirtualFile> roots) {
        VirtualFile[] files;
        for (VirtualFile file2 : files = moduleRootManager.orderEntries().withoutModuleSourceEntries().withoutDepModules().classes().getRoots()) {
            if (file2.getFileSystem() instanceof JarFileSystem && file2.getParent() != null) continue;
            roots.add(file2);
        }
    }

    public void update(PresentationData presentation) {
        presentation.setPresentableText(IdeBundle.message((String)"node.projectview.libraries", (Object[])new Object[0]));
        presentation.setIcon(PlatformIcons.LIBRARY_ICON);
    }

    public String getTestPresentation() {
        return "Libraries";
    }

    public boolean shouldUpdateData() {
        return true;
    }

    public int getWeight() {
        return 60;
    }
}

