/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.search;

import com.intellij.codeStyle.CodeStyleFacade;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.ui.search.ConfigurableHit;
import com.intellij.ide.ui.search.IndexedCharsInterner;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.ide.ui.search.PorterStemmerUtil;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.ide.ui.search.SearchableOptionsRegistrar;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ResourceUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.ByteArrayCharSequence;
import com.intellij.util.text.CharSequenceHashingStrategy;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.event.DocumentEvent;
import org.jdom.Document;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SearchableOptionsRegistrarImpl
extends SearchableOptionsRegistrar {
    private final Map<CharSequence, long[]> myStorage = Collections.synchronizedMap(new THashMap(20, 0.9f, (TObjectHashingStrategy)CharSequenceHashingStrategy.CASE_SENSITIVE));
    private final Set<String> myStopWords = Collections.synchronizedSet(new THashSet());
    private final Map<Couple<String>, Set<String>> myHighlightOption2Synonym = Collections.synchronizedMap(new THashMap());
    private volatile boolean allTheseHugeFilesAreLoaded;
    private final IndexedCharsInterner myIdentifierTable = new IndexedCharsInterner(){

        @Override
        public synchronized int toId(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/ide/ui/search/SearchableOptionsRegistrarImpl$1", "toId"));
            }
            return super.toId(name);
        }

        @Override
        @NotNull
        public synchronized CharSequence fromId(int id) {
            CharSequence charSequence = super.fromId(id);
            if (charSequence == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/ui/search/SearchableOptionsRegistrarImpl$1", "fromId"));
            }
            return charSequence;
        }
    };
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.ui.search.SearchableOptionsRegistrarImpl");
    private static final int LOAD_FACTOR = 20;
    @NonNls
    private static final Pattern REG_EXP = Pattern.compile("[\\W&&[^-]]+");

    public SearchableOptionsRegistrarImpl() {
        if (ApplicationManager.getApplication().isCommandLine() || ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        try {
            String text = ResourceUtil.loadText((URL)ResourceUtil.getResource(SearchableOptionsRegistrarImpl.class, (String)"/search/", (String)"ignore.txt"));
            Object[] stopWords = text.split("[\\W]");
            ContainerUtil.addAll(this.myStopWords, (Object[])stopWords);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private void loadHugeFilesIfNecessary() {
        if (this.allTheseHugeFilesAreLoaded) {
            return;
        }
        this.allTheseHugeFilesAreLoaded = true;
        try {
            String groupName;
            String id;
            Element configurable;
            URL indexResource = ResourceUtil.getResource(SearchableOptionsRegistrar.class, (String)"/search/", (String)"searchableOptions.xml");
            if (indexResource == null) {
                LOG.info("No /search/searchableOptions.xml found, settings search won't work!");
                return;
            }
            Document document = JDOMUtil.loadDocument((URL)indexResource);
            Element root = document.getRootElement();
            List configurables = root.getChildren("configurable");
            for (Object o : configurables) {
                configurable = (Element)o;
                id = configurable.getAttributeValue("id");
                groupName = configurable.getAttributeValue("configurable_name");
                List options = configurable.getChildren("option");
                for (Object o1 : options) {
                    Element optionElement = (Element)o1;
                    String option = optionElement.getAttributeValue("name");
                    String path = optionElement.getAttributeValue("path");
                    String hit = optionElement.getAttributeValue("hit");
                    this.putOptionWithHelpId(option, id, groupName, hit, path);
                }
            }
            document = JDOMUtil.loadDocument((URL)ResourceUtil.getResource(SearchableOptionsRegistrar.class, (String)"/search/", (String)"synonyms.xml"));
            root = document.getRootElement();
            configurables = root.getChildren("configurable");
            for (Object o : configurables) {
                configurable = (Element)o;
                id = configurable.getAttributeValue("id");
                groupName = configurable.getAttributeValue("configurable_name");
                List synonyms = configurable.getChildren("synonym");
                for (Object o1 : synonyms) {
                    Element synonymElement = (Element)o1;
                    String synonym = synonymElement.getTextNormalize();
                    if (synonym == null) continue;
                    Set<String> words = this.getProcessedWords(synonym);
                    for (String word : words) {
                        this.putOptionWithHelpId(word, id, groupName, synonym, null);
                    }
                }
                List options = configurable.getChildren("option");
                for (Object o1 : options) {
                    Element optionElement = (Element)o1;
                    String option = optionElement.getAttributeValue("name");
                    List list = optionElement.getChildren("synonym");
                    for (Object o2 : list) {
                        Element synonymElement = (Element)o2;
                        String synonym = synonymElement.getTextNormalize();
                        if (synonym == null) continue;
                        Set<String> words = this.getProcessedWords(synonym);
                        for (String word : words) {
                            this.putOptionWithHelpId(word, id, groupName, synonym, null);
                        }
                        Couple key2 = Couple.of((Object)option, (Object)id);
                        THashSet foundSynonyms = this.myHighlightOption2Synonym.get(key2);
                        if (foundSynonyms == null) {
                            foundSynonyms = new THashSet();
                            this.myHighlightOption2Synonym.put((Couple<String>)key2, (Set<String>)foundSynonyms);
                        }
                        foundSynonyms.add((String)synonym);
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        ApplicationInfoEx applicationInfo = ApplicationInfoEx.getInstanceEx();
        for (IdeaPluginDescriptor plugin : PluginManagerCore.getPlugins()) {
            if (applicationInfo.isEssentialPlugin(plugin.getPluginId().getIdString())) continue;
            String pluginName = plugin.getName();
            Set<String> words = this.getProcessedWordsWithoutStemming(pluginName);
            String description = plugin.getDescription();
            if (description != null) {
                words.addAll(this.getProcessedWordsWithoutStemming(description));
            }
            for (String word : words) {
                this.addOption(word, null, pluginName, "preferences.pluginManager", PluginManagerConfigurable.DISPLAY_NAME);
            }
        }
    }

    private long pack(@NotNull String id, @Nullable String hit, @Nullable String path, @Nullable String groupName) {
        long _groupName;
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/ide/ui/search/SearchableOptionsRegistrarImpl", "pack"));
        }
        long _id = this.myIdentifierTable.toId(id.trim());
        long _hit = hit == null ? 32767L : (long)this.myIdentifierTable.toId(hit.trim());
        long _path = path == null ? 32767L : (long)this.myIdentifierTable.toId(path.trim());
        long l = _groupName = groupName == null ? 32767L : (long)this.myIdentifierTable.toId(groupName.trim());
        assert (_id >= 0L && _id < 32767L);
        assert (_hit >= 0L && _hit <= 32767L);
        assert (_path >= 0L && _path <= 32767L);
        assert (_groupName >= 0L && _groupName <= 32767L);
        return _groupName << 48 | _id << 32 | _hit << 16 | _path << 0;
    }

    private OptionDescription unpack(long data) {
        int _groupName = (int)(data >> 48 & 0xFFFFL);
        int _id = (int)(data >> 32 & 0xFFFFL);
        int _hit = (int)(data >> 16 & 0xFFFFL);
        int _path = (int)(data & 0xFFFFL);
        assert (_id >= 0 && _id < Short.MAX_VALUE);
        assert (_hit >= 0 && _hit <= Short.MAX_VALUE);
        assert (_path >= 0 && _path <= Short.MAX_VALUE);
        assert (_groupName >= 0 && _groupName <= Short.MAX_VALUE);
        String groupName = _groupName == Short.MAX_VALUE ? null : this.myIdentifierTable.fromId(_groupName).toString();
        String configurableId = this.myIdentifierTable.fromId(_id).toString();
        String hit = _hit == Short.MAX_VALUE ? null : this.myIdentifierTable.fromId(_hit).toString();
        String path = _path == Short.MAX_VALUE ? null : this.myIdentifierTable.fromId(_path).toString();
        return new OptionDescription(null, configurableId, hit, path, groupName);
    }

    private synchronized void putOptionWithHelpId(@NotNull String option, @NotNull String id, @Nullable String groupName, @Nullable String hit, @Nullable String path) {
        if (option == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "option", "com/intellij/ide/ui/search/SearchableOptionsRegistrarImpl", "putOptionWithHelpId"));
        }
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/ide/ui/search/SearchableOptionsRegistrarImpl", "putOptionWithHelpId"));
        }
        if (this.isStopWord(option)) {
            return;
        }
        String stopWord = PorterStemmerUtil.stem(option);
        if (stopWord == null) {
            return;
        }
        if (this.isStopWord(stopWord)) {
            return;
        }
        long[] configs = this.myStorage.get(option);
        long packed = this.pack(id, hit, path, groupName);
        configs = configs == null ? new long[]{packed} : (ArrayUtil.indexOf((long[])configs, (long)packed) == -1 ? ArrayUtil.append((long[])configs, (long)packed) : configs);
        this.myStorage.put(ByteArrayCharSequence.convertToBytesIfAsciiString((String)option), configs);
    }

    @NotNull
    public ConfigurableHit getConfigurables(ConfigurableGroup[] groups, DocumentEvent.EventType type, Set<Configurable> configurables, String option, Project project2) {
        ConfigurableHit hits = new ConfigurableHit();
        Set contentHits = hits.getContentHits();
        Set<String> options = this.getProcessedWordsWithoutStemming(option);
        if (configurables == null) {
            for (ConfigurableGroup group : groups) {
                contentHits.addAll(SearchUtil.expandGroup(group));
            }
        } else {
            contentHits.addAll(configurables);
        }
        String optionToCheck = option.trim().toLowerCase();
        for (Configurable each : contentHits) {
            if (each.getDisplayName() == null) continue;
            String displayName = each.getDisplayName().toLowerCase();
            List allWords = StringUtil.getWordsIn((String)displayName);
            if (displayName.contains(optionToCheck)) {
                hits.getNameFullHits().add(each);
                hits.getNameHits().add(each);
            }
            for (String eachWord : allWords) {
                if (!eachWord.startsWith(optionToCheck)) continue;
                hits.getNameHits().add(each);
                break;
            }
            if (!options.isEmpty()) continue;
            hits.getNameHits().add(each);
            hits.getNameFullHits().add(each);
        }
        HashSet currentConfigurables = new HashSet(contentHits);
        if (options.isEmpty()) {
            String[] components = REG_EXP.split(optionToCheck);
            if (components.length > 0) {
                Collections.addAll(options, components);
            } else {
                options.add(option);
            }
        }
        HashSet<String> helpIds = null;
        for (String opt : options) {
            Set<OptionDescription> optionIds = this.getAcceptableDescriptions(opt);
            if (optionIds == null) {
                contentHits.clear();
                ConfigurableHit configurableHit = hits;
                if (configurableHit == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/ui/search/SearchableOptionsRegistrarImpl", "getConfigurables"));
                }
                return configurableHit;
            }
            HashSet<String> ids = new HashSet<String>();
            for (OptionDescription id : optionIds) {
                ids.add(id.getConfigurableId());
            }
            if (helpIds == null) {
                helpIds = ids;
            }
            helpIds.retainAll(ids);
        }
        if (helpIds != null) {
            Iterator it = contentHits.iterator();
            while (it.hasNext()) {
                Configurable configurable = (Configurable)it.next();
                if (CodeStyleFacade.getInstance((Project)project2).isUnsuitableCodeStyleConfigurable(configurable)) {
                    it.remove();
                    continue;
                }
                if (configurable instanceof SearchableConfigurable && helpIds.contains(((SearchableConfigurable)configurable).getId())) continue;
                it.remove();
            }
        }
        if (currentConfigurables.equals(contentHits) && (configurables != null || type != DocumentEvent.EventType.CHANGE)) {
            ConfigurableHit configurableHit = this.getConfigurables(groups, DocumentEvent.EventType.CHANGE, null, option, project2);
            if (configurableHit == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/ui/search/SearchableOptionsRegistrarImpl", "getConfigurables"));
            }
            return configurableHit;
        }
        ConfigurableHit configurableHit = hits;
        if (configurableHit == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/ui/search/SearchableOptionsRegistrarImpl", "getConfigurables"));
        }
        return configurableHit;
    }

    @Nullable
    public synchronized Set<OptionDescription> getAcceptableDescriptions(String prefix) {
        if (prefix == null) {
            return null;
        }
        String stemmedPrefix = PorterStemmerUtil.stem(prefix);
        if (StringUtil.isEmptyOrSpaces((String)stemmedPrefix)) {
            return null;
        }
        this.loadHugeFilesIfNecessary();
        THashSet result2 = null;
        for (Map.Entry<CharSequence, long[]> entry : this.myStorage.entrySet()) {
            String stemmedOption;
            long[] descriptions = entry.getValue();
            CharSequence option = entry.getKey();
            if (!StringUtil.startsWith((CharSequence)option, (CharSequence)prefix) && !StringUtil.startsWith((CharSequence)option, (CharSequence)stemmedPrefix) && (stemmedOption = PorterStemmerUtil.stem(option.toString())) != null && !stemmedOption.startsWith(prefix) && !stemmedOption.startsWith(stemmedPrefix)) continue;
            if (result2 == null) {
                result2 = new THashSet();
            }
            for (long description : descriptions) {
                OptionDescription desc = this.unpack(description);
                result2.add(desc);
            }
        }
        return result2;
    }

    @Nullable
    public String getInnerPath(SearchableConfigurable configurable, @NonNls String option) {
        this.loadHugeFilesIfNecessary();
        HashSet<OptionDescription> path = null;
        Set<String> words = this.getProcessedWordsWithoutStemming(option);
        for (String word : words) {
            Set<OptionDescription> configs = this.getAcceptableDescriptions(word);
            if (configs == null) {
                return null;
            }
            HashSet<OptionDescription> paths = new HashSet<OptionDescription>();
            for (OptionDescription config : configs) {
                if (!Comparing.strEqual((String)config.getConfigurableId(), (String)configurable.getId())) continue;
                paths.add(config);
            }
            if (path == null) {
                path = paths;
            }
            path.retainAll(paths);
        }
        if (path == null || path.isEmpty()) {
            return null;
        }
        OptionDescription result2 = null;
        for (OptionDescription description : path) {
            String hit = description.getHit();
            if (hit != null) {
                boolean theBest = true;
                for (String word : words) {
                    if (hit.contains(word)) continue;
                    theBest = false;
                }
                if (theBest) {
                    return description.getPath();
                }
            }
            result2 = description;
        }
        return result2 != null ? result2.getPath() : null;
    }

    public boolean isStopWord(String word) {
        return this.myStopWords.contains(word);
    }

    public Set<String> getSynonym(String option, @NotNull SearchableConfigurable configurable) {
        if (configurable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurable", "com/intellij/ide/ui/search/SearchableOptionsRegistrarImpl", "getSynonym"));
        }
        this.loadHugeFilesIfNecessary();
        return this.myHighlightOption2Synonym.get(Couple.of((Object)option, (Object)configurable.getId()));
    }

    public Map<String, Set<String>> findPossibleExtension(@NotNull String prefix, Project project2) {
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/ide/ui/search/SearchableOptionsRegistrarImpl", "findPossibleExtension"));
        }
        this.loadHugeFilesIfNecessary();
        boolean perProject = CodeStyleFacade.getInstance((Project)project2).projectUsesOwnSettings();
        THashMap result2 = new THashMap();
        int count = 0;
        Set<String> prefixes = this.getProcessedWordsWithoutStemming(prefix);
        for (String opt : prefixes) {
            Set<OptionDescription> configs = this.getAcceptableDescriptions(opt);
            if (configs == null) continue;
            for (OptionDescription description : configs) {
                Set foundHits;
                String groupName = description.getGroupName();
                if (perProject) {
                    if (Comparing.strEqual((String)groupName, (String)ApplicationBundle.message((String)"title.global.code.style", (Object[])new Object[0]))) {
                        groupName = ApplicationBundle.message((String)"title.project.code.style", (Object[])new Object[0]);
                    }
                } else if (Comparing.strEqual((String)groupName, (String)ApplicationBundle.message((String)"title.project.code.style", (Object[])new Object[0]))) {
                    groupName = ApplicationBundle.message((String)"title.global.code.style", (Object[])new Object[0]);
                }
                if ((foundHits = (Set)result2.get(groupName)) == null) {
                    foundHits = new THashSet();
                    result2.put(groupName, foundHits);
                }
                foundHits.add(description.getHit());
                ++count;
            }
        }
        if (count > 20) {
            result2.clear();
        }
        return result2;
    }

    public void addOption(String option, String path, String hit, String configurableId, String configurableDisplayName) {
        this.putOptionWithHelpId(option, configurableId, configurableDisplayName, hit, path);
    }

    public Set<String> getProcessedWordsWithoutStemming(@NotNull String text) {
        String[] options;
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/ide/ui/search/SearchableOptionsRegistrarImpl", "getProcessedWordsWithoutStemming"));
        }
        HashSet<String> result2 = new HashSet<String>();
        String toLowerCase = text.toLowerCase();
        for (String opt : options = REG_EXP.split(toLowerCase)) {
            String processed2;
            if (this.isStopWord(opt) || this.isStopWord(processed2 = PorterStemmerUtil.stem(opt))) continue;
            result2.add(opt);
        }
        return result2;
    }

    public Set<String> getProcessedWords(@NotNull String text) {
        String[] options;
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/ide/ui/search/SearchableOptionsRegistrarImpl", "getProcessedWords"));
        }
        HashSet<String> result2 = new HashSet<String>();
        String toLowerCase = text.toLowerCase();
        for (String opt : options = REG_EXP.split(toLowerCase)) {
            if (this.isStopWord(opt) || (opt = PorterStemmerUtil.stem(opt)) == null) continue;
            result2.add(opt);
        }
        return result2;
    }

    public Set<String> replaceSynonyms(Set<String> options, SearchableConfigurable configurable) {
        HashSet<String> result2 = new HashSet<String>(options);
        for (String option : options) {
            Set<String> synonyms = this.getSynonym(option, configurable);
            if (synonyms != null) {
                result2.addAll(synonyms);
                continue;
            }
            result2.add(option);
        }
        return result2;
    }
}

