/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.ModuleRendererFactory;
import com.intellij.ide.util.PlatformModuleRendererFactory;
import com.intellij.navigation.ColoredItemPresentation;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.impl.EditorTabbedContainer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.IconUtil;
import com.intellij.util.text.Matcher;
import com.intellij.util.text.MatcherHolder;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Comparator;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiElementListCellRenderer<T extends PsiElement>
extends JPanel
implements ListCellRenderer {
    private static final String LEFT = "West";
    private boolean myFocusBorderEnabled = Registry.is((String)"psi.element.list.cell.renderer.focus.border.enabled");
    protected int myRightComponentWidth;

    protected PsiElementListCellRenderer() {
        super(new BorderLayout());
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new MyAccessibleContext();
        }
        return this.accessibleContext;
    }

    protected static Color getBackgroundColor(@Nullable Object value) {
        if (value instanceof PsiElement) {
            Color fileBgColor;
            PsiElement psiElement = (PsiElement)value;
            Project project2 = psiElement.getProject();
            VirtualFile file2 = null;
            PsiFile psiFile = psiElement.getContainingFile();
            if (psiFile != null) {
                file2 = psiFile.getVirtualFile();
            } else if (psiElement instanceof PsiDirectory) {
                file2 = ((PsiDirectory)psiElement).getVirtualFile();
            }
            Color color = fileBgColor = file2 != null ? EditorTabbedContainer.calcTabColor(project2, file2) : null;
            if (fileBgColor != null) {
                return fileBgColor;
            }
        }
        return UIUtil.getListBackground();
    }

    @Nullable
    protected TextAttributes getNavigationItemAttributes(Object value) {
        TextAttributes attributes = null;
        if (value instanceof NavigationItem) {
            TextAttributesKey attributesKey = null;
            ItemPresentation presentation = ((NavigationItem)value).getPresentation();
            if (presentation instanceof ColoredItemPresentation) {
                attributesKey = ((ColoredItemPresentation)presentation).getTextAttributesKey();
            }
            if (attributesKey != null) {
                attributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(attributesKey);
            }
        }
        return attributes;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.removeAll();
        this.myRightComponentWidth = 0;
        DefaultListCellRenderer rightRenderer = this.getRightCellRenderer(value);
        Component rightCellRendererComponent = null;
        JPanel spacer = null;
        if (rightRenderer != null) {
            rightCellRendererComponent = rightRenderer.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            this.add(rightCellRendererComponent, "East");
            spacer = new JPanel();
            spacer.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
            this.add((Component)spacer, "Center");
            this.myRightComponentWidth = rightCellRendererComponent.getPreferredSize().width;
            this.myRightComponentWidth += spacer.getPreferredSize().width;
        }
        LeftRenderer leftRenderer = new LeftRenderer(null, MatcherHolder.getAssociatedMatcher(list));
        Component leftCellRendererComponent = leftRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        this.add(leftCellRendererComponent, LEFT);
        Color bg = isSelected ? UIUtil.getListSelectionBackground() : leftCellRendererComponent.getBackground();
        this.setBackground(bg);
        if (rightCellRendererComponent != null) {
            rightCellRendererComponent.setBackground(bg);
        }
        if (spacer != null) {
            spacer.setBackground(bg);
        }
        return this;
    }

    protected void setFocusBorderEnabled(boolean enabled) {
        this.myFocusBorderEnabled = enabled;
    }

    protected boolean customizeNonPsiElementLeftRenderer(ColoredListCellRenderer renderer, JList list, Object value, int index, boolean selected, boolean hasFocus) {
        return false;
    }

    @Nullable
    protected DefaultListCellRenderer getRightCellRenderer(Object value) {
        if (UISettings.getInstance().getShowIconInQuickNavigation()) {
            DefaultListCellRenderer renderer = ModuleRendererFactory.findInstance(value).getModuleRenderer();
            if (renderer instanceof PlatformModuleRendererFactory.PlatformModuleRenderer) {
                return null;
            }
            return renderer;
        }
        return null;
    }

    public abstract String getElementText(T var1);

    @Nullable
    protected abstract String getContainerText(T var1, String var2);

    @Nullable
    protected String getContainerTextForLeftComponent(T element, String name) {
        return this.getContainerText(element, name);
    }

    @Iconable.IconFlags
    protected abstract int getIconFlags();

    protected Icon getIcon(PsiElement element) {
        return element.getIcon(this.getIconFlags());
    }

    public Comparator<T> getComparator() {
        return Comparator.comparing(this::getComparingObject);
    }

    @NotNull
    public Comparable getComparingObject(T element) {
        Comparable comparable = (Comparable)ReadAction.compute(() -> {
            String elementText = this.getElementText(element);
            String containerText = this.getContainerText(element, elementText);
            return containerText != null ? elementText + " " + containerText : elementText;
        });
        if (comparable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/PsiElementListCellRenderer", "getComparingObject"));
        }
        return comparable;
    }

    public void installSpeedSearch(PopupChooserBuilder builder) {
        this.installSpeedSearch(builder, false);
    }

    public void installSpeedSearch(PopupChooserBuilder builder, boolean includeContainerText) {
        builder.setFilteringEnabled(o -> {
            if (o instanceof PsiElement) {
                String elementText = this.getElementText((PsiElement)o);
                if (includeContainerText) {
                    return elementText + " " + this.getContainerText((PsiElement)o, elementText);
                }
                return elementText;
            }
            return o.toString();
        });
    }

    @Deprecated
    public void installSpeedSearch(JList list) {
        new ListSpeedSearch(list){

            @Override
            protected String getElementText(Object o) {
                if (o instanceof PsiElement) {
                    String elementText = PsiElementListCellRenderer.this.getElementText((PsiElement)o);
                    return elementText + " " + PsiElementListCellRenderer.this.getContainerText((PsiElement)o, elementText);
                }
                return o.toString();
            }
        };
    }

    private class LeftRenderer
    extends ColoredListCellRenderer {
        private final String myModuleName;
        private final Matcher myMatcher;

        public LeftRenderer(String moduleName, Matcher matcher) {
            this.myModuleName = moduleName;
            this.myMatcher = matcher;
        }

        protected void customizeCellRenderer(@NotNull JList list, Object value, int index, boolean selected, boolean hasFocus) {
            if (list == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/ide/util/PsiElementListCellRenderer$LeftRenderer", "customizeCellRenderer"));
            }
            Color bgColor = UIUtil.getListBackground();
            Color color = list.getForeground();
            this.setPaintFocusBorder(hasFocus && UIUtil.isToUseDottedCellBorder() && PsiElementListCellRenderer.this.myFocusBorderEnabled);
            if (value instanceof PsiElement) {
                SimpleTextAttributes nameAttributes;
                VirtualFile vFile;
                PsiElement element = (PsiElement)value;
                String name = element.isValid() ? PsiElementListCellRenderer.this.getElementText(element) : "INVALID";
                PsiFile psiFile = element.isValid() ? element.getContainingFile() : null;
                boolean isProblemFile = false;
                if (psiFile != null && (vFile = psiFile.getVirtualFile()) != null) {
                    Project project2 = psiFile.getProject();
                    if (WolfTheProblemSolver.getInstance((Project)project2).isProblemFile(vFile)) {
                        isProblemFile = true;
                    }
                    FileStatus status = FileStatusManager.getInstance((Project)project2).getStatus(vFile);
                    color = status.getColor();
                    Color fileBgColor = EditorTabbedContainer.calcTabColor(project2, vFile);
                    bgColor = fileBgColor == null ? bgColor : fileBgColor;
                }
                TextAttributes attributes = PsiElementListCellRenderer.this.getNavigationItemAttributes(value);
                if (isProblemFile) {
                    attributes = TextAttributes.merge((TextAttributes)new TextAttributes(color, null, (Color)JBColor.RED, EffectType.WAVE_UNDERSCORE, 0), (TextAttributes)attributes);
                }
                SimpleTextAttributes simpleTextAttributes = nameAttributes = attributes != null ? SimpleTextAttributes.fromTextAttributes((TextAttributes)attributes) : null;
                if (nameAttributes == null) {
                    nameAttributes = new SimpleTextAttributes(0, color);
                }
                assert (name != null) : "Null name for PSI element " + element + " (by " + PsiElementListCellRenderer.this + ")";
                SpeedSearchUtil.appendColoredFragmentForMatcher((String)name, (SimpleColoredComponent)this, (SimpleTextAttributes)nameAttributes, (Matcher)this.myMatcher, (Color)bgColor, (boolean)selected);
                if (!element.isValid()) {
                    this.append(" Invalid", SimpleTextAttributes.ERROR_ATTRIBUTES);
                    return;
                }
                this.setIcon(PsiElementListCellRenderer.this.getIcon(element));
                String containerText = PsiElementListCellRenderer.this.getContainerTextForLeftComponent(element, name + (this.myModuleName != null ? this.myModuleName + "        " : ""));
                if (containerText != null) {
                    this.append(" " + containerText, new SimpleTextAttributes(0, (Color)JBColor.GRAY));
                }
            } else if (!PsiElementListCellRenderer.this.customizeNonPsiElementLeftRenderer(this, list, value, index, selected, hasFocus)) {
                this.setIcon(IconUtil.getEmptyIcon((boolean)false));
                this.append(value == null ? "" : value.toString(), new SimpleTextAttributes(0, list.getForeground()));
            }
            this.setBackground(selected ? UIUtil.getListSelectionBackground() : bgColor);
        }
    }

    private class MyAccessibleContext
    extends JPanel.AccessibleJPanel {
        private MyAccessibleContext() {
            super(PsiElementListCellRenderer.this);
        }

        @Override
        public String getAccessibleName() {
            LayoutManager lm = PsiElementListCellRenderer.this.getLayout();
            assert (lm instanceof BorderLayout);
            Component leftCellRendererComp = ((BorderLayout)lm).getLayoutComponent(PsiElementListCellRenderer.LEFT);
            return leftCellRendererComp instanceof Accessible ? leftCellRendererComp.getAccessibleContext().getAccessibleName() : super.getAccessibleName();
        }
    }
}

