/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbServiceImpl;
import com.intellij.openapi.project.Project;
import com.intellij.util.TimeoutUtil;
import org.jetbrains.annotations.NotNull;

public class ToggleDumbModeAction
extends DumbAwareAction {
    private volatile boolean myDumb = false;

    public void actionPerformed(AnActionEvent e) {
        if (this.myDumb) {
            this.myDumb = false;
        } else {
            this.myDumb = true;
            Project project2 = e.getProject();
            if (project2 == null) {
                return;
            }
            DumbServiceImpl.getInstance(project2).queueTask(new DumbModeTask(){

                public void performInDumbMode(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/internal/ToggleDumbModeAction$1", "performInDumbMode"));
                    }
                    while (ToggleDumbModeAction.this.myDumb) {
                        indicator.checkCanceled();
                        TimeoutUtil.sleep((long)100L);
                    }
                }
            });
        }
    }

    public void update(AnActionEvent e) {
        boolean enabled;
        Project project2 = e.getProject();
        if (project2 == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        boolean dumb = DumbServiceImpl.getInstance(project2).isDumb();
        boolean bl = enabled = !dumb || this.myDumb;
        if (enabled && this.myDumb != dumb) {
            this.myDumb = dumb;
        }
        e.getPresentation().setEnabled(enabled);
        e.getPresentation().setText(dumb ? "Exit Dumb Mode" : "Enter Dumb Mode");
    }
}

