/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.psi.impl;

import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.impl.JsonContainerImpl;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JsonObjectMixin
extends JsonContainerImpl
implements JsonObject {
    private final CachedValueProvider<Map<String, JsonProperty>> myPropertyCache;

    public JsonObjectMixin(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/json/psi/impl/JsonObjectMixin", "<init>"));
        }
        super(node);
        this.myPropertyCache = () -> {
            HashMap<String, JsonProperty> cache = new HashMap<String, JsonProperty>();
            for (JsonProperty property : this.getPropertyList()) {
                String propertyName = property.getName();
                if (cache.containsKey(propertyName)) continue;
                cache.put(propertyName, property);
            }
            return CachedValueProvider.Result.createSingleDependency(cache, (Object)this);
        };
    }

    @Override
    @Nullable
    public JsonProperty findProperty(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/json/psi/impl/JsonObjectMixin", "findProperty"));
        }
        return (JsonProperty)((Map)CachedValuesManager.getCachedValue((PsiElement)this, this.myPropertyCache)).get(name);
    }
}

