/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.codeInsight.editorActions.smartEnter.SmartEnterProcessor;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.OrderedSet;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class SmartEnterProcessorWithFixers
extends SmartEnterProcessor {
    protected static final Logger LOG = Logger.getInstance(SmartEnterProcessorWithFixers.class);
    protected static final int MAX_ATTEMPTS = 20;
    protected static final Key<Long> SMART_ENTER_TIMESTAMP = Key.create((String)"smartEnterOriginalTimestamp");
    protected int myFirstErrorOffset = Integer.MAX_VALUE;
    protected int myAttempt = 0;
    private final List<Fixer<? extends SmartEnterProcessorWithFixers>> myFixers = new ArrayList<Fixer<? extends SmartEnterProcessorWithFixers>>();
    protected final List<FixEnterProcessor> myEnterProcessors = new ArrayList<FixEnterProcessor>();
    private final List<FixEnterProcessor> myAfterEnterProcessors = new ArrayList<FixEnterProcessor>();

    protected static void plainEnter(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/SmartEnterProcessorWithFixers", "plainEnter"));
        }
        SmartEnterProcessorWithFixers.getEnterHandler().execute(editor, ((EditorEx)editor).getDataContext());
    }

    protected static EditorActionHandler getEnterHandler() {
        return EditorActionManager.getInstance().getActionHandler("EditorStartNewLine");
    }

    protected static boolean isModified(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/SmartEnterProcessorWithFixers", "isModified"));
        }
        Long timestamp = (Long)editor.getUserData(SMART_ENTER_TIMESTAMP);
        assert (timestamp != null);
        return editor.getDocument().getModificationStamp() != timestamp.longValue();
    }

    public boolean doNotStepInto(PsiElement element) {
        return false;
    }

    public boolean process(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/SmartEnterProcessorWithFixers", "process"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/SmartEnterProcessorWithFixers", "process"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/lang/SmartEnterProcessorWithFixers", "process"));
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.complete.statement");
        return this.invokeProcessor(project2, editor, psiFile, false);
    }

    public boolean processAfterCompletion(@NotNull Editor editor, @NotNull PsiFile psiFile) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/SmartEnterProcessorWithFixers", "processAfterCompletion"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/lang/SmartEnterProcessorWithFixers", "processAfterCompletion"));
        }
        return this.invokeProcessor(psiFile.getProject(), editor, psiFile, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean invokeProcessor(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile psiFile, boolean afterCompletion) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/SmartEnterProcessorWithFixers", "invokeProcessor"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/SmartEnterProcessorWithFixers", "invokeProcessor"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/lang/SmartEnterProcessorWithFixers", "invokeProcessor"));
        }
        Document document = editor.getDocument();
        CharSequence textForRollback = document.getImmutableCharSequence();
        try {
            editor.putUserData(SMART_ENTER_TIMESTAMP, (Object)editor.getDocument().getModificationStamp());
            this.myFirstErrorOffset = Integer.MAX_VALUE;
            this.process(project2, editor, psiFile, 0, afterCompletion);
        }
        catch (TooManyAttemptsException e) {
            document.replaceString(0, document.getTextLength(), textForRollback);
        }
        finally {
            editor.putUserData(SMART_ENTER_TIMESTAMP, null);
        }
        return true;
    }

    protected void process(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2, int attempt, boolean afterCompletion) throws TooManyAttemptsException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/SmartEnterProcessorWithFixers", "process"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/SmartEnterProcessorWithFixers", "process"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/SmartEnterProcessorWithFixers", "process"));
        }
        if (attempt > 20) {
            throw new TooManyAttemptsException();
        }
        this.myAttempt = attempt;
        try {
            this.commit(editor);
            if (this.myFirstErrorOffset != Integer.MAX_VALUE) {
                editor.getCaretModel().moveToOffset(this.myFirstErrorOffset);
            }
            this.myFirstErrorOffset = Integer.MAX_VALUE;
            PsiElement atCaret = this.getStatementAtCaret(editor, file2);
            if (atCaret == null) {
                this.processDefaultEnter(project2, editor, file2);
                return;
            }
            OrderedSet queue = new OrderedSet();
            this.collectAllElements(atCaret, (OrderedSet<PsiElement>)queue, this.collectChildrenRecursively(atCaret));
            queue.add((Object)atCaret);
            for (PsiElement psiElement : queue) {
                for (Fixer<? extends SmartEnterProcessorWithFixers> fixer : this.myFixers) {
                    fixer.apply(editor, this, psiElement);
                    if (LookupManager.getInstance(project2).getActiveLookup() != null) {
                        return;
                    }
                    if (!SmartEnterProcessorWithFixers.isUncommited((Project)project2) && psiElement.isValid()) continue;
                    this.moveCaretInsideBracesIfAny(editor, file2);
                    this.process(project2, editor, file2, attempt + 1, afterCompletion);
                    return;
                }
            }
            this.doEnter(atCaret, file2, editor, afterCompletion);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    protected boolean collectChildrenRecursively(@NotNull PsiElement atCaret) {
        if (atCaret == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "atCaret", "com/intellij/lang/SmartEnterProcessorWithFixers", "collectChildrenRecursively"));
        }
        return true;
    }

    protected void processDefaultEnter(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/SmartEnterProcessorWithFixers", "processDefaultEnter"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/SmartEnterProcessorWithFixers", "processDefaultEnter"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/SmartEnterProcessorWithFixers", "processDefaultEnter"));
        }
    }

    protected void collectAllElements(@NotNull PsiElement element, @NotNull OrderedSet<PsiElement> result2, boolean recursive) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/SmartEnterProcessorWithFixers", "collectAllElements"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/SmartEnterProcessorWithFixers", "collectAllElements"));
        }
        result2.add(0, (Object)element);
        if (this.doNotStepInto(element)) {
            if (!recursive) {
                return;
            }
            recursive = false;
        }
        this.collectAdditionalElements(element, (List<PsiElement>)result2);
        for (PsiElement child : element.getChildren()) {
            this.collectAllElements(child, result2, recursive);
        }
    }

    protected void doEnter(@NotNull PsiElement atCaret, @NotNull PsiFile psiFile, @NotNull Editor editor, boolean afterCompletion) throws IncorrectOperationException {
        if (atCaret == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "atCaret", "com/intellij/lang/SmartEnterProcessorWithFixers", "doEnter"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/lang/SmartEnterProcessorWithFixers", "doEnter"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/SmartEnterProcessorWithFixers", "doEnter"));
        }
        if (this.myFirstErrorOffset != Integer.MAX_VALUE) {
            editor.getCaretModel().moveToOffset(this.myFirstErrorOffset);
            this.reformat(atCaret);
            return;
        }
        RangeMarker rangeMarker = this.createRangeMarker(atCaret);
        if (this.reformatBeforeEnter(atCaret)) {
            this.reformat(atCaret);
        }
        this.commit(editor);
        PsiElement actualAtCaret = this.restoreElementAtCaret(psiFile, atCaret, rangeMarker);
        int endOffset = rangeMarker.getEndOffset();
        rangeMarker.dispose();
        if (actualAtCaret != null) {
            for (FixEnterProcessor enterProcessor : this.myEnterProcessors) {
                if (!enterProcessor.doEnter(actualAtCaret, psiFile, editor, SmartEnterProcessorWithFixers.isModified(editor))) continue;
                return;
            }
        }
        if (!SmartEnterProcessorWithFixers.isModified(editor) && !afterCompletion) {
            if (actualAtCaret != null) {
                SmartEnterProcessorWithFixers.plainEnter(editor);
            }
        } else {
            editor.getCaretModel().moveToOffset(this.myFirstErrorOffset == Integer.MAX_VALUE ? (actualAtCaret != null ? actualAtCaret.getTextRange().getEndOffset() : endOffset) : this.myFirstErrorOffset);
        }
    }

    protected PsiElement restoreElementAtCaret(PsiFile file2, PsiElement origElement, RangeMarker marker) {
        if (!origElement.isValid()) {
            LOG.warn("Please, override com.intellij.lang.SmartEnterProcessorWithFixers.restoreElementAtCaret for your language!");
        }
        return origElement;
    }

    protected boolean reformatBeforeEnter(@NotNull PsiElement atCaret) {
        if (atCaret == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "atCaret", "com/intellij/lang/SmartEnterProcessorWithFixers", "reformatBeforeEnter"));
        }
        return true;
    }

    protected void addEnterProcessors(FixEnterProcessor ... processors) {
        ContainerUtil.addAllNotNull(this.myEnterProcessors, (Object[])processors);
    }

    protected void addAfterEnterProcessors(FixEnterProcessor ... processors) {
        ContainerUtil.addAllNotNull(this.myAfterEnterProcessors, (Object[])processors);
    }

    @SafeVarargs
    protected final void addFixers(Fixer<? extends SmartEnterProcessorWithFixers> ... fixers) {
        if (fixers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fixers", "com/intellij/lang/SmartEnterProcessorWithFixers", "addFixers"));
        }
        ContainerUtil.addAllNotNull(this.myFixers, (Object[])fixers);
    }

    protected void collectAdditionalElements(@NotNull PsiElement element, @NotNull List<PsiElement> result2) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/SmartEnterProcessorWithFixers", "collectAdditionalElements"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/SmartEnterProcessorWithFixers", "collectAdditionalElements"));
        }
    }

    protected void moveCaretInsideBracesIfAny(@NotNull Editor editor, @NotNull PsiFile file2) throws IncorrectOperationException {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/SmartEnterProcessorWithFixers", "moveCaretInsideBracesIfAny"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/SmartEnterProcessorWithFixers", "moveCaretInsideBracesIfAny"));
        }
    }

    public void registerUnresolvedError(int offset) {
        if (this.myFirstErrorOffset > offset) {
            this.myFirstErrorOffset = offset;
        }
    }

    public static abstract class FixEnterProcessor {
        public abstract boolean doEnter(PsiElement var1, PsiFile var2, @NotNull Editor var3, boolean var4);

        protected void plainEnter(@NotNull Editor editor) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/SmartEnterProcessorWithFixers$FixEnterProcessor", "plainEnter"));
            }
            SmartEnterProcessorWithFixers.plainEnter(editor);
        }
    }

    public static abstract class Fixer<P extends SmartEnterProcessorWithFixers> {
        public abstract void apply(@NotNull Editor var1, @NotNull P var2, @NotNull PsiElement var3) throws IncorrectOperationException;
    }

    public static class TooManyAttemptsException
    extends Exception {
    }
}

