/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch;

import com.intellij.openapi.diff.impl.patch.AirContentRevision;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.PathDescription;
import com.intellij.openapi.diff.impl.patch.StaticPathDescription;
import com.intellij.openapi.diff.impl.patch.TextPatchBuilder;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsOutgoingChangesProvider;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.BinaryContentRevision;
import com.intellij.openapi.vcs.changes.ByteBackedContentRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.BeforeAfter;
import com.intellij.util.ObjectUtils;
import com.intellij.vcsUtil.VcsUtil;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeaTextPatchBuilder {
    private IdeaTextPatchBuilder() {
    }

    public static List<BeforeAfter<AirContentRevision>> revisionsConvertor(Project project2, List<Change> changes) throws VcsException {
        ArrayList<BeforeAfter<AirContentRevision>> result2 = new ArrayList<BeforeAfter<AirContentRevision>>(changes.size());
        Map byRoots = VcsUtil.groupByRoots((Project)project2, changes, change -> (FilePath)ObjectUtils.chooseNotNull((Object)ChangesUtil.getBeforePath((Change)change), (Object)ChangesUtil.getAfterPath((Change)change)));
        for (VcsRoot root : byRoots.keySet()) {
            Collection rootChanges = (Collection)byRoots.get(root);
            if (root.getVcs() == null || root.getVcs().getOutgoingChangesProvider() == null) {
                IdeaTextPatchBuilder.addConvertChanges(rootChanges, result2);
                continue;
            }
            VcsOutgoingChangesProvider provider = root.getVcs().getOutgoingChangesProvider();
            Collection basedOnLocal = provider.filterLocalChangesBasedOnLocalCommits(rootChanges, root.getPath());
            rootChanges.removeAll(basedOnLocal);
            IdeaTextPatchBuilder.addConvertChanges(rootChanges, result2);
            for (Change change2 : basedOnLocal) {
                result2.add((BeforeAfter<AirContentRevision>)new BeforeAfter((Object)IdeaTextPatchBuilder.convertRevision(change2.getBeforeRevision(), provider), (Object)IdeaTextPatchBuilder.convertRevision(change2.getAfterRevision(), provider)));
            }
        }
        return result2;
    }

    private static void addConvertChanges(Collection<Change> changes, List<BeforeAfter<AirContentRevision>> result2) {
        for (Change change : changes) {
            result2.add((BeforeAfter<AirContentRevision>)new BeforeAfter((Object)IdeaTextPatchBuilder.convertRevisionToAir(change.getBeforeRevision()), (Object)IdeaTextPatchBuilder.convertRevisionToAir(change.getAfterRevision())));
        }
    }

    @NotNull
    public static List<FilePatch> buildPatch(Project project2, Collection<Change> changes, String basePath, boolean reversePatch) throws VcsException {
        ArrayList<BeforeAfter<AirContentRevision>> revisions;
        if (project2 != null) {
            revisions = IdeaTextPatchBuilder.revisionsConvertor(project2, new ArrayList<Change>(changes));
        } else {
            revisions = new ArrayList(changes.size());
            for (Change change : changes) {
                revisions.add((BeforeAfter<AirContentRevision>)new BeforeAfter((Object)IdeaTextPatchBuilder.convertRevisionToAir(change.getBeforeRevision()), (Object)IdeaTextPatchBuilder.convertRevisionToAir(change.getAfterRevision())));
            }
        }
        List<FilePatch> list = TextPatchBuilder.buildPatch(revisions, basePath, reversePatch, SystemInfo.isFileSystemCaseSensitive, () -> ProgressManager.checkCanceled());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/patch/IdeaTextPatchBuilder", "buildPatch"));
        }
        return list;
    }

    @Nullable
    private static AirContentRevision convertRevisionToAir(ContentRevision cr) {
        return IdeaTextPatchBuilder.convertRevisionToAir(cr, null);
    }

    @Nullable
    private static AirContentRevision convertRevisionToAir(ContentRevision cr, Long ts) {
        if (cr == null) {
            return null;
        }
        FilePath fp = cr.getFile();
        StaticPathDescription description = new StaticPathDescription(fp.isDirectory(), ts == null ? fp.getIOFile().lastModified() : ts.longValue(), fp.getPath());
        if (cr instanceof BinaryContentRevision) {
            return new BinaryAirContentRevision((BinaryContentRevision)cr, description, ts);
        }
        return new TextAirContentRevision(cr, description, ts);
    }

    @Nullable
    private static AirContentRevision convertRevision(@Nullable ContentRevision cr, VcsOutgoingChangesProvider provider) {
        if (cr == null) {
            return null;
        }
        Date date = provider.getRevisionDate(cr.getRevisionNumber(), cr.getFile());
        Long ts = date == null ? null : Long.valueOf(date.getTime());
        return IdeaTextPatchBuilder.convertRevisionToAir(cr, ts);
    }

    private static class TextAirContentRevision
    implements AirContentRevision {
        @NotNull
        private final ContentRevision myRevision;
        @NotNull
        private final StaticPathDescription myDescription;
        @Nullable
        private final Long myTimestamp;

        public TextAirContentRevision(@NotNull ContentRevision revision, @NotNull StaticPathDescription description, @Nullable Long timestamp) {
            if (revision == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revision", "com/intellij/openapi/diff/impl/patch/IdeaTextPatchBuilder$TextAirContentRevision", "<init>"));
            }
            if (description == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/intellij/openapi/diff/impl/patch/IdeaTextPatchBuilder$TextAirContentRevision", "<init>"));
            }
            this.myRevision = revision;
            this.myDescription = description;
            this.myTimestamp = timestamp;
        }

        public boolean isBinary() {
            return false;
        }

        public String getContentAsString() throws VcsException {
            return this.myRevision.getContent();
        }

        public byte[] getContentAsBytes() throws VcsException {
            if (this.myRevision instanceof ByteBackedContentRevision) {
                return ((ByteBackedContentRevision)this.myRevision).getContentAsBytes();
            }
            String textContent = this.getContentAsString();
            if (textContent == null) {
                return null;
            }
            return textContent.getBytes(this.getCharset());
        }

        public String getRevisionNumber() {
            return this.myTimestamp != null ? null : this.myRevision.getRevisionNumber().asString();
        }

        @NotNull
        public PathDescription getPath() {
            StaticPathDescription staticPathDescription = this.myDescription;
            if (staticPathDescription == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/patch/IdeaTextPatchBuilder$TextAirContentRevision", "getPath"));
            }
            return staticPathDescription;
        }

        public Charset getCharset() {
            return this.myRevision.getFile().getCharset();
        }

        @Nullable
        public String getLineSeparator() {
            VirtualFile virtualFile = this.myRevision.getFile().getVirtualFile();
            return virtualFile != null ? virtualFile.getDetectedLineSeparator() : null;
        }
    }

    private static class BinaryAirContentRevision
    implements AirContentRevision {
        @NotNull
        private final BinaryContentRevision myRevision;
        @NotNull
        private final StaticPathDescription myDescription;
        @Nullable
        private final Long myTimestamp;

        public BinaryAirContentRevision(@NotNull BinaryContentRevision revision, @NotNull StaticPathDescription description, @Nullable Long timestamp) {
            if (revision == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revision", "com/intellij/openapi/diff/impl/patch/IdeaTextPatchBuilder$BinaryAirContentRevision", "<init>"));
            }
            if (description == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/intellij/openapi/diff/impl/patch/IdeaTextPatchBuilder$BinaryAirContentRevision", "<init>"));
            }
            this.myRevision = revision;
            this.myDescription = description;
            this.myTimestamp = timestamp;
        }

        public boolean isBinary() {
            return true;
        }

        public String getContentAsString() {
            throw new IllegalStateException();
        }

        public byte[] getContentAsBytes() throws VcsException {
            return this.myRevision.getBinaryContent();
        }

        public String getRevisionNumber() {
            return this.myTimestamp != null ? null : this.myRevision.getRevisionNumber().asString();
        }

        @NotNull
        public PathDescription getPath() {
            StaticPathDescription staticPathDescription = this.myDescription;
            if (staticPathDescription == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/patch/IdeaTextPatchBuilder$BinaryAirContentRevision", "getPath"));
            }
            return staticPathDescription;
        }
    }
}

