/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.view;

import com.intellij.lang.CodeDocumentationAwareCommenter;
import com.intellij.lang.Commenter;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCommenters;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.bidi.BidiRegionsSeparator;
import com.intellij.openapi.editor.bidi.LanguageBidiRegionsSeparator;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.impl.ComplementaryFontsRegistry;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.editor.impl.view.ApproximationFragment;
import com.intellij.openapi.editor.impl.view.EditorView;
import com.intellij.openapi.editor.impl.view.IterationState;
import com.intellij.openapi.editor.impl.view.LineFragment;
import com.intellij.openapi.editor.impl.view.LogicalPositionCache;
import com.intellij.openapi.editor.impl.view.TabFragment;
import com.intellij.openapi.editor.impl.view.TextFragmentFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.BitUtil;
import com.intellij.util.DocumentUtil;
import com.intellij.util.text.CharArrayUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.text.Bidi;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Stream;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class LineLayout {
    private static final Logger LOG = Logger.getInstance(LineLayout.class);

    private LineLayout() {
    }

    @NotNull
    static LineLayout create(@NotNull EditorView view, int line, boolean skipBidiLayout) {
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/openapi/editor/impl/view/LineLayout", "create"));
        }
        List<BidiRun> runs = LineLayout.createFragments(view, line, skipBidiLayout);
        LineLayout lineLayout = LineLayout.createLayout(view, runs, null, line);
        if (lineLayout == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/view/LineLayout", "create"));
        }
        return lineLayout;
    }

    @NotNull
    static LineLayout create(@NotNull EditorView view, @NotNull CharSequence text, @JdkConstants.FontStyle int fontStyle) {
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/openapi/editor/impl/view/LineLayout", "create"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/editor/impl/view/LineLayout", "create"));
        }
        List<BidiRun> runs = LineLayout.createFragments(view, text, fontStyle);
        LineLayout delegate = LineLayout.createLayout(view, runs, text, 0);
        WithSize withSize = new WithSize(delegate);
        if (withSize == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/view/LineLayout", "create"));
        }
        return withSize;
    }

    private static LineLayout createLayout(@NotNull EditorView view, @NotNull List<BidiRun> runs, @Nullable CharSequence text, int line) {
        BidiRun run2;
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/openapi/editor/impl/view/LineLayout", "createLayout"));
        }
        if (runs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runs", "com/intellij/openapi/editor/impl/view/LineLayout", "createLayout"));
        }
        if (runs.isEmpty()) {
            return new SingleChunk(null);
        }
        if (runs.size() == 1 && (run2 = runs.get(0)).level == 0 && run2.getChunkCount() == 1) {
            Chunk chunk = run2.chunks == null ? new Chunk(0, run2.endOffset) : run2.chunks[0];
            return new SingleChunk(chunk);
        }
        BidiRun[] runArray = new BidiRun[runs.size()];
        int prevColumn = 0;
        for (int i2 = 0; i2 < runs.size(); ++i2) {
            BidiRun run3 = runs.get(i2);
            assert (i2 == 0 || run3.startOffset == runs.get(i2 - 1).endOffset);
            int startColumn = prevColumn;
            int endColumn = text == null ? view.getLogicalPositionCache().offsetToLogicalColumn(line, run3.endOffset) : LogicalPositionCache.calcColumn(text, run3.startOffset, prevColumn, run3.endOffset, view.getTabSize());
            run3.visualStartLogicalColumn = run3.isRtl() ? endColumn : startColumn;
            prevColumn = endColumn;
            runArray[i2] = run3;
        }
        return new MultiChunk(runArray);
    }

    private static void reorderRunsVisually(BidiRun[] bidiRuns) {
        byte[] levels = new byte[bidiRuns.length];
        for (int i2 = 0; i2 < bidiRuns.length; ++i2) {
            levels[i2] = bidiRuns[i2].level;
        }
        Bidi.reorderVisually(levels, 0, bidiRuns, 0, levels.length);
    }

    static boolean isBidiLayoutRequired(@NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/editor/impl/view/LineLayout", "isBidiLayoutRequired"));
        }
        char[] chars = CharArrayUtil.fromSequence((CharSequence)text);
        return Bidi.requiresBidi(chars, 0, chars.length);
    }

    private static List<BidiRun> createFragments(@NotNull EditorView view, int line, boolean skipBidiLayout) {
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/openapi/editor/impl/view/LineLayout", "createFragments"));
        }
        DocumentEx document = view.getEditor().getDocument();
        int lineStartOffset = document.getLineStartOffset(line);
        int lineEndOffset = document.getLineEndOffset(line);
        if (lineEndOffset <= lineStartOffset) {
            return Collections.emptyList();
        }
        if (skipBidiLayout) {
            return Collections.singletonList(new BidiRun(lineEndOffset - lineStartOffset));
        }
        CharSequence text = document.getImmutableCharSequence().subSequence(lineStartOffset, lineEndOffset);
        char[] chars = CharArrayUtil.fromSequence((CharSequence)text);
        return LineLayout.createRuns(view, chars, lineStartOffset);
    }

    private static List<BidiRun> createFragments(@NotNull EditorView view, @NotNull CharSequence text, @JdkConstants.FontStyle int fontStyle) {
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/openapi/editor/impl/view/LineLayout", "createFragments"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/editor/impl/view/LineLayout", "createFragments"));
        }
        if (text.length() == 0) {
            return Collections.emptyList();
        }
        FontRenderContext fontRenderContext = view.getFontRenderContext();
        FontPreferences fontPreferences = view.getEditor().getColorsScheme().getFontPreferences();
        char[] chars = CharArrayUtil.fromSequence((CharSequence)text);
        List<BidiRun> runs = LineLayout.createRuns(view, chars, -1);
        for (BidiRun run2 : runs) {
            for (Chunk chunk : run2.getChunks(text, 0)) {
                chunk.fragments = new ArrayList<LineFragment>();
                LineLayout.addFragments(run2, chunk, chars, chunk.startOffset, chunk.endOffset, fontStyle, fontPreferences, fontRenderContext, null);
            }
        }
        return runs;
    }

    private static List<BidiRun> createRuns(EditorView view, char[] text, int startOffsetInEditor) {
        int textLength = text.length;
        if (view.getEditor().myDisableRtl || !Bidi.requiresBidi(text, 0, textLength)) {
            return Collections.singletonList(new BidiRun(textLength));
        }
        ArrayList<BidiRun> runs = new ArrayList<BidiRun>();
        int flags = view.getBidiFlags();
        if (startOffsetInEditor >= 0) {
            int relLastOffset = 0;
            IElementType lastToken = null;
            HighlighterIterator iterator = view.getEditor().getHighlighter().createIterator(startOffsetInEditor);
            while (!iterator.atEnd() && iterator.getStart() - startOffsetInEditor < textLength) {
                int iteratorRelStart = LineLayout.alignToCodePointBoundary(text, iterator.getStart() - startOffsetInEditor);
                int iteratorRelEnd = LineLayout.alignToCodePointBoundary(text, iterator.getEnd() - startOffsetInEditor);
                IElementType currentToken = iterator.getTokenType();
                int relStartOffset = Math.max(0, iteratorRelStart);
                String lcPrefix = LineLayout.getLineCommentPrefix(currentToken);
                if (!StringUtil.isEmpty((String)lcPrefix) && lcPrefix.length() <= iteratorRelEnd - iteratorRelStart && CharArrayUtil.regionMatches((char[])text, (int)relStartOffset, (int)(relStartOffset + lcPrefix.length()), (CharSequence)lcPrefix) && !LineLayout.isInsideSurrogatePair(text, relStartOffset + lcPrefix.length())) {
                    LineLayout.addRuns(runs, text, relLastOffset, relStartOffset, flags);
                    int textStartOffset = Math.min(textLength, Math.min(iteratorRelEnd, CharArrayUtil.shiftForward((char[])text, (int)(relStartOffset + lcPrefix.length()), (String)" \t")));
                    relLastOffset = Math.min(iteratorRelEnd, textLength);
                    lastToken = null;
                    LineLayout.addRuns(runs, text, relStartOffset, textStartOffset, flags);
                    LineLayout.addRuns(runs, text, textStartOffset, relLastOffset, flags);
                } else if (LineLayout.distinctTokens(lastToken, currentToken)) {
                    LineLayout.addRuns(runs, text, relLastOffset, relStartOffset, flags);
                    lastToken = currentToken;
                    relLastOffset = relStartOffset;
                }
                iterator.advance();
            }
            LineLayout.addRuns(runs, text, relLastOffset, textLength, flags);
        } else {
            LineLayout.addRuns(runs, text, 0, textLength, flags);
        }
        for (BidiRun run2 : runs) {
            assert (!LineLayout.isInsideSurrogatePair(text, run2.startOffset));
            assert (!LineLayout.isInsideSurrogatePair(text, run2.endOffset));
        }
        return runs;
    }

    private static boolean isInsideSurrogatePair(char[] text, int offset) {
        return offset > 0 && offset < text.length && Character.isHighSurrogate(text[offset - 1]) && Character.isLowSurrogate(text[offset]);
    }

    private static int alignToCodePointBoundary(char[] text, int offset) {
        return LineLayout.isInsideSurrogatePair(text, offset) ? offset - 1 : offset;
    }

    private static int alignToCodePointBoundary(CharSequence text, int offset) {
        return offset > 0 && offset < text.length() && Character.isHighSurrogate(text.charAt(offset - 1)) && Character.isLowSurrogate(text.charAt(offset)) ? offset - 1 : offset;
    }

    private static String getLineCommentPrefix(IElementType token) {
        if (token == null) {
            return null;
        }
        Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(token.getLanguage());
        return commenter instanceof CodeDocumentationAwareCommenter && token.equals(((CodeDocumentationAwareCommenter)commenter).getLineCommentTokenType()) ? commenter.getLineCommentPrefix() : null;
    }

    private static boolean distinctTokens(@Nullable IElementType token1, @Nullable IElementType token2) {
        if (token1 == token2) {
            return false;
        }
        if (token1 == null || token2 == null) {
            return true;
        }
        if (StringEscapesTokenTypes.STRING_LITERAL_ESCAPES.contains(token1) || StringEscapesTokenTypes.STRING_LITERAL_ESCAPES.contains(token2)) {
            return false;
        }
        if (token1 != TokenType.WHITE_SPACE && token2 != TokenType.WHITE_SPACE && !token1.getLanguage().is(token2.getLanguage())) {
            return true;
        }
        Language language = token1.getLanguage();
        if (language == Language.ANY) {
            language = token2.getLanguage();
        }
        BidiRegionsSeparator separator = (BidiRegionsSeparator)LanguageBidiRegionsSeparator.INSTANCE.forLanguage(language);
        return separator.createBorderBetweenTokens(token1, token2);
    }

    private static void addRuns(List<BidiRun> runs, char[] text, int start, int end, int flags) {
        if (start < end && !Bidi.requiresBidi(text, start, end)) {
            LineLayout.addOrMergeRun(runs, new BidiRun(0, start, end));
            return;
        }
        int afterLastTabPosition = start;
        for (int i2 = start; i2 < end; ++i2) {
            if (text[i2] != '\t') continue;
            LineLayout.addRunsNoTabs(runs, text, afterLastTabPosition, i2, flags);
            afterLastTabPosition = i2 + 1;
            LineLayout.addOrMergeRun(runs, new BidiRun(0, i2, i2 + 1));
        }
        LineLayout.addRunsNoTabs(runs, text, afterLastTabPosition, end, flags);
    }

    private static void addRunsNoTabs(List<BidiRun> runs, char[] text, int start, int end, int flags) {
        if (start >= end) {
            return;
        }
        Bidi bidi = new Bidi(text, start, null, 0, end - start, flags);
        int runCount = bidi.getRunCount();
        for (int i2 = 0; i2 < runCount; ++i2) {
            LineLayout.addOrMergeRun(runs, new BidiRun((byte)bidi.getRunLevel(i2), start + bidi.getRunStart(i2), start + bidi.getRunLimit(i2)));
        }
    }

    private static void addOrMergeRun(List<BidiRun> runs, BidiRun run2) {
        int size = runs.size();
        if (size > 0 && runs.get(size - 1).level == 0 && run2.level == 0) {
            BidiRun lastRun = runs.remove(size - 1);
            assert (lastRun.endOffset == run2.startOffset);
            runs.add(new BidiRun(0, lastRun.startOffset, run2.endOffset));
        } else {
            runs.add(run2);
        }
    }

    private static void addFragments(BidiRun run2, Chunk chunk, char[] text, int start, int end, int fontStyle, FontPreferences fontPreferences, FontRenderContext fontRenderContext, @Nullable TabFragment tabFragment) {
        assert (start < end);
        FontInfo currentFontInfo = null;
        int currentIndex = start;
        for (int i2 = start; i2 < end; ++i2) {
            FontInfo fontInfo;
            char nextChar;
            int c = text[i2];
            if (c == 9 && tabFragment != null) {
                assert (run2.level == 0);
                LineLayout.addTextFragmentIfNeeded(chunk, text, currentIndex, i2, currentFontInfo, false);
                chunk.fragments.add(tabFragment);
                currentFontInfo = null;
                currentIndex = i2 + 1;
                continue;
            }
            boolean surrogatePair = false;
            int codePoint = c;
            if (Character.isHighSurrogate((char)c) && i2 + 1 < end && Character.isLowSurrogate(nextChar = text[i2 + 1])) {
                codePoint = Character.toCodePoint((char)c, nextChar);
                surrogatePair = true;
            }
            if (!(fontInfo = ComplementaryFontsRegistry.getFontAbleToDisplay(codePoint, fontStyle, fontPreferences, fontRenderContext)).equals(currentFontInfo)) {
                LineLayout.addTextFragmentIfNeeded(chunk, text, currentIndex, i2, currentFontInfo, run2.isRtl());
                currentFontInfo = fontInfo;
                currentIndex = i2;
            }
            if (!surrogatePair) continue;
            ++i2;
        }
        LineLayout.addTextFragmentIfNeeded(chunk, text, currentIndex, end, currentFontInfo, run2.isRtl());
        assert (!chunk.fragments.isEmpty());
    }

    private static void addTextFragmentIfNeeded(Chunk chunk, char[] chars, int from, int to, FontInfo fontInfo, boolean isRtl) {
        if (to > from) {
            assert (fontInfo != null);
            chunk.fragments.add(TextFragmentFactory.createTextFragment(chars, from, to, isRtl, fontInfo));
        }
    }

    Iterable<VisualFragment> getFragmentsInVisualOrder(final float startX) {
        return new Iterable<VisualFragment>(){

            @Override
            public Iterator<VisualFragment> iterator() {
                return new VisualOrderIterator(null, 0, startX, 0, 0, LineLayout.this.getRunsInVisualOrder());
            }
        };
    }

    Iterator<VisualFragment> getFragmentsInVisualOrder(@NotNull EditorView view, int line, float startX, int startVisualColumn, int startOffset, int endOffset, @Nullable Runnable quickEvaluationListener) {
        BidiRun[] runs;
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/openapi/editor/impl/view/LineLayout", "getFragmentsInVisualOrder"));
        }
        assert (startOffset <= endOffset);
        DocumentEx document = view.getEditor().getDocument();
        int lineStartOffset = document.getLineStartOffset(line);
        assert (!DocumentUtil.isInsideSurrogatePair(document, lineStartOffset + startOffset));
        assert (!DocumentUtil.isInsideSurrogatePair(document, lineStartOffset + endOffset));
        if (startOffset == endOffset) {
            runs = BidiRun.EMPTY_ARRAY;
        } else {
            ArrayList<BidiRun> runList = new ArrayList<BidiRun>();
            for (BidiRun run2 : this.getRunsInLogicalOrder()) {
                if (run2.endOffset <= startOffset) continue;
                if (run2.startOffset >= endOffset) break;
                runList.add(run2.subRun(view, line, startOffset, endOffset, quickEvaluationListener));
            }
            if ((runs = runList.toArray(new BidiRun[runList.size()])).length > 1) {
                LineLayout.reorderRunsVisually(runs);
            }
        }
        return new VisualOrderIterator(view, line, startX, startVisualColumn, startOffset, runs);
    }

    abstract Stream<Chunk> getChunksInLogicalOrder();

    float getWidth() {
        throw new RuntimeException("This LineLayout instance doesn't have precalculated width");
    }

    abstract boolean isLtr();

    abstract boolean isRtlLocation(int var1, boolean var2);

    abstract int findNearestDirectionBoundary(int var1, boolean var2);

    abstract BidiRun[] getRunsInLogicalOrder();

    abstract BidiRun[] getRunsInVisualOrder();

    static class VisualFragment {
        private LineFragment delegate;
        private int startOffset;
        private int startLogicalColumn;
        private int startVisualColumn;
        private float startX;
        private boolean isRtl;

        VisualFragment() {
        }

        boolean isRtl() {
            return this.isRtl;
        }

        int getMinOffset() {
            return this.isRtl ? this.startOffset - this.getLength() : this.startOffset;
        }

        int getMaxOffset() {
            return this.isRtl ? this.startOffset : this.startOffset + this.getLength();
        }

        int getStartOffset() {
            return this.startOffset;
        }

        int getEndOffset() {
            return this.isRtl ? this.startOffset - this.getLength() : this.startOffset + this.getLength();
        }

        int getLength() {
            return this.delegate.getLength();
        }

        int getStartLogicalColumn() {
            return this.startLogicalColumn;
        }

        int getEndLogicalColumn() {
            return this.isRtl ? this.startLogicalColumn - this.getLogicalColumnCount() : this.startLogicalColumn + this.getLogicalColumnCount();
        }

        int getMinLogicalColumn() {
            return this.isRtl ? this.startLogicalColumn - this.getLogicalColumnCount() : this.startLogicalColumn;
        }

        int getMaxLogicalColumn() {
            return this.isRtl ? this.startLogicalColumn : this.startLogicalColumn + this.getLogicalColumnCount();
        }

        int getStartVisualColumn() {
            return this.startVisualColumn;
        }

        int getEndVisualColumn() {
            return this.startVisualColumn + this.getVisualColumnCount();
        }

        int getLogicalColumnCount() {
            return this.delegate.getLogicalColumnCount(this.isRtl ? 0 : this.getMinLogicalColumn());
        }

        int getVisualColumnCount() {
            return this.delegate.getVisualColumnCount(this.startX);
        }

        float getStartX() {
            return this.startX;
        }

        float getEndX() {
            return this.delegate.offsetToX(this.startX, 0, this.getLength());
        }

        float getWidth() {
            return this.getEndX() - this.getStartX();
        }

        int logicalToVisualColumn(int column) {
            return this.startVisualColumn + this.delegate.logicalToVisualColumn(this.startX, this.getMinLogicalColumn(), this.isRtl ? this.startLogicalColumn - column : column - this.startLogicalColumn);
        }

        int visualToLogicalColumn(int column) {
            int relativeLogicalColumn = this.delegate.visualToLogicalColumn(this.startX, this.getMinLogicalColumn(), column - this.startVisualColumn);
            return this.isRtl ? this.startLogicalColumn - relativeLogicalColumn : this.startLogicalColumn + relativeLogicalColumn;
        }

        float offsetToX(int offset) {
            return this.delegate.offsetToX(this.startX, 0, this.getRelativeOffset(offset));
        }

        float offsetToX(float startX, int startOffset, int offset) {
            return this.delegate.offsetToX(startX, this.getRelativeOffset(startOffset), this.getRelativeOffset(offset));
        }

        int[] xToVisualColumn(float x) {
            int[] column = this.delegate.xToVisualColumn(this.startX, x);
            column[0] = column[0] + this.startVisualColumn;
            return column;
        }

        float visualColumnToX(int column) {
            return this.delegate.visualColumnToX(this.startX, column - this.startVisualColumn);
        }

        void draw(Graphics2D g, float x, float y) {
            this.delegate.draw(g, x, y, 0, this.getLength());
        }

        void draw(Graphics2D g, float x, float y, int startRelativeColumn, int endRelativeColumn) {
            this.delegate.draw(g, x, y, startRelativeColumn, endRelativeColumn);
        }

        private int getRelativeOffset(int offset) {
            return this.isRtl ? this.startOffset - offset : offset - this.startOffset;
        }
    }

    private static class VisualOrderIterator
    implements Iterator<VisualFragment> {
        private final EditorView myView;
        private final CharSequence myText;
        private final int myLine;
        private final int myLineStartOffset;
        private final BidiRun[] myRuns;
        private int myRunIndex = 0;
        private int myChunkIndex = 0;
        private int myFragmentIndex = 0;
        private int myOffsetInsideRun = 0;
        private VisualFragment myFragment = new VisualFragment();

        private VisualOrderIterator(EditorView view, int line, float startX, int startVisualColumn, int startOffset, BidiRun[] runsInVisualOrder) {
            this.myView = view;
            this.myText = view == null ? null : view.getEditor().getDocument().getImmutableCharSequence();
            this.myLine = line;
            this.myLineStartOffset = view == null ? 0 : view.getEditor().getDocument().getLineStartOffset(line);
            this.myRuns = runsInVisualOrder;
            this.myFragment.startX = startX;
            this.myFragment.startVisualColumn = startVisualColumn;
            this.myFragment.startOffset = startOffset;
        }

        @Override
        public boolean hasNext() {
            if (this.myRunIndex >= this.myRuns.length) {
                return false;
            }
            BidiRun run2 = this.myRuns[this.myRunIndex];
            Chunk[] chunks = run2.getChunks(this.myText, this.myLineStartOffset);
            if (this.myChunkIndex >= chunks.length) {
                return false;
            }
            Chunk chunk = chunks[run2.isRtl() ? chunks.length - 1 - this.myChunkIndex : this.myChunkIndex];
            if (this.myView != null) {
                chunk.ensureLayout(this.myView, run2, this.myLine);
            }
            return this.myFragmentIndex < chunk.fragments.size();
        }

        @Override
        public VisualFragment next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            BidiRun run2 = this.myRuns[this.myRunIndex];
            if (this.myRunIndex == 0 && this.myChunkIndex == 0 && this.myFragmentIndex == 0) {
                this.myFragment.startLogicalColumn = run2.visualStartLogicalColumn;
            } else {
                if (this.myChunkIndex == 0 && this.myFragmentIndex == 0) {
                    this.myFragment.startLogicalColumn = run2.visualStartLogicalColumn;
                } else {
                    this.myFragment.startLogicalColumn = this.myFragment.getEndLogicalColumn();
                }
                this.myFragment.startVisualColumn = this.myFragment.getEndVisualColumn();
                this.myFragment.startX = this.myFragment.getEndX();
            }
            this.myFragment.isRtl = run2.isRtl();
            Chunk[] chunks = run2.getChunks(this.myText, this.myLineStartOffset);
            Chunk chunk = chunks[run2.isRtl() ? chunks.length - 1 - this.myChunkIndex : this.myChunkIndex];
            this.myFragment.delegate = chunk.fragments.get(run2.isRtl() ? chunk.fragments.size() - 1 - this.myFragmentIndex : this.myFragmentIndex);
            this.myFragment.startOffset = run2.isRtl() ? run2.endOffset - this.myOffsetInsideRun : run2.startOffset + this.myOffsetInsideRun;
            this.myOffsetInsideRun += this.myFragment.getLength();
            ++this.myFragmentIndex;
            if (this.myFragmentIndex >= chunk.fragments.size()) {
                this.myFragmentIndex = 0;
                ++this.myChunkIndex;
                if (this.myChunkIndex >= chunks.length) {
                    this.myChunkIndex = 0;
                    this.myOffsetInsideRun = 0;
                    ++this.myRunIndex;
                }
            }
            return this.myFragment;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class SyntheticChunk
    extends Chunk {
        private SyntheticChunk(int startOffset, int endOffset) {
            super(startOffset, endOffset);
        }

        @Override
        boolean isReal() {
            return false;
        }
    }

    static class Chunk {
        List<LineFragment> fragments;
        private int startOffset;
        private int endOffset;

        private Chunk(int startOffset, int endOffset) {
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }

        private void ensureLayout(@NotNull EditorView view, BidiRun run2, int line) {
            if (view == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/openapi/editor/impl/view/LineLayout$Chunk", "ensureLayout"));
            }
            if (this.isReal()) {
                view.getTextLayoutCache().onChunkAccess(this);
            }
            if (this.fragments != null) {
                return;
            }
            assert (this.isReal());
            this.fragments = new ArrayList<LineFragment>();
            int lineStartOffset = view.getEditor().getDocument().getLineStartOffset(line);
            int start = lineStartOffset + this.startOffset;
            int end = lineStartOffset + this.endOffset;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Text layout for " + view.getEditor().getVirtualFile() + " (" + start + "-" + end + ")");
            }
            IterationState it = new IterationState(view.getEditor(), start, end, null, false, true, false, false);
            FontPreferences fontPreferences = view.getEditor().getColorsScheme().getFontPreferences();
            char[] chars = CharArrayUtil.fromSequence((CharSequence)view.getEditor().getDocument().getImmutableCharSequence(), (int)start, (int)end);
            int currentFontType = 0;
            Color currentColor = null;
            int currentStart = start;
            while (!it.atEnd()) {
                int fontType = it.getMergedAttributes().getFontType();
                Color color = it.getMergedAttributes().getForegroundColor();
                if (fontType != currentFontType || !color.equals(currentColor)) {
                    int tokenStart = it.getStartOffset();
                    if (tokenStart > currentStart) {
                        LineLayout.addFragments(run2, this, chars, currentStart - start, tokenStart - start, currentFontType, fontPreferences, view.getFontRenderContext(), view.getTabFragment());
                    }
                    currentStart = tokenStart;
                    currentFontType = fontType;
                    currentColor = color;
                }
                it.advance();
            }
            if (end > currentStart) {
                LineLayout.addFragments(run2, this, chars, currentStart - start, end - start, currentFontType, fontPreferences, view.getFontRenderContext(), view.getTabFragment());
            }
            view.getSizeManager().textLayoutPerformed(start, end);
            assert (!this.fragments.isEmpty());
        }

        private Chunk subChunk(EditorView view, BidiRun run2, int line, int targetStartOffset, int targetEndOffset, @Nullable Runnable quickEvaluationListener) {
            assert (this.isReal());
            assert (targetStartOffset < this.endOffset);
            assert (targetEndOffset > this.startOffset);
            int start = Math.max(this.startOffset, targetStartOffset);
            int end = Math.min(this.endOffset, targetEndOffset);
            if (quickEvaluationListener != null && this.fragments == null) {
                quickEvaluationListener.run();
                SyntheticChunk chunk = new SyntheticChunk(start, end);
                int startColumn = view.getLogicalPositionCache().offsetToLogicalColumn(line, start);
                int endColumn = view.getLogicalPositionCache().offsetToLogicalColumn(line, end);
                chunk.fragments = Collections.singletonList(new ApproximationFragment(end - start, endColumn - startColumn, view.getMaxCharWidth()));
                return chunk;
            }
            if (start == this.startOffset && end == this.endOffset) {
                return this;
            }
            this.ensureLayout(view, run2, line);
            SyntheticChunk chunk = new SyntheticChunk(start, end);
            chunk.fragments = new ArrayList<LineFragment>();
            int offset = this.startOffset;
            for (LineFragment fragment : this.fragments) {
                if (end <= offset) break;
                int endOffset = offset + fragment.getLength();
                if (start < endOffset) {
                    chunk.fragments.add(fragment.subFragment(Math.max(start, offset) - offset, Math.min(end, endOffset) - offset));
                }
                offset = endOffset;
            }
            return chunk;
        }

        boolean isReal() {
            return true;
        }

        void clearCache() {
            this.fragments = null;
        }
    }

    private static class BidiRun {
        public static final BidiRun[] EMPTY_ARRAY = new BidiRun[0];
        private static final int CHUNK_CHARACTERS = 1024;
        private final byte level;
        private final int startOffset;
        private final int endOffset;
        private int visualStartLogicalColumn;
        private Chunk[] chunks;

        private BidiRun(int length) {
            this(0, 0, length);
        }

        private BidiRun(byte level, int startOffset, int endOffset) {
            this.level = level;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }

        private boolean isRtl() {
            return BitUtil.isSet((int)this.level, (int)1);
        }

        private Chunk[] getChunks(CharSequence text, int startOffsetInText) {
            if (this.chunks == null) {
                int chunkCount = this.getChunkCount();
                this.chunks = new Chunk[chunkCount];
                for (int i2 = 0; i2 < chunkCount; ++i2) {
                    Chunk chunk;
                    int from = this.startOffset + i2 * 1024;
                    int to = i2 == chunkCount - 1 ? this.endOffset : from + 1024;
                    this.chunks[i2] = chunk = new Chunk(LineLayout.alignToCodePointBoundary(text, from + startOffsetInText) - startOffsetInText, LineLayout.alignToCodePointBoundary(text, to + startOffsetInText) - startOffsetInText);
                }
            }
            return this.chunks;
        }

        private int getChunkCount() {
            return (this.endOffset - this.startOffset + 1024 - 1) / 1024;
        }

        private BidiRun subRun(@NotNull EditorView view, int line, int targetStartOffset, int targetEndOffset, @Nullable Runnable quickEvaluationListener) {
            if (view == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/openapi/editor/impl/view/LineLayout$BidiRun", "subRun"));
            }
            assert (targetStartOffset < this.endOffset);
            assert (targetEndOffset > this.startOffset);
            int start = Math.max(this.startOffset, targetStartOffset);
            int end = Math.min(this.endOffset, targetEndOffset);
            BidiRun subRun = new BidiRun(this.level, start, end);
            ArrayList<Chunk> subChunks = new ArrayList<Chunk>();
            DocumentEx document = view.getEditor().getDocument();
            for (Chunk chunk : this.getChunks(document.getImmutableCharSequence(), document.getLineStartOffset(line))) {
                if (chunk.endOffset <= start) continue;
                if (chunk.startOffset >= end) break;
                subChunks.add(chunk.subChunk(view, this, line, start, end, quickEvaluationListener));
            }
            subRun.chunks = subChunks.toArray(new Chunk[subChunks.size()]);
            subRun.visualStartLogicalColumn = (subRun.isRtl() ? end == this.endOffset : start == this.startOffset) ? this.visualStartLogicalColumn : view.getLogicalPositionCache().offsetToLogicalColumn(line, subRun.isRtl() ? end : start);
            return subRun;
        }

        static /* synthetic */ Chunk[] access$402(BidiRun x0, Chunk[] x1) {
            x0.chunks = x1;
            return x1;
        }
    }

    private static class WithSize
    extends LineLayout {
        private final LineLayout myDelegate;
        private final float myWidth;

        private WithSize(@NotNull LineLayout delegate) {
            if (delegate == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/openapi/editor/impl/view/LineLayout$WithSize", "<init>"));
            }
            this.myDelegate = delegate;
            this.myWidth = this.calculateWidth();
        }

        private float calculateWidth() {
            float x = 0.0f;
            for (VisualFragment fragment : this.getFragmentsInVisualOrder(x)) {
                x = fragment.getEndX();
            }
            return x;
        }

        @Override
        Stream<Chunk> getChunksInLogicalOrder() {
            return this.myDelegate.getChunksInLogicalOrder();
        }

        @Override
        float getWidth() {
            return this.myWidth;
        }

        @Override
        boolean isLtr() {
            return this.myDelegate.isLtr();
        }

        @Override
        boolean isRtlLocation(int offset, boolean leanForward) {
            return this.myDelegate.isRtlLocation(offset, leanForward);
        }

        @Override
        int findNearestDirectionBoundary(int offset, boolean lookForward) {
            return this.myDelegate.findNearestDirectionBoundary(offset, lookForward);
        }

        @Override
        BidiRun[] getRunsInLogicalOrder() {
            return this.myDelegate.getRunsInLogicalOrder();
        }

        @Override
        BidiRun[] getRunsInVisualOrder() {
            return this.myDelegate.getRunsInVisualOrder();
        }
    }

    private static class MultiChunk
    extends LineLayout {
        private final BidiRun[] myBidiRunsInLogicalOrder;
        private final BidiRun[] myBidiRunsInVisualOrder;

        private MultiChunk(BidiRun[] bidiRunsInLogicalOrder) {
            this.myBidiRunsInLogicalOrder = bidiRunsInLogicalOrder;
            if (bidiRunsInLogicalOrder.length > 1) {
                this.myBidiRunsInVisualOrder = (BidiRun[])this.myBidiRunsInLogicalOrder.clone();
                LineLayout.reorderRunsVisually(this.myBidiRunsInVisualOrder);
            } else {
                this.myBidiRunsInVisualOrder = bidiRunsInLogicalOrder;
            }
        }

        @Override
        Stream<Chunk> getChunksInLogicalOrder() {
            return Stream.of(this.myBidiRunsInLogicalOrder).flatMap(r -> ((BidiRun)r).chunks == null ? Stream.empty() : Stream.of(((BidiRun)r).chunks));
        }

        @Override
        boolean isLtr() {
            return this.myBidiRunsInLogicalOrder.length == 0 || this.myBidiRunsInLogicalOrder.length == 1 && !this.myBidiRunsInLogicalOrder[0].isRtl();
        }

        @Override
        boolean isRtlLocation(int offset, boolean leanForward) {
            if (offset == 0 && !leanForward) {
                return false;
            }
            for (BidiRun run2 : this.myBidiRunsInLogicalOrder) {
                if (offset >= run2.endOffset && (offset != run2.endOffset || leanForward)) continue;
                return run2.isRtl();
            }
            return false;
        }

        @Override
        int findNearestDirectionBoundary(int offset, boolean lookForward) {
            if (lookForward) {
                byte originLevel = -1;
                for (BidiRun run2 : this.myBidiRunsInLogicalOrder) {
                    if (originLevel >= 0) {
                        if (run2.level == originLevel) continue;
                        return run2.startOffset;
                    }
                    if (run2.endOffset <= offset) continue;
                    originLevel = run2.level;
                }
                return originLevel > 0 ? this.myBidiRunsInLogicalOrder[this.myBidiRunsInLogicalOrder.length - 1].endOffset : -1;
            }
            byte originLevel = -1;
            for (int i2 = this.myBidiRunsInLogicalOrder.length - 1; i2 >= 0; --i2) {
                BidiRun run3 = this.myBidiRunsInLogicalOrder[i2];
                if (originLevel >= 0) {
                    if (run3.level == originLevel) continue;
                    return run3.endOffset;
                }
                if (run3.startOffset >= offset) continue;
                originLevel = run3.level;
            }
            return originLevel > 0 ? 0 : -1;
        }

        @Override
        BidiRun[] getRunsInLogicalOrder() {
            return this.myBidiRunsInLogicalOrder;
        }

        @Override
        BidiRun[] getRunsInVisualOrder() {
            return this.myBidiRunsInVisualOrder;
        }
    }

    private static class SingleChunk
    extends LineLayout {
        private final Chunk myChunk;

        private SingleChunk(Chunk chunk) {
            this.myChunk = chunk;
        }

        @Override
        Stream<Chunk> getChunksInLogicalOrder() {
            return this.myChunk == null ? Stream.empty() : Stream.of(this.myChunk);
        }

        @Override
        boolean isLtr() {
            return true;
        }

        @Override
        boolean isRtlLocation(int offset, boolean leanForward) {
            return false;
        }

        @Override
        int findNearestDirectionBoundary(int offset, boolean lookForward) {
            return -1;
        }

        @Override
        BidiRun[] getRunsInLogicalOrder() {
            return this.createRuns();
        }

        @Override
        BidiRun[] getRunsInVisualOrder() {
            return this.createRuns();
        }

        private BidiRun[] createRuns() {
            if (this.myChunk == null) {
                return BidiRun.EMPTY_ARRAY;
            }
            BidiRun run2 = new BidiRun(this.myChunk.endOffset);
            BidiRun.access$402(run2, new Chunk[]{this.myChunk});
            return new BidiRun[]{run2};
        }
    }
}

