/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.importing.ImportSpecBuilder;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.service.project.ProjectRenameAware;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManager;
import com.intellij.openapi.externalSystem.service.ui.ExternalToolWindowManager;
import com.intellij.openapi.externalSystem.service.vcs.ExternalSystemVcsRegistrar;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.util.DisposeAwareRunnable;
import org.jetbrains.annotations.NotNull;

public class ExternalSystemStartupActivity
implements StartupActivity {
    public void runActivity(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/ExternalSystemStartupActivity", "runActivity"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        Runnable task = () -> {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/ExternalSystemStartupActivity", "lambda$runActivity$0"));
            }
            for (ExternalSystemManager manager : ExternalSystemApiUtil.getAllManagers()) {
                if (!(manager instanceof StartupActivity)) continue;
                ((StartupActivity)manager).runActivity(project2);
            }
            if (project2.getUserData(ExternalSystemDataKeys.NEWLY_IMPORTED_PROJECT) != Boolean.TRUE) {
                for (ExternalSystemManager manager : (ExternalSystemManager[])ExternalSystemManager.EP_NAME.getExtensions()) {
                    boolean isNewProject;
                    boolean bl = isNewProject = project2.getUserData(ExternalSystemDataKeys.NEWLY_CREATED_PROJECT) == Boolean.TRUE;
                    if (!isNewProject) continue;
                    ExternalSystemUtil.refreshProjects(new ImportSpecBuilder(project2, manager.getSystemId()));
                }
            }
            ExternalToolWindowManager.handle(project2);
            ExternalSystemVcsRegistrar.handle(project2);
            ProjectRenameAware.beAware(project2);
        };
        ExternalProjectsManager.getInstance(project2).init();
        DumbService.getInstance((Project)project2).runWhenSmart(DisposeAwareRunnable.create((Runnable)task, (Project)project2));
    }
}

