/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.execution;

import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.ExternalSystemUiAware;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskPojo;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.ui.DefaultExternalSystemUiAware;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractExternalSystemTaskConfigurationType
implements ConfigurationType {
    @NotNull
    private final ProjectSystemId myExternalSystemId;
    @NotNull
    private final ConfigurationFactory[] myFactories;
    @NotNull
    private final NotNullLazyValue<Icon> myIcon;

    protected AbstractExternalSystemTaskConfigurationType(@NotNull ProjectSystemId externalSystemId) {
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSystemId", "com/intellij/openapi/externalSystem/service/execution/AbstractExternalSystemTaskConfigurationType", "<init>"));
        }
        this.myFactories = new ConfigurationFactory[1];
        this.myIcon = new NotNullLazyValue<Icon>(){

            @NotNull
            protected Icon compute() {
                ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)AbstractExternalSystemTaskConfigurationType.this.myExternalSystemId);
                Icon result2 = null;
                if (manager instanceof ExternalSystemUiAware) {
                    result2 = ((ExternalSystemUiAware)manager).getProjectIcon();
                }
                Icon icon = result2 == null ? DefaultExternalSystemUiAware.INSTANCE.getTaskIcon() : result2;
                if (icon == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/execution/AbstractExternalSystemTaskConfigurationType$1", "compute"));
                }
                return icon;
            }
        };
        this.myExternalSystemId = externalSystemId;
        this.myFactories[0] = new ConfigurationFactory(this){

            @NotNull
            public RunConfiguration createTemplateConfiguration(@NotNull Project project2) {
                if (project2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/execution/AbstractExternalSystemTaskConfigurationType$2", "createTemplateConfiguration"));
                }
                ExternalSystemRunConfiguration externalSystemRunConfiguration = AbstractExternalSystemTaskConfigurationType.this.doCreateConfiguration(AbstractExternalSystemTaskConfigurationType.this.myExternalSystemId, project2, this, "");
                if (externalSystemRunConfiguration == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/execution/AbstractExternalSystemTaskConfigurationType$2", "createTemplateConfiguration"));
                }
                return externalSystemRunConfiguration;
            }
        };
    }

    @NotNull
    public ProjectSystemId getExternalSystemId() {
        ProjectSystemId projectSystemId = this.myExternalSystemId;
        if (projectSystemId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/execution/AbstractExternalSystemTaskConfigurationType", "getExternalSystemId"));
        }
        return projectSystemId;
    }

    @NotNull
    public ConfigurationFactory getFactory() {
        ConfigurationFactory configurationFactory = this.myFactories[0];
        if (configurationFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/execution/AbstractExternalSystemTaskConfigurationType", "getFactory"));
        }
        return configurationFactory;
    }

    @NotNull
    protected ExternalSystemRunConfiguration doCreateConfiguration(@NotNull ProjectSystemId externalSystemId, @NotNull Project project2, @NotNull ConfigurationFactory factory, @NotNull String name) {
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSystemId", "com/intellij/openapi/externalSystem/service/execution/AbstractExternalSystemTaskConfigurationType", "doCreateConfiguration"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/execution/AbstractExternalSystemTaskConfigurationType", "doCreateConfiguration"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/openapi/externalSystem/service/execution/AbstractExternalSystemTaskConfigurationType", "doCreateConfiguration"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/externalSystem/service/execution/AbstractExternalSystemTaskConfigurationType", "doCreateConfiguration"));
        }
        ExternalSystemRunConfiguration externalSystemRunConfiguration = new ExternalSystemRunConfiguration(externalSystemId, project2, factory, name);
        if (externalSystemRunConfiguration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/execution/AbstractExternalSystemTaskConfigurationType", "doCreateConfiguration"));
        }
        return externalSystemRunConfiguration;
    }

    public String getDisplayName() {
        return this.myExternalSystemId.getReadableName();
    }

    public String getConfigurationTypeDescription() {
        return ExternalSystemBundle.message((String)"run.configuration.description", (Object[])new Object[]{this.myExternalSystemId.getReadableName()});
    }

    public Icon getIcon() {
        return (Icon)this.myIcon.getValue();
    }

    @NotNull
    public String getId() {
        String string = this.myExternalSystemId.getReadableName() + "RunConfiguration";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/execution/AbstractExternalSystemTaskConfigurationType", "getId"));
        }
        return string;
    }

    public ConfigurationFactory[] getConfigurationFactories() {
        return this.myFactories;
    }

    @NotNull
    public static String generateName(@NotNull Project project2, @NotNull ExternalSystemTaskExecutionSettings settings) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/execution/AbstractExternalSystemTaskConfigurationType", "generateName"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/openapi/externalSystem/service/execution/AbstractExternalSystemTaskConfigurationType", "generateName"));
        }
        String string = AbstractExternalSystemTaskConfigurationType.generateName(project2, settings.getExternalSystemId(), settings.getExternalProjectPath(), settings.getTaskNames(), settings.getExecutionName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/execution/AbstractExternalSystemTaskConfigurationType", "generateName"));
        }
        return string;
    }

    @NotNull
    public static String generateName(@NotNull Project project2, @NotNull ExternalTaskPojo task, @NotNull ProjectSystemId externalSystemId) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/execution/AbstractExternalSystemTaskConfigurationType", "generateName"));
        }
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/externalSystem/service/execution/AbstractExternalSystemTaskConfigurationType", "generateName"));
        }
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSystemId", "com/intellij/openapi/externalSystem/service/execution/AbstractExternalSystemTaskConfigurationType", "generateName"));
        }
        String string = AbstractExternalSystemTaskConfigurationType.generateName(project2, externalSystemId, task.getLinkedExternalProjectPath(), Collections.singletonList(task.getName()));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/execution/AbstractExternalSystemTaskConfigurationType", "generateName"));
        }
        return string;
    }

    @NotNull
    public static String generateName(@NotNull Project project2, @NotNull ProjectSystemId externalSystemId, @Nullable String externalProjectPath, @NotNull List<String> taskNames) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/execution/AbstractExternalSystemTaskConfigurationType", "generateName"));
        }
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSystemId", "com/intellij/openapi/externalSystem/service/execution/AbstractExternalSystemTaskConfigurationType", "generateName"));
        }
        if (taskNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskNames", "com/intellij/openapi/externalSystem/service/execution/AbstractExternalSystemTaskConfigurationType", "generateName"));
        }
        String string = AbstractExternalSystemTaskConfigurationType.generateName(project2, externalSystemId, externalProjectPath, taskNames, null);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/execution/AbstractExternalSystemTaskConfigurationType", "generateName"));
        }
        return string;
    }

    @NotNull
    public static String generateName(@NotNull Project project2, @NotNull ProjectSystemId externalSystemId, @Nullable String externalProjectPath, @NotNull List<String> taskNames, @Nullable String executionName) {
        String projectName;
        ExternalProjectInfo projectInfo;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/execution/AbstractExternalSystemTaskConfigurationType", "generateName"));
        }
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSystemId", "com/intellij/openapi/externalSystem/service/execution/AbstractExternalSystemTaskConfigurationType", "generateName"));
        }
        if (taskNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskNames", "com/intellij/openapi/externalSystem/service/execution/AbstractExternalSystemTaskConfigurationType", "generateName"));
        }
        String rootProjectPath = null;
        if (externalProjectPath != null && (projectInfo = ExternalSystemUtil.getExternalProjectInfo(project2, externalSystemId, externalProjectPath)) != null) {
            rootProjectPath = projectInfo.getExternalProjectPath();
        }
        StringBuilder buffer = new StringBuilder();
        if (rootProjectPath == null) {
            projectName = null;
        } else {
            ExternalSystemUiAware uiAware = ExternalSystemUiUtil.getUiAware(externalSystemId);
            projectName = uiAware.getProjectRepresentationName(project2, externalProjectPath, rootProjectPath);
        }
        if (!StringUtil.isEmptyOrSpaces(projectName)) {
            buffer.append(projectName);
            buffer.append(' ');
        } else {
            buffer.append(externalProjectPath);
            buffer.append(' ');
        }
        buffer.append('[');
        if (!StringUtil.isEmpty((String)executionName)) {
            buffer.append(executionName);
        } else if (!taskNames.isEmpty()) {
            for (String taskName : taskNames) {
                buffer.append(taskName).append(' ');
            }
            buffer.setLength(buffer.length() - 1);
        }
        buffer.append(']');
        String string = buffer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/execution/AbstractExternalSystemTaskConfigurationType", "generateName"));
        }
        return string;
    }
}

