/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project;

import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.DependencyData;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.LibraryDependencyData;
import com.intellij.openapi.externalSystem.model.project.LibraryLevel;
import com.intellij.openapi.externalSystem.model.project.LibraryPathType;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ModuleDependencyData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModelsProvider;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeModelsProviderImpl
implements IdeModelsProvider {
    @NotNull
    protected final Project myProject;

    public IdeModelsProviderImpl(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/IdeModelsProviderImpl", "<init>"));
        }
        this.myProject = project2;
    }

    @NotNull
    public Module[] getModules() {
        Module[] moduleArray = ModuleManager.getInstance((Project)this.myProject).getModules();
        if (moduleArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/IdeModelsProviderImpl", "getModules"));
        }
        return moduleArray;
    }

    @NotNull
    public Module[] getModules(@NotNull ProjectData projectData) {
        if (projectData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectData", "com/intellij/openapi/externalSystem/service/project/IdeModelsProviderImpl", "getModules"));
        }
        List modules = ContainerUtil.filter((Object[])this.getModules(), module2 -> {
            if (projectData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectData", "com/intellij/openapi/externalSystem/service/project/IdeModelsProviderImpl", "lambda$getModules$0"));
            }
            return ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)projectData.getOwner(), (Module)module2) && StringUtil.equals((CharSequence)projectData.getLinkedExternalProjectPath(), (CharSequence)ExternalSystemApiUtil.getExternalRootProjectPath((Module)module2));
        });
        Module[] moduleArray = (Module[])ContainerUtil.toArray((List)modules, (Object[])new Module[modules.size()]);
        if (moduleArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/IdeModelsProviderImpl", "getModules"));
        }
        return moduleArray;
    }

    @NotNull
    public OrderEntry[] getOrderEntries(@NotNull Module module2) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/externalSystem/service/project/IdeModelsProviderImpl", "getOrderEntries"));
        }
        OrderEntry[] orderEntryArray = ModuleRootManager.getInstance((Module)module2).getOrderEntries();
        if (orderEntryArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/IdeModelsProviderImpl", "getOrderEntries"));
        }
        return orderEntryArray;
    }

    @Nullable
    public Module findIdeModule(@NotNull ModuleData module2) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/externalSystem/service/project/IdeModelsProviderImpl", "findIdeModule"));
        }
        for (String candidate : this.suggestModuleNameCandidates(module2)) {
            Module ideModule = this.findIdeModule(candidate);
            if (ideModule == null || !IdeModelsProviderImpl.isApplicableIdeModule(module2, ideModule)) continue;
            return ideModule;
        }
        return null;
    }

    protected String[] suggestModuleNameCandidates(@NotNull ModuleData module2) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/externalSystem/service/project/IdeModelsProviderImpl", "suggestModuleNameCandidates"));
        }
        String prefix = module2.getGroup();
        File modulePath = new File(module2.getLinkedExternalProjectPath());
        if (modulePath.isFile()) {
            modulePath = modulePath.getParentFile();
        }
        if (modulePath.getParentFile() != null) {
            prefix = modulePath.getParentFile().getName();
        }
        return new String[]{module2.getInternalName(), prefix + '-' + module2.getInternalName(), prefix + '-' + module2.getInternalName() + "~1"};
    }

    private static boolean isApplicableIdeModule(@NotNull ModuleData moduleData, @NotNull Module ideModule) {
        if (moduleData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleData", "com/intellij/openapi/externalSystem/service/project/IdeModelsProviderImpl", "isApplicableIdeModule"));
        }
        if (ideModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideModule", "com/intellij/openapi/externalSystem/service/project/IdeModelsProviderImpl", "isApplicableIdeModule"));
        }
        for (VirtualFile root : ModuleRootManager.getInstance((Module)ideModule).getContentRoots()) {
            if (!FileUtil.pathsEqual((String)root.getPath(), (String)moduleData.getLinkedExternalProjectPath())) continue;
            return true;
        }
        return ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)moduleData.getOwner(), (Module)ideModule) && FileUtil.pathsEqual((String)ExternalSystemApiUtil.getExternalProjectPath((Module)ideModule), (String)moduleData.getLinkedExternalProjectPath());
    }

    @Nullable
    public Module findIdeModule(@NotNull String ideModuleName) {
        if (ideModuleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideModuleName", "com/intellij/openapi/externalSystem/service/project/IdeModelsProviderImpl", "findIdeModule"));
        }
        return ModuleManager.getInstance((Project)this.myProject).findModuleByName(ideModuleName);
    }

    @Nullable
    public Library findIdeLibrary(@NotNull LibraryData libraryData) {
        if (libraryData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryData", "com/intellij/openapi/externalSystem/service/project/IdeModelsProviderImpl", "findIdeLibrary"));
        }
        LibraryTable libraryTable = LibraryTablesRegistrar.getInstance().getLibraryTable(this.myProject);
        for (Library ideLibrary : libraryTable.getLibraries()) {
            if (!ExternalSystemApiUtil.isRelated((Library)ideLibrary, (LibraryData)libraryData)) continue;
            return ideLibrary;
        }
        return null;
    }

    @Nullable
    public ModuleOrderEntry findIdeModuleDependency(@NotNull ModuleDependencyData dependency, @NotNull Module module2) {
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/intellij/openapi/externalSystem/service/project/IdeModelsProviderImpl", "findIdeModuleDependency"));
        }
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/externalSystem/service/project/IdeModelsProviderImpl", "findIdeModuleDependency"));
        }
        for (OrderEntry entry : this.getOrderEntries(module2)) {
            if (!(entry instanceof ModuleOrderEntry)) continue;
            ModuleOrderEntry candidate = (ModuleOrderEntry)entry;
            if (!dependency.getInternalName().equals(candidate.getModuleName()) || !dependency.getScope().equals((Object)candidate.getScope())) continue;
            return candidate;
        }
        return null;
    }

    @Nullable
    public OrderEntry findIdeModuleOrderEntry(@NotNull DependencyData data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/openapi/externalSystem/service/project/IdeModelsProviderImpl", "findIdeModuleOrderEntry"));
        }
        Module ownerIdeModule = this.findIdeModule(data.getOwnerModule());
        if (ownerIdeModule == null) {
            return null;
        }
        LibraryDependencyData libraryDependencyData = null;
        ModuleDependencyData moduleDependencyData = null;
        if (data instanceof LibraryDependencyData) {
            libraryDependencyData = (LibraryDependencyData)data;
        } else if (data instanceof ModuleDependencyData) {
            moduleDependencyData = (ModuleDependencyData)data;
        } else {
            return null;
        }
        for (OrderEntry entry : this.getOrderEntries(ownerIdeModule)) {
            String entryName;
            if (entry instanceof LibraryOrderEntry && libraryDependencyData != null) {
                if (((LibraryOrderEntry)entry).isModuleLevel() && libraryDependencyData.getLevel() != LibraryLevel.MODULE) continue;
                if (StringUtil.isEmpty((String)((LibraryOrderEntry)entry).getLibraryName())) {
                    Set paths = ContainerUtil.map2Set((Collection)((LibraryData)libraryDependencyData.getTarget()).getPaths(LibraryPathType.BINARY), path -> PathUtil.getLocalPath((String)path));
                    Set entryPaths = ContainerUtil.map2Set((Object[])entry.getUrls(OrderRootType.CLASSES), s -> PathUtil.getLocalPath((String)VfsUtilCore.urlToPath((String)s)));
                    if (!entryPaths.equals(paths) || ((LibraryOrderEntry)entry).getScope() != data.getScope()) continue;
                    return entry;
                }
            }
            String string = entryName = libraryDependencyData != null ? libraryDependencyData.getInternalName() : moduleDependencyData.getInternalName();
            if (!entryName.equals(entry.getPresentableName()) || entry instanceof ExportableOrderEntry && ((ExportableOrderEntry)entry).getScope() != data.getScope()) continue;
            return entry;
        }
        return null;
    }

    @NotNull
    public VirtualFile[] getContentRoots(Module module2) {
        VirtualFile[] virtualFileArray = ModuleRootManager.getInstance((Module)module2).getContentRoots();
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/IdeModelsProviderImpl", "getContentRoots"));
        }
        return virtualFileArray;
    }

    @NotNull
    public VirtualFile[] getSourceRoots(Module module2) {
        VirtualFile[] virtualFileArray = ModuleRootManager.getInstance((Module)module2).getSourceRoots();
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/IdeModelsProviderImpl", "getSourceRoots"));
        }
        return virtualFileArray;
    }

    @NotNull
    public VirtualFile[] getSourceRoots(Module module2, boolean includingTests) {
        VirtualFile[] virtualFileArray = ModuleRootManager.getInstance((Module)module2).getSourceRoots(includingTests);
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/IdeModelsProviderImpl", "getSourceRoots"));
        }
        return virtualFileArray;
    }

    @NotNull
    public Library[] getAllLibraries() {
        Library[] libraryArray = LibraryTablesRegistrar.getInstance().getLibraryTable(this.myProject).getLibraries();
        if (libraryArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/IdeModelsProviderImpl", "getAllLibraries"));
        }
        return libraryArray;
    }

    @Nullable
    public Library getLibraryByName(String name) {
        return LibraryTablesRegistrar.getInstance().getLibraryTable(this.myProject).getLibraryByName(name);
    }

    @NotNull
    public String[] getLibraryUrls(@NotNull Library library, @NotNull OrderRootType type) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/openapi/externalSystem/service/project/IdeModelsProviderImpl", "getLibraryUrls"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/externalSystem/service/project/IdeModelsProviderImpl", "getLibraryUrls"));
        }
        String[] stringArray = library.getUrls(type);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/IdeModelsProviderImpl", "getLibraryUrls"));
        }
        return stringArray;
    }

    @NotNull
    public List<Module> getAllDependentModules(@NotNull Module module2) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/externalSystem/service/project/IdeModelsProviderImpl", "getAllDependentModules"));
        }
        List list = ModuleUtilCore.getAllDependentModules((Module)module2);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/IdeModelsProviderImpl", "getAllDependentModules"));
        }
        return list;
    }
}

