/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.file.exclude.ui;

import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.file.exclude.EnforcedPlainTextFileTypeManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.Set;

public class MarkAsOriginalTypeAction
extends DumbAwareAction {
    public void actionPerformed(AnActionEvent e) {
        Project project2 = e.getProject();
        EnforcedPlainTextFileTypeManager typeManager = EnforcedPlainTextFileTypeManager.getInstance();
        if (project2 == null || typeManager == null) {
            return;
        }
        JBIterable selectedFiles = JBIterable.of((Object[])((Object[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY))).filter(file2 -> EnforcedPlainTextFileTypeManager.isApplicableFor(file2) && typeManager.isMarkedAsPlainText((VirtualFile)file2));
        typeManager.resetOriginalFileType(project2, VfsUtilCore.toVirtualFileArray((Collection)selectedFiles.toList()));
    }

    public void update(AnActionEvent e) {
        EnforcedPlainTextFileTypeManager typeManager = EnforcedPlainTextFileTypeManager.getInstance();
        JBIterable selectedFiles = typeManager == null ? JBIterable.empty() : JBIterable.of((Object[])((Object[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY))).filter(file2 -> EnforcedPlainTextFileTypeManager.isApplicableFor(file2) && typeManager.isMarkedAsPlainText((VirtualFile)file2));
        FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        boolean enabled = e.getProject() != null && !selectedFiles.isEmpty();
        Set fileTypes = selectedFiles.map(file2 -> fileTypeManager.getFileTypeByFileName(file2.getName())).toSet();
        if (fileTypes.size() == 1) {
            FileType original = (FileType)fileTypes.iterator().next();
            String originalName = original.getName();
            String text = ActionsBundle.actionText((String)"MarkAsOriginalTypeAction").replace("Original File Type", originalName);
            e.getPresentation().setText(text);
            e.getPresentation().setIcon(original.getIcon());
        }
        e.getPresentation().setEnabledAndVisible(enabled);
    }
}

