/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl.text;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.TextEditorLocation;
import com.intellij.openapi.fileEditor.impl.text.AsyncEditorLoader;
import com.intellij.openapi.fileEditor.impl.text.TextEditorComponent;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileEditor.impl.text.TextEditorState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class TextEditorImpl
extends UserDataHolderBase
implements TextEditor {
    protected final Project myProject;
    private final PropertyChangeSupport myChangeSupport;
    @NotNull
    private final TextEditorComponent myComponent;
    @NotNull
    protected final VirtualFile myFile;
    private final AsyncEditorLoader myAsyncLoader;
    private final Future<?> myLoadingFinished;

    TextEditorImpl(@NotNull Project project2, @NotNull VirtualFile file2, TextEditorProvider provider) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileEditor/impl/text/TextEditorImpl", "<init>"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/text/TextEditorImpl", "<init>"));
        }
        this.myProject = project2;
        this.myFile = file2;
        this.myChangeSupport = new PropertyChangeSupport((Object)this);
        this.myComponent = this.createEditorComponent(project2, file2);
        this.myAsyncLoader = new AsyncEditorLoader(this, this.myComponent, provider);
        this.myLoadingFinished = this.myAsyncLoader.start();
    }

    @NotNull
    protected Runnable loadEditorInBackground() {
        EditorColorsScheme scheme2 = EditorColorsManager.getInstance().getGlobalScheme();
        EditorHighlighter highlighter = EditorHighlighterFactory.getInstance().createEditorHighlighter(this.myFile, scheme2, this.myProject);
        EditorEx editor = (EditorEx)this.getEditor();
        highlighter.setText(editor.getDocument().getImmutableCharSequence());
        Runnable runnable2 = () -> editor.setHighlighter(highlighter);
        if (runnable2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/text/TextEditorImpl", "loadEditorInBackground"));
        }
        return runnable2;
    }

    @NotNull
    protected TextEditorComponent createEditorComponent(Project project2, VirtualFile file2) {
        TextEditorComponent textEditorComponent = new TextEditorComponent(project2, file2, this);
        if (textEditorComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/text/TextEditorImpl", "createEditorComponent"));
        }
        return textEditorComponent;
    }

    public void dispose() {
        this.myComponent.dispose();
    }

    @NotNull
    public TextEditorComponent getComponent() {
        TextEditorComponent textEditorComponent = this.myComponent;
        if (textEditorComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/text/TextEditorImpl", "getComponent"));
        }
        return textEditorComponent;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        JComponent jComponent = this.getActiveEditor().getContentComponent();
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/text/TextEditorImpl", "getPreferredFocusedComponent"));
        }
        return jComponent;
    }

    @NotNull
    public Editor getEditor() {
        Editor editor = this.getActiveEditor();
        if (editor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/text/TextEditorImpl", "getEditor"));
        }
        return editor;
    }

    @NotNull
    private Editor getActiveEditor() {
        Editor editor = this.myComponent.getEditor();
        if (editor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/text/TextEditorImpl", "getActiveEditor"));
        }
        return editor;
    }

    @NotNull
    public String getName() {
        if ("Text" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/text/TextEditorImpl", "getName"));
        }
        return "Text";
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/openapi/fileEditor/impl/text/TextEditorImpl", "getState"));
        }
        TextEditorState textEditorState = this.myAsyncLoader.getEditorState(level);
        if (textEditorState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/text/TextEditorImpl", "getState"));
        }
        return textEditorState;
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/openapi/fileEditor/impl/text/TextEditorImpl", "setState"));
        }
        this.myAsyncLoader.setEditorState((TextEditorState)state);
    }

    public boolean isModified() {
        return this.myComponent.isModified();
    }

    public boolean isValid() {
        return this.myComponent.isEditorValid();
    }

    public void selectNotify() {
        this.myComponent.selectNotify();
    }

    public void deselectNotify() {
    }

    public void updateModifiedProperty() {
        this.myComponent.updateModifiedProperty();
    }

    void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.myChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/fileEditor/impl/text/TextEditorImpl", "addPropertyChangeListener"));
        }
        this.myChangeSupport.addPropertyChangeListener(listener2);
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/fileEditor/impl/text/TextEditorImpl", "removePropertyChangeListener"));
        }
        this.myChangeSupport.removePropertyChangeListener(listener2);
    }

    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    public FileEditorLocation getCurrentLocation() {
        return new TextEditorLocation(this.getEditor().getCaretModel().getLogicalPosition(), (TextEditor)this);
    }

    public StructureViewBuilder getStructureViewBuilder() {
        Document document = this.myComponent.getEditor().getDocument();
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
        if (file2 == null || !file2.isValid()) {
            return null;
        }
        return StructureViewBuilder.PROVIDER.getStructureViewBuilder(file2.getFileType(), file2, this.myProject);
    }

    public boolean canNavigateTo(@NotNull Navigatable navigatable) {
        if (navigatable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigatable", "com/intellij/openapi/fileEditor/impl/text/TextEditorImpl", "canNavigateTo"));
        }
        return navigatable instanceof OpenFileDescriptor && (((OpenFileDescriptor)navigatable).getLine() != -1 || ((OpenFileDescriptor)navigatable).getOffset() >= 0);
    }

    public void navigateTo(@NotNull Navigatable navigatable) {
        if (navigatable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigatable", "com/intellij/openapi/fileEditor/impl/text/TextEditorImpl", "navigateTo"));
        }
        ((OpenFileDescriptor)navigatable).navigateIn(this.getEditor());
    }

    public String toString() {
        return "Editor: " + this.myComponent.getFile();
    }

    /*
     * WARNING - void declaration
     */
    public void waitForLoaded(long timeout, @NotNull TimeUnit timeUnit) throws TimeoutException {
        if (timeUnit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unit", "com/intellij/openapi/fileEditor/impl/text/TextEditorImpl", "waitForLoaded"));
        }
        try {
            void unit;
            this.myLoadingFinished.get(timeout, (TimeUnit)unit);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

