/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileElement;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Component;
import java.util.Arrays;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SchemeImportUtil {
    @Nullable
    public static VirtualFile selectImportSource(@NotNull String[] sourceExtensions, @NotNull Component parent, @Nullable VirtualFile preselect, @Nullable String description) {
        VirtualFile[] preselectFiles;
        FileChooserDialog fileChooser;
        VirtualFile[] virtualFiles;
        if (sourceExtensions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceExtensions", "com/intellij/openapi/options/SchemeImportUtil", "selectImportSource"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/options/SchemeImportUtil", "selectImportSource"));
        }
        final HashSet<String> extensions = new HashSet<String>(Arrays.asList(sourceExtensions));
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, false, false, false, false, false){

            public boolean isFileVisible(VirtualFile file2, boolean showHiddenFiles) {
                return !(!file2.isDirectory() && !extensions.contains(file2.getExtension()) || !showHiddenFiles && FileElement.isFileHidden((VirtualFile)file2));
            }

            public boolean isFileSelectable(VirtualFile file2) {
                return !file2.isDirectory() && extensions.contains(file2.getExtension());
            }
        };
        if (description != null) {
            descriptor.setDescription(description);
        }
        if ((virtualFiles = (fileChooser = FileChooserFactory.getInstance().createFileChooser(descriptor, null, parent)).choose(null, preselectFiles = preselect != null ? new VirtualFile[]{preselect} : VirtualFile.EMPTY_ARRAY)).length != 1) {
            return null;
        }
        virtualFiles[0].refresh(false, false);
        return virtualFiles[0];
    }
}

