/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.PowerSaveMode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionId;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.DumbUnawareHider;
import com.intellij.openapi.project.NoAccessDuringPsiEvents;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerAdapter;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.AppIconScheme;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.ui.AppIcon;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Queue;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DumbServiceImpl
extends DumbService
implements Disposable,
ModificationTracker {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.project.DumbServiceImpl");
    private static Throwable ourForcedTrace;
    private final AtomicReference<State> myState = new AtomicReference<State>(State.SMART);
    private volatile Throwable myDumbStart;
    private volatile TransactionId myDumbStartTransaction;
    private final DumbService.DumbModeListener myPublisher;
    private long myModificationCount;
    private final Set<Object> myQueuedEquivalences = new HashSet<Object>();
    private final Queue<DumbModeTask> myUpdatesQueue = new Queue(5);
    private final Map<DumbModeTask, ProgressIndicatorEx> myProgresses = ContainerUtil.newConcurrentMap();
    private final Queue<Runnable> myRunWhenSmartQueue = new Queue(5);
    private final Project myProject;
    private final ThreadLocal<Integer> myAlternativeResolution = new ThreadLocal();
    private final StartupManager myStartupManager;

    public DumbServiceImpl(Project project2, StartupManager startupManager) {
        this.myProject = project2;
        this.myPublisher = (DumbService.DumbModeListener)project2.getMessageBus().syncPublisher(DUMB_MODE);
        this.myStartupManager = startupManager;
    }

    public static DumbServiceImpl getInstance(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/project/DumbServiceImpl", "getInstance"));
        }
        return (DumbServiceImpl)DumbService.getInstance((Project)project2);
    }

    public void cancelTask(@NotNull DumbModeTask task) {
        ProgressIndicatorEx indicator;
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/project/DumbServiceImpl", "cancelTask"));
        }
        if (ApplicationManager.getApplication().isInternal()) {
            LOG.info("cancel " + task);
        }
        if ((indicator = this.myProgresses.get(task)) != null) {
            indicator.cancel();
        }
    }

    public void dispose() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myUpdatesQueue.clear();
        this.myQueuedEquivalences.clear();
        this.myRunWhenSmartQueue.clear();
        for (DumbModeTask task : new ArrayList<DumbModeTask>(this.myProgresses.keySet())) {
            this.cancelTask(task);
            Disposer.dispose((Disposable)task);
        }
    }

    public Project getProject() {
        return this.myProject;
    }

    public boolean isAlternativeResolveEnabled() {
        return this.myAlternativeResolution.get() != null;
    }

    public void setAlternativeResolveEnabled(boolean enabled) {
        Integer oldValue = this.myAlternativeResolution.get();
        int newValue = (oldValue == null ? 0 : oldValue) + (enabled ? 1 : -1);
        assert (newValue >= 0) : "Non-paired alternative resolution mode";
        this.myAlternativeResolution.set(newValue == 0 ? null : Integer.valueOf(newValue));
    }

    public ModificationTracker getModificationTracker() {
        return this;
    }

    public boolean isDumb() {
        return this.myState.get() != State.SMART;
    }

    public void setDumb(boolean dumb) {
        if (dumb) {
            this.myState.set(State.RUNNING_DUMB_TASKS);
            this.myPublisher.enteredDumbMode();
        } else {
            this.myState.set(State.WAITING_FOR_FINISH);
            this.updateFinished();
        }
    }

    public void runWhenSmart(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/project/DumbServiceImpl", "runWhenSmart"));
        }
        this.myStartupManager.runWhenProjectIsInitialized(() -> {
            if (runnable2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/project/DumbServiceImpl", "lambda$runWhenSmart$0"));
            }
            Queue<Runnable> queue = this.myRunWhenSmartQueue;
            synchronized (queue) {
                if (this.isDumb()) {
                    this.myRunWhenSmartQueue.addLast((Object)runnable2);
                    return;
                }
            }
            runnable2.run();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueTask(@NotNull DumbModeTask task) {
        Application application;
        Throwable trace;
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/project/DumbServiceImpl", "queueTask"));
        }
        TransactionId contextTransaction = TransactionGuard.getInstance().getContextTransaction();
        Throwable throwable = trace = ourForcedTrace != null ? ourForcedTrace : new Throwable();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Scheduling task " + task);
        }
        if ((application = ApplicationManager.getApplication()).isUnitTestMode() || application.isHeadlessEnvironment()) {
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            if (indicator != null) {
                indicator.pushState();
            }
            AccessToken token = HeavyProcessLatch.INSTANCE.processStarted("Performing indexing task");
            try {
                task.performInDumbMode((ProgressIndicator)(indicator != null ? indicator : new EmptyProgressIndicator()));
            }
            finally {
                token.finish();
                if (indicator != null) {
                    indicator.popState();
                }
                Disposer.dispose((Disposable)task);
            }
            return;
        }
        Runnable runnable2 = () -> {
            if (task == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/project/DumbServiceImpl", "lambda$queueTask$1"));
            }
            this.queueTaskOnEdt(task, contextTransaction, trace);
        };
        if (application.isDispatchThread()) {
            runnable2.run();
        } else {
            TransactionGuard.submitTransaction((Disposable)this.myProject, (Runnable)runnable2);
        }
    }

    private void queueTaskOnEdt(@NotNull DumbModeTask task, @Nullable TransactionId contextTransaction, @NotNull Throwable trace) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/project/DumbServiceImpl", "queueTaskOnEdt"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "com/intellij/openapi/project/DumbServiceImpl", "queueTaskOnEdt"));
        }
        if (!this.addTaskToQueue(task)) {
            return;
        }
        if (this.myState.get() == State.SMART || this.myState.get() == State.WAITING_FOR_FINISH) {
            this.enterDumbMode(contextTransaction, trace);
            ApplicationManager.getApplication().invokeLater(this::startBackgroundProcess, this.myProject.getDisposed());
        }
    }

    private boolean addTaskToQueue(@NotNull DumbModeTask task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/project/DumbServiceImpl", "addTaskToQueue"));
        }
        if (!this.myQueuedEquivalences.add(task.getEquivalenceObject())) {
            Disposer.dispose((Disposable)task);
            return false;
        }
        this.myProgresses.put(task, new ProgressIndicatorBase());
        Disposer.register((Disposable)task, () -> {
            if (task == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/project/DumbServiceImpl", "lambda$addTaskToQueue$2"));
            }
            ApplicationManager.getApplication().assertIsDispatchThread();
            this.myProgresses.remove(task);
        });
        this.myUpdatesQueue.addLast((Object)task);
        return true;
    }

    private void enterDumbMode(@Nullable TransactionId contextTransaction, @NotNull Throwable trace) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "com/intellij/openapi/project/DumbServiceImpl", "enterDumbMode"));
        }
        boolean wasSmart = !this.isDumb();
        WriteAction.run(() -> {
            if (trace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "com/intellij/openapi/project/DumbServiceImpl", "lambda$enterDumbMode$3"));
            }
            Queue<Runnable> queue = this.myRunWhenSmartQueue;
            synchronized (queue) {
                this.myState.set(State.SCHEDULED_TASKS);
            }
            this.myDumbStart = trace;
            this.myDumbStartTransaction = contextTransaction;
            ++this.myModificationCount;
        });
        if (wasSmart) {
            try {
                this.myPublisher.enteredDumbMode();
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
    }

    @NotNull
    public static AccessToken forceDumbModeStartTrace(@NotNull Throwable trace) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "com/intellij/openapi/project/DumbServiceImpl", "forceDumbModeStartTrace"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        final Throwable prev = ourForcedTrace;
        ourForcedTrace = trace;
        AccessToken accessToken = new AccessToken(){

            public void finish() {
                ourForcedTrace = prev;
            }
        };
        if (accessToken == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/project/DumbServiceImpl", "forceDumbModeStartTrace"));
        }
        return accessToken;
    }

    private void queueUpdateFinished() {
        if (this.myState.compareAndSet(State.RUNNING_DUMB_TASKS, State.WAITING_FOR_FINISH)) {
            StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(() -> TransactionGuard.getInstance().submitTransaction((Disposable)this.myProject, this.myDumbStartTransaction, this::updateFinished));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean switchToSmartMode() {
        Queue<Runnable> queue = this.myRunWhenSmartQueue;
        synchronized (queue) {
            if (!this.myState.compareAndSet(State.WAITING_FOR_FINISH, State.SMART)) {
                return false;
            }
        }
        this.myDumbStart = null;
        ++this.myModificationCount;
        return !this.myProject.isDisposed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFinished() {
        if (!((Boolean)WriteAction.compute(this::switchToSmartMode)).booleanValue()) {
            return;
        }
        if (ApplicationManager.getApplication().isInternal()) {
            LOG.info("updateFinished");
        }
        try {
            this.myPublisher.exitDumbMode();
            FileEditorManagerEx.getInstanceEx(this.myProject).refreshIcons();
        }
        catch (Throwable throwable) {
            while (!this.isDumb()) {
                Runnable runnable2;
                Queue<Runnable> queue = this.myRunWhenSmartQueue;
                synchronized (queue) {
                    if (this.myRunWhenSmartQueue.isEmpty()) {
                        break;
                    }
                    runnable2 = (Runnable)this.myRunWhenSmartQueue.pullFirst();
                }
                try {
                    runnable2.run();
                }
                catch (ProcessCanceledException e) {
                    LOG.error("Task canceled: " + runnable2, new Attachment[]{new Attachment("pce", (Throwable)e)});
                }
                catch (Throwable e) {
                    LOG.error("Error executing task " + runnable2, e);
                }
            }
            throw throwable;
        }
        while (!this.isDumb()) {
            Runnable runnable3;
            Queue<Runnable> queue = this.myRunWhenSmartQueue;
            synchronized (queue) {
                if (this.myRunWhenSmartQueue.isEmpty()) {
                    break;
                }
                runnable3 = (Runnable)this.myRunWhenSmartQueue.pullFirst();
            }
            try {
                runnable3.run();
            }
            catch (ProcessCanceledException e) {
                LOG.error("Task canceled: " + runnable3, new Attachment[]{new Attachment("pce", (Throwable)e)});
            }
            catch (Throwable e) {
                LOG.error("Error executing task " + runnable3, e);
            }
        }
    }

    public void showDumbModeNotification(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/openapi/project/DumbServiceImpl", "showDumbModeNotification"));
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/openapi/project/DumbServiceImpl", "lambda$showDumbModeNotification$5"));
            }
            IdeFrame ideFrame = WindowManager.getInstance().getIdeFrame(this.myProject);
            if (ideFrame != null) {
                StatusBarEx statusBar = (StatusBarEx)ideFrame.getStatusBar();
                statusBar.notifyProgressByBalloon(MessageType.WARNING, message, null, null);
            }
        });
    }

    public void waitForSmartMode() {
        if (!this.isDumb()) {
            return;
        }
        Application application = ApplicationManager.getApplication();
        if (application.isReadAccessAllowed() || application.isDispatchThread()) {
            throw new AssertionError((Object)"Don't invoke waitForSmartMode from inside read action in dumb mode");
        }
        Semaphore semaphore = new Semaphore();
        semaphore.down();
        this.runWhenSmart(() -> ((Semaphore)semaphore).up());
        while (!semaphore.waitFor(50L)) {
            ProgressManager.checkCanceled();
        }
        return;
    }

    public JComponent wrapGently(@NotNull JComponent dumbUnawareContent, @NotNull Disposable parentDisposable) {
        if (dumbUnawareContent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dumbUnawareContent", "com/intellij/openapi/project/DumbServiceImpl", "wrapGently"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/project/DumbServiceImpl", "wrapGently"));
        }
        final DumbUnawareHider wrapper = new DumbUnawareHider(dumbUnawareContent);
        wrapper.setContentVisible(!this.isDumb());
        this.getProject().getMessageBus().connect(parentDisposable).subscribe(DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void enteredDumbMode() {
                wrapper.setContentVisible(false);
            }

            public void exitDumbMode() {
                wrapper.setContentVisible(true);
            }
        });
        return wrapper;
    }

    public void smartInvokeLater(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/project/DumbServiceImpl", "smartInvokeLater"));
        }
        this.smartInvokeLater(runnable2, ModalityState.defaultModalityState());
    }

    public void smartInvokeLater(@NotNull Runnable runnable2, @NotNull ModalityState modalityState) {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/project/DumbServiceImpl", "smartInvokeLater"));
        }
        if (modalityState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modalityState", "com/intellij/openapi/project/DumbServiceImpl", "smartInvokeLater"));
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (runnable2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/project/DumbServiceImpl", "lambda$smartInvokeLater$7"));
            }
            if (modalityState == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modalityState", "com/intellij/openapi/project/DumbServiceImpl", "lambda$smartInvokeLater$7"));
            }
            if (this.isDumb()) {
                this.runWhenSmart(() -> {
                    if (runnable2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/project/DumbServiceImpl", "lambda$null$6"));
                    }
                    if (modalityState == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modalityState", "com/intellij/openapi/project/DumbServiceImpl", "lambda$null$6"));
                    }
                    this.smartInvokeLater(runnable2, modalityState);
                });
            } else {
                runnable2.run();
            }
        }, modalityState, this.myProject.getDisposed());
    }

    public void completeJustSubmittedTasks() {
        assert (this.myProject.isInitialized());
        if (this.myState.get() != State.SCHEDULED_TASKS) {
            return;
        }
        while (this.isDumb()) {
            this.showModalProgress();
        }
    }

    private void showModalProgress() {
        NoAccessDuringPsiEvents.checkCallContext();
        try {
            ((ApplicationImpl)ApplicationManager.getApplication()).executeSuspendingWriteAction(this.myProject, IdeBundle.message((String)"progress.indexing", (Object[])new Object[0]), () -> this.runBackgroundProcess(ProgressManager.getInstance().getProgressIndicator()));
        }
        finally {
            if (this.myState.get() != State.SMART) {
                if (this.myState.get() != State.WAITING_FOR_FINISH) {
                    throw new AssertionError((Object)this.myState.get());
                }
                this.updateFinished();
            }
        }
    }

    private void startBackgroundProcess() {
        try {
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, IdeBundle.message((String)"progress.indexing", (Object[])new Object[0]), false){

                public void run(@NotNull ProgressIndicator visibleIndicator) {
                    if (visibleIndicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visibleIndicator", "com/intellij/openapi/project/DumbServiceImpl$3", "run"));
                    }
                    DumbServiceImpl.this.runBackgroundProcess(visibleIndicator);
                }
            });
        }
        catch (Throwable e) {
            this.queueUpdateFinished();
            LOG.error("Failed to start background index update task", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void runBackgroundProcess(final @NotNull ProgressIndicator visibleIndicator) {
        block21: {
            if (visibleIndicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", new Object[]{"visibleIndicator", "com/intellij/openapi/project/DumbServiceImpl", "runBackgroundProcess"}));
            }
            if (!this.myState.compareAndSet(State.SCHEDULED_TASKS, State.RUNNING_DUMB_TASKS)) {
                return;
            }
            shutdownTracker = ShutDownTracker.getInstance();
            self = Thread.currentThread();
            try {
                shutdownTracker.registerStopperThread(self);
                if (visibleIndicator instanceof ProgressIndicatorEx) {
                    ((ProgressIndicatorEx)visibleIndicator).addStateDelegate(new AppIconProgress());
                }
                task = null;
                while (true) lbl-1000:
                // 3 sources

                {
                    if ((pair = this.getNextTask(task, visibleIndicator)) == null) {
                        break block21;
                    }
                    task = (DumbModeTask)pair.first;
                    taskIndicator = (ProgressIndicatorEx)pair.second;
                    if (visibleIndicator instanceof ProgressIndicatorEx) {
                        taskIndicator.addStateDelegate(new AbstractProgressIndicatorExBase(){

                            @Override
                            protected void delegateProgressChange(@NotNull AbstractProgressIndicatorExBase.IndicatorAction action) {
                                if (action == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/project/DumbServiceImpl$4", "delegateProgressChange"));
                                }
                                super.delegateProgressChange(action);
                                action.execute((ProgressIndicatorEx)visibleIndicator);
                            }
                        });
                    }
                    ignored = HeavyProcessLatch.INSTANCE.processStarted("Performing indexing tasks");
                    var8_9 = null;
                    try {
                        DumbServiceImpl.runSingleTask(task, taskIndicator);
                    }
                    catch (Throwable var9_11) {
                        var8_9 = var9_11;
                        throw var9_11;
                    }
                    finally {
                        if (ignored == null) continue;
                        if (var8_9 != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable var9_10) {
                                var8_9.addSuppressed(var9_10);
                            }
                            continue;
                        }
                        ignored.close();
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable unexpected) {
                DumbServiceImpl.LOG.error(unexpected);
                break block21;
            }
            finally {
                shutdownTracker.unregisterStopperThread(self);
            }
            ** GOTO lbl-1000
        }
    }

    private static void runSingleTask(DumbModeTask task, ProgressIndicatorEx taskIndicator) {
        if (ApplicationManager.getApplication().isInternal()) {
            LOG.info("Running dumb mode task: " + task);
        }
        ProgressManager.getInstance().runProcess(() -> {
            try {
                taskIndicator.checkCanceled();
                taskIndicator.setIndeterminate(true);
                taskIndicator.setText(IdeBundle.message((String)"progress.indexing.scanning", (Object[])new Object[0]));
                task.performInDumbMode((ProgressIndicator)taskIndicator);
            }
            catch (ProcessCanceledException processCanceledException) {
            }
            catch (Throwable unexpected) {
                LOG.error(unexpected);
            }
        }, (ProgressIndicator)taskIndicator);
    }

    @Nullable
    private Pair<DumbModeTask, ProgressIndicatorEx> getNextTask(@Nullable DumbModeTask prevTask, @NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/project/DumbServiceImpl", "getNextTask"));
        }
        CompletableFuture result2 = new CompletableFuture();
        UIUtil.invokeLaterIfNeeded(() -> {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/project/DumbServiceImpl", "lambda$getNextTask$11"));
            }
            if (this.myProject.isDisposed()) {
                result2.completeExceptionally(new ProcessCanceledException());
                return;
            }
            if (prevTask != null) {
                Disposer.dispose((Disposable)prevTask);
            }
            if (PowerSaveMode.isEnabled() && Registry.is((String)"pause.indexing.in.power.save.mode")) {
                indicator.setText("Indexing paused during Power Save mode...");
                this.runWhenPowerSaveModeChanges(() -> result2.complete(this.pollTaskQueue()));
                this.completeWhenProjectClosed(result2);
            } else {
                result2.complete(this.pollTaskQueue());
            }
        });
        return (Pair)DumbServiceImpl.waitForFuture(result2);
    }

    @Nullable
    private Pair<DumbModeTask, ProgressIndicatorEx> pollTaskQueue() {
        ProgressIndicatorEx indicator;
        DumbModeTask queuedTask;
        while (true) {
            if (this.myUpdatesQueue.isEmpty()) {
                this.queueUpdateFinished();
                return null;
            }
            queuedTask = (DumbModeTask)this.myUpdatesQueue.pullFirst();
            this.myQueuedEquivalences.remove(queuedTask.getEquivalenceObject());
            indicator = this.myProgresses.get(queuedTask);
            if (!indicator.isCanceled()) break;
            Disposer.dispose((Disposable)queuedTask);
        }
        return Pair.create((Object)queuedTask, (Object)indicator);
    }

    @Nullable
    private static <T> T waitForFuture(Future<T> result2) {
        try {
            return result2.get();
        }
        catch (InterruptedException e) {
            return null;
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (!(cause instanceof ProcessCanceledException)) {
                ExceptionUtil.rethrowAllAsUnchecked((Throwable)cause);
            }
            return null;
        }
    }

    private void completeWhenProjectClosed(final CompletableFuture<Pair<DumbModeTask, ProgressIndicatorEx>> result2) {
        ProjectManagerAdapter listener2 = new ProjectManagerAdapter(){

            public void projectClosed(Project project2) {
                result2.completeExceptionally(new ProcessCanceledException());
            }
        };
        ProjectManager.getInstance().addProjectManagerListener(this.myProject, (ProjectManagerListener)listener2);
        result2.thenAccept(p -> ProjectManager.getInstance().removeProjectManagerListener(this.myProject, (ProjectManagerListener)listener2));
    }

    private void runWhenPowerSaveModeChanges(Runnable r) {
        MessageBusConnection connection = this.myProject.getMessageBus().connect();
        connection.subscribe(PowerSaveMode.TOPIC, () -> {
            r.run();
            connection.disconnect();
        });
    }

    public long getModificationCount() {
        return this.myModificationCount;
    }

    @Nullable
    public Throwable getDumbModeStartTrace() {
        return this.myDumbStart;
    }

    private static enum State {
        SMART,
        SCHEDULED_TASKS,
        RUNNING_DUMB_TASKS,
        WAITING_FOR_FINISH;

    }

    private class AppIconProgress
    extends ProgressIndicatorBase {
        private double lastFraction;

        private AppIconProgress() {
        }

        @Override
        public void setFraction(double fraction) {
            if (fraction - this.lastFraction < 0.01) {
                return;
            }
            this.lastFraction = fraction;
            UIUtil.invokeLaterIfNeeded(() -> AppIcon.getInstance().setProgress(DumbServiceImpl.this.myProject, "indexUpdate", AppIconScheme.Progress.INDEXING, fraction, true));
        }

        @Override
        public void finish(@NotNull TaskInfo task) {
            if (task == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/project/DumbServiceImpl$AppIconProgress", "finish"));
            }
            if (this.lastFraction != 0.0) {
                UIUtil.invokeLaterIfNeeded(() -> {
                    AppIcon appIcon = AppIcon.getInstance();
                    if (appIcon.hideProgress(DumbServiceImpl.this.myProject, "indexUpdate")) {
                        appIcon.requestAttention(DumbServiceImpl.this.myProject, false);
                        appIcon.setOkBadge(DumbServiceImpl.this.myProject, true);
                    }
                });
            }
        }
    }
}

