/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectLocatorImpl
extends ProjectLocator {
    @Nullable
    public Project guessProjectForFile(VirtualFile file2) {
        ProjectManager projectManager = ProjectManager.getInstance();
        if (projectManager == null) {
            return null;
        }
        Project[] projects = projectManager.getOpenProjects();
        if (projects.length == 0) {
            return null;
        }
        if (projects.length == 1 && !projects[0].isDisposed()) {
            return projects[0];
        }
        if (file2 != null) {
            Project preferredProject = (Project)file2.getUserData(PREFERRED_PROJECT_KEY);
            if (preferredProject != null) {
                return preferredProject;
            }
            for (Project project2 : projects) {
                if (!project2.isInitialized() || project2.isDisposed() || !ProjectRootManager.getInstance((Project)project2).getFileIndex().isInContent(file2)) continue;
                return project2;
            }
        }
        return !projects[0].isDisposed() ? projects[0] : null;
    }

    @NotNull
    public Collection<Project> getProjectsForFile(VirtualFile file2) {
        ProjectManager projectManager = ProjectManager.getInstance();
        if (projectManager == null || file2 == null) {
            List<Project> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/project/ProjectLocatorImpl", "getProjectsForFile"));
            }
            return list;
        }
        Project[] openProjects = projectManager.getOpenProjects();
        if (openProjects.length == 0) {
            List<Project> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/project/ProjectLocatorImpl", "getProjectsForFile"));
            }
            return list;
        }
        SmartList result2 = new SmartList();
        for (Project project2 : openProjects) {
            if (!project2.isInitialized() || project2.isDisposed() || !ProjectRootManager.getInstance((Project)project2).getFileIndex().isInContent(file2)) continue;
            result2.add(project2);
        }
        SmartList smartList = result2;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/project/ProjectLocatorImpl", "getProjectsForFile"));
        }
        return smartList;
    }
}

