/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.projectRoots.JdkVersionUtil;
import com.intellij.openapi.projectRoots.impl.JavaHomeFinder;
import com.intellij.openapi.util.Comparing;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class WindowsJavaFinder
extends JavaHomeFinder {
    WindowsJavaFinder() {
    }

    @Override
    @NotNull
    protected List<String> findExistingJdks() {
        String x86Suffix;
        boolean x86;
        File anotherJavasFolder;
        String name;
        String property = System.getProperty("java.home");
        if (property == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/impl/WindowsJavaFinder", "findExistingJdks"));
            }
            return list;
        }
        File javaHome = new File(property).getParentFile();
        if (javaHome == null || !javaHome.isDirectory() || javaHome.getParentFile() == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/impl/WindowsJavaFinder", "findExistingJdks"));
            }
            return list;
        }
        ArrayList<String> result2 = new ArrayList<String>();
        File javasFolder = javaHome.getParentFile();
        WindowsJavaFinder.scanFolder(javasFolder, result2);
        File parentFile = javasFolder.getParentFile();
        File root = parentFile != null ? parentFile.getParentFile() : null;
        String string = name = parentFile != null ? parentFile.getName() : "";
        if (name.contains("Program Files") && root != null && (anotherJavasFolder = (x86 = name.endsWith(x86Suffix = " (x86)") && name.length() > x86Suffix.length()) ? new File(root, name.substring(0, name.length() - x86Suffix.length())) : new File(root, name + x86Suffix)).isDirectory()) {
            WindowsJavaFinder.scanFolder(new File(anotherJavasFolder, javasFolder.getName()), result2);
        }
        result2.sort((o1, o2) -> Comparing.compare((Comparable)JdkVersionUtil.getVersion((String)o2), (Comparable)JdkVersionUtil.getVersion((String)o1)));
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/impl/WindowsJavaFinder", "findExistingJdks"));
        }
        return arrayList;
    }
}

