/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.CompilerProjectExtension;
import com.intellij.openapi.roots.ProjectExtension;
import com.intellij.openapi.roots.WatchedRootsProvider;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.containers.HashSet;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompilerProjectExtensionImpl
extends CompilerProjectExtension {
    @NonNls
    private static final String OUTPUT_TAG = "output";
    @NonNls
    private static final String URL = "url";
    private VirtualFilePointer myCompilerOutput;
    private LocalFileSystem.WatchRequest myCompilerOutputWatchRequest;
    private final Project myProject;

    public CompilerProjectExtensionImpl(Project project2) {
        this.myProject = project2;
    }

    private void readExternal(Element element) {
        Element outputPathChild = element.getChild(OUTPUT_TAG);
        if (outputPathChild != null) {
            String outputPath = outputPathChild.getAttributeValue(URL);
            this.myCompilerOutput = VirtualFilePointerManager.getInstance().create(outputPath, (Disposable)this.myProject, null);
        }
    }

    private void writeExternal(Element element) {
        if (this.myCompilerOutput != null) {
            Element pathElement = new Element(OUTPUT_TAG);
            pathElement.setAttribute(URL, this.myCompilerOutput.getUrl());
            element.addContent(pathElement);
        }
    }

    @Nullable
    public VirtualFile getCompilerOutput() {
        if (this.myCompilerOutput == null) {
            return null;
        }
        return this.myCompilerOutput.getFile();
    }

    @Nullable
    public String getCompilerOutputUrl() {
        if (this.myCompilerOutput == null) {
            return null;
        }
        return this.myCompilerOutput.getUrl();
    }

    public VirtualFilePointer getCompilerOutputPointer() {
        return this.myCompilerOutput;
    }

    public void setCompilerOutputPointer(VirtualFilePointer pointer) {
        this.myCompilerOutput = pointer;
    }

    public void setCompilerOutputUrl(String compilerOutputUrl) {
        VirtualFilePointer pointer = VirtualFilePointerManager.getInstance().create(compilerOutputUrl, (Disposable)this.myProject, null);
        this.setCompilerOutputPointer(pointer);
        String path = VfsUtilCore.urlToPath((String)compilerOutputUrl);
        this.myCompilerOutputWatchRequest = LocalFileSystem.getInstance().replaceWatchedRoot(this.myCompilerOutputWatchRequest, path, true);
    }

    @NotNull
    private Set<String> getRootsToWatch() {
        Module[] modules;
        HashSet rootsToWatch = new HashSet();
        for (Module module2 : modules = ModuleManager.getInstance((Project)this.myProject).getModules()) {
            String compilerOutputPathForTests;
            String compilerOutputPath = ProjectRootManagerImpl.extractLocalPath(CompilerModuleExtension.getInstance((Module)module2).getCompilerOutputUrl());
            if (compilerOutputPath.length() > 0) {
                rootsToWatch.add(compilerOutputPath);
            }
            if ((compilerOutputPathForTests = ProjectRootManagerImpl.extractLocalPath(CompilerModuleExtension.getInstance((Module)module2).getCompilerOutputUrlForTests())).length() <= 0) continue;
            rootsToWatch.add(compilerOutputPathForTests);
        }
        if (this.myCompilerOutput != null) {
            String url = this.myCompilerOutput.getUrl();
            rootsToWatch.add(ProjectRootManagerImpl.extractLocalPath(url));
        }
        HashSet hashSet = rootsToWatch;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/CompilerProjectExtensionImpl", "getRootsToWatch"));
        }
        return hashSet;
    }

    private static CompilerProjectExtensionImpl getImpl(Project project2) {
        return (CompilerProjectExtensionImpl)CompilerProjectExtension.getInstance((Project)project2);
    }

    public static class MyWatchedRootsProvider
    implements WatchedRootsProvider {
        private final Project myProject;

        public MyWatchedRootsProvider(Project project2) {
            this.myProject = project2;
        }

        @NotNull
        public Set<String> getRootsToWatch() {
            Set set2 = CompilerProjectExtensionImpl.getImpl(this.myProject).getRootsToWatch();
            if (set2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/CompilerProjectExtensionImpl$MyWatchedRootsProvider", "getRootsToWatch"));
            }
            return set2;
        }
    }

    public static class MyProjectExtension
    extends ProjectExtension {
        private final Project myProject;

        public MyProjectExtension(Project project2) {
            this.myProject = project2;
        }

        @Override
        public void readExternal(@NotNull Element element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/roots/impl/CompilerProjectExtensionImpl$MyProjectExtension", "readExternal"));
            }
            CompilerProjectExtensionImpl.getImpl(this.myProject).readExternal(element);
        }

        @Override
        public void writeExternal(@NotNull Element element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/roots/impl/CompilerProjectExtensionImpl$MyProjectExtension", "writeExternal"));
            }
            CompilerProjectExtensionImpl.getImpl(this.myProject).writeExternal(element);
        }
    }
}

