/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.roots.AnnotationOrderRootType;
import com.intellij.openapi.roots.JavaModuleExternalPaths;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.ModuleExtension;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.PersistentOrderRootType;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerContainer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.ArrayUtil;
import gnu.trove.THashMap;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JavaModuleExternalPathsImpl
extends JavaModuleExternalPaths {
    @NonNls
    private static final String ROOT_ELEMENT = "root";
    private final Map<OrderRootType, VirtualFilePointerContainer> myOrderRootPointerContainers = new THashMap();
    private JavaModuleExternalPathsImpl mySource;

    public JavaModuleExternalPathsImpl() {
    }

    public JavaModuleExternalPathsImpl(JavaModuleExternalPathsImpl source) {
        this.mySource = source;
        this.copyContainersFrom(source);
    }

    public ModuleExtension getModifiableModel(boolean writable) {
        return new JavaModuleExternalPathsImpl(this);
    }

    public void commit() {
        this.mySource.copyContainersFrom(this);
    }

    @NotNull
    public String[] getJavadocUrls() {
        VirtualFilePointerContainer container = this.myOrderRootPointerContainers.get(JavadocOrderRootType.getInstance());
        String[] stringArray = container != null ? container.getUrls() : ArrayUtil.EMPTY_STRING_ARRAY;
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/JavaModuleExternalPathsImpl", "getJavadocUrls"));
        }
        return stringArray;
    }

    @NotNull
    public VirtualFile[] getExternalAnnotationsRoots() {
        VirtualFilePointerContainer container = this.myOrderRootPointerContainers.get(AnnotationOrderRootType.getInstance());
        VirtualFile[] virtualFileArray = container != null ? container.getFiles() : VirtualFile.EMPTY_ARRAY;
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/JavaModuleExternalPathsImpl", "getExternalAnnotationsRoots"));
        }
        return virtualFileArray;
    }

    @NotNull
    public String[] getExternalAnnotationsUrls() {
        VirtualFilePointerContainer container = this.myOrderRootPointerContainers.get(AnnotationOrderRootType.getInstance());
        String[] stringArray = container != null ? container.getUrls() : ArrayUtil.EMPTY_STRING_ARRAY;
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/JavaModuleExternalPathsImpl", "getExternalAnnotationsUrls"));
        }
        return stringArray;
    }

    public void setJavadocUrls(@NotNull String[] urls) {
        if (urls == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urls", "com/intellij/openapi/roots/impl/JavaModuleExternalPathsImpl", "setJavadocUrls"));
        }
        this.setRootUrls(JavadocOrderRootType.getInstance(), urls);
    }

    public void setExternalAnnotationUrls(@NotNull String[] urls) {
        if (urls == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urls", "com/intellij/openapi/roots/impl/JavaModuleExternalPathsImpl", "setExternalAnnotationUrls"));
        }
        this.setRootUrls(AnnotationOrderRootType.getInstance(), urls);
    }

    private void setRootUrls(OrderRootType orderRootType, @NotNull String[] urls) {
        if (urls == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urls", "com/intellij/openapi/roots/impl/JavaModuleExternalPathsImpl", "setRootUrls"));
        }
        VirtualFilePointerContainer container = this.myOrderRootPointerContainers.get(orderRootType);
        if (container == null) {
            if (urls.length == 0) {
                return;
            }
            container = VirtualFilePointerManager.getInstance().createContainer((Disposable)this, null);
            this.myOrderRootPointerContainers.put(orderRootType, container);
        } else {
            container.clear();
        }
        for (String url : urls) {
            container.add(url);
        }
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/roots/impl/JavaModuleExternalPathsImpl", "readExternal"));
        }
        for (PersistentOrderRootType orderRootType : OrderRootType.getAllPersistentTypes()) {
            Element pathsElement;
            String paths = orderRootType.getModulePathsName();
            if (paths == null || (pathsElement = element.getChild(paths)) == null) continue;
            VirtualFilePointerContainer container = VirtualFilePointerManager.getInstance().createContainer((Disposable)this, null);
            this.myOrderRootPointerContainers.put((OrderRootType)orderRootType, container);
            container.readExternal(pathsElement, ROOT_ELEMENT);
        }
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/roots/impl/JavaModuleExternalPathsImpl", "writeExternal"));
        }
        for (OrderRootType orderRootType : this.myOrderRootPointerContainers.keySet()) {
            VirtualFilePointerContainer container = this.myOrderRootPointerContainers.get(orderRootType);
            if (container == null || container.size() <= 0) continue;
            Element javaDocPaths = new Element(((PersistentOrderRootType)orderRootType).getModulePathsName());
            container.writeExternal(javaDocPaths, ROOT_ELEMENT);
            element.addContent(javaDocPaths);
        }
    }

    private void copyContainersFrom(@NotNull JavaModuleExternalPathsImpl source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/openapi/roots/impl/JavaModuleExternalPathsImpl", "copyContainersFrom"));
        }
        this.myOrderRootPointerContainers.clear();
        for (OrderRootType orderRootType : source.myOrderRootPointerContainers.keySet()) {
            VirtualFilePointerContainer otherContainer = source.myOrderRootPointerContainers.get(orderRootType);
            if (otherContainer == null) continue;
            this.myOrderRootPointerContainers.put(orderRootType, otherContainer.clone((Disposable)this, null));
        }
    }

    public boolean isChanged() {
        if (this.myOrderRootPointerContainers.size() != this.mySource.myOrderRootPointerContainers.size()) {
            return true;
        }
        for (OrderRootType type : this.myOrderRootPointerContainers.keySet()) {
            String[] otherUrls;
            VirtualFilePointerContainer container = this.myOrderRootPointerContainers.get(type);
            VirtualFilePointerContainer otherContainer = this.mySource.myOrderRootPointerContainers.get(type);
            if (container == null || otherContainer == null) {
                if (container == otherContainer) continue;
                return true;
            }
            String[] urls = container.getUrls();
            if (urls.length != (otherUrls = otherContainer.getUrls()).length) {
                return true;
            }
            for (int i2 = 0; i2 < urls.length; ++i2) {
                if (Comparing.strEqual((String)urls[i2], (String)otherUrls[i2])) continue;
                return true;
            }
        }
        return false;
    }

    public void dispose() {
    }
}

