/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ui.configuration.AnnotationsEditor;
import com.intellij.openapi.roots.ui.configuration.BuildElementsEditor;
import com.intellij.openapi.roots.ui.configuration.JavadocEditor;
import com.intellij.openapi.roots.ui.configuration.ModuleConfigurationState;
import com.intellij.openapi.roots.ui.configuration.ModuleElementsEditor;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class OutputEditor
extends ModuleElementsEditor {
    private final BuildElementsEditor myCompilerOutputEditor;
    private final JavadocEditor myJavadocEditor;
    private final AnnotationsEditor myAnnotationsEditor;

    protected OutputEditor(ModuleConfigurationState state) {
        super(state);
        this.myCompilerOutputEditor = new BuildElementsEditor(state);
        this.myJavadocEditor = new JavadocEditor(state);
        this.myAnnotationsEditor = new AnnotationsEditor(state);
    }

    @Override
    protected JComponent createComponentImpl() {
        JPanel panel2 = new JPanel(new GridBagLayout());
        panel2.setBorder(new EmptyBorder(UIUtil.PANEL_SMALL_INSETS));
        GridBagConstraints gc = new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 1, (Insets)JBUI.emptyInsets(), 0, 0);
        panel2.add((Component)this.myCompilerOutputEditor.createComponentImpl(), gc);
        JPanel javadocPanel = (JPanel)this.myJavadocEditor.createComponentImpl();
        javadocPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)this.myJavadocEditor.getDisplayName(), (boolean)false));
        gc.weighty = 1.0;
        panel2.add((Component)javadocPanel, gc);
        JPanel annotationsPanel = (JPanel)this.myAnnotationsEditor.createComponentImpl();
        annotationsPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)this.myAnnotationsEditor.getDisplayName(), (boolean)false));
        panel2.add((Component)annotationsPanel, gc);
        return panel2;
    }

    public void saveData() {
        this.myCompilerOutputEditor.saveData();
        this.myJavadocEditor.saveData();
        this.myAnnotationsEditor.saveData();
    }

    public String getDisplayName() {
        return ProjectBundle.message((String)"project.roots.path.tab.title", (Object[])new Object[0]);
    }

    public void moduleStateChanged() {
        super.moduleStateChanged();
        this.myCompilerOutputEditor.moduleStateChanged();
        this.myJavadocEditor.moduleStateChanged();
        this.myAnnotationsEditor.moduleStateChanged();
    }

    @Override
    public void moduleCompileOutputChanged(String baseUrl, String moduleName) {
        super.moduleCompileOutputChanged(baseUrl, moduleName);
        this.myCompilerOutputEditor.moduleCompileOutputChanged(baseUrl, moduleName);
        this.myJavadocEditor.moduleCompileOutputChanged(baseUrl, moduleName);
        this.myAnnotationsEditor.moduleCompileOutputChanged(baseUrl, moduleName);
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return "projectStructure.modules.paths";
    }
}

