/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.libraryEditor;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.sun.jna.platform.mac.XAttrUtil;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class JavadocQuarantineStatusCleaner {
    private static final Logger LOG = Logger.getInstance(JavadocQuarantineStatusCleaner.class);
    private static final String QUARANTINE_ATTRIBUTE = "com.apple.quarantine";

    public static void cleanIfNeeded(@NotNull VirtualFile javadocFolder) {
        if (javadocFolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javadocFolder", "com/intellij/openapi/roots/ui/configuration/libraryEditor/JavadocQuarantineStatusCleaner", "cleanIfNeeded"));
        }
        Application application = ApplicationManager.getApplication();
        assert (!application.isDispatchThread());
        if (!(SystemInfo.isMac && javadocFolder.isInLocalFileSystem() && javadocFolder.isDirectory())) {
            return;
        }
        String folderPath = VfsUtilCore.virtualToIoFile((VirtualFile)javadocFolder).getAbsolutePath();
        if (XAttrUtil.getXAttr((String)folderPath, (String)QUARANTINE_ATTRIBUTE) == null) {
            return;
        }
        application.invokeLater(() -> {
            int result2 = Messages.showYesNoDialog((String)ApplicationBundle.message((String)"quarantine.dialog.message", (Object[])new Object[0]), (String)ApplicationBundle.message((String)"quarantine.dialog.title", (Object[])new Object[0]), null);
            if (result2 == 0) {
                JavadocQuarantineStatusCleaner.cleanQuarantineStatusInBackground(folderPath);
            }
        }, ModalityState.any());
    }

    private static void cleanQuarantineStatusInBackground(final @NotNull String folderPath) {
        if (folderPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "folderPath", "com/intellij/openapi/roots/ui/configuration/libraryEditor/JavadocQuarantineStatusCleaner", "cleanQuarantineStatusInBackground"));
        }
        ProgressIndicatorBase progressIndicator = new ProgressIndicatorBase();
        String message = ApplicationBundle.message((String)"quarantine.clean.progress", (Object[])new Object[]{folderPath});
        ProgressManager.getInstance().runProcessWithProgressAsynchronously(new Task.Backgroundable(null, message){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/roots/ui/configuration/libraryEditor/JavadocQuarantineStatusCleaner$1", "run"));
                }
                try (Stream<Path> s = Files.walk(Paths.get(folderPath, new String[0]), new FileVisitOption[0]);){
                    s.forEach(p -> {
                        ProgressManager.checkCanceled();
                        XAttrUtil.removeXAttr((String)p.toFile().getAbsolutePath(), (String)JavadocQuarantineStatusCleaner.QUARANTINE_ATTRIBUTE);
                    });
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            public void onThrowable(@NotNull Throwable error) {
                if (error == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/intellij/openapi/roots/ui/configuration/libraryEditor/JavadocQuarantineStatusCleaner$1", "onThrowable"));
                }
                LOG.warn(error);
                new Notification(ApplicationBundle.message((String)"quarantine.error.group", (Object[])new Object[0]), ApplicationBundle.message((String)"quarantine.error.title", (Object[])new Object[0]), ApplicationBundle.message((String)"quarantine.error.message", (Object[])new Object[0]), NotificationType.WARNING).notify(null);
            }
        }, (ProgressIndicator)progressIndicator);
    }
}

