/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.impl;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.RemoteDesktopService;
import com.intellij.ide.impl.TypeSafeDataProviderAdapter;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.DialogWrapperDialog;
import com.intellij.openapi.ui.DialogWrapperPeer;
import com.intellij.openapi.ui.impl.DialogWrapperPeerImpl;
import com.intellij.openapi.ui.impl.FocusTrackbackProvider;
import com.intellij.openapi.ui.impl.ShadowBorderPainter;
import com.intellij.openapi.ui.popup.StackingPopupDispatcher;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.IdeGlassPaneEx;
import com.intellij.ui.FocusTrackback;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.lang.ref.WeakReference;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GlassPaneDialogWrapperPeer
extends DialogWrapperPeer
implements FocusTrackbackProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.ui.impl.GlassPaneDialogWrapperPeer");
    private DialogWrapper myWrapper;
    private WindowManagerEx myWindowManager;
    private Project myProject;
    private MyDialog myDialog;
    private boolean myCanBeParent;
    private String myTitle;

    public GlassPaneDialogWrapperPeer(DialogWrapper wrapper, Project project2, boolean canBeParent) throws GlasspanePeerUnavailableException {
        this.myWrapper = wrapper;
        this.myCanBeParent = canBeParent;
        this.myWindowManager = null;
        Application application = ApplicationManager.getApplication();
        if (application != null && application.hasComponent(WindowManager.class)) {
            this.myWindowManager = (WindowManagerEx)WindowManager.getInstance();
        }
        Window window = null;
        if (this.myWindowManager != null) {
            Window focusedWindow;
            if (project2 == null) {
                project2 = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext());
            }
            this.myProject = project2;
            window = this.myWindowManager.suggestParentWindow(project2);
            if (window == null && (focusedWindow = this.myWindowManager.getMostRecentFocusedWindow()) instanceof IdeFrameImpl) {
                window = focusedWindow;
            }
        }
        Window owner = window != null ? window : JOptionPane.getRootFrame();
        this.createDialog(owner);
    }

    public GlassPaneDialogWrapperPeer(DialogWrapper wrapper, boolean canBeParent) throws GlasspanePeerUnavailableException {
        this(wrapper, (Project)null, canBeParent);
    }

    public GlassPaneDialogWrapperPeer(DialogWrapper wrapper, @NotNull Component parent, boolean canBeParent) throws GlasspanePeerUnavailableException {
        Window owner;
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/ui/impl/GlassPaneDialogWrapperPeer", "<init>"));
        }
        this.myWrapper = wrapper;
        this.myCanBeParent = canBeParent;
        if (!parent.isShowing() && parent != JOptionPane.getRootFrame()) {
            throw new IllegalArgumentException("parent must be showing: " + parent);
        }
        this.myWindowManager = null;
        Application application = ApplicationManager.getApplication();
        if (application != null && application.hasComponent(WindowManager.class)) {
            this.myWindowManager = (WindowManagerEx)WindowManager.getInstance();
        }
        if (!((owner = UIUtil.getWindow((Component)parent)) instanceof Dialog) && !(owner instanceof Frame)) {
            owner = JOptionPane.getRootFrame();
        }
        this.createDialog(owner);
    }

    private void createDialog(Window owner) throws GlasspanePeerUnavailableException {
        Component glassPane;
        Window active = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        if (!(active instanceof JDialog) && owner instanceof IdeFrame) {
            if (owner instanceof JFrame) {
                glassPane = ((JFrame)owner).getGlassPane();
            } else if (owner instanceof JDialog) {
                glassPane = ((JDialog)owner).getGlassPane();
            } else {
                throw new IllegalStateException("Cannot find glass pane for " + owner.getClass().getName());
            }
            assert (glassPane instanceof IdeGlassPaneEx) : "GlassPane should be instance of IdeGlassPane!";
        } else {
            throw new GlasspanePeerUnavailableException();
        }
        this.myDialog = new MyDialog((IdeGlassPaneEx)((Object)glassPane), this.myWrapper, this.myProject);
    }

    @Override
    public FocusTrackback getFocusTrackback() {
        if (this.myDialog != null) {
            return this.myDialog.getFocusTrackback();
        }
        return null;
    }

    public void setUndecorated(boolean undecorated) {
        LOG.assertTrue(undecorated, (Object)"Decorated dialogs are not supported!");
    }

    public void addMouseListener(MouseListener listener2) {
        throw new UnsupportedOperationException("Not implemented in " + this.getClass().getCanonicalName());
    }

    public void addMouseListener(MouseMotionListener listener2) {
        throw new UnsupportedOperationException("Not implemented in " + this.getClass().getCanonicalName());
    }

    public void addKeyListener(KeyListener listener2) {
        throw new UnsupportedOperationException("Not implemented in " + this.getClass().getCanonicalName());
    }

    public void toFront() {
        throw new UnsupportedOperationException("Not implemented in " + this.getClass().getCanonicalName());
    }

    public void toBack() {
        throw new UnsupportedOperationException("Not implemented in " + this.getClass().getCanonicalName());
    }

    public void dispose() {
        LOG.assertTrue(EventQueue.isDispatchThread(), (Object)"Access is allowed from event dispatch thread only");
        if (this.myDialog != null) {
            Disposer.dispose((Disposable)this.myDialog);
            this.myDialog = null;
            this.myProject = null;
            this.myWindowManager = null;
        }
    }

    public Container getContentPane() {
        return this.myDialog.getContentPane();
    }

    public Window getOwner() {
        throw new UnsupportedOperationException("Not implemented in " + this.getClass().getCanonicalName());
    }

    public Window getWindow() {
        return null;
    }

    public JRootPane getRootPane() {
        if (this.myDialog == null) {
            return null;
        }
        return this.myDialog.getRootPane();
    }

    public Dimension getSize() {
        return this.myDialog.getSize();
    }

    public String getTitle() {
        return "";
    }

    public Dimension getPreferredSize() {
        return this.myDialog.getPreferredSize();
    }

    public void setModal(boolean modal) {
        LOG.assertTrue(modal, (Object)"Can't be non modal!");
    }

    public boolean isModal() {
        return true;
    }

    public boolean isVisible() {
        return this.myDialog != null && this.myDialog.isVisible();
    }

    public boolean isShowing() {
        return this.myDialog != null && this.myDialog.isShowing();
    }

    public void setSize(int width, int height) {
        this.myDialog.setSize(width, height);
    }

    public void setTitle(String title) {
        this.myTitle = title;
    }

    public void isResizable() {
    }

    public void setResizable(boolean resizable) {
        throw new UnsupportedOperationException("Not implemented in " + this.getClass().getCanonicalName());
    }

    @NotNull
    public Point getLocation() {
        Point point = this.myDialog.getLocation();
        if (point == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/impl/GlassPaneDialogWrapperPeer", "getLocation"));
        }
        return point;
    }

    public void setLocation(@NotNull Point p) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/openapi/ui/impl/GlassPaneDialogWrapperPeer", "setLocation"));
        }
        this.setLocation(p.x, p.y);
    }

    public void setLocation(int x, int y) {
        if (this.myDialog == null || !this.myDialog.isShowing()) {
            return;
        }
        Point _p = new Point(x, y);
        JRootPane pane = SwingUtilities.getRootPane(this.myDialog);
        SwingUtilities.convertPointFromScreen(_p, pane);
        this.myDialog.setLocation(_p.x, _p.y);
    }

    public ActionCallback show() {
        LOG.assertTrue(EventQueue.isDispatchThread(), (Object)"Access is allowed from event dispatch thread only");
        this.hidePopupsIfNeeded();
        this.myDialog.setVisible(true);
        return ActionCallback.DONE;
    }

    public void setContentPane(JComponent content) {
        this.myDialog.setContentPane(content);
    }

    public void centerInParent() {
        if (this.myDialog != null) {
            this.myDialog.center();
        }
    }

    public void validate() {
        if (this.myDialog != null) {
            this.myDialog.resetSizeCache();
            this.myDialog.invalidate();
        }
    }

    public void repaint() {
        if (this.myDialog != null) {
            this.myDialog.repaint();
        }
    }

    public void pack() {
    }

    public void setAppIcons() {
        throw new UnsupportedOperationException("Not implemented in " + this.getClass().getCanonicalName());
    }

    public boolean isHeadless() {
        return DialogWrapperPeerImpl.isHeadlessEnv();
    }

    private void hidePopupsIfNeeded() {
        if (!SystemInfo.isMac) {
            return;
        }
        StackingPopupDispatcher.getInstance().hidePersistentPopups();
        Disposer.register((Disposable)this.myDialog, (Disposable)new Disposable(){

            public void dispose() {
                StackingPopupDispatcher.getInstance().restorePersistentPopups();
            }
        });
    }

    public static class TransparentLayeredPane
    extends JBLayeredPane {
        private TransparentLayeredPane() {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            this.addMouseListener(new MouseAdapter(){});
            this.addMouseMotionListener(new MouseMotionAdapter(){});
        }

        public void addNotify() {
            Container container = this.getParent();
            if (container != null) {
                this.setBounds(0, 0, container.getWidth(), container.getHeight());
            }
            super.addNotify();
        }

        public boolean isOptimizedDrawingEnabled() {
            return this.getComponentCount() <= 1;
        }
    }

    public static class GlasspanePeerUnavailableException
    extends Exception {
    }

    private static class MyRootPane
    extends JRootPane
    implements Disposable {
        private MyDialog myDialog;

        private MyRootPane(MyDialog dialog2) {
            this.myDialog = dialog2;
        }

        @Override
        protected JLayeredPane createLayeredPane() {
            JBLayeredPane p = new JBLayeredPane();
            p.setName(this.getName() + ".layeredPane");
            return p;
        }

        public void dispose() {
            DialogWrapper.cleanupRootPane((JRootPane)this);
            this.myDialog = null;
        }

        @Override
        public void registerKeyboardAction(ActionListener anAction, String aCommand, KeyStroke aKeyStroke, int aCondition) {
            this.myDialog.registerKeyboardAction(anAction, aCommand, aKeyStroke, aCondition);
        }

        @Override
        public void unregisterKeyboardAction(KeyStroke aKeyStroke) {
            this.myDialog.unregisterKeyboardAction(aKeyStroke);
        }

        @Override
        public void setDefaultButton(JButton defaultButton) {
            this.myDialog.setDefaultButton(defaultButton);
        }

        @Override
        public void setContentPane(Container contentPane) {
            super.setContentPane(contentPane);
            if (contentPane != null) {
                contentPane.addMouseMotionListener(new MouseMotionAdapter(){});
            }
        }
    }

    private static class MyDialog
    extends JPanel
    implements Disposable,
    DialogWrapperDialog,
    DataProvider,
    FocusTrackback.Provider {
        private final WeakReference<DialogWrapper> myDialogWrapper;
        private final IdeGlassPaneEx myPane;
        private JComponent myContentPane;
        private MyRootPane myRootPane;
        private BufferedImage shadow;
        private int shadowWidth;
        private int shadowHeight;
        private final JLayeredPane myTransparentPane;
        private JButton myDefaultButton;
        private final Container myWrapperPane;
        private Component myPreviouslyFocusedComponent;
        private Dimension myCachedSize = null;

        private MyDialog(IdeGlassPaneEx pane, DialogWrapper wrapper, Project project2) {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            this.setBorder(BorderFactory.createEmptyBorder(AllIcons.Ide.Shadow.Top.getIconHeight(), AllIcons.Ide.Shadow.Left.getIconWidth(), AllIcons.Ide.Shadow.Bottom.getIconHeight(), AllIcons.Ide.Shadow.Right.getIconWidth()));
            this.myPane = pane;
            this.myDialogWrapper = new WeakReference<DialogWrapper>(wrapper);
            this.myRootPane = new MyRootPane(this);
            Disposer.register((Disposable)this, (Disposable)this.myRootPane);
            this.myContentPane = new JPanel();
            this.myContentPane.setOpaque(true);
            this.add((Component)this.myContentPane, "Center");
            this.myTransparentPane = this.createTransparentPane();
            this.myWrapperPane = this.createWrapperPane();
            this.myWrapperPane.add(this);
            this.setFocusCycleRoot(true);
        }

        public void resetSizeCache() {
            this.myCachedSize = null;
        }

        private Container createWrapperPane() {
            JPanel result2 = new JPanel(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void doLayout() {
                    Object object = this.getTreeLock();
                    synchronized (object) {
                        Container container = this.getParent();
                        if (container != null) {
                            Component[] components = this.getComponents();
                            LOG.assertTrue(components.length == 1);
                            for (Component c : components) {
                                Point location;
                                if (myCachedSize == null) {
                                    myCachedSize = c.getPreferredSize();
                                    location = this.getLocationInCenter(myCachedSize, c.getLocation());
                                } else {
                                    location = c.getLocation();
                                }
                                double _width = myCachedSize.getWidth();
                                double _height = myCachedSize.getHeight();
                                DialogWrapper dialogWrapper = (DialogWrapper)myDialogWrapper.get();
                                if (dialogWrapper != null) {
                                    int width = (int)(_width * (double)dialogWrapper.getHorizontalStretch());
                                    int height = (int)(_height * (double)dialogWrapper.getVerticalStretch());
                                    c.setBounds((int)location.getX(), (int)location.getY(), width, height);
                                    continue;
                                }
                                c.setBounds((int)location.getX(), (int)location.getY(), (int)_width, (int)_height);
                            }
                        }
                    }
                    super.doLayout();
                }
            };
            result2.setLayout(null);
            result2.setOpaque(false);
            result2.addMouseListener(new MouseAdapter(){});
            result2.addMouseMotionListener(new MouseMotionAdapter(){});
            return result2;
        }

        private TransparentLayeredPane getExistingTransparentPane() {
            for (int i = 0; i < this.myPane.getComponentCount(); ++i) {
                Component c = this.myPane.getComponent(i);
                if (!(c instanceof TransparentLayeredPane)) continue;
                return (TransparentLayeredPane)((Object)c);
            }
            return null;
        }

        private boolean isTransparentPaneExist() {
            for (int i = 0; i < this.myPane.getComponentCount(); ++i) {
                Component c = this.myPane.getComponent(i);
                if (!(c instanceof TransparentLayeredPane)) continue;
                return true;
            }
            return false;
        }

        @Override
        public void setVisible(boolean show) {
            if (show) {
                if (!this.isTransparentPaneExist()) {
                    this.myPane.add(this.myTransparentPane);
                } else {
                    this.myPreviouslyFocusedComponent = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                }
                this.myTransparentPane.add(this.myWrapperPane);
                this.myTransparentPane.setLayer(this.myWrapperPane, this.myTransparentPane.getComponentCount() - 1);
                if (!this.myTransparentPane.isVisible()) {
                    this.myTransparentPane.setVisible(true);
                }
            }
            super.setVisible(show);
            if (show) {
                this.myTransparentPane.revalidate();
                this.myTransparentPane.repaint();
            } else {
                this.myTransparentPane.remove(this.myWrapperPane);
                this.myTransparentPane.revalidate();
                this.myTransparentPane.repaint();
                if (this.myPreviouslyFocusedComponent != null) {
                    this.myPreviouslyFocusedComponent.requestFocus();
                    this.myPreviouslyFocusedComponent = null;
                }
                if (this.myTransparentPane.getComponentCount() == 0) {
                    this.myTransparentPane.setVisible(false);
                    this.myPane.remove(this.myTransparentPane);
                }
            }
        }

        @Override
        public void paint(Graphics g) {
            UISettings.setupAntialiasing((Graphics)g);
            super.paint(g);
        }

        private JLayeredPane createTransparentPane() {
            TransparentLayeredPane pane = this.getExistingTransparentPane();
            if (pane == null) {
                pane = new TransparentLayeredPane();
            }
            return pane;
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            if (this.shadow != null) {
                UIUtil.drawImage((Graphics)g2, (Image)this.shadow, (int)0, (int)0, null);
            }
            super.paintComponent(g);
        }

        @Override
        public void setBounds(int x, int y, int width, int height) {
            JLayeredPane p = this.myTransparentPane;
            if (p != null) {
                Rectangle bounds = new Rectangle(((Component)p).getWidth() - width, ((Component)p).getHeight() - height);
                JBInsets.removeFrom((Rectangle)bounds, (Insets)this.getInsets());
                x = bounds.width < 0 ? bounds.width / 2 : Math.min(bounds.x + bounds.width, Math.max(bounds.x, x));
                y = bounds.height < 0 ? bounds.height / 2 : Math.min(bounds.y + bounds.height, Math.max(bounds.y, y));
            }
            super.setBounds(x, y, width, height);
            if (RemoteDesktopService.isRemoteSession()) {
                this.shadow = null;
            } else if (this.shadow == null || this.shadowWidth != width || this.shadowHeight != height) {
                this.shadow = ShadowBorderPainter.createShadow(this, width, height);
                this.shadowWidth = width;
                this.shadowHeight = height;
            }
        }

        public void dispose() {
            this.setVisible(false);
            this.remove(this.getContentPane());
            DialogWrapper.unregisterKeyboardActions((Component)this.myWrapperPane);
            this.myRootPane = null;
        }

        public void setContentPane(JComponent content) {
            if (this.myContentPane != null) {
                this.remove(this.myContentPane);
                this.myContentPane = null;
            }
            this.myContentPane = content;
            this.myContentPane.setOpaque(true);
            this.add((Component)this.myContentPane, "Center");
        }

        public JComponent getContentPane() {
            return this.myContentPane;
        }

        @Override
        public JRootPane getRootPane() {
            return this.myRootPane;
        }

        public DialogWrapper getDialogWrapper() {
            return (DialogWrapper)this.myDialogWrapper.get();
        }

        public Object getData(@NonNls String dataId) {
            DialogWrapper wrapper = (DialogWrapper)this.myDialogWrapper.get();
            if (wrapper instanceof DataProvider) {
                return ((DataProvider)wrapper).getData(dataId);
            }
            if (wrapper instanceof TypeSafeDataProvider) {
                TypeSafeDataProviderAdapter adapter = new TypeSafeDataProviderAdapter((TypeSafeDataProvider)wrapper);
                return adapter.getData(dataId);
            }
            return null;
        }

        @Override
        public void setSize(int width, int height) {
            Point location = this.getLocation();
            Rectangle rect = new Rectangle(location.x, location.y, width, height);
            ScreenUtil.fitToScreen((Rectangle)rect);
            if (location.x != rect.x || location.y != rect.y) {
                this.setLocation(rect.x, rect.y);
            }
            super.setSize(rect.width, rect.height);
        }

        @Override
        public FocusTrackback getFocusTrackback() {
            return null;
        }

        @Nullable
        private Point getLocationInCenter(Dimension size, @Nullable Point _default) {
            if (this.myTransparentPane != null) {
                Dimension d = this.myTransparentPane.getSize();
                return new Point((d.width - size.width) / 2, (d.height - size.height) / 2);
            }
            return _default;
        }

        public void center() {
            Point location = this.getLocationInCenter(this.getSize(), null);
            if (location != null) {
                this.setLocation(location);
                this.repaint();
            }
        }

        public void setDefaultButton(JButton defaultButton) {
            this.myDefaultButton = defaultButton;
        }
    }
}

