/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.diagnostic.IdeErrorsDialog;
import com.intellij.externalDependencies.DependencyOnPlugin;
import com.intellij.externalDependencies.ExternalDependenciesManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.externalComponents.ExternalComponentManager;
import com.intellij.ide.externalComponents.ExternalComponentSource;
import com.intellij.ide.externalComponents.UpdatableExternalComponent;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.RepositoryHelper;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.PermanentInstallationID;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.openapi.diagnostic.LogUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.updateSettings.impl.BuildInfo;
import com.intellij.openapi.updateSettings.impl.CheckForUpdateResult;
import com.intellij.openapi.updateSettings.impl.ExternalUpdate;
import com.intellij.openapi.updateSettings.impl.NoUpdatesDialog;
import com.intellij.openapi.updateSettings.impl.PatchInfo;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.PluginUpdateInfoDialog;
import com.intellij.openapi.updateSettings.impl.UpdateChannel;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.updateSettings.impl.UpdateInfoDialog;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.updateSettings.impl.UpdateStrategy;
import com.intellij.openapi.updateSettings.impl.UpdatesInfo;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import gnu.trove.THashMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.event.HyperlinkEvent;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.http.client.utils.URIBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u00e0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001dB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\u0004H\u0007JF\u0010)\u001a\u00020&2\u0006\u0010*\u001a\u00020!2\u0006\u0010+\u001a\u00020,2\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u00020!0.2\u000e\u00100\u001a\n\u0012\u0004\u0012\u000202\u0018\u0001012\b\u00103\u001a\u0004\u0018\u000104H\u0007J\u0010\u00105\u001a\u00020&2\u0006\u00106\u001a\u000207H\u0007J\u0010\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;H\u0002J<\u0010<\u001a\n\u0012\u0004\u0012\u00020!\u0018\u00010=2\u0006\u0010>\u001a\u00020;2\b\u00103\u001a\u0004\u0018\u0001042\u000e\u00100\u001a\n\u0012\u0004\u0012\u000202\u0018\u0001012\b\u0010?\u001a\u0004\u0018\u00010@H\u0002J\u0014\u0010A\u001a\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u0002020.H\u0002J>\u0010B\u001a\u00020&2\b\u0010C\u001a\u0004\u0018\u00010D2\u0006\u0010E\u001a\u00020\u001b2\u0006\u0010F\u001a\u00020\u001b2\u0006\u0010>\u001a\u00020;2\b\u00103\u001a\u0004\u0018\u0001042\b\u0010G\u001a\u0004\u0018\u00010HH\u0002J\u0015\u0010I\u001a\u00070\u0004\u00a2\u0006\u0002\b\u00072\u0006\u0010J\u001a\u00020KH\u0007J\u0010\u0010L\u001a\u00020\u001b2\u0006\u0010M\u001a\u00020\u0004H\u0002J\u0018\u0010N\u001a\u00020\u001b2\u0006\u0010C\u001a\u00020D2\u0006\u0010M\u001a\u00020\u0004H\u0002J\u0010\u0010O\u001a\u00020&2\u0006\u0010P\u001a\u00020QH\u0002J\b\u0010R\u001a\u00020&H\u0007J\u0018\u0010S\u001a\u00020&2\u0006\u0010T\u001a\u00020\u001b2\u0006\u0010U\u001a\u00020\u0004H\u0002J0\u0010V\u001a\u00020&2\b\u0010C\u001a\u0004\u0018\u00010D2\u0006\u0010U\u001a\u00020\u00042\f\u0010W\u001a\b\u0012\u0004\u0012\u00020&0X2\u0006\u0010Y\u001a\u00020\u001eH\u0002Jb\u0010Z\u001a\u00020&2\b\u0010C\u001a\u0004\u0018\u00010D2\u0006\u0010[\u001a\u0002092\u0006\u0010>\u001a\u00020;2\u000e\u0010\\\u001a\n\u0012\u0004\u0012\u00020!\u0018\u00010=2\u000e\u00100\u001a\n\u0012\u0004\u0012\u000202\u0018\u00010=2\u000e\u0010]\u001a\n\u0012\u0004\u0012\u00020^\u0018\u00010=2\u0006\u0010_\u001a\u00020\u001b2\u0006\u0010`\u001a\u00020\u001bH\u0002J\b\u0010a\u001a\u00020HH\u0007J\u001c\u0010a\u001a\u00020&2\b\u0010C\u001a\u0004\u0018\u00010D2\b\u0010b\u001a\u0004\u0018\u00010;H\u0007J(\u0010c\u001a\b\u0012\u0004\u0012\u00020^0=2\u0006\u0010F\u001a\u00020\u001b2\u0006\u0010>\u001a\u00020;2\b\u00103\u001a\u0004\u0018\u000104H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\f8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\r\u0010\u0002\u001a\u0004\b\u000e\u0010\u000fR!\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u0011j\b\u0012\u0004\u0012\u00020\u00040\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R*\u0010\u0015\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0016j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010 \u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020!0\u0016j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020!0\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$\u00a8\u0006e"}, d2={"Lcom/intellij/openapi/updateSettings/impl/UpdateChecker;", "", "()V", "DISABLED_UPDATE", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "NOTIFICATIONS", "Lcom/intellij/notification/NotificationGroup;", "NO_PLATFORM_UPDATE", "disabledToUpdatePlugins", "", "disabledToUpdatePlugins$annotations", "getDisabledToUpdatePlugins", "()Ljava/util/Set;", "excludedFromUpdateCheckPlugins", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "getExcludedFromUpdateCheckPlugins", "()Ljava/util/HashSet;", "ourAdditionalRequestOptions", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "ourDisabledToUpdatePlugins", "", "ourHasFailedPlugins", "", "ourShownNotifications", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/openapi/updateSettings/impl/UpdateChecker$NotificationUniqueType;", "Lcom/intellij/notification/Notification;", "ourUpdatedPlugins", "Lcom/intellij/openapi/updateSettings/impl/PluginDownloader;", "updateUrl", "getUpdateUrl", "()Ljava/lang/String;", "addUpdateRequestParameter", "", "name", "value", "checkAndPrepareToInstall", "downloader", "state", "Lcom/intellij/ide/plugins/InstalledPluginsState;", "toUpdate", "", "Lcom/intellij/openapi/extensions/PluginId;", "incompatiblePlugins", "", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "checkForUpdate", "event", "Lcom/intellij/openapi/diagnostic/IdeaLoggingEvent;", "checkPlatformUpdate", "Lcom/intellij/openapi/updateSettings/impl/CheckForUpdateResult;", "settings", "Lcom/intellij/openapi/updateSettings/impl/UpdateSettings;", "checkPluginsUpdate", "", "updateSettings", "buildNumber", "Lcom/intellij/openapi/util/BuildNumber;", "collectUpdateablePlugins", "doUpdateAndShowResult", "project", "Lcom/intellij/openapi/project/Project;", "fromSettings", "manualCheck", "callback", "Lcom/intellij/openapi/util/ActionCallback;", "getInstallationUID", "c", "Lcom/intellij/ide/util/PropertiesComponent;", "isRequiredForAnyOpenProject", "pluginId", "isRequiredForProject", "prepareUpdateCheckArgs", "uriBuilder", "Lorg/apache/http/client/utils/URIBuilder;", "saveDisabledToUpdatePlugins", "showErrorMessage", "showDialog", "message", "showNotification", "action", "Lkotlin/Function0;", "notificationType", "showUpdateResult", "checkForUpdateResult", "updatedPlugins", "externalUpdates", "Lcom/intellij/openapi/updateSettings/impl/ExternalUpdate;", "enableLink", "alwaysShowResults", "updateAndShowResult", "customSettings", "updateExternal", "NotificationUniqueType", "platform-impl"})
public final class UpdateChecker {
    private static final Logger LOG;
    @JvmField
    @NotNull
    public static final NotificationGroup NOTIFICATIONS;
    private static final String DISABLED_UPDATE = "disabled_update.txt";
    private static final String NO_PLATFORM_UPDATE = "ide.no.platform.update";
    private static Set<String> ourDisabledToUpdatePlugins;
    private static final HashMap<String, String> ourAdditionalRequestOptions;
    private static final HashMap<String, PluginDownloader> ourUpdatedPlugins;
    private static final MultiMap<NotificationUniqueType, Notification> ourShownNotifications;
    @NotNull
    private static final HashSet<String> excludedFromUpdateCheckPlugins;
    private static boolean ourHasFailedPlugins;
    public static final UpdateChecker INSTANCE;

    @NotNull
    public final HashSet<String> getExcludedFromUpdateCheckPlugins() {
        return excludedFromUpdateCheckPlugins;
    }

    private final String getUpdateUrl() {
        String string = System.getProperty("idea.updates.url");
        if (string == null) {
            String string2 = ApplicationInfoEx.getInstanceEx().getUpdateUrls().getCheckingUrl();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"ApplicationInfoEx.getIns\u2026().updateUrls.checkingUrl");
        }
        return string;
    }

    @JvmStatic
    @NotNull
    public static final ActionCallback updateAndShowResult() {
        ActionCallback callback = new ActionCallback();
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(callback){
            final /* synthetic */ ActionCallback $callback;

            public final void run() {
                UpdateSettings updateSettings = UpdateSettings.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)updateSettings, (String)"UpdateSettings.getInstance()");
                UpdateChecker.access$doUpdateAndShowResult(UpdateChecker.INSTANCE, null, true, false, updateSettings, null, this.$callback);
            }
            {
                this.$callback = actionCallback;
            }
        });
        return callback;
    }

    @JvmStatic
    public static final void updateAndShowResult(@Nullable Project project2, @Nullable UpdateSettings customSettings) {
        UpdateSettings updateSettings = customSettings;
        if (updateSettings == null) {
            updateSettings = UpdateSettings.getInstance();
        }
        UpdateSettings settings = updateSettings;
        boolean fromSettings = customSettings != null;
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(fromSettings, settings, project2, project2, IdeBundle.message((String)"updates.checking.progress", (Object[])new Object[0]), true){
            final /* synthetic */ boolean $fromSettings;
            final /* synthetic */ UpdateSettings $settings;
            final /* synthetic */ Project $project;

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                Project project2 = this.getProject();
                UpdateSettings updateSettings = this.$settings;
                Intrinsics.checkExpressionValueIsNotNull((Object)updateSettings, (String)"settings");
                UpdateChecker.access$doUpdateAndShowResult(UpdateChecker.INSTANCE, project2, this.$fromSettings, true, updateSettings, indicator, null);
            }

            public boolean isConditionalModal() {
                return this.$fromSettings;
            }

            public boolean shouldStartInBackground() {
                return !this.$fromSettings;
            }
            {
                this.$fromSettings = $captured_local_variable$0;
                this.$settings = $captured_local_variable$1;
                this.$project = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4, $super_call_param$5);
            }
        });
    }

    private final void doUpdateAndShowResult(Project project2, boolean fromSettings, boolean manualCheck, UpdateSettings updateSettings, ProgressIndicator indicator, ActionCallback callback) {
        Collection<ExternalUpdate> externalUpdates;
        Collection<PluginDownloader> updatedPlugins;
        ProgressIndicator progressIndicator = indicator;
        if (progressIndicator != null) {
            progressIndicator.setText(IdeBundle.message((String)"updates.checking.platform", (Object[])new Object[0]));
        }
        CheckForUpdateResult result2 = this.checkPlatformUpdate(updateSettings);
        if (manualCheck && Intrinsics.areEqual((Object)((Object)result2.getState()), (Object)((Object)UpdateStrategy.State.LOADED))) {
            UpdateSettings.getInstance().saveLastCheckedInfo();
        } else if (Intrinsics.areEqual((Object)((Object)result2.getState()), (Object)((Object)UpdateStrategy.State.CONNECTION_ERROR))) {
            Exception e = result2.getError();
            if (e != null) {
                LOG.debug((Throwable)e);
            }
            Object[] objectArray = new Object[1];
            Object object = e;
            if (object == null || (object = ((Throwable)object).getMessage()) == null) {
                object = "internal error";
            }
            objectArray[0] = object;
            String string = IdeBundle.message((String)"updates.error.connection.failed", (Object[])objectArray);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"IdeBundle.message(\"updat\u2026sage ?: \"internal error\")");
            this.showErrorMessage(manualCheck, string);
            return;
        }
        ProgressIndicator progressIndicator2 = indicator;
        if (progressIndicator2 != null) {
            progressIndicator2.setText(IdeBundle.message((String)"updates.checking.plugins", (Object[])new Object[0]));
        }
        BuildInfo buildInfo = result2.getNewBuild();
        BuildNumber buildNumber = buildInfo != null ? buildInfo.getApiVersion() : null;
        Collection incompatiblePlugins = buildNumber != null ? (Collection)new HashSet() : null;
        try {
            updatedPlugins = this.checkPluginsUpdate(updateSettings, indicator, incompatiblePlugins, buildNumber);
            externalUpdates = UpdateChecker.updateExternal(manualCheck, updateSettings, indicator);
        }
        catch (IOException e) {
            String string = IdeBundle.message((String)"updates.error.connection.failed", (Object[])new Object[]{e.getMessage()});
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"IdeBundle.message(\"updat\u2026ction.failed\", e.message)");
            this.showErrorMessage(manualCheck, string);
            return;
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(project2, result2, updateSettings, updatedPlugins, incompatiblePlugins, externalUpdates, fromSettings, manualCheck, callback){
            final /* synthetic */ Project $project;
            final /* synthetic */ CheckForUpdateResult $result;
            final /* synthetic */ UpdateSettings $updateSettings;
            final /* synthetic */ Collection $updatedPlugins;
            final /* synthetic */ Collection $incompatiblePlugins;
            final /* synthetic */ Collection $externalUpdates;
            final /* synthetic */ boolean $fromSettings;
            final /* synthetic */ boolean $manualCheck;
            final /* synthetic */ ActionCallback $callback;

            public final void run() {
                block0: {
                    UpdateChecker.access$showUpdateResult(UpdateChecker.INSTANCE, this.$project, this.$result, this.$updateSettings, this.$updatedPlugins, this.$incompatiblePlugins, this.$externalUpdates, !this.$fromSettings, this.$manualCheck);
                    ActionCallback actionCallback = this.$callback;
                    if (actionCallback == null) break block0;
                    actionCallback.setDone();
                }
            }
            {
                this.$project = project2;
                this.$result = checkForUpdateResult;
                this.$updateSettings = updateSettings;
                this.$updatedPlugins = collection;
                this.$incompatiblePlugins = collection2;
                this.$externalUpdates = collection3;
                this.$fromSettings = bl;
                this.$manualCheck = bl2;
                this.$callback = actionCallback;
            }
        }, fromSettings ? ModalityState.any() : ModalityState.NON_MODAL);
    }

    private final CheckForUpdateResult checkPlatformUpdate(UpdateSettings settings) {
        UpdatesInfo updateInfo;
        if (SystemProperties.getBooleanProperty((String)NO_PLATFORM_UPDATE, (boolean)false)) {
            return new CheckForUpdateResult(UpdateStrategy.State.NOTHING_LOADED, null);
        }
        try {
            URIBuilder uriBuilder = new URIBuilder(this.getUpdateUrl());
            if (Intrinsics.areEqual((Object)"file", (Object)uriBuilder.getScheme()) ^ true) {
                this.prepareUpdateCheckArgs(uriBuilder);
            }
            String updateUrl = uriBuilder.build().toString();
            LogUtil.debug((Logger)LOG, (String)"load update xml (UPDATE_URL='%s')", (Object[])new Object[]{updateUrl});
            updateInfo = (UpdatesInfo)HttpRequests.request((String)updateUrl).forceHttps(settings.canUseSecureConnection()).connect((HttpRequests.RequestProcessor)checkPlatformUpdate.1.INSTANCE);
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
            return new CheckForUpdateResult(UpdateStrategy.State.CONNECTION_ERROR, e);
        }
        if (updateInfo == null) {
            return new CheckForUpdateResult(UpdateStrategy.State.NOTHING_LOADED, null);
        }
        BuildNumber buildNumber = ApplicationInfo.getInstance().getBuild();
        Intrinsics.checkExpressionValueIsNotNull((Object)buildNumber, (String)"ApplicationInfo.getInstance().build");
        UpdateStrategy strategy = new UpdateStrategy(buildNumber, updateInfo, settings);
        return strategy.checkForUpdates();
    }

    private final Collection<PluginDownloader> checkPluginsUpdate(UpdateSettings updateSettings, ProgressIndicator indicator, Collection<IdeaPluginDescriptor> incompatiblePlugins, BuildNumber buildNumber) {
        Map<PluginId, IdeaPluginDescriptor> updateable = this.collectUpdateablePlugins();
        if (updateable.isEmpty()) {
            return null;
        }
        THashMap toUpdate = ContainerUtil.newTroveMap();
        List<String> hosts = RepositoryHelper.getPluginHosts();
        InstalledPluginsState state = InstalledPluginsState.getInstance();
        block2: for (String host : hosts) {
            try {
                boolean forceHttps = host == null && updateSettings.canUseSecureConnection();
                List<IdeaPluginDescriptor> list = RepositoryHelper.loadPlugins(host, buildNumber, null, forceHttps, indicator);
                for (IdeaPluginDescriptor descriptor : list) {
                    PluginDownloader downloader;
                    PluginId id = descriptor.getPluginId();
                    if (!updateable.containsKey(id)) continue;
                    updateable.remove(id);
                    state.onDescriptorDownload(descriptor);
                    PluginDownloader pluginDownloader = downloader = PluginDownloader.createDownloader(descriptor, host, buildNumber, forceHttps);
                    Intrinsics.checkExpressionValueIsNotNull((Object)pluginDownloader, (String)"downloader");
                    InstalledPluginsState installedPluginsState = state;
                    Intrinsics.checkExpressionValueIsNotNull((Object)installedPluginsState, (String)"state");
                    THashMap tHashMap = toUpdate;
                    Intrinsics.checkExpressionValueIsNotNull((Object)tHashMap, (String)"toUpdate");
                    UpdateChecker.checkAndPrepareToInstall(pluginDownloader, installedPluginsState, (Map)tHashMap, incompatiblePlugins, indicator);
                    if (!updateable.isEmpty()) continue;
                    break block2;
                }
            }
            catch (IOException e) {
                LOG.debug((Throwable)e);
                if (host != null) {
                    LOG.info("failed to load plugin descriptions from " + host + ": " + e.getMessage());
                    continue;
                }
                throw (Throwable)e;
            }
        }
        return toUpdate.isEmpty() ? null : toUpdate.values();
    }

    /*
     * WARNING - void declaration
     */
    private final Map<PluginId, IdeaPluginDescriptor> collectUpdateablePlugins() {
        void $receiver$iv$iv;
        void $receiver$iv$iv2;
        THashMap updateable = ContainerUtil.newTroveMap();
        Map map = (Map)updateable;
        Object $receiver$iv = PluginManagerCore.getPlugins();
        Object[] objectArray = $receiver$iv;
        Object destination$iv$iv = new ArrayList();
        for (int i = 0; i < ((void)$receiver$iv$iv2).length; ++i) {
            Iterator element$iv$iv = $receiver$iv$iv2[i];
            IdeaPluginDescriptor it = (IdeaPluginDescriptor)element$iv$iv;
            if (!(!it.isBundled() || it.allowBundledUpdate())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10)), (int)16);
        destination$iv$iv = $receiver$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        for (Object element$iv$iv : $receiver$iv$iv) {
            void it;
            IdeaPluginDescriptor $i$a$1$filter = (IdeaPluginDescriptor)element$iv$iv;
            Map map2 = destination$iv$iv2;
            PluginId pluginId = it.getPluginId();
            map2.put(pluginId, element$iv$iv);
        }
        $receiver$iv = destination$iv$iv2;
        map.putAll($receiver$iv);
        File onceInstalled = PluginManager.getOnceInstalledIfExists();
        if (onceInstalled != null) {
            try {
                Iterator iterator = FileUtil.loadLines((File)onceInstalled).iterator();
                while (iterator.hasNext()) {
                    PluginId id;
                    String line;
                    String $receiver$iv2 = line = (String)iterator.next();
                    CharSequence $receiver$iv$iv3 = $receiver$iv2;
                    int startIndex$iv$iv = 0;
                    int endIndex$iv$iv = $receiver$iv$iv3.length() - 1;
                    boolean startFound$iv$iv = false;
                    while (startIndex$iv$iv <= endIndex$iv$iv) {
                        boolean match$iv$iv;
                        int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                        char it = $receiver$iv$iv3.charAt(index$iv$iv);
                        boolean bl = match$iv$iv = it <= ' ';
                        if (!startFound$iv$iv) {
                            if (!match$iv$iv) {
                                startFound$iv$iv = true;
                                continue;
                            }
                            ++startIndex$iv$iv;
                            continue;
                        }
                        if (!match$iv$iv) break;
                        --endIndex$iv$iv;
                    }
                    if (!(updateable.contains((Object)(id = PluginId.getId((String)((Object)$receiver$iv$iv3.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()))) ^ true)) continue;
                    updateable.put((Object)id, null);
                }
            }
            catch (IOException e) {
                LOG.error(onceInstalled.getPath(), (Throwable)e);
            }
            onceInstalled.deleteOnExit();
        }
        Iterator<String> iterator = excludedFromUpdateCheckPlugins.iterator();
        while (iterator.hasNext()) {
            String excludedPluginId;
            String string = excludedPluginId = iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"excludedPluginId");
            if (this.isRequiredForAnyOpenProject(string)) continue;
            updateable.remove((Object)PluginId.getId((String)excludedPluginId));
        }
        THashMap tHashMap = updateable;
        Intrinsics.checkExpressionValueIsNotNull((Object)tHashMap, (String)"updateable");
        return (Map)tHashMap;
    }

    private final boolean isRequiredForAnyOpenProject(String pluginId) {
        boolean bl;
        block1: {
            Object[] $receiver$iv = ProjectManager.getInstance().getOpenProjects();
            for (int i = 0; i < $receiver$iv.length; ++i) {
                Project it;
                Object element$iv = $receiver$iv[i];
                Project project2 = it = (Project)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"it");
                if (!INSTANCE.isRequiredForProject(project2, pluginId)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private final boolean isRequiredForProject(Project project2, String pluginId) {
        boolean bl;
        block1: {
            Iterable $receiver$iv = ExternalDependenciesManager.getInstance(project2).getDependencies(DependencyOnPlugin.class);
            for (Object element$iv : $receiver$iv) {
                DependencyOnPlugin it = (DependencyOnPlugin)element$iv;
                if (!Intrinsics.areEqual((Object)it.getPluginId(), (Object)pluginId)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    @JvmStatic
    @NotNull
    public static final Collection<ExternalUpdate> updateExternal(boolean manualCheck, @NotNull UpdateSettings updateSettings, @Nullable ProgressIndicator indicator) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)updateSettings, (String)"updateSettings");
        ArrayList result2 = CollectionsKt.arrayListOf((Object[])new ExternalUpdate[0]);
        ExternalComponentManager manager = ExternalComponentManager.getInstance();
        ProgressIndicator progressIndicator = indicator;
        if (progressIndicator != null) {
            progressIndicator.setText(IdeBundle.message((String)"updates.external.progress", (Object[])new Object[0]));
        }
        for (ExternalComponentSource source : manager.getComponentSources()) {
            ProgressIndicator progressIndicator2 = indicator;
            if (progressIndicator2 != null) {
                progressIndicator2.checkCanceled();
            }
            if (!updateSettings.getEnabledExternalUpdateSources().contains(source.getName())) continue;
            try {
                ArrayList siteResult = CollectionsKt.arrayListOf((Object[])new UpdatableExternalComponent[0]);
                for (UpdatableExternalComponent component : source.getAvailableVersions(indicator, updateSettings)) {
                    if (!component.isUpdateFor(manager.findExistingComponentMatching(component, source))) continue;
                    siteResult.add(component);
                }
                if (siteResult.isEmpty()) continue;
                result2.add(new ExternalUpdate(siteResult, source));
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
                Object[] objectArray = new Object[2];
                objectArray[0] = source.getName();
                String string = e.getMessage();
                if (string == null) {
                    string = "internal error";
                }
                objectArray[1] = string;
                String string2 = IdeBundle.message((String)"updates.external.error.message", (Object[])objectArray);
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"IdeBundle.message(\"updat\u2026sage ?: \"internal error\")");
                INSTANCE.showErrorMessage(manualCheck, string2);
            }
        }
        return result2;
    }

    @JvmStatic
    public static final void checkAndPrepareToInstall(@NotNull PluginDownloader downloader, @NotNull InstalledPluginsState state, @NotNull Map<PluginId, PluginDownloader> toUpdate, @Nullable Collection<IdeaPluginDescriptor> incompatiblePlugins, @Nullable ProgressIndicator indicator) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)downloader, (String)"downloader");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull(toUpdate, (String)"toUpdate");
        PluginDownloader downloader2 = downloader;
        String pluginId = downloader2.getPluginId();
        if (PluginManagerCore.getDisabledPlugins().contains(pluginId)) {
            return;
        }
        String pluginVersion = downloader2.getPluginVersion();
        IdeaPluginDescriptor installedPlugin = PluginManager.getPlugin(PluginId.getId((String)pluginId));
        if (installedPlugin == null || pluginVersion == null || PluginDownloader.compareVersionsSkipBrokenAndIncompatible(installedPlugin, pluginVersion) > 0) {
            IdeaPluginDescriptor descriptor;
            PluginDownloader oldDownloader = ourUpdatedPlugins.get(pluginId);
            if (oldDownloader == null || StringUtil.compareVersionNumbers((String)pluginVersion, (String)oldDownloader.getPluginVersion()) > 0) {
                descriptor = downloader2.getDescriptor();
                if (descriptor instanceof PluginNode && ((PluginNode)descriptor).isIncomplete()) {
                    ProgressIndicator progressIndicator = indicator;
                    if (progressIndicator == null) {
                        progressIndicator = (ProgressIndicator)new EmptyProgressIndicator();
                    }
                    if (downloader2.prepareToInstall(progressIndicator)) {
                        descriptor = downloader2.getDescriptor();
                    }
                    ourUpdatedPlugins.put(pluginId, downloader2);
                }
            } else {
                downloader2 = oldDownloader;
                descriptor = oldDownloader.getDescriptor();
            }
            if (descriptor != null && PluginManagerCore.isCompatible(descriptor, downloader2.getBuildNumber()) && !state.wasUpdated(descriptor.getPluginId())) {
                PluginId pluginId2 = PluginId.getId((String)pluginId);
                Intrinsics.checkExpressionValueIsNotNull((Object)pluginId2, (String)"PluginId.getId(pluginId)");
                toUpdate.put(pluginId2, downloader2);
            }
        }
        if (incompatiblePlugins != null && installedPlugin != null && installedPlugin.isEnabled() && !toUpdate.containsKey(installedPlugin.getPluginId()) && PluginManagerCore.isIncompatible(installedPlugin, downloader2.getBuildNumber())) {
            incompatiblePlugins.add(installedPlugin);
        }
    }

    private final void showErrorMessage(boolean showDialog, String message) {
        LOG.info(message);
        if (showDialog) {
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(message){
                final /* synthetic */ String $message;

                public final void run() {
                    Messages.showErrorDialog((String)this.$message, (String)IdeBundle.message((String)"updates.error.connection.title", (Object[])new Object[0]));
                }
                {
                    this.$message = string;
                }
            });
        }
    }

    private final void showUpdateResult(Project project2, CheckForUpdateResult checkForUpdateResult, UpdateSettings updateSettings, Collection<? extends PluginDownloader> updatedPlugins, Collection<? extends IdeaPluginDescriptor> incompatiblePlugins, Collection<? extends ExternalUpdate> externalUpdates, boolean enableLink, boolean alwaysShowResults) {
        UpdateChannel updatedChannel = checkForUpdateResult.getUpdatedChannel();
        BuildInfo newBuild = checkForUpdateResult.getNewBuild();
        if (updatedChannel != null && newBuild != null) {
            Function0 runnable2 = (Function0)new Function0<Unit>(checkForUpdateResult, updateSettings, updatedChannel, newBuild, enableLink, updatedPlugins, incompatiblePlugins){
                final /* synthetic */ CheckForUpdateResult $checkForUpdateResult;
                final /* synthetic */ UpdateSettings $updateSettings;
                final /* synthetic */ UpdateChannel $updatedChannel;
                final /* synthetic */ BuildInfo $newBuild;
                final /* synthetic */ boolean $enableLink;
                final /* synthetic */ Collection $updatedPlugins;
                final /* synthetic */ Collection $incompatiblePlugins;

                public final void invoke() {
                    PatchInfo patch = this.$checkForUpdateResult.findPatchForBuild(ApplicationInfo.getInstance().getBuild());
                    boolean forceHttps = this.$updateSettings.canUseSecureConnection();
                    new UpdateInfoDialog(this.$updatedChannel, this.$newBuild, patch, this.$enableLink, forceHttps, this.$updatedPlugins, this.$incompatiblePlugins).show();
                }
                {
                    this.$checkForUpdateResult = checkForUpdateResult;
                    this.$updateSettings = updateSettings;
                    this.$updatedChannel = updateChannel;
                    this.$newBuild = buildInfo;
                    this.$enableLink = bl;
                    this.$updatedPlugins = collection;
                    this.$incompatiblePlugins = collection2;
                    super(0);
                }
            };
            Collection collection = ourShownNotifications.remove((Object)NotificationUniqueType.PLATFORM);
            if (collection != null) {
                Iterable iterable = collection;
                for (Object element$iv : iterable) {
                    Notification it = (Notification)element$iv;
                    it.expire();
                }
            }
            if (alwaysShowResults) {
                runnable2.invoke();
            } else {
                String string;
                String string2 = string = IdeBundle.message((String)"updates.ready.message", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()});
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"message");
                this.showNotification(project2, string2, (Function0<Unit>)runnable2, NotificationUniqueType.PLATFORM);
            }
            return;
        }
        boolean updateFound = false;
        if (updatedPlugins != null && !updatedPlugins.isEmpty()) {
            updateFound = true;
            Function0 function0 = (Function0)new Function0<Unit>(updatedPlugins, enableLink){
                final /* synthetic */ Collection $updatedPlugins;
                final /* synthetic */ boolean $enableLink;

                public final void invoke() {
                    new PluginUpdateInfoDialog(this.$updatedPlugins, this.$enableLink).show();
                }
                {
                    this.$updatedPlugins = collection;
                    this.$enableLink = bl;
                    super(0);
                }
            };
            Collection collection = ourShownNotifications.remove((Object)NotificationUniqueType.PLUGINS);
            if (collection != null) {
                Iterable $receiver$iv = collection;
                for (Object element$iv : $receiver$iv) {
                    Notification it = (Notification)element$iv;
                    it.expire();
                }
            }
            if (alwaysShowResults) {
                function0.invoke();
            } else {
                String message;
                String plugins2 = CollectionsKt.joinToString$default((Iterable)updatedPlugins, null, null, null, (int)0, null, (Function1)showUpdateResult.plugins.1.INSTANCE, (int)31, null);
                String string = message = IdeBundle.message((String)"updates.plugins.ready.message", (Object[])new Object[]{updatedPlugins.size(), plugins2});
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"message");
                this.showNotification(project2, string, (Function0<Unit>)function0, NotificationUniqueType.PLUGINS);
            }
        }
        if (externalUpdates != null && !externalUpdates.isEmpty()) {
            updateFound = true;
            Collection collection = ourShownNotifications.remove((Object)NotificationUniqueType.EXTERNAL);
            if (collection != null) {
                Iterable iterable = collection;
                for (Object element$iv : iterable) {
                    Notification it = (Notification)element$iv;
                    it.expire();
                }
            }
            for (ExternalUpdate externalUpdate : externalUpdates) {
                String message;
                Function0 runnable4 = (Function0)new Function0<Unit>(externalUpdate){
                    final /* synthetic */ ExternalUpdate $update;

                    public final void invoke() {
                        this.$update.getSource().installUpdates(this.$update.getComponents());
                    }
                    {
                        this.$update = externalUpdate;
                        super(0);
                    }
                };
                if (alwaysShowResults) {
                    runnable4.invoke();
                    continue;
                }
                String updates = CollectionsKt.joinToString$default((Iterable)externalUpdate.getComponents(), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
                String string = message = IdeBundle.message((String)"updates.external.ready.message", (Object[])new Object[]{externalUpdate.getComponents().size(), updates});
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"message");
                this.showNotification(project2, string, (Function0<Unit>)runnable4, NotificationUniqueType.EXTERNAL);
            }
        }
        if (!updateFound && alwaysShowResults) {
            new NoUpdatesDialog(enableLink).show();
        }
    }

    private final void showNotification(Project project2, String message, Function0<Unit> action, NotificationUniqueType notificationType) {
        NotificationListener listener2 = new NotificationListener(action){
            final /* synthetic */ Function0 $action;

            public final void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)notification, (String)"notification");
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                notification.expire();
                this.$action.invoke();
            }
            {
                this.$action = function0;
            }
        };
        String title = IdeBundle.message((String)"update.notifications.title", (Object[])new Object[0]);
        Notification notification = NOTIFICATIONS.createNotification(title, XmlStringUtil.wrapInHtml((CharSequence)message), NotificationType.INFORMATION, listener2);
        notification.whenExpired(new Runnable(notificationType, notification){
            final /* synthetic */ NotificationUniqueType $notificationType;
            final /* synthetic */ Notification $notification;

            public final void run() {
                UpdateChecker.access$getOurShownNotifications$p(UpdateChecker.INSTANCE).remove((Object)((Object)this.$notificationType), (Object)this.$notification);
            }
            {
                this.$notificationType = notificationUniqueType;
                this.$notification = notification;
            }
        });
        notification.notify(project2);
        ourShownNotifications.putValue((Object)notificationType, (Object)notification);
    }

    @JvmStatic
    public static final void addUpdateRequestParameter(@NotNull String name, @NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        ourAdditionalRequestOptions.put(name, value);
    }

    private final void prepareUpdateCheckArgs(URIBuilder uriBuilder) {
        String string = ApplicationInfo.getInstance().getBuild().asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ApplicationInfo.getInstance().build.asString()");
        UpdateChecker.addUpdateRequestParameter("build", string);
        String string2 = PermanentInstallationID.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"PermanentInstallationID.get()");
        UpdateChecker.addUpdateRequestParameter("uid", string2);
        UpdateChecker.addUpdateRequestParameter("os", SystemInfo.OS_NAME + ' ' + SystemInfo.OS_VERSION);
        if (ApplicationInfoEx.getInstanceEx().isEAP()) {
            UpdateChecker.addUpdateRequestParameter("eap", "");
        }
        Map map = ourAdditionalRequestOptions;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator.next();
            String name = (String)entry2.getKey();
            entry2 = entry;
            String value = (String)entry2.getValue();
            uriBuilder.addParameter(name, StringUtil.isEmpty((String)value) ? null : value);
        }
    }

    @Deprecated(message="Replaced", replaceWith=@ReplaceWith(expression="PermanentInstallationID.get()", imports={"com.intellij.openapi.application.PermanentInstallationID"}))
    @JvmStatic
    @NotNull
    public static final String getInstallationUID(@NotNull PropertiesComponent c) {
        Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
        return PermanentInstallationID.get();
    }

    @JvmStatic
    public static /* synthetic */ void disabledToUpdatePlugins$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<String> getDisabledToUpdatePlugins() {
        if (ourDisabledToUpdatePlugins == null) {
            ourDisabledToUpdatePlugins = new TreeSet();
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                try {
                    File file2 = new File(PathManager.getConfigPath(), DISABLED_UPDATE);
                    if (file2.isFile()) {
                        Iterator iterator;
                        CharSequence charSequence;
                        void $receiver$iv$iv;
                        CharSequence charSequence2 = FileUtil.loadFile((File)file2);
                        Object object = "[\\s]";
                        object = new Regex((String)object);
                        int n = 0;
                        int n2 = 2;
                        Object var5_8 = null;
                        if ((n2 & 2) != 0) {
                            n = 0;
                        }
                        Iterable $receiver$iv = object.split(charSequence2, n);
                        object = $receiver$iv;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                        for (Object item$iv$iv : $receiver$iv$iv) {
                            void it;
                            void var7_10;
                            charSequence = (String)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            void v0 = var7_10 = it;
                            if (v0 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                            }
                            String string = ((Object)StringsKt.trim((CharSequence)((CharSequence)v0))).toString();
                            collection.add(string);
                        }
                        $receiver$iv = (List)((Object)iterator);
                        Set<String> set2 = ourDisabledToUpdatePlugins;
                        if (set2 == null) {
                            Intrinsics.throwNpe();
                        }
                        Collection destination$iv = set2;
                        for (Object element$iv : $receiver$iv) {
                            String it = (String)element$iv;
                            charSequence = it;
                            if (!(charSequence.length() > 0)) continue;
                            destination$iv.add(element$iv);
                        }
                    }
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
        }
        Set<String> set3 = ourDisabledToUpdatePlugins;
        if (set3 == null) {
            Intrinsics.throwNpe();
        }
        return set3;
    }

    @JvmStatic
    public static final void saveDisabledToUpdatePlugins() {
        File plugins2 = new File(PathManager.getConfigPath(), DISABLED_UPDATE);
        try {
            PluginManagerCore.savePluginsList((Collection<String>)UpdateChecker.getDisabledToUpdatePlugins(), false, plugins2);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    @JvmStatic
    public static final void checkForUpdate(@NotNull IdeaLoggingEvent event) {
        IdeaPluginDescriptor pluginDescriptor;
        Application app;
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        if (!(ourHasFailedPlugins || (app = ApplicationManager.getApplication()) == null || app.isDisposed() || app.isDisposeInProgress() || !UpdateSettings.getInstance().isCheckNeeded() || (pluginDescriptor = PluginManager.getPlugin(IdeErrorsDialog.findPluginId(event.getThrowable()))) == null || pluginDescriptor.isBundled())) {
            ourHasFailedPlugins = true;
            UpdateChecker.updateAndShowResult();
        }
    }

    private UpdateChecker() {
        INSTANCE = this;
        LOG = Logger.getInstance((String)"#com.intellij.openapi.updateSettings.impl.UpdateChecker");
        NOTIFICATIONS = new NotificationGroup(IdeBundle.message((String)"update.notifications.title", (Object[])new Object[0]), NotificationDisplayType.STICKY_BALLOON, true);
        DISABLED_UPDATE = DISABLED_UPDATE;
        NO_PLATFORM_UPDATE = NO_PLATFORM_UPDATE;
        ourAdditionalRequestOptions = MapsKt.hashMapOf((Pair[])new Pair[0]);
        ourUpdatedPlugins = MapsKt.hashMapOf((Pair[])new Pair[0]);
        ourShownNotifications = new MultiMap();
        excludedFromUpdateCheckPlugins = SetsKt.hashSetOf((Object[])new String[0]);
    }

    static {
        new UpdateChecker();
    }

    public static final /* synthetic */ void access$doUpdateAndShowResult(UpdateChecker $this, @Nullable Project project2, boolean fromSettings, boolean manualCheck, @NotNull UpdateSettings updateSettings, @Nullable ProgressIndicator indicator, @Nullable ActionCallback callback) {
        $this.doUpdateAndShowResult(project2, fromSettings, manualCheck, updateSettings, indicator, callback);
    }

    public static final /* synthetic */ void access$showUpdateResult(UpdateChecker $this, @Nullable Project project2, @NotNull CheckForUpdateResult checkForUpdateResult, @NotNull UpdateSettings updateSettings, @Nullable Collection updatedPlugins, @Nullable Collection incompatiblePlugins, @Nullable Collection externalUpdates, boolean enableLink, boolean alwaysShowResults) {
        $this.showUpdateResult(project2, checkForUpdateResult, updateSettings, updatedPlugins, incompatiblePlugins, externalUpdates, enableLink, alwaysShowResults);
    }

    @NotNull
    public static final /* synthetic */ Logger access$getLOG$p(UpdateChecker $this) {
        UpdateChecker updateChecker = $this;
        return LOG;
    }

    @NotNull
    public static final /* synthetic */ MultiMap access$getOurShownNotifications$p(UpdateChecker $this) {
        UpdateChecker updateChecker = $this;
        return ourShownNotifications;
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/openapi/updateSettings/impl/UpdateChecker$NotificationUniqueType;", "", "(Ljava/lang/String;I)V", "PLATFORM", "PLUGINS", "EXTERNAL", "platform-impl"})
    private static final class NotificationUniqueType
    extends Enum<NotificationUniqueType> {
        public static final /* enum */ NotificationUniqueType PLATFORM;
        public static final /* enum */ NotificationUniqueType PLUGINS;
        public static final /* enum */ NotificationUniqueType EXTERNAL;
        private static final /* synthetic */ NotificationUniqueType[] $VALUES;

        static {
            NotificationUniqueType[] notificationUniqueTypeArray = new NotificationUniqueType[3];
            NotificationUniqueType[] notificationUniqueTypeArray2 = notificationUniqueTypeArray;
            notificationUniqueTypeArray[0] = PLATFORM = new NotificationUniqueType();
            notificationUniqueTypeArray[1] = PLUGINS = new NotificationUniqueType();
            notificationUniqueTypeArray[2] = EXTERNAL = new NotificationUniqueType();
            $VALUES = notificationUniqueTypeArray;
        }

        public static NotificationUniqueType[] values() {
            return (NotificationUniqueType[])$VALUES.clone();
        }

        public static NotificationUniqueType valueOf(String string) {
            return Enum.valueOf(NotificationUniqueType.class, string);
        }
    }
}

