/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsNotifier {
    public static final NotificationGroup NOTIFICATION_GROUP_ID = NotificationGroup.toolWindowGroup((String)"Vcs Messages", (String)ChangesViewContentManager.TOOLWINDOW_ID);
    public static final NotificationGroup IMPORTANT_ERROR_NOTIFICATION = new NotificationGroup("Vcs Important Messages", NotificationDisplayType.STICKY_BALLOON, true);
    public static final NotificationGroup STANDARD_NOTIFICATION = new NotificationGroup("Vcs Notifications", NotificationDisplayType.BALLOON, true);
    public static final NotificationGroup SILENT_NOTIFICATION = new NotificationGroup("Vcs Silent Notifications", NotificationDisplayType.NONE, true);
    @NotNull
    private final Project myProject;

    public static VcsNotifier getInstance(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/VcsNotifier", "getInstance"));
        }
        return (VcsNotifier)ServiceManager.getService((Project)project2, VcsNotifier.class);
    }

    public VcsNotifier(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/VcsNotifier", "<init>"));
        }
        this.myProject = project2;
    }

    @NotNull
    public static Notification createNotification(@NotNull NotificationGroup notificationGroup, @NotNull String title, @NotNull String message, @NotNull NotificationType type, @Nullable NotificationListener listener2) {
        if (notificationGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notificationGroup", "com/intellij/openapi/vcs/VcsNotifier", "createNotification"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/vcs/VcsNotifier", "createNotification"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/openapi/vcs/VcsNotifier", "createNotification"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/vcs/VcsNotifier", "createNotification"));
        }
        if (StringUtil.isEmptyOrSpaces((String)message)) {
            message = title;
            title = "";
        }
        Notification notification = notificationGroup.createNotification(title, message, type, listener2);
        if (notification == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/VcsNotifier", "createNotification"));
        }
        return notification;
    }

    @NotNull
    public Notification notify(@NotNull NotificationGroup notificationGroup, @NotNull String title, @NotNull String message, @NotNull NotificationType type, @Nullable NotificationListener listener2) {
        if (notificationGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notificationGroup", "com/intellij/openapi/vcs/VcsNotifier", "notify"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/vcs/VcsNotifier", "notify"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/openapi/vcs/VcsNotifier", "notify"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/vcs/VcsNotifier", "notify"));
        }
        Notification notification = VcsNotifier.createNotification(notificationGroup, title, message, type, listener2);
        Notification notification2 = this.notify(notification);
        if (notification2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/VcsNotifier", "notify"));
        }
        return notification2;
    }

    @NotNull
    public Notification notify(@NotNull Notification notification) {
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/openapi/vcs/VcsNotifier", "notify"));
        }
        notification.notify(this.myProject);
        Notification notification2 = notification;
        if (notification2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/VcsNotifier", "notify"));
        }
        return notification2;
    }

    @NotNull
    public Notification notifyError(@NotNull String title, @NotNull String message) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/vcs/VcsNotifier", "notifyError"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/openapi/vcs/VcsNotifier", "notifyError"));
        }
        Notification notification = this.notifyError(title, message, null);
        if (notification == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/VcsNotifier", "notifyError"));
        }
        return notification;
    }

    @NotNull
    public Notification notifyError(@NotNull String title, @NotNull String message, @Nullable NotificationListener listener2) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/vcs/VcsNotifier", "notifyError"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/openapi/vcs/VcsNotifier", "notifyError"));
        }
        Notification notification = this.notify(IMPORTANT_ERROR_NOTIFICATION, title, message, NotificationType.ERROR, listener2);
        if (notification == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/VcsNotifier", "notifyError"));
        }
        return notification;
    }

    @NotNull
    public Notification notifyWeakError(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/openapi/vcs/VcsNotifier", "notifyWeakError"));
        }
        Notification notification = this.notify(NOTIFICATION_GROUP_ID, "", message, NotificationType.ERROR, null);
        if (notification == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/VcsNotifier", "notifyWeakError"));
        }
        return notification;
    }

    @NotNull
    public Notification notifySuccess(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/openapi/vcs/VcsNotifier", "notifySuccess"));
        }
        Notification notification = this.notifySuccess("", message);
        if (notification == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/VcsNotifier", "notifySuccess"));
        }
        return notification;
    }

    @NotNull
    public Notification notifySuccess(@NotNull String title, @NotNull String message) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/vcs/VcsNotifier", "notifySuccess"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/openapi/vcs/VcsNotifier", "notifySuccess"));
        }
        Notification notification = this.notifySuccess(title, message, null);
        if (notification == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/VcsNotifier", "notifySuccess"));
        }
        return notification;
    }

    @NotNull
    public Notification notifySuccess(@NotNull String title, @NotNull String message, @Nullable NotificationListener listener2) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/vcs/VcsNotifier", "notifySuccess"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/openapi/vcs/VcsNotifier", "notifySuccess"));
        }
        Notification notification = this.notify(NOTIFICATION_GROUP_ID, title, message, NotificationType.INFORMATION, listener2);
        if (notification == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/VcsNotifier", "notifySuccess"));
        }
        return notification;
    }

    @NotNull
    public Notification notifyImportantInfo(@NotNull String title, @NotNull String message) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/vcs/VcsNotifier", "notifyImportantInfo"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/openapi/vcs/VcsNotifier", "notifyImportantInfo"));
        }
        Notification notification = this.notify(IMPORTANT_ERROR_NOTIFICATION, title, message, NotificationType.INFORMATION, null);
        if (notification == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/VcsNotifier", "notifyImportantInfo"));
        }
        return notification;
    }

    @NotNull
    public Notification notifyImportantInfo(@NotNull String title, @NotNull String message, @Nullable NotificationListener listener2) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/vcs/VcsNotifier", "notifyImportantInfo"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/openapi/vcs/VcsNotifier", "notifyImportantInfo"));
        }
        Notification notification = this.notify(IMPORTANT_ERROR_NOTIFICATION, title, message, NotificationType.INFORMATION, listener2);
        if (notification == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/VcsNotifier", "notifyImportantInfo"));
        }
        return notification;
    }

    @NotNull
    public Notification notifyInfo(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/openapi/vcs/VcsNotifier", "notifyInfo"));
        }
        Notification notification = this.notifyInfo("", message);
        if (notification == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/VcsNotifier", "notifyInfo"));
        }
        return notification;
    }

    @NotNull
    public Notification notifyInfo(@NotNull String title, @NotNull String message) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/vcs/VcsNotifier", "notifyInfo"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/openapi/vcs/VcsNotifier", "notifyInfo"));
        }
        Notification notification = this.notifyInfo(title, message, null);
        if (notification == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/VcsNotifier", "notifyInfo"));
        }
        return notification;
    }

    @NotNull
    public Notification notifyInfo(@NotNull String title, @NotNull String message, @Nullable NotificationListener listener2) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/vcs/VcsNotifier", "notifyInfo"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/openapi/vcs/VcsNotifier", "notifyInfo"));
        }
        Notification notification = this.notify(NOTIFICATION_GROUP_ID, title, message, NotificationType.INFORMATION, listener2);
        if (notification == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/VcsNotifier", "notifyInfo"));
        }
        return notification;
    }

    @NotNull
    public Notification notifyMinorWarning(@NotNull String title, @NotNull String message) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/vcs/VcsNotifier", "notifyMinorWarning"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/openapi/vcs/VcsNotifier", "notifyMinorWarning"));
        }
        Notification notification = this.notifyMinorWarning(title, message, null);
        if (notification == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/VcsNotifier", "notifyMinorWarning"));
        }
        return notification;
    }

    @NotNull
    public Notification notifyMinorWarning(@NotNull String title, @NotNull String message, @Nullable NotificationListener listener2) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/vcs/VcsNotifier", "notifyMinorWarning"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/openapi/vcs/VcsNotifier", "notifyMinorWarning"));
        }
        Notification notification = this.notify(STANDARD_NOTIFICATION, title, message, NotificationType.WARNING, listener2);
        if (notification == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/VcsNotifier", "notifyMinorWarning"));
        }
        return notification;
    }

    @NotNull
    public Notification notifyWarning(@NotNull String title, @NotNull String message) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/vcs/VcsNotifier", "notifyWarning"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/openapi/vcs/VcsNotifier", "notifyWarning"));
        }
        Notification notification = this.notifyWarning(title, message, null);
        if (notification == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/VcsNotifier", "notifyWarning"));
        }
        return notification;
    }

    @NotNull
    public Notification notifyWarning(@NotNull String title, @NotNull String message, @Nullable NotificationListener listener2) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/vcs/VcsNotifier", "notifyWarning"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/openapi/vcs/VcsNotifier", "notifyWarning"));
        }
        Notification notification = this.notify(NOTIFICATION_GROUP_ID, title, message, NotificationType.WARNING, listener2);
        if (notification == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/VcsNotifier", "notifyWarning"));
        }
        return notification;
    }

    @NotNull
    public Notification notifyImportantWarning(@NotNull String title, @NotNull String message) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/vcs/VcsNotifier", "notifyImportantWarning"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/openapi/vcs/VcsNotifier", "notifyImportantWarning"));
        }
        Notification notification = this.notify(IMPORTANT_ERROR_NOTIFICATION, title, message, NotificationType.WARNING, null);
        if (notification == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/VcsNotifier", "notifyImportantWarning"));
        }
        return notification;
    }

    @NotNull
    public Notification notifyImportantWarning(@NotNull String title, @NotNull String message, @Nullable NotificationListener listener2) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/vcs/VcsNotifier", "notifyImportantWarning"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/openapi/vcs/VcsNotifier", "notifyImportantWarning"));
        }
        Notification notification = this.notify(IMPORTANT_ERROR_NOTIFICATION, title, message, NotificationType.WARNING, listener2);
        if (notification == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/VcsNotifier", "notifyImportantWarning"));
        }
        return notification;
    }

    @NotNull
    public Notification notifyMinorInfo(@NotNull String title, @NotNull String message) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/vcs/VcsNotifier", "notifyMinorInfo"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/openapi/vcs/VcsNotifier", "notifyMinorInfo"));
        }
        Notification notification = this.notifyMinorInfo(title, message, null);
        if (notification == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/VcsNotifier", "notifyMinorInfo"));
        }
        return notification;
    }

    @NotNull
    public Notification notifyMinorInfo(@NotNull String title, @NotNull String message, @Nullable NotificationListener listener2) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/vcs/VcsNotifier", "notifyMinorInfo"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/openapi/vcs/VcsNotifier", "notifyMinorInfo"));
        }
        Notification notification = this.notify(STANDARD_NOTIFICATION, title, message, NotificationType.INFORMATION, listener2);
        if (notification == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/VcsNotifier", "notifyMinorInfo"));
        }
        return notification;
    }

    public Notification logInfo(@NotNull String title, @NotNull String message) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/vcs/VcsNotifier", "logInfo"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/openapi/vcs/VcsNotifier", "logInfo"));
        }
        return this.notify(SILENT_NOTIFICATION, title, message, NotificationType.INFORMATION, null);
    }
}

