/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.lifecycle.PeriodicalTasksCloser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.impl.DirectoryIndexExcludePolicy;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsConnectionProblem;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.VcsListener;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.changes.BaseRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListAdapter;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerEx;
import com.intellij.openapi.vcs.changes.ChangeListManagerGate;
import com.intellij.openapi.vcs.changes.ChangeListManagerSerialization;
import com.intellij.openapi.vcs.changes.ChangeListOwner;
import com.intellij.openapi.vcs.changes.ChangeListWorker;
import com.intellij.openapi.vcs.changes.ChangeProvider;
import com.intellij.openapi.vcs.changes.ChangelistBuilder;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ChangesViewI;
import com.intellij.openapi.vcs.changes.ChangesViewManager;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.DelayedNotificator;
import com.intellij.openapi.vcs.changes.DummyChangesView;
import com.intellij.openapi.vcs.changes.FileHolder;
import com.intellij.openapi.vcs.changes.FileHolderComposite;
import com.intellij.openapi.vcs.changes.FoldersCutDownWorker;
import com.intellij.openapi.vcs.changes.IgnoredFileBean;
import com.intellij.openapi.vcs.changes.IgnoredFileProvider;
import com.intellij.openapi.vcs.changes.IgnoredFilesComponent;
import com.intellij.openapi.vcs.changes.IgnoredFilesCompositeHolder;
import com.intellij.openapi.vcs.changes.IgnoredFilesHolder;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.LastUnchangedContentTracker;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.LocalChangeListsLoadedListener;
import com.intellij.openapi.vcs.changes.LocallyDeletedChange;
import com.intellij.openapi.vcs.changes.LogicalLock;
import com.intellij.openapi.vcs.changes.LogicallyLockedHolder;
import com.intellij.openapi.vcs.changes.Modifier;
import com.intellij.openapi.vcs.changes.RemoteRevisionsCache;
import com.intellij.openapi.vcs.changes.SwitchedFileHolder;
import com.intellij.openapi.vcs.changes.UpdateRequestsQueue;
import com.intellij.openapi.vcs.changes.UpdatingChangeListBuilder;
import com.intellij.openapi.vcs.changes.VcsAnnotationRefresher;
import com.intellij.openapi.vcs.changes.VcsConfirmationDialog;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeModifier;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeVfsListener;
import com.intellij.openapi.vcs.changes.VcsInvalidated;
import com.intellij.openapi.vcs.changes.VcsModifiableDirtyScope;
import com.intellij.openapi.vcs.changes.VirtualFileHolder;
import com.intellij.openapi.vcs.changes.actions.ChangeListRemoveConfirmation;
import com.intellij.openapi.vcs.changes.conflicts.ChangelistConflictTracker;
import com.intellij.openapi.vcs.changes.ui.CommitHelper;
import com.intellij.openapi.vcs.changes.ui.PlusMinusModify;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.impl.AbstractVcsHelperImpl;
import com.intellij.openapi.vcs.impl.ContentRevisionCache;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import com.intellij.openapi.vcs.impl.VcsInitObject;
import com.intellij.openapi.vcs.impl.VcsRootIterator;
import com.intellij.openapi.vcs.readOnlyHandler.ReadonlyStatusHandlerImpl;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.Consumer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.FunctionUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.Processor;
import com.intellij.util.ThreeState;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ChangeListManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public class ChangeListManagerImpl
extends ChangeListManagerEx
implements ProjectComponent,
ChangeListOwner,
PersistentStateComponent<Element> {
    public static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.ChangeListManagerImpl");
    private static final String EXCLUDED_CONVERTED_TO_IGNORED_OPTION = "EXCLUDED_CONVERTED_TO_IGNORED";
    private final Project myProject;
    private final VcsConfiguration myConfig;
    private final ChangesViewI myChangesViewManager;
    private final FileStatusManager myFileStatusManager;
    private final UpdateRequestsQueue myUpdater;
    private static final AtomicReference<Future> ourUpdateAlarm = new AtomicReference();
    private final ScheduledExecutorService myScheduledExecutorService = AppExecutorUtil.createBoundedScheduledExecutorService((String)"ChangeListManagerImpl pool", (int)1);
    private final Modifier myModifier;
    private FileHolderComposite myComposite;
    private ChangeListWorker myWorker;
    private VcsException myUpdateException;
    private Factory<JComponent> myAdditionalInfo;
    private final EventDispatcher<ChangeListListener> myListeners = EventDispatcher.create(ChangeListListener.class);
    private final Object myDataLock = new Object();
    private final List<CommitExecutor> myExecutors = new ArrayList<CommitExecutor>();
    private final IgnoredFilesComponent myIgnoredIdeaLevel;
    private boolean myExcludedConvertedToIgnored;
    @NotNull
    private volatile ProgressIndicator myUpdateChangesProgressIndicator = ChangeListManagerImpl.createProgressIndicator();
    public static final Topic<LocalChangeListsLoadedListener> LISTS_LOADED = new Topic("LOCAL_CHANGE_LISTS_LOADED", LocalChangeListsLoadedListener.class);
    private boolean myShowLocalChangesInvalidated;
    private final AtomicReference<String> myFreezeName;
    private final DelayedNotificator myDelayedNotificator;
    private final VcsListener myVcsListener = new VcsListener(){

        public void directoryMappingChanged() {
            VcsDirtyScopeManager.getInstance((Project)ChangeListManagerImpl.this.myProject).markEverythingDirty();
        }
    };
    private final ChangelistConflictTracker myConflictTracker;
    private VcsDirtyScopeManager myDirtyScopeManager;
    private boolean myModalNotificationsBlocked;
    @NotNull
    private final Collection<LocalChangeList> myListsToBeDeleted = new HashSet<LocalChangeList>();

    public static ChangeListManagerImpl getInstanceImpl(Project project2) {
        return (ChangeListManagerImpl)PeriodicalTasksCloser.getInstance().safeGetComponent(project2, ChangeListManager.class);
    }

    void setDirtyScopeManager(VcsDirtyScopeManager dirtyScopeManager) {
        this.myDirtyScopeManager = dirtyScopeManager;
    }

    public ChangeListManagerImpl(Project project2, final VcsConfiguration config) {
        this.myProject = project2;
        this.myConfig = config;
        this.myFreezeName = new AtomicReference<Object>(null);
        this.myAdditionalInfo = null;
        this.myChangesViewManager = this.myProject.isDefault() ? new DummyChangesView(this.myProject) : ChangesViewManager.getInstance(this.myProject);
        this.myFileStatusManager = FileStatusManager.getInstance((Project)this.myProject);
        this.myComposite = new FileHolderComposite(project2);
        this.myIgnoredIdeaLevel = new IgnoredFilesComponent(this.myProject, true);
        this.myUpdater = new UpdateRequestsQueue(this.myProject, ourUpdateAlarm, this.myScheduledExecutorService, new ActualUpdater());
        this.myWorker = new ChangeListWorker(this.myProject, new MyChangesDeltaForwarder(this.myProject, ourUpdateAlarm, this.myScheduledExecutorService));
        this.myDelayedNotificator = new DelayedNotificator(this.myListeners, ourUpdateAlarm, this.myScheduledExecutorService);
        this.myModifier = new Modifier(this.myWorker, this.myDelayedNotificator);
        this.myConflictTracker = new ChangelistConflictTracker(project2, this, this.myFileStatusManager, EditorNotifications.getInstance((Project)project2));
        this.myListeners.addListener((EventListener)new ChangeListAdapter(){

            public void defaultListChanged(ChangeList oldDefaultList, ChangeList newDefaultList) {
                LocalChangeList oldList = (LocalChangeList)oldDefaultList;
                if (oldDefaultList == null || oldList.hasDefaultName() || oldDefaultList.equals(newDefaultList)) {
                    return;
                }
                if (!ApplicationManager.getApplication().isUnitTestMode()) {
                    ChangeListManagerImpl.this.scheduleAutomaticChangeListDeletionIfEmpty(oldList, config);
                }
            }
        });
    }

    private void scheduleAutomaticChangeListDeletionIfEmpty(LocalChangeList oldList, VcsConfiguration config) {
        if (oldList.isReadOnly() || !oldList.getChanges().isEmpty()) {
            return;
        }
        this.invokeAfterUpdate(() -> {
            LocalChangeList actualList = this.getChangeList(oldList.getId());
            if (actualList == null) {
                return;
            }
            if (this.myModalNotificationsBlocked && config.REMOVE_EMPTY_INACTIVE_CHANGELISTS != VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY) {
                this.myListsToBeDeleted.add(oldList);
            } else {
                this.deleteEmptyChangeLists(Collections.singletonList(actualList));
            }
        }, InvokeAfterUpdateMode.SILENT, null, null);
    }

    private void deleteEmptyChangeLists(@NotNull Collection<LocalChangeList> lists) {
        if (lists == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lists", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "deleteEmptyChangeLists"));
        }
        if (lists.isEmpty() || this.myConfig.REMOVE_EMPTY_INACTIVE_CHANGELISTS == VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY) {
            return;
        }
        ChangeListRemoveConfirmation.processLists(this.myProject, false, lists, new ChangeListRemoveConfirmation(){

            @Override
            public boolean askIfShouldRemoveChangeLists(@NotNull List<? extends LocalChangeList> toAsk) {
                if (toAsk == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toAsk", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl$3", "askIfShouldRemoveChangeLists"));
                }
                return ((ChangeListManagerImpl)ChangeListManagerImpl.this).myConfig.REMOVE_EMPTY_INACTIVE_CHANGELISTS != VcsShowConfirmationOption.Value.SHOW_CONFIRMATION || ChangeListManagerImpl.this.showRemoveEmptyChangeListsProposal(ChangeListManagerImpl.this.myConfig, toAsk);
            }
        });
    }

    private boolean showRemoveEmptyChangeListsProposal(final @NotNull VcsConfiguration config, @NotNull Collection<? extends LocalChangeList> lists) {
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "showRemoveEmptyChangeListsProposal"));
        }
        if (lists == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lists", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "showRemoveEmptyChangeListsProposal"));
        }
        if (lists.isEmpty()) {
            return false;
        }
        String question = lists.size() == 1 ? String.format("<html>The empty changelist '%s' is no longer active.<br>Do you want to remove it?</html>", StringUtil.first((String)lists.iterator().next().getName(), (int)30, (boolean)true)) : String.format("<html>Empty changelists<br/>%s are no longer active.<br>Do you want to remove them?</html>", StringUtil.join(lists, list -> StringUtil.first((String)list.getName(), (int)30, (boolean)true), (String)"<br/>"));
        VcsConfirmationDialog dialog2 = new VcsConfirmationDialog(this.myProject, "Remove Empty Changelist", "Remove", "Cancel", new VcsShowConfirmationOption(){

            public VcsShowConfirmationOption.Value getValue() {
                return config.REMOVE_EMPTY_INACTIVE_CHANGELISTS;
            }

            public void setValue(VcsShowConfirmationOption.Value value) {
                config.REMOVE_EMPTY_INACTIVE_CHANGELISTS = value;
            }

            public boolean isPersistent() {
                return true;
            }
        }, question, "&Remember my choice");
        return dialog2.showAndGet();
    }

    @Override
    public void blockModalNotifications() {
        this.myModalNotificationsBlocked = true;
    }

    @Override
    public void unblockModalNotifications() {
        this.myModalNotificationsBlocked = false;
        this.deleteEmptyChangeLists(this.myListsToBeDeleted);
        this.myListsToBeDeleted.clear();
    }

    public void projectOpened() {
        this.initializeForNewProject();
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.myUpdater.initialized();
            this.myProject.getMessageBus().connect().subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, (Object)this.myVcsListener);
        } else {
            ((ProjectLevelVcsManagerImpl)vcsManager).addInitializationRequest(VcsInitObject.CHANGE_LIST_MANAGER, (Runnable)((DumbAwareRunnable)() -> {
                this.myUpdater.initialized();
                this.broadcastStateAfterLoad();
                this.myProject.getMessageBus().connect().subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, (Object)this.myVcsListener);
            }));
            this.myConflictTracker.startTracking();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void broadcastStateAfterLoad() {
        List<LocalChangeList> listCopy;
        Object object = this.myDataLock;
        synchronized (object) {
            listCopy = this.getChangeListsCopy();
        }
        if (!this.myProject.isDisposed()) {
            ((LocalChangeListsLoadedListener)this.myProject.getMessageBus().syncPublisher(LISTS_LOADED)).processLoadedLists(listCopy);
        }
    }

    private void initializeForNewProject() {
        ApplicationManager.getApplication().runReadAction(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                if (this.myWorker.isEmpty()) {
                    this.setDefaultChangeList(this.myWorker.addChangeList(LocalChangeList.DEFAULT_NAME, null, null));
                }
                if (!Registry.is((String)"ide.hide.excluded.files") && !this.myExcludedConvertedToIgnored) {
                    this.convertExcludedToIgnored();
                    this.myExcludedConvertedToIgnored = true;
                }
            }
        });
    }

    void convertExcludedToIgnored() {
        for (DirectoryIndexExcludePolicy policy : (DirectoryIndexExcludePolicy[])DirectoryIndexExcludePolicy.EP_NAME.getExtensions((AreaInstance)this.myProject)) {
            for (VirtualFile file2 : policy.getExcludeRootsForProject()) {
                this.addDirectoryToIgnoreImplicitly(file2.getPath());
            }
        }
        ProjectFileIndex fileIndex = ProjectFileIndex.SERVICE.getInstance((Project)this.myProject);
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        for (Module module2 : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            for (String url : ModuleRootManager.getInstance((Module)module2).getExcludeRootUrls()) {
                VirtualFile file3 = virtualFileManager.findFileByUrl(url);
                if (file3 != null && !fileIndex.isExcluded(file3)) continue;
                this.addDirectoryToIgnoreImplicitly(VfsUtilCore.urlToPath((String)url));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void projectClosed() {
        Object object = this.myDataLock;
        synchronized (object) {
            this.myUpdateChangesProgressIndicator.cancel();
        }
        this.myUpdater.stop();
        this.myConflictTracker.stopTracking();
    }

    @NotNull
    @NonNls
    public String getComponentName() {
        if ("ChangeListManager" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getComponentName"));
        }
        return "ChangeListManager";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    public void invokeAfterUpdate(Runnable afterUpdate, InvokeAfterUpdateMode mode, @Nullable String title, @Nullable ModalityState state) {
        this.myUpdater.invokeAfterUpdate(afterUpdate, mode, title, null, state);
    }

    public void invokeAfterUpdate(Runnable afterUpdate, InvokeAfterUpdateMode mode, String title, Consumer<VcsDirtyScopeManager> dirtyScopeManagerFiller, ModalityState state) {
        this.myUpdater.invokeAfterUpdate(afterUpdate, mode, title, dirtyScopeManagerFiller, state);
    }

    public void freeze(@NotNull String reason) {
        if (reason == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "freeze"));
        }
        this.myUpdater.setIgnoreBackgroundOperation(true);
        Semaphore sem = new Semaphore();
        sem.down();
        this.invokeAfterUpdate(() -> {
            if (reason == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "lambda$freeze$4"));
            }
            this.myUpdater.setIgnoreBackgroundOperation(false);
            this.myUpdater.pause();
            this.myFreezeName.set(reason);
            sem.up();
        }, InvokeAfterUpdateMode.SILENT_CALLBACK_POOLED, "", ModalityState.defaultModalityState());
        boolean free = false;
        while (!free) {
            ProgressIndicator pi = ProgressManager.getInstance().getProgressIndicator();
            if (pi != null) {
                pi.checkCanceled();
            }
            free = sem.waitFor(500L);
        }
    }

    public void letGo() {
        this.myUpdater.go();
        this.myFreezeName.set(null);
    }

    public String isFreezed() {
        return this.myFreezeName.get();
    }

    public void scheduleUpdate() {
        this.myUpdater.schedule();
    }

    public void scheduleUpdate(boolean updateUnversionedFiles) {
        this.myUpdater.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void filterOutIgnoredFiles(List<VcsDirtyScope> scopes) {
        HashSet<VirtualFile> refreshFiles = new HashSet<VirtualFile>();
        try {
            Iterator iterator = this.myDataLock;
            synchronized (iterator) {
                IgnoredFilesCompositeHolder fileHolder = this.myComposite.getIgnoredFileHolder();
                Iterator<VcsDirtyScope> iterator2 = scopes.iterator();
                while (iterator2.hasNext()) {
                    VcsModifiableDirtyScope scope = (VcsModifiableDirtyScope)iterator2.next();
                    VcsDirtyScopeModifier modifier = scope.getModifier();
                    if (modifier == null) continue;
                    fileHolder.notifyVcsStarted(scope.getVcs());
                    Iterator filesIterator = modifier.getDirtyFilesIterator();
                    while (filesIterator.hasNext()) {
                        FilePath dirtyFile = (FilePath)filesIterator.next();
                        if (dirtyFile.getVirtualFile() == null || !this.isIgnoredFile(dirtyFile.getVirtualFile())) continue;
                        filesIterator.remove();
                        fileHolder.addFile(dirtyFile.getVirtualFile());
                        refreshFiles.add(dirtyFile.getVirtualFile());
                    }
                    Collection roots = modifier.getAffectedVcsRoots();
                    for (VirtualFile root : roots) {
                        Iterator dirIterator = modifier.getDirtyDirectoriesIterator(root);
                        while (dirIterator.hasNext()) {
                            FilePath dir = (FilePath)dirIterator.next();
                            if (dir.getVirtualFile() == null || !this.isIgnoredFile(dir.getVirtualFile())) continue;
                            dirIterator.remove();
                            fileHolder.addFile(dir.getVirtualFile());
                            refreshFiles.add(dir.getVirtualFile());
                        }
                    }
                    modifier.recheckDirtyKeys();
                    if (!scope.isEmpty()) continue;
                    iterator2.remove();
                }
            }
        }
        catch (AssertionError | Exception ex) {
            LOG.error((Throwable)ex);
        }
        for (VirtualFile file2 : refreshFiles) {
            this.myFileStatusManager.fileStatusChanged(file2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateImmediately() {
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        if (!vcsManager.hasActiveVcss()) {
            return;
        }
        VcsInvalidated invalidated = this.myDirtyScopeManager.retrieveScopes();
        if (this.checkScopeIsEmpty(invalidated)) {
            this.myDirtyScopeManager.changesProcessed();
            return;
        }
        boolean wasEverythingDirty = invalidated.isEverythingDirty();
        List scopes = invalidated.getScopes();
        try {
            boolean takeChanges;
            DataHolder dataHolder;
            this.checkIfDisposed();
            ProgressIndicator indicator = ChangeListManagerImpl.createProgressIndicator();
            Object object = this.myDataLock;
            synchronized (object) {
                dataHolder = new DataHolder((FileHolderComposite)this.myComposite.copy(), this.myWorker.copy(), wasEverythingDirty);
                this.myModifier.enterUpdate();
                if (wasEverythingDirty) {
                    this.myUpdateException = null;
                    this.myAdditionalInfo = null;
                }
                this.myUpdateChangesProgressIndicator = indicator;
            }
            if (LOG.isDebugEnabled()) {
                String scopeInString = StringUtil.join((Collection)scopes, scope -> scope.toString(), (String)"->\n");
                LOG.debug("refresh procedure started, everything: " + wasEverythingDirty + " dirty scope: " + scopeInString + "\ncurrent changes: " + this.myWorker);
            }
            dataHolder.notifyStart();
            this.myChangesViewManager.scheduleRefresh();
            ProgressManager.getInstance().runProcess(() -> this.iterateScopes(dataHolder, scopes, wasEverythingDirty), indicator);
            boolean bl = takeChanges = this.myUpdateException == null;
            if (takeChanges) {
                this.updateIgnoredFiles(dataHolder.getComposite());
            }
            this.clearCurrentRevisionsCache(invalidated);
            ApplicationManager.getApplication().runReadAction(() -> {
                if (this.myProject.isDisposed()) {
                    return;
                }
                Object object = this.myDataLock;
                synchronized (object) {
                    dataHolder.notifyEnd();
                    this.myModifier.finishUpdate(dataHolder.getChangeListWorker());
                    if (takeChanges) {
                        ChangeListWorker oldWorker = this.myWorker;
                        this.myWorker = dataHolder.getChangeListWorker();
                        this.myWorker.onAfterWorkerSwitch(oldWorker);
                        this.myModifier.setWorker(this.myWorker);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("refresh procedure finished, unversioned size: " + dataHolder.getComposite().getVFHolder(FileHolder.HolderType.UNVERSIONED).getFiles().size() + "\nchanges: " + this.myWorker);
                        }
                        boolean statusChanged = !this.myComposite.equals(dataHolder.getComposite());
                        this.myComposite = dataHolder.getComposite();
                        if (statusChanged) {
                            this.myDelayedNotificator.getProxyDispatcher().unchangedFileStatusChanged();
                        }
                    }
                    this.myShowLocalChangesInvalidated = false;
                }
            });
            for (VcsDirtyScope scope2 : scopes) {
                AbstractVcs vcs = scope2.getVcs();
                if (vcs == null || !vcs.isTrackingUnchangedContent()) continue;
                scope2.iterateExistingInsideScope(file2 -> {
                    LastUnchangedContentTracker.markUntouched(file2);
                    return true;
                });
            }
            this.myChangesViewManager.scheduleRefresh();
        }
        catch (ProcessCanceledException | DisposedException dataHolder2) {
            this.myDirtyScopeManager.changesProcessed();
            Object dataHolder2 = this.myDataLock;
            synchronized (dataHolder2) {
                this.myDelayedNotificator.getProxyDispatcher().changeListUpdateDone();
                this.myChangesViewManager.scheduleRefresh();
            }
        }
        catch (AssertionError | Exception ex) {
            LOG.error((Throwable)ex);
        }
        finally {
            this.myDirtyScopeManager.changesProcessed();
            Object object = this.myDataLock;
            synchronized (object) {
                this.myDelayedNotificator.getProxyDispatcher().changeListUpdateDone();
                this.myChangesViewManager.scheduleRefresh();
            }
        }
    }

    private boolean checkScopeIsAllIgnored(VcsInvalidated invalidated) {
        if (!invalidated.isEverythingDirty()) {
            this.filterOutIgnoredFiles(invalidated.getScopes());
            if (invalidated.isEmpty()) {
                return true;
            }
        }
        return false;
    }

    private boolean checkScopeIsEmpty(VcsInvalidated invalidated) {
        if (invalidated == null || invalidated.isEmpty()) {
            if (invalidated != null && invalidated.isEmpty() && invalidated.isEverythingDirty()) {
                VcsDirtyScopeManager.getInstance((Project)this.myProject).markEverythingDirty();
            }
            return true;
        }
        return this.checkScopeIsAllIgnored(invalidated);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void iterateScopes(DataHolder dataHolder, List<VcsDirtyScope> scopes, boolean wasEverythingDirty) {
        ChangeListManagerGate gate = dataHolder.getChangeListWorker().createSelfGate();
        Getter disposedGetter = () -> this.myProject.isDisposed() || (Boolean)this.myUpdater.getIsStoppedGetter().get() != false;
        UpdatingChangeListBuilder builder = new UpdatingChangeListBuilder(dataHolder.getChangeListWorker(), dataHolder.getComposite(), (Getter<Boolean>)disposedGetter, this, gate);
        for (VcsDirtyScope scope : scopes) {
            this.myUpdateChangesProgressIndicator.checkCanceled();
            AbstractVcs vcs = scope.getVcs();
            if (vcs == null) continue;
            scope.setWasEverythingDirty(wasEverythingDirty);
            this.myChangesViewManager.setBusy(true);
            dataHolder.notifyStartProcessingChanges((VcsModifiableDirtyScope)scope);
            this.actualUpdate(builder, scope, vcs, dataHolder, gate);
            if (this.myUpdateException == null) continue;
            break;
        }
        Object object = this.myDataLock;
        synchronized (object) {
            if (this.myAdditionalInfo == null) {
                this.myAdditionalInfo = builder.getAdditionalInfo();
            }
        }
    }

    private void clearCurrentRevisionsCache(VcsInvalidated invalidated) {
        ContentRevisionCache cache = ProjectLevelVcsManager.getInstance((Project)this.myProject).getContentRevisionCache();
        if (invalidated.isEverythingDirty()) {
            cache.clearAllCurrent();
        } else {
            cache.clearScope(invalidated.getScopes());
        }
    }

    @NotNull
    private static ProgressIndicator createProgressIndicator() {
        EmptyProgressIndicator emptyProgressIndicator = new EmptyProgressIndicator();
        if (emptyProgressIndicator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "createProgressIndicator"));
        }
        return emptyProgressIndicator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void actualUpdate(@NotNull UpdatingChangeListBuilder builder, @NotNull VcsDirtyScope scope, @NotNull AbstractVcs vcs, @NotNull DataHolder dataHolder, @NotNull ChangeListManagerGate gate) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "actualUpdate"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "actualUpdate"));
        }
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "actualUpdate"));
        }
        if (dataHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataHolder", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "actualUpdate"));
        }
        if (gate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gate", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "actualUpdate"));
        }
        try {
            ChangeProvider changeProvider = vcs.getChangeProvider();
            if (changeProvider != null) {
                FoldersCutDownWorker foldersCutDownWorker = new FoldersCutDownWorker();
                try {
                    builder.setCurrent(scope, foldersCutDownWorker);
                    changeProvider.getChanges(scope, (ChangelistBuilder)builder, this.myUpdateChangesProgressIndicator, gate);
                }
                catch (VcsException e) {
                    this.handleUpdateException(e);
                }
            }
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable t) {
            LOG.debug(t);
            ExceptionUtil.rethrowAllAsUnchecked((Throwable)t);
        }
        finally {
            if (!this.myUpdater.isStopped()) {
                dataHolder.notifyDoneProcessingChanges();
            }
        }
    }

    private void handleUpdateException(VcsException e) {
        LOG.info((Throwable)e);
        if (e instanceof VcsConnectionProblem) {
            ApplicationManager.getApplication().invokeLater(() -> ((VcsConnectionProblem)e).attemptQuickFix(false));
        }
        if (this.myUpdateException == null) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                AbstractVcsHelper helper = AbstractVcsHelper.getInstance((Project)this.myProject);
                if (helper instanceof AbstractVcsHelperImpl && ((AbstractVcsHelperImpl)helper).handleCustom(e)) {
                    return;
                }
                e.printStackTrace();
            }
            this.myUpdateException = e;
        }
    }

    private void checkIfDisposed() {
        if (this.myUpdater.isStopped()) {
            throw new DisposedException();
        }
    }

    public static boolean isUnder(Change change, VcsDirtyScope scope) {
        ContentRevision before = change.getBeforeRevision();
        ContentRevision after2 = change.getAfterRevision();
        return before != null && scope.belongsTo(before.getFile()) || after2 != null && scope.belongsTo(after2.getFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LocalChangeList> getChangeListsCopy() {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getListsCopy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public List<LocalChangeList> getChangeLists() {
        Object object = this.myDataLock;
        // MONITORENTER : object
        List<LocalChangeList> list = this.getChangeListsCopy();
        // MONITOREXIT : object
        if (list != null) return list;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getChangeLists"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<File> getAffectedPaths() {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getAffectedPaths();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public List<VirtualFile> getAffectedFiles() {
        Object object = this.myDataLock;
        // MONITORENTER : object
        List<VirtualFile> list = this.myWorker.getAffectedFiles();
        // MONITOREXIT : object
        if (list != null) return list;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getAffectedFiles"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Collection<Change> getAllChanges() {
        Object object = this.myDataLock;
        // MONITORENTER : object
        Collection<Change> collection = this.myWorker.getAllChanges();
        // MONITOREXIT : object
        if (collection != null) return collection;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getAllChanges"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public List<VirtualFile> getUnversionedFiles() {
        Object object = this.myDataLock;
        // MONITORENTER : object
        List<VirtualFile> list = this.myComposite.getVFHolder(FileHolder.HolderType.UNVERSIONED).getFiles();
        // MONITOREXIT : object
        if (list != null) return list;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getUnversionedFiles"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<VirtualFile> getModifiedWithoutEditing() {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myComposite.getVFHolder(FileHolder.HolderType.MODIFIED_WITHOUT_EDITING).getFiles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public List<VirtualFile> getIgnoredFiles() {
        Object object = this.myDataLock;
        // MONITORENTER : object
        ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>(this.myComposite.getIgnoredFileHolder().values());
        // MONITOREXIT : object
        if (arrayList != null) return arrayList;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getIgnoredFiles"));
    }

    boolean isIgnoredInUpdateMode() {
        return this.myComposite.getIgnoredFileHolder().isInUpdatingMode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<VirtualFile> getLockedFolders() {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myComposite.getVFHolder(FileHolder.HolderType.LOCKED).getFiles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<VirtualFile, LogicalLock> getLogicallyLockedFolders() {
        Object object = this.myDataLock;
        synchronized (object) {
            return new HashMap<VirtualFile, LogicalLock>(((LogicallyLockedHolder)this.myComposite.get(FileHolder.HolderType.LOGICALLY_LOCKED)).getMap());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLogicallyLocked(VirtualFile file2) {
        Object object = this.myDataLock;
        synchronized (object) {
            return ((LogicallyLockedHolder)this.myComposite.get(FileHolder.HolderType.LOGICALLY_LOCKED)).containsKey(file2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isContainedInLocallyDeleted(FilePath filePath) {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.isContainedInLocallyDeleted(filePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LocallyDeletedChange> getDeletedFiles() {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getLocallyDeleted().getFiles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MultiMap<String, VirtualFile> getSwitchedFilesMap() {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getSwitchedHolder().getBranchToFileMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    Map<VirtualFile, String> getSwitchedRoots() {
        Object object = this.myDataLock;
        synchronized (object) {
            return ((SwitchedFileHolder)this.myComposite.get(FileHolder.HolderType.ROOT_SWITCH)).getFilesMapCopy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VcsException getUpdateException() {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myUpdateException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Factory<JComponent> getAdditionalUpdateInfo() {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myAdditionalInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFileAffected(VirtualFile file2) {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getStatus(file2) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public LocalChangeList findChangeList(String name) {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getCopyByName(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalChangeList getChangeList(String id) {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getChangeList(id);
        }
    }

    public LocalChangeList addChangeList(@NotNull String name, @Nullable String comment) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "addChangeList"));
        }
        return this.addChangeList(name, comment, null);
    }

    @Override
    public LocalChangeList addChangeList(@NotNull String name, @Nullable String comment, @Nullable Object data) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "addChangeList"));
        }
        return (LocalChangeList)ReadAction.compute(() -> {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "lambda$addChangeList$11"));
            }
            Object object = this.myDataLock;
            synchronized (object) {
                LocalChangeList changeList = this.myModifier.addChangeList(name, comment, data);
                this.myChangesViewManager.scheduleRefresh();
                return changeList;
            }
        });
    }

    public void removeChangeList(String name) {
        ApplicationManager.getApplication().runReadAction(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                this.myModifier.removeChangeList(name);
                this.myChangesViewManager.scheduleRefresh();
            }
        });
    }

    public void removeChangeList(LocalChangeList list) {
        this.removeChangeList(list.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Runnable prepareForChangeDeletion(Collection<Change> changes) {
        Map<String, List<Change>> map;
        HashMap<String, LocalChangeList> lists = new HashMap<String, LocalChangeList>();
        Object object = this.myDataLock;
        synchronized (object) {
            map = this.myWorker.listsForChanges(changes, lists);
        }
        Runnable runnable2 = () -> {
            ChangeListListener multicaster = this.myDelayedNotificator.getProxyDispatcher();
            ApplicationManager.getApplication().runReadAction(() -> {
                Object object = this.myDataLock;
                synchronized (object) {
                    for (Map.Entry entry : map.entrySet()) {
                        List changes1 = (List)entry.getValue();
                        Iterator iterator = changes1.iterator();
                        while (iterator.hasNext()) {
                            Change change = (Change)iterator.next();
                            if (this.getChangeList(change) == null) continue;
                            iterator.remove();
                        }
                        multicaster.changesRemoved((Collection)changes1, (ChangeList)lists.get(entry.getKey()));
                    }
                    for (String listName : map.keySet()) {
                        LocalChangeList byName = this.myWorker.getCopyByName(listName);
                        if (byName == null || byName.isDefault()) continue;
                        this.scheduleAutomaticChangeListDeletionIfEmpty(byName, this.myConfig);
                    }
                }
            });
        };
        if (runnable2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "prepareForChangeDeletion"));
        }
        return runnable2;
    }

    public void setDefaultChangeList(@NotNull LocalChangeList list) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "setDefaultChangeList"));
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            if (list == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "lambda$setDefaultChangeList$15"));
            }
            Object object = this.myDataLock;
            synchronized (object) {
                this.myModifier.setDefault(list.getName());
            }
        });
        this.myChangesViewManager.scheduleRefresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public LocalChangeList getDefaultChangeList() {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getDefaultListCopy();
        }
    }

    public boolean isDefaultChangeList(ChangeList list) {
        return list instanceof LocalChangeList && this.myWorker.isDefaultList((LocalChangeList)list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public Collection<LocalChangeList> getInvolvedListsFilterChanges(Collection<Change> changes, List<Change> validChanges) {
        Object object = this.myDataLock;
        // MONITORENTER : object
        Collection<LocalChangeList> collection = this.myWorker.getInvolvedListsFilterChanges(changes, validChanges);
        // MONITOREXIT : object
        if (collection != null) return collection;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getInvolvedListsFilterChanges"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public LocalChangeList getChangeList(@NotNull Change change) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getChangeList"));
        }
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.listForChange(change);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getChangeListNameIfOnlyOne(Change[] changes) {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.listNameIfOnlyOne(changes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public LocalChangeList getIdentityChangeList(Change change) {
        Object object = this.myDataLock;
        synchronized (object) {
            List<LocalChangeList> lists = this.myWorker.getListsCopy();
            for (LocalChangeList list : lists) {
                for (Change oldChange : list.getChanges()) {
                    if (oldChange != change) continue;
                    return list;
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isInUpdate() {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myModifier.isInsideUpdate() || this.myShowLocalChangesInvalidated;
        }
    }

    @Nullable
    public Change getChange(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getChange"));
        }
        return this.getChange(VcsUtil.getFilePath((VirtualFile)file2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalChangeList getChangeList(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getChangeList"));
        }
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getListCopy(file2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Change getChange(FilePath file2) {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getChangeForPath(file2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUnversioned(VirtualFile file2) {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myComposite.getVFHolder(FileHolder.HolderType.UNVERSIONED).containsFile(file2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public FileStatus getStatus(VirtualFile file2) {
        Object object = this.myDataLock;
        // MONITORENTER : object
        if (this.myComposite.getVFHolder(FileHolder.HolderType.UNVERSIONED).containsFile(file2)) {
            FileStatus fileStatus = FileStatus.UNKNOWN;
            // MONITOREXIT : object
            if (fileStatus != null) return fileStatus;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getStatus"));
        }
        if (this.myComposite.getVFHolder(FileHolder.HolderType.MODIFIED_WITHOUT_EDITING).containsFile(file2)) {
            FileStatus fileStatus = FileStatus.HIJACKED;
            // MONITOREXIT : object
            if (fileStatus != null) return fileStatus;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getStatus"));
        }
        if (this.myComposite.getIgnoredFileHolder().containsFile(file2)) {
            FileStatus fileStatus = FileStatus.IGNORED;
            // MONITOREXIT : object
            if (fileStatus != null) return fileStatus;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getStatus"));
        }
        boolean switched = this.myWorker.isSwitched(file2);
        FileStatus status = this.myWorker.getStatus(file2);
        if (status != null) {
            FileStatus fileStatus = FileStatus.NOT_CHANGED.equals(status) && switched ? FileStatus.SWITCHED : status;
            // MONITOREXIT : object
            if (fileStatus != null) return fileStatus;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getStatus"));
        }
        if (switched) {
            FileStatus fileStatus = FileStatus.SWITCHED;
            // MONITOREXIT : object
            if (fileStatus != null) return fileStatus;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getStatus"));
        }
        FileStatus fileStatus = FileStatus.NOT_CHANGED;
        // MONITOREXIT : object
        if (fileStatus != null) return fileStatus;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getStatus"));
    }

    @NotNull
    public Collection<Change> getChangesIn(VirtualFile dir) {
        Collection<Change> collection = this.getChangesIn(VcsUtil.getFilePath((VirtualFile)dir));
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getChangesIn"));
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public ThreeState haveChangesUnder(@NotNull VirtualFile vf) {
        if (vf == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vf", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "haveChangesUnder"));
        }
        if (vf.isValid() && vf.isDirectory()) {
            Object object = this.myDataLock;
            // MONITORENTER : object
            ThreeState threeState = this.myWorker.haveChangesUnder(vf);
            // MONITOREXIT : object
            if (threeState != null) return threeState;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "haveChangesUnder"));
        }
        ThreeState threeState = ThreeState.NO;
        if (threeState != null) return threeState;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "haveChangesUnder"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Collection<Change> getChangesIn(FilePath dirPath) {
        Object object = this.myDataLock;
        // MONITORENTER : object
        Collection<Change> collection = this.myWorker.getChangesIn(dirPath);
        // MONITOREXIT : object
        if (collection != null) return collection;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getChangesIn"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public AbstractVcs getVcsFor(@NotNull Change change) {
        VcsKey key2;
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getVcsFor"));
        }
        Object object = this.myDataLock;
        synchronized (object) {
            key2 = this.myWorker.getVcsFor(change);
        }
        return key2 != null ? ProjectLevelVcsManager.getInstance((Project)this.myProject).findVcsByName(key2.getName()) : null;
    }

    @Override
    public void moveChangesTo(LocalChangeList list, Change ... changes) {
        ApplicationManager.getApplication().runReadAction(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                this.myModifier.moveChangesTo(list.getName(), changes);
            }
        });
        this.myChangesViewManager.scheduleRefresh();
    }

    @Override
    public void addUnversionedFiles(LocalChangeList list, @NotNull List<VirtualFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "addUnversionedFiles"));
        }
        this.addUnversionedFiles(list, files, ChangeListManagerImpl.getDefaultUnversionedFileCondition(), null);
    }

    @Deprecated
    @NotNull
    public List<VcsException> addUnversionedFiles(LocalChangeList list, @NotNull List<VirtualFile> files, @NotNull Condition<FileStatus> statusChecker, @Nullable Consumer<List<Change>> changesConsumer) {
        boolean syncUpdateRequired;
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "addUnversionedFiles"));
        }
        if (statusChecker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statusChecker", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "addUnversionedFiles"));
        }
        ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
        HashSet allProcessedFiles = new HashSet();
        ChangesUtil.processVirtualFilesByVcs((Project)this.myProject, files, (vcs, items) -> {
            if (statusChecker == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statusChecker", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "lambda$addUnversionedFiles$17"));
            }
            final CheckinEnvironment environment = vcs.getCheckinEnvironment();
            if (environment != null) {
                final Set<VirtualFile> descendants = this.getUnversionedDescendantsRecursively(items, statusChecker);
                Set parents = vcs.areDirectoriesVersionedItems() ? this.getUnversionedParents(items, statusChecker) : Collections.emptySet();
                final ArrayList result2 = ContainerUtil.newArrayList();
                ProgressManager.getInstance().run((Task)new Task.Modal(this.myProject, "Adding files to VCS...", true){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl$5", "run"));
                        }
                        indicator.setIndeterminate(true);
                        List exs = environment.scheduleUnversionedFilesForAddition((List)ContainerUtil.newArrayList((Iterable)descendants));
                        if (exs != null) {
                            ContainerUtil.addAll((Collection)result2, (Iterable)exs);
                        }
                    }
                });
                allProcessedFiles.addAll(descendants);
                allProcessedFiles.addAll(parents);
                exceptions.addAll(result2);
            }
        });
        if (!exceptions.isEmpty()) {
            StringBuilder message = new StringBuilder(VcsBundle.message((String)"error.adding.files.prompt", (Object[])new Object[0]));
            for (VcsException ex : exceptions) {
                message.append("\n").append(ex.getMessage());
            }
            Messages.showErrorDialog((Project)this.myProject, (String)message.toString(), (String)VcsBundle.message((String)"error.adding.files.title", (Object[])new Object[0]));
        }
        for (VirtualFile file2 : allProcessedFiles) {
            this.myFileStatusManager.fileStatusChanged(file2);
        }
        VcsDirtyScopeManager.getInstance((Project)this.myProject).filesDirty(allProcessedFiles, null);
        Ref foundChanges = Ref.create();
        boolean moveRequired = !list.isDefault();
        boolean bl = syncUpdateRequired = changesConsumer != null;
        if (moveRequired || syncUpdateRequired) {
            InvokeAfterUpdateMode updateMode = syncUpdateRequired ? InvokeAfterUpdateMode.SYNCHRONOUS_CANCELLABLE : InvokeAfterUpdateMode.BACKGROUND_NOT_CANCELLABLE;
            this.invokeAfterUpdate(() -> {
                ApplicationManager.getApplication().runReadAction(() -> {
                    Object object = this.myDataLock;
                    synchronized (object) {
                        List<Change> newChanges = this.findChanges(allProcessedFiles);
                        foundChanges.set(newChanges);
                        if (moveRequired && !newChanges.isEmpty()) {
                            this.moveChangesTo(list, newChanges.toArray(new Change[newChanges.size()]));
                        }
                    }
                });
                this.myChangesViewManager.scheduleRefresh();
            }, updateMode, VcsBundle.message((String)"change.lists.manager.add.unversioned", (Object[])new Object[0]), null);
            if (changesConsumer != null) {
                changesConsumer.consume(foundChanges.get());
            }
        } else {
            this.myChangesViewManager.scheduleRefresh();
        }
        ArrayList<VcsException> arrayList = exceptions;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "addUnversionedFiles"));
        }
        return arrayList;
    }

    @NotNull
    private List<Change> findChanges(@NotNull Collection<VirtualFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "findChanges"));
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        for (Change change : this.getDefaultChangeList().getChanges()) {
            VirtualFile file2;
            ContentRevision afterRevision = change.getAfterRevision();
            if (afterRevision == null || !files.contains(file2 = afterRevision.getFile().getVirtualFile())) continue;
            result2.add(change);
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "findChanges"));
        }
        return arrayList;
    }

    @NotNull
    public static Condition<FileStatus> getDefaultUnversionedFileCondition() {
        Condition condition = status -> status == FileStatus.UNKNOWN;
        if (condition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getDefaultUnversionedFileCondition"));
        }
        return condition;
    }

    @NotNull
    private Set<VirtualFile> getUnversionedDescendantsRecursively(@NotNull List<VirtualFile> items, @NotNull Condition<FileStatus> condition) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getUnversionedDescendantsRecursively"));
        }
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getUnversionedDescendantsRecursively"));
        }
        HashSet result2 = ContainerUtil.newHashSet();
        Processor addToResultProcessor = file2 -> {
            if (condition == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "lambda$getUnversionedDescendantsRecursively$21"));
            }
            if (condition.value((Object)this.getStatus((VirtualFile)file2))) {
                result2.add(file2);
            }
            return true;
        };
        for (VirtualFile item : items) {
            VcsRootIterator.iterateVfUnderVcsRoot(this.myProject, item, (Processor<VirtualFile>)addToResultProcessor);
        }
        HashSet hashSet = result2;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getUnversionedDescendantsRecursively"));
        }
        return hashSet;
    }

    @NotNull
    private Set<VirtualFile> getUnversionedParents(@NotNull Collection<VirtualFile> items, @NotNull Condition<FileStatus> condition) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getUnversionedParents"));
        }
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getUnversionedParents"));
        }
        HashSet result2 = ContainerUtil.newHashSet();
        for (VirtualFile item : items) {
            for (VirtualFile parent = item.getParent(); parent != null && condition.value((Object)this.getStatus(parent)); parent = parent.getParent()) {
                result2.add(parent);
            }
        }
        HashSet hashSet = result2;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "getUnversionedParents"));
        }
        return hashSet;
    }

    @Override
    public Project getProject() {
        return this.myProject;
    }

    public void addChangeListListener(ChangeListListener listener2) {
        this.myListeners.addListener((EventListener)listener2);
    }

    public void removeChangeListListener(ChangeListListener listener2) {
        this.myListeners.removeListener((EventListener)listener2);
    }

    public void registerCommitExecutor(CommitExecutor executor) {
        this.myExecutors.add(executor);
    }

    public void commitChanges(LocalChangeList changeList, List<Change> changes) {
        this.doCommit(changeList, changes, false);
    }

    private boolean doCommit(LocalChangeList changeList, List<Change> changes, boolean synchronously) {
        FileDocumentManager.getInstance().saveAllDocuments();
        return new CommitHelper(this.myProject, (ChangeList)changeList, changes, changeList.getName(), StringUtil.isEmpty((String)changeList.getComment()) ? changeList.getName() : changeList.getComment(), new ArrayList<CheckinHandler>(), false, synchronously, (NullableFunction<Object, Object>)FunctionUtil.nullConstant(), null).doCommit();
    }

    public void commitChangesSynchronously(LocalChangeList changeList, List<Change> changes) {
        this.doCommit(changeList, changes, true);
    }

    public boolean commitChangesSynchronouslyWithResult(LocalChangeList changeList, List<Change> changes) {
        return this.doCommit(changeList, changes, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(Element element) {
        if (this.myProject.isDefault()) {
            return;
        }
        Object object = this.myDataLock;
        synchronized (object) {
            this.myIgnoredIdeaLevel.clear();
            new ChangeListManagerSerialization(this.myIgnoredIdeaLevel, this.myWorker).readExternal(element);
            if (!this.myWorker.isEmpty() && this.getDefaultChangeList() == null) {
                this.setDefaultChangeList(this.myWorker.getListsCopy().get(0));
            }
        }
        this.myExcludedConvertedToIgnored = Boolean.parseBoolean(JDOMExternalizerUtil.readField((Element)element, (String)EXCLUDED_CONVERTED_TO_IGNORED_OPTION));
        this.myConflictTracker.loadState(element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Element getState() {
        ChangeListWorker worker;
        IgnoredFilesComponent ignoredFilesComponent;
        Element element = new Element("state");
        if (this.myProject.isDefault()) {
            return element;
        }
        Object object = this.myDataLock;
        synchronized (object) {
            ignoredFilesComponent = new IgnoredFilesComponent(this.myIgnoredIdeaLevel);
            worker = this.myWorker.copy();
        }
        ChangeListManagerSerialization.writeExternal(element, ignoredFilesComponent, worker);
        if (this.myExcludedConvertedToIgnored) {
            JDOMExternalizerUtil.writeField((Element)element, (String)EXCLUDED_CONVERTED_TO_IGNORED_OPTION, (String)String.valueOf(true));
        }
        this.myConflictTracker.saveState(element);
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reopenFiles(List<FilePath> paths) {
        ReadonlyStatusHandlerImpl readonlyStatusHandler = (ReadonlyStatusHandlerImpl)ReadonlyStatusHandler.getInstance((Project)this.myProject);
        boolean savedOption = readonlyStatusHandler.getState().SHOW_DIALOG;
        readonlyStatusHandler.getState().SHOW_DIALOG = false;
        try {
            readonlyStatusHandler.ensureFilesWritable(ChangeListManagerImpl.collectFiles(paths));
        }
        finally {
            readonlyStatusHandler.getState().SHOW_DIALOG = savedOption;
        }
    }

    public List<CommitExecutor> getRegisteredExecutors() {
        return Collections.unmodifiableList(this.myExecutors);
    }

    public void addFilesToIgnore(IgnoredFileBean ... filesToIgnore) {
        this.myIgnoredIdeaLevel.add(filesToIgnore);
        this.scheduleUnversionedUpdate();
    }

    public void addDirectoryToIgnoreImplicitly(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "addDirectoryToIgnoreImplicitly"));
        }
        this.myIgnoredIdeaLevel.addIgnoredDirectoryImplicitly(path, this.myProject);
    }

    public void removeImplicitlyIgnoredDirectory(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "removeImplicitlyIgnoredDirectory"));
        }
        this.myIgnoredIdeaLevel.removeImplicitlyIgnoredDirectory(path, this.myProject);
    }

    public IgnoredFilesComponent getIgnoredFilesComponent() {
        return this.myIgnoredIdeaLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleUnversionedUpdate() {
        MyDirtyFilesScheduler scheduler = new MyDirtyFilesScheduler(this.myProject);
        Object object = this.myDataLock;
        synchronized (object) {
            VirtualFileHolder unversionedHolder = this.myComposite.getVFHolder(FileHolder.HolderType.UNVERSIONED);
            IgnoredFilesHolder ignoredHolder = (IgnoredFilesHolder)this.myComposite.get(FileHolder.HolderType.IGNORED);
            scheduler.accept(unversionedHolder.getFiles());
            scheduler.accept(ignoredHolder.values());
        }
        scheduler.arise();
    }

    public void setFilesToIgnore(IgnoredFileBean ... filesToIgnore) {
        this.myIgnoredIdeaLevel.set(filesToIgnore);
        this.scheduleUnversionedUpdate();
    }

    private void updateIgnoredFiles(FileHolderComposite composite) {
        VirtualFileHolder vfHolder = composite.getVFHolder(FileHolder.HolderType.UNVERSIONED);
        List<VirtualFile> unversionedFiles = vfHolder.getFiles();
        this.exchangeWithIgnored(composite, vfHolder, unversionedFiles);
        VirtualFileHolder vfModifiedHolder = composite.getVFHolder(FileHolder.HolderType.MODIFIED_WITHOUT_EDITING);
        List<VirtualFile> modifiedFiles = vfModifiedHolder.getFiles();
        this.exchangeWithIgnored(composite, vfModifiedHolder, modifiedFiles);
    }

    private void exchangeWithIgnored(FileHolderComposite composite, VirtualFileHolder vfHolder, List<VirtualFile> unversionedFiles) {
        for (VirtualFile file2 : unversionedFiles) {
            if (!this.isIgnoredFile(file2)) continue;
            vfHolder.removeFile(file2);
            composite.getIgnoredFileHolder().addFile(file2);
        }
    }

    public IgnoredFileBean[] getFilesToIgnore() {
        return this.myIgnoredIdeaLevel.getFilesToIgnore();
    }

    public boolean isIgnoredFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "isIgnoredFile"));
        }
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)file2);
        return ContainerUtil.exists((Object[])IgnoredFileProvider.IGNORE_FILE.getExtensions(), it -> it.isIgnoredFile(this.myProject, filePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getSwitchedBranch(VirtualFile file2) {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getBranchForFile(file2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDefaultListName() {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getDefaultListName();
        }
    }

    private static VirtualFile[] collectFiles(List<FilePath> paths) {
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
        for (FilePath path : paths) {
            if (path.getVirtualFile() == null) continue;
            result2.add(path.getVirtualFile());
        }
        return VfsUtilCore.toVirtualFileArray(result2);
    }

    public boolean setReadOnly(String name, boolean value) {
        return (Boolean)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                boolean result2 = this.myModifier.setReadOnly(name, value);
                this.myChangesViewManager.scheduleRefresh();
                return result2;
            }
        });
    }

    public boolean editName(@NotNull String fromName, @NotNull String toName) {
        if (fromName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromName", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "editName"));
        }
        if (toName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toName", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "editName"));
        }
        return (Boolean)ReadAction.compute(() -> {
            if (fromName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromName", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "lambda$editName$24"));
            }
            if (toName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toName", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "lambda$editName$24"));
            }
            Object object = this.myDataLock;
            synchronized (object) {
                boolean result2 = this.myModifier.editName(fromName, toName);
                this.myChangesViewManager.scheduleRefresh();
                return result2;
            }
        });
    }

    public String editComment(@NotNull String fromName, String newComment) {
        if (fromName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromName", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "editComment"));
        }
        return (String)ReadAction.compute(() -> {
            if (fromName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromName", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl", "lambda$editComment$25"));
            }
            Object object = this.myDataLock;
            synchronized (object) {
                String oldComment = this.myModifier.editComment(fromName, newComment);
                this.myChangesViewManager.scheduleRefresh();
                return oldComment;
            }
        });
    }

    public void waitUntilRefreshed() {
        VcsDirtyScopeVfsListener.getInstance(this.myProject).flushDirt();
        this.myUpdater.waitUntilRefreshed();
        this.waitUpdateAlarm();
    }

    private void waitUpdateAlarm() {
        Semaphore semaphore = new Semaphore();
        semaphore.down();
        this.myScheduledExecutorService.execute(() -> semaphore.up());
        semaphore.waitFor();
    }

    public void stopEveryThingIfInTestMode() {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        Future future2 = ourUpdateAlarm.get();
        if (future2 != null) {
            future2.cancel(true);
        }
    }

    public void waitEverythingDoneInTestMode() {
        Future future2;
        assert (ApplicationManager.getApplication().isUnitTestMode());
        while ((future2 = ourUpdateAlarm.get()) != null) {
            if (ApplicationManager.getApplication().isDispatchThread()) {
                UIUtil.dispatchAllInvocationEvents();
            }
            try {
                future2.get(10L, TimeUnit.MILLISECONDS);
                break;
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.error((Throwable)e);
            }
            catch (TimeoutException timeoutException) {
            }
        }
    }

    public void forceGoInTestMode() {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        this.myUpdater.forceGo();
    }

    public void executeOnUpdaterThread(Runnable r) {
        ourUpdateAlarm.set(this.myScheduledExecutorService.submit(r));
    }

    public boolean ensureUpToDate(boolean canBeCanceled) {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            this.updateImmediately();
            return true;
        }
        VcsDirtyScopeVfsListener.getInstance(this.myProject).flushDirt();
        this.myUpdater.waitUntilRefreshed();
        this.waitUpdateAlarm();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getChangeListsNumber() {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getChangeListsNumber();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showLocalChangesInvalidated() {
        Object object = this.myDataLock;
        synchronized (object) {
            this.myShowLocalChangesInvalidated = true;
        }
    }

    public ChangelistConflictTracker getConflictTracker() {
        return this.myConflictTracker;
    }

    public boolean isFreezedWithNotification(String modalTitle) {
        String freezeReason = this.isFreezed();
        if (freezeReason != null) {
            if (modalTitle != null) {
                Messages.showErrorDialog((Project)this.myProject, (String)freezeReason, (String)modalTitle);
            } else {
                VcsBalloonProblemNotifier.showOverChangesView(this.myProject, freezeReason, MessageType.WARNING, new NamedRunnable[0]);
            }
        }
        return freezeReason != null;
    }

    private static class MyChangesDeltaForwarder
    implements PlusMinusModify<BaseRevision> {
        private final RemoteRevisionsCache myRevisionsCache;
        private final ProjectLevelVcsManager myVcsManager;
        private final Project myProject;
        private final AtomicReference<Future> myFuture;
        private final ExecutorService myService;

        public MyChangesDeltaForwarder(Project project2, AtomicReference<Future> future2, @NotNull ExecutorService service) {
            if (service == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "service", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl$MyChangesDeltaForwarder", "<init>"));
            }
            this.myProject = project2;
            this.myFuture = future2;
            this.myService = service;
            this.myRevisionsCache = RemoteRevisionsCache.getInstance(project2);
            this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)project2);
        }

        @Override
        public void modify(BaseRevision was, BaseRevision become) {
            this.myFuture.set(this.myService.submit(() -> {
                AbstractVcs vcs = this.getVcs(was);
                if (vcs != null) {
                    this.myRevisionsCache.plus((Pair<String, AbstractVcs>)Pair.create((Object)was.getPath().getPath(), (Object)vcs));
                }
                ((VcsAnnotationRefresher)this.myProject.getMessageBus().syncPublisher(VcsAnnotationRefresher.LOCAL_CHANGES_CHANGED)).dirty(become);
            }));
        }

        @Override
        public void plus(BaseRevision baseRevision) {
            this.myFuture.set(this.myService.submit(() -> {
                AbstractVcs vcs = this.getVcs(baseRevision);
                if (vcs != null) {
                    this.myRevisionsCache.plus((Pair<String, AbstractVcs>)Pair.create((Object)baseRevision.getPath().getPath(), (Object)vcs));
                }
                ((VcsAnnotationRefresher)this.myProject.getMessageBus().syncPublisher(VcsAnnotationRefresher.LOCAL_CHANGES_CHANGED)).dirty(baseRevision);
            }));
        }

        @Override
        public void minus(BaseRevision baseRevision) {
            this.myFuture.set(this.myService.submit(() -> {
                AbstractVcs vcs = this.getVcs(baseRevision);
                if (vcs != null) {
                    this.myRevisionsCache.minus((Pair<String, AbstractVcs>)Pair.create((Object)baseRevision.getPath().getPath(), (Object)vcs));
                }
                ((VcsAnnotationRefresher)this.myProject.getMessageBus().syncPublisher(VcsAnnotationRefresher.LOCAL_CHANGES_CHANGED)).dirty(baseRevision.getPath().getPath());
            }));
        }

        @Nullable
        private AbstractVcs getVcs(BaseRevision baseRevision) {
            FilePath path;
            VcsKey vcsKey = baseRevision.getVcs();
            if (vcsKey == null && (vcsKey = this.findVcs(path = baseRevision.getPath())) == null) {
                return null;
            }
            return this.myVcsManager.findVcsByName(vcsKey.getName());
        }

        @Nullable
        private VcsKey findVcs(FilePath path) {
            VirtualFile vf = path.getVirtualFile();
            if (vf == null) {
                vf = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(path.getIOFile());
            }
            if (vf == null) {
                return null;
            }
            AbstractVcs vcs = this.myVcsManager.getVcsFor(vf);
            return vcs == null ? null : vcs.getKeyInstanceMethod();
        }
    }

    private static class DefaultIgnoredFileProvider
    implements IgnoredFileProvider {
        private DefaultIgnoredFileProvider() {
        }

        public boolean isIgnoredFile(@NotNull Project project2, @NotNull FilePath filePath) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl$DefaultIgnoredFileProvider", "isIgnoredFile"));
            }
            if (filePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl$DefaultIgnoredFileProvider", "isIgnoredFile"));
            }
            return ((ChangeListManagerImpl)ChangeListManager.getInstance((Project)project2)).myIgnoredIdeaLevel.isIgnoredFile(filePath);
        }
    }

    private static class MyDirtyFilesScheduler {
        private static final int ourPiecesLimit = 100;
        private final List<VirtualFile> myFiles = new ArrayList<VirtualFile>();
        private final List<VirtualFile> myDirs = new ArrayList<VirtualFile>();
        private boolean myEveryThing;
        private int myCnt;
        private final Project myProject;

        private MyDirtyFilesScheduler(Project project2) {
            this.myProject = project2;
            this.myCnt = 0;
            this.myEveryThing = false;
        }

        public void accept(Collection<VirtualFile> coll) {
            for (VirtualFile vf : coll) {
                if (this.myCnt > 100) {
                    this.myEveryThing = true;
                    break;
                }
                if (vf.isDirectory()) {
                    this.myDirs.add(vf);
                } else {
                    this.myFiles.add(vf);
                }
                ++this.myCnt;
            }
        }

        public void arise() {
            VcsDirtyScopeManager vcsDirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)this.myProject);
            if (this.myEveryThing) {
                vcsDirtyScopeManager.markEverythingDirty();
            } else {
                vcsDirtyScopeManager.filesDirty(this.myFiles, this.myDirs);
            }
        }
    }

    private class DataHolder {
        private final boolean myWasEverythingDirty;
        private final FileHolderComposite myComposite;
        private final ChangeListWorker myChangeListWorker;

        private DataHolder(FileHolderComposite composite, ChangeListWorker changeListWorker, boolean wasEverythingDirty) {
            this.myComposite = composite;
            this.myChangeListWorker = changeListWorker;
            this.myWasEverythingDirty = wasEverythingDirty;
        }

        private void notifyStart() {
            if (this.myWasEverythingDirty) {
                this.myComposite.cleanAll();
                this.myChangeListWorker.notifyStartProcessingChanges(null);
            }
        }

        private void notifyStartProcessingChanges(@NotNull VcsModifiableDirtyScope scope) {
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl$DataHolder", "notifyStartProcessingChanges"));
            }
            if (!this.myWasEverythingDirty) {
                this.myComposite.cleanAndAdjustScope(scope);
                this.myChangeListWorker.notifyStartProcessingChanges(scope);
            }
            this.myComposite.notifyVcsStarted(scope.getVcs());
            this.myChangeListWorker.notifyVcsStarted(scope.getVcs());
        }

        private void notifyDoneProcessingChanges() {
            if (!this.myWasEverythingDirty) {
                this.myChangeListWorker.notifyDoneProcessingChanges(ChangeListManagerImpl.this.myDelayedNotificator.getProxyDispatcher());
            }
        }

        void notifyEnd() {
            if (this.myWasEverythingDirty) {
                this.myChangeListWorker.notifyDoneProcessingChanges(ChangeListManagerImpl.this.myDelayedNotificator.getProxyDispatcher());
            }
        }

        public FileHolderComposite getComposite() {
            return this.myComposite;
        }

        ChangeListWorker getChangeListWorker() {
            return this.myChangeListWorker;
        }
    }

    private class ActualUpdater
    implements Runnable {
        private ActualUpdater() {
        }

        @Override
        public void run() {
            ChangeListManagerImpl.this.updateImmediately();
        }
    }

    static class DisposedException
    extends RuntimeException {
        DisposedException() {
        }
    }
}

