/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.diff.util.DiffUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.actions.ContextHelpAction;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.lifecycle.PeriodicalTasksCloser;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.CacheChangeProcessor;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListAdapter;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangesViewI;
import com.intellij.openapi.vcs.changes.DnDTargetContentAdapter;
import com.intellij.openapi.vcs.changes.RemoteRevisionsCache;
import com.intellij.openapi.vcs.changes.actions.IgnoredSettingsAction;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.ui.ChangesDnDSupport;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vcs.changes.ui.ShelvedChangeListDragBean;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.content.Content;
import com.intellij.util.Alarm;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="ChangesViewManager", storages={@Storage(file="$WORKSPACE_FILE$")})
public class ChangesViewManager
implements ChangesViewI,
ProjectComponent,
PersistentStateComponent<State> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.ChangesViewManager");
    @NotNull
    private final ChangesListView myView;
    private JPanel myProgressLabel;
    private final Alarm myRepaintAlarm;
    private boolean myDisposed;
    @NotNull
    private final ChangeListListener myListener;
    @NotNull
    private final Project myProject;
    @NotNull
    private final ChangesViewContentManager myContentManager;
    @NotNull
    private State myState;
    private JBSplitter mySplitter;
    private boolean myDetailsOn;
    @NotNull
    private final NotNullLazyValue<MyChangeProcessor> myDiffDetails;
    @NotNull
    private final TreeSelectionListener myTsl;
    private Content myContent;

    @NotNull
    public static ChangesViewI getInstance(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ChangesViewManager", "getInstance"));
        }
        ChangesViewI changesViewI = (ChangesViewI)PeriodicalTasksCloser.getInstance().safeGetComponent(project2, ChangesViewI.class);
        if (changesViewI == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangesViewManager", "getInstance"));
        }
        return changesViewI;
    }

    public ChangesViewManager(@NotNull Project project2, @NotNull ChangesViewContentManager contentManager) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ChangesViewManager", "<init>"));
        }
        if (contentManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentManager", "com/intellij/openapi/vcs/changes/ChangesViewManager", "<init>"));
        }
        this.myDisposed = false;
        this.myListener = new MyChangeListListener();
        this.myState = new State();
        this.myDiffDetails = new NotNullLazyValue<MyChangeProcessor>(){

            @NotNull
            protected MyChangeProcessor compute() {
                MyChangeProcessor myChangeProcessor = new MyChangeProcessor(ChangesViewManager.this.myProject);
                if (myChangeProcessor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangesViewManager$1", "compute"));
                }
                return myChangeProcessor;
            }
        };
        this.myProject = project2;
        this.myContentManager = contentManager;
        this.myView = new ChangesListView(project2);
        this.myRepaintAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)project2);
        this.myTsl = new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (LOG.isDebugEnabled()) {
                    Object[] paths = ChangesViewManager.this.myView.getSelectionPaths();
                    String joinedPaths = paths != null ? StringUtil.join((Object[])paths, (Function)FunctionUtil.string(), (String)", ") : null;
                    String message = "selection changed. selected:  " + joinedPaths;
                    if (LOG.isTraceEnabled()) {
                        LOG.trace(message + " from: " + DebugUtil.currentStackTrace());
                    } else {
                        LOG.debug(message);
                    }
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ChangesViewManager.this.changeDetails();
                    }
                });
            }
        };
    }

    public void projectOpened() {
        final ChangeListManager changeListManager = ChangeListManager.getInstance((Project)this.myProject);
        changeListManager.addChangeListListener(this.myListener);
        Disposer.register((Disposable)this.myProject, (Disposable)new Disposable(){

            public void dispose() {
                changeListManager.removeChangeListListener(ChangesViewManager.this.myListener);
            }
        });
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return;
        }
        this.myContent = new MyChangeViewContent(this.createChangeViewComponent(), "Local Changes", false);
        this.myContent.setCloseable(false);
        this.myContentManager.addContent(this.myContent);
        this.scheduleRefresh();
        this.myProject.getMessageBus().connect().subscribe(RemoteRevisionsCache.REMOTE_VERSION_CHANGED, (Object)new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ChangesViewManager.this.refreshView();
                    }
                }, ModalityState.NON_MODAL, ChangesViewManager.this.myProject.getDisposed());
            }
        });
        this.myDetailsOn = VcsConfiguration.getInstance((Project)this.myProject).LOCAL_CHANGES_DETAILS_PREVIEW_SHOWN;
        this.changeDetails();
    }

    public void projectClosed() {
        this.myView.removeTreeSelectionListener(this.myTsl);
        this.myDisposed = true;
        this.myRepaintAlarm.cancelAllRequests();
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("ChangesViewManager" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangesViewManager", "getComponentName"));
        }
        return "ChangesViewManager";
    }

    private JComponent createChangeViewComponent() {
        SimpleToolWindowPanel panel2 = new SimpleToolWindowPanel(false, true);
        EmptyAction.registerWithShortcutSet((String)"ChangesView.Refresh", (ShortcutSet)CommonShortcuts.getRerun(), (JComponent)panel2);
        EmptyAction.registerWithShortcutSet((String)"ChangesView.NewChangeList", (ShortcutSet)CommonShortcuts.getNew(), (JComponent)panel2);
        EmptyAction.registerWithShortcutSet((String)"ChangesView.RemoveChangeList", (ShortcutSet)CommonShortcuts.getDelete(), (JComponent)panel2);
        EmptyAction.registerWithShortcutSet((String)"ChangesView.Move", (ShortcutSet)CommonShortcuts.getMove(), (JComponent)panel2);
        EmptyAction.registerWithShortcutSet((String)"ChangesView.Rename", (ShortcutSet)CommonShortcuts.getRename(), (JComponent)panel2);
        EmptyAction.registerWithShortcutSet((String)"ChangesView.SetDefault", (ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(85, 0x200 | ChangesViewManager.ctrlMask())), (JComponent)panel2);
        EmptyAction.registerWithShortcutSet((String)"ChangesView.Diff", (ShortcutSet)CommonShortcuts.getDiff(), (JComponent)panel2);
        DefaultActionGroup group = (DefaultActionGroup)ActionManager.getInstance().getAction("ChangesViewToolbar");
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("ChangesViewToolbar", (ActionGroup)group, false);
        toolbar.setTargetComponent((JComponent)((Object)this.myView));
        JComponent toolbarComponent = toolbar.getComponent();
        JPanel toolbarPanel = new JPanel(new BorderLayout());
        toolbarPanel.add((Component)toolbarComponent, "West");
        DefaultActionGroup visualActionsGroup = new DefaultActionGroup();
        Expander expander = new Expander();
        visualActionsGroup.add(CommonActionsManager.getInstance().createExpandAllAction((TreeExpander)expander, (JComponent)panel2));
        visualActionsGroup.add(CommonActionsManager.getInstance().createCollapseAllAction((TreeExpander)expander, (JComponent)panel2));
        ToggleShowFlattenAction showFlattenAction = new ToggleShowFlattenAction();
        showFlattenAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(80, ChangesViewManager.ctrlMask())), (JComponent)panel2);
        visualActionsGroup.add((AnAction)showFlattenAction);
        visualActionsGroup.add(ActionManager.getInstance().getAction("$Copy"));
        visualActionsGroup.add((AnAction)new ToggleShowIgnoredAction());
        visualActionsGroup.add((AnAction)new IgnoredSettingsAction());
        visualActionsGroup.add((AnAction)new ToggleDetailsAction());
        visualActionsGroup.add((AnAction)new ContextHelpAction("ideaInterface.changes"));
        toolbarPanel.add((Component)ActionManager.getInstance().createActionToolbar("ChangesViewToolbar", (ActionGroup)visualActionsGroup, false).getComponent(), "Center");
        this.myView.setMenuActions((ActionGroup)((DefaultActionGroup)ActionManager.getInstance().getAction("ChangesViewPopupMenu")));
        this.myView.setShowFlatten(this.myState.myShowFlatten);
        this.myProgressLabel = new JPanel(new BorderLayout());
        panel2.setToolbar((JComponent)toolbarPanel);
        JPanel content = new JPanel(new BorderLayout());
        this.mySplitter = new JBSplitter(false, "ChangesViewManager.DETAILS_SPLITTER_PROPORTION", 0.5f);
        this.mySplitter.setHonorComponentsMinimumSize(false);
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)((Object)this.myView));
        JPanel wrapper = new JPanel(new BorderLayout());
        wrapper.add((Component)scrollPane, "Center");
        this.mySplitter.setFirstComponent((JComponent)wrapper);
        content.add((Component)this.mySplitter, "Center");
        content.add((Component)this.myProgressLabel, "South");
        panel2.setContent((JComponent)content);
        ChangesDnDSupport.install(this.myProject, this.myView);
        this.myView.addTreeSelectionListener(this.myTsl);
        return panel2;
    }

    private void changeDetails() {
        if (!this.myDetailsOn) {
            if (this.myDiffDetails.isComputed()) {
                ((MyChangeProcessor)this.myDiffDetails.getValue()).clear();
                if (this.mySplitter.getSecondComponent() != null) {
                    this.setChangeDetailsPanel(null);
                }
            }
        } else {
            ((MyChangeProcessor)this.myDiffDetails.getValue()).refresh();
            if (this.mySplitter.getSecondComponent() == null) {
                this.setChangeDetailsPanel(((MyChangeProcessor)this.myDiffDetails.getValue()).getComponent());
            }
        }
    }

    private void setChangeDetailsPanel(@Nullable JComponent component) {
        this.mySplitter.setSecondComponent(component);
        this.mySplitter.getFirstComponent().setBorder(component == null ? null : IdeBorderFactory.createBorder((int)4));
        this.mySplitter.revalidate();
        this.mySplitter.repaint();
    }

    @JdkConstants.InputEventMask
    private static int ctrlMask() {
        return SystemInfo.isMac ? 256 : 128;
    }

    private void updateProgressComponent(final @NotNull Factory<JComponent> progress) {
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/openapi/vcs/changes/ChangesViewManager", "updateProgressComponent"));
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ChangesViewManager.this.myProgressLabel != null) {
                    ChangesViewManager.this.myProgressLabel.removeAll();
                    ChangesViewManager.this.myProgressLabel.add((Component)progress.create());
                    ChangesViewManager.this.myProgressLabel.setMinimumSize((Dimension)JBUI.emptySize());
                }
            }
        });
    }

    @Override
    public void updateProgressText(String text, boolean isError) {
        this.updateProgressComponent(ChangesViewManager.createTextStatusFactory(text, isError));
    }

    @Override
    public void setBusy(final boolean b) {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                ChangesViewManager.this.myView.setPaintBusy(b);
            }
        });
    }

    @NotNull
    public static Factory<JComponent> createTextStatusFactory(final String text, final boolean isError) {
        Factory<JComponent> factory = new Factory<JComponent>(){

            public JComponent create() {
                JLabel label = new JLabel(text);
                label.setForeground((Color)(isError ? JBColor.RED : UIUtil.getLabelForeground()));
                return label;
            }
        };
        if (factory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangesViewManager", "createTextStatusFactory"));
        }
        return factory;
    }

    @Override
    public void scheduleRefresh() {
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return;
        }
        if (this.myProject.isDisposed()) {
            return;
        }
        int was = this.myRepaintAlarm.cancelAllRequests();
        if (LOG.isDebugEnabled()) {
            LOG.debug("schedule refresh, was " + was);
        }
        if (!this.myRepaintAlarm.isDisposed()) {
            this.myRepaintAlarm.addRequest(new Runnable(){

                @Override
                public void run() {
                    ChangesViewManager.this.refreshView();
                }
            }, 100, ModalityState.NON_MODAL);
        }
    }

    private void refreshView() {
        if (this.myDisposed || !this.myProject.isInitialized() || ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        if (!ProjectLevelVcsManager.getInstance((Project)this.myProject).hasActiveVcss()) {
            return;
        }
        ChangeListManagerImpl changeListManager = ChangeListManagerImpl.getInstanceImpl(this.myProject);
        TreeModelBuilder treeModelBuilder = new TreeModelBuilder(this.myProject, this.myView.isShowFlatten()).setChangeLists(changeListManager.getChangeListsCopy()).setLocallyDeletedPaths(changeListManager.getDeletedFiles()).setModifiedWithoutEditing(changeListManager.getModifiedWithoutEditing()).setSwitchedFiles(changeListManager.getSwitchedFilesMap()).setSwitchedRoots(changeListManager.getSwitchedRoots()).setLockedFolders(changeListManager.getLockedFolders()).setLogicallyLockedFiles(changeListManager.getLogicallyLockedFolders()).setUnversioned(changeListManager.getUnversionedFiles());
        if (this.myState.myShowIgnored) {
            treeModelBuilder.setIgnored(changeListManager.getIgnoredFiles(), changeListManager.isIgnoredInUpdateMode());
        }
        this.myView.updateModel(treeModelBuilder.build());
        this.changeDetails();
    }

    @NotNull
    public State getState() {
        State state = this.myState;
        if (state == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangesViewManager", "getState"));
        }
        return state;
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/openapi/vcs/changes/ChangesViewManager", "loadState"));
        }
        this.myState = state;
    }

    @Override
    public void setShowFlattenMode(boolean state) {
        this.myState.myShowFlatten = state;
        this.myView.setShowFlatten(state);
        this.refreshView();
    }

    @Override
    public void selectFile(@Nullable VirtualFile vFile) {
        if (vFile == null) {
            return;
        }
        Change change = ChangeListManager.getInstance((Project)this.myProject).getChange(vFile);
        Change objectToFind = change != null ? change : vFile;
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.myView.getModel().getRoot();
        DefaultMutableTreeNode node = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)root, (Object)objectToFind);
        if (node != null) {
            TreeUtil.selectNode((JTree)((Object)this.myView), (TreeNode)node);
        }
    }

    @Override
    public void refreshChangesViewNodeAsync(final @NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/changes/ChangesViewManager", "refreshChangesViewNodeAsync"));
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                ChangesViewManager.this.refreshChangesViewNode(file2);
            }
        }, this.myProject.getDisposed());
    }

    private void refreshChangesViewNode(@NotNull VirtualFile file2) {
        DefaultMutableTreeNode root;
        DefaultMutableTreeNode node;
        VirtualFile userObject;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/changes/ChangesViewManager", "refreshChangesViewNode"));
        }
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)this.myProject);
        Object object = userObject = changeListManager.isUnversioned(file2) ? file2 : changeListManager.getChange(file2);
        if (userObject != null && (node = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)(root = (DefaultMutableTreeNode)this.myView.getModel().getRoot()), (Object)userObject)) != null) {
            this.myView.getModel().nodeChanged(node);
        }
    }

    public void disposeComponent() {
    }

    public void initComponent() {
    }

    private class MyChangeViewContent
    extends DnDTargetContentAdapter {
        private MyChangeViewContent(JComponent component, String displayName, boolean isLockable) {
            super(component, displayName, isLockable);
        }

        public void drop(DnDEvent event) {
            Object attachedObject = event.getAttachedObject();
            if (attachedObject instanceof ShelvedChangeListDragBean) {
                FileDocumentManager.getInstance().saveAllDocuments();
                ShelvedChangeListDragBean shelvedBean = (ShelvedChangeListDragBean)attachedObject;
                ShelveChangesManager.getInstance(ChangesViewManager.this.myProject).unshelveSilentlyAsynchronously(ChangesViewManager.this.myProject, shelvedBean.getShelvedChangelists(), shelvedBean.getChanges(), shelvedBean.getBinaryFiles(), null);
            }
        }

        public boolean update(DnDEvent event) {
            Object attachedObject = event.getAttachedObject();
            if (attachedObject instanceof ShelvedChangeListDragBean) {
                ShelvedChangeListDragBean shelveBean = (ShelvedChangeListDragBean)attachedObject;
                event.setDropPossible(!shelveBean.getShelvedChangelists().isEmpty());
                return false;
            }
            return true;
        }
    }

    private class MyChangeProcessor
    extends CacheChangeProcessor {
        public MyChangeProcessor(Project project2) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ChangesViewManager$MyChangeProcessor", "<init>"));
            }
            super(project2, "ChangesView");
            Disposer.register((Disposable)project2, (Disposable)this);
        }

        @Override
        public boolean isWindowFocused() {
            return DiffUtil.isFocusedComponent(ChangesViewManager.this.myProject, ChangesViewManager.this.myContent.getComponent());
        }

        @Override
        @NotNull
        protected List<Change> getSelectedChanges() {
            List<Object> result2 = ChangesViewManager.this.myView.getSelectedChanges().collect(Collectors.toList());
            if (result2.isEmpty()) {
                result2 = ChangesViewManager.this.myView.getChanges().collect(Collectors.toList());
            }
            List<Change> list = result2;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangesViewManager$MyChangeProcessor", "getSelectedChanges"));
            }
            return list;
        }

        @Override
        @NotNull
        protected List<Change> getAllChanges() {
            List<Change> list = ChangesViewManager.this.myView.getChanges().collect(Collectors.toList());
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangesViewManager$MyChangeProcessor", "getAllChanges"));
            }
            return list;
        }

        @Override
        protected void selectChange(@NotNull Change change) {
            if (change == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/openapi/vcs/changes/ChangesViewManager$MyChangeProcessor", "selectChange"));
            }
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)ChangesViewManager.this.myView.getModel().getRoot();
            DefaultMutableTreeNode node = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)root, (Object)change);
            if (node != null) {
                TreePath path = TreeUtil.getPathFromRoot((TreeNode)node);
                TreeUtil.selectPath((JTree)((Object)ChangesViewManager.this.myView), (TreePath)path, (boolean)false);
            }
        }
    }

    private class ToggleDetailsAction
    extends ToggleAction
    implements DumbAware {
        private ToggleDetailsAction() {
            super("Preview Diff", null, AllIcons.Actions.PreviewDetails);
        }

        public boolean isSelected(AnActionEvent e) {
            return ChangesViewManager.this.myDetailsOn;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            ChangesViewManager.this.myDetailsOn = state;
            VcsConfiguration.getInstance((Project)((ChangesViewManager)ChangesViewManager.this).myProject).LOCAL_CHANGES_DETAILS_PREVIEW_SHOWN = ChangesViewManager.this.myDetailsOn;
            ChangesViewManager.this.changeDetails();
        }
    }

    private class ToggleShowIgnoredAction
    extends ToggleAction
    implements DumbAware {
        public ToggleShowIgnoredAction() {
            super(VcsBundle.message((String)"changes.action.show.ignored.text", (Object[])new Object[0]), VcsBundle.message((String)"changes.action.show.ignored.description", (Object[])new Object[0]), AllIcons.Actions.ShowHiddens);
        }

        public boolean isSelected(AnActionEvent e) {
            return ((ChangesViewManager)ChangesViewManager.this).myState.myShowIgnored;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            ((ChangesViewManager)ChangesViewManager.this).myState.myShowIgnored = state;
            ChangesViewManager.this.refreshView();
        }
    }

    private class ToggleShowFlattenAction
    extends ToggleAction
    implements DumbAware {
        public ToggleShowFlattenAction() {
            super(VcsBundle.message((String)"changes.action.show.directories.text", (Object[])new Object[0]), VcsBundle.message((String)"changes.action.show.directories.description", (Object[])new Object[0]), AllIcons.Actions.GroupByPackage);
        }

        public boolean isSelected(AnActionEvent e) {
            return !((ChangesViewManager)ChangesViewManager.this).myState.myShowFlatten;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            ChangesViewManager.this.setShowFlattenMode(!state);
        }
    }

    private class Expander
    implements TreeExpander {
        private Expander() {
        }

        public void expandAll() {
            TreeUtil.expandAll((JTree)((Object)ChangesViewManager.this.myView));
        }

        public boolean canExpand() {
            return true;
        }

        public void collapseAll() {
            TreeUtil.collapseAll((JTree)((Object)ChangesViewManager.this.myView), (int)2);
            TreeUtil.expand((JTree)((Object)ChangesViewManager.this.myView), (int)1);
        }

        public boolean canCollapse() {
            return true;
        }
    }

    private class MyChangeListListener
    extends ChangeListAdapter {
        private MyChangeListListener() {
        }

        public void changeListAdded(ChangeList list) {
            ChangesViewManager.this.scheduleRefresh();
        }

        public void changeListRemoved(ChangeList list) {
            ChangesViewManager.this.scheduleRefresh();
        }

        public void changeListRenamed(ChangeList list, String oldName) {
            ChangesViewManager.this.scheduleRefresh();
        }

        public void changesMoved(Collection<Change> changes, ChangeList fromList, ChangeList toList) {
            ChangesViewManager.this.scheduleRefresh();
        }

        public void defaultListChanged(ChangeList oldDefaultList, ChangeList newDefaultList) {
            ChangesViewManager.this.scheduleRefresh();
        }

        public void changeListUpdateDone() {
            ChangesViewManager.this.scheduleRefresh();
            ChangeListManagerImpl changeListManager = ChangeListManagerImpl.getInstanceImpl(ChangesViewManager.this.myProject);
            VcsException updateException = changeListManager.getUpdateException();
            ChangesViewManager.this.setBusy(false);
            if (updateException == null) {
                Factory<JComponent> additionalUpdateInfo = changeListManager.getAdditionalUpdateInfo();
                if (additionalUpdateInfo != null) {
                    ChangesViewManager.this.updateProgressComponent((Factory<JComponent>)additionalUpdateInfo);
                } else {
                    ChangesViewManager.this.updateProgressText("", false);
                }
            } else {
                ChangesViewManager.this.updateProgressText(VcsBundle.message((String)"error.updating.changes", (Object[])new Object[]{updateException.getMessage()}), true);
            }
        }
    }

    public static class State {
        @Attribute(value="flattened_view")
        public boolean myShowFlatten = true;
        @Attribute(value="show_ignored")
        public boolean myShowIgnored;
    }
}

