/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl.projectlevelman;

import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.VcsShowConfirmationOptionImpl;
import com.intellij.openapi.vcs.VcsShowOptionsSettingImpl;
import com.intellij.openapi.vcs.impl.projectlevelman.OptionsAndConfirmations;
import com.intellij.util.containers.HashMap;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ProjectLevelVcsManagerSerialization {
    @NonNls
    private static final String OPTIONS_SETTING = "OptionsSetting";
    @NonNls
    private static final String CONFIRMATIONS_SETTING = "ConfirmationsSetting";
    @NonNls
    private static final String VALUE_ATTTIBUTE = "value";
    @NonNls
    private static final String ID_ATTRIBUTE = "id";
    private final Map<String, VcsShowConfirmationOption.Value> myReadValue = new HashMap();

    private static VcsShowOptionsSettingImpl getOrCreateOption(Map<String, VcsShowOptionsSettingImpl> options, String actionName) {
        if (!options.containsKey(actionName)) {
            options.put(actionName, new VcsShowOptionsSettingImpl(actionName));
        }
        return options.get(actionName);
    }

    public void readExternalUtil(Element element, OptionsAndConfirmations optionsAndConfirmations) throws InvalidDataException {
        String value;
        String id;
        Map<String, VcsShowOptionsSettingImpl> options = optionsAndConfirmations.getOptions();
        for (Element subElement : element.getChildren(OPTIONS_SETTING)) {
            id = subElement.getAttributeValue(ID_ATTRIBUTE);
            value = subElement.getAttributeValue(VALUE_ATTTIBUTE);
            if (id == null || value == null) continue;
            try {
                ProjectLevelVcsManagerSerialization.getOrCreateOption(options, id).setValue(Boolean.parseBoolean(value));
            }
            catch (Exception exception) {}
        }
        this.myReadValue.clear();
        for (Element subElement : element.getChildren(CONFIRMATIONS_SETTING)) {
            id = subElement.getAttributeValue(ID_ATTRIBUTE);
            value = subElement.getAttributeValue(VALUE_ATTTIBUTE);
            if (id == null || value == null) continue;
            try {
                this.myReadValue.put(id, VcsShowConfirmationOption.Value.fromString((String)value));
            }
            catch (Exception exception) {}
        }
    }

    public void writeExternalUtil(@NotNull Element element, @NotNull OptionsAndConfirmations optionsAndConfirmations) throws WriteExternalException {
        Element settingElement;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/vcs/impl/projectlevelman/ProjectLevelVcsManagerSerialization", "writeExternalUtil"));
        }
        if (optionsAndConfirmations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "optionsAndConfirmations", "com/intellij/openapi/vcs/impl/projectlevelman/ProjectLevelVcsManagerSerialization", "writeExternalUtil"));
        }
        Map<String, VcsShowOptionsSettingImpl> options = optionsAndConfirmations.getOptions();
        Map<String, VcsShowConfirmationOptionImpl> confirmations = optionsAndConfirmations.getConfirmations();
        for (VcsShowOptionsSettingImpl vcsShowOptionsSettingImpl : options.values()) {
            if (vcsShowOptionsSettingImpl.getValue()) continue;
            settingElement = new Element(OPTIONS_SETTING);
            element.addContent(settingElement);
            settingElement.setAttribute(VALUE_ATTTIBUTE, Boolean.toString(vcsShowOptionsSettingImpl.getValue()));
            settingElement.setAttribute(ID_ATTRIBUTE, vcsShowOptionsSettingImpl.getDisplayName());
        }
        for (VcsShowConfirmationOptionImpl vcsShowConfirmationOptionImpl : confirmations.values()) {
            if (vcsShowConfirmationOptionImpl.getValue() == VcsShowConfirmationOption.Value.SHOW_CONFIRMATION) continue;
            settingElement = new Element(CONFIRMATIONS_SETTING);
            element.addContent(settingElement);
            settingElement.setAttribute(VALUE_ATTTIBUTE, vcsShowConfirmationOptionImpl.getValue().toString());
            settingElement.setAttribute(ID_ATTRIBUTE, vcsShowConfirmationOptionImpl.getDisplayName());
        }
    }

    public VcsShowConfirmationOption.Value getInitOptionValue(String id) {
        return this.myReadValue.get(id);
    }
}

