/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightFilePointer
implements VirtualFilePointer {
    private final String myUrl;
    private VirtualFile myFile;

    public LightFilePointer(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/vfs/impl/LightFilePointer", "<init>"));
        }
        this.myUrl = url;
    }

    public LightFilePointer(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/LightFilePointer", "<init>"));
        }
        this.myUrl = file2.getUrl();
        this.myFile = file2;
    }

    @Nullable
    public VirtualFile getFile() {
        this.refreshFile();
        return this.myFile;
    }

    @NotNull
    public String getUrl() {
        String string = this.myUrl;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/LightFilePointer", "getUrl"));
        }
        return string;
    }

    @NotNull
    public String getFileName() {
        if (this.myFile != null) {
            String string = this.myFile.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/LightFilePointer", "getFileName"));
            }
            return string;
        }
        int index = this.myUrl.lastIndexOf(47);
        String string = index >= 0 ? this.myUrl.substring(index + 1) : this.myUrl;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/LightFilePointer", "getFileName"));
        }
        return string;
    }

    @NotNull
    public String getPresentableUrl() {
        VirtualFile file2 = this.getFile();
        if (file2 != null) {
            String string = file2.getPresentableUrl();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/LightFilePointer", "getPresentableUrl"));
            }
            return string;
        }
        String string = LightFilePointer.toPresentableUrl(this.myUrl);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/LightFilePointer", "getPresentableUrl"));
        }
        return string;
    }

    @NotNull
    private static String toPresentableUrl(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/vfs/impl/LightFilePointer", "toPresentableUrl"));
        }
        String path = VirtualFileManager.extractPath((String)url);
        String protocol = VirtualFileManager.extractProtocol((String)url);
        VirtualFileSystem fileSystem = VirtualFileManager.getInstance().getFileSystem(protocol);
        String string = ((VirtualFileSystem)ObjectUtils.notNull((Object)fileSystem, (Object)StandardFileSystems.local())).extractPresentableUrl(path);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/LightFilePointer", "toPresentableUrl"));
        }
        return string;
    }

    public boolean isValid() {
        return this.getFile() != null;
    }

    private void refreshFile() {
        if (this.myFile != null && this.myFile.isValid()) {
            return;
        }
        VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(this.myUrl);
        this.myFile = virtualFile != null && virtualFile.isValid() ? virtualFile : null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LightFilePointer)) {
            return false;
        }
        return this.myUrl.equals(((LightFilePointer)o).myUrl);
    }

    public int hashCode() {
        return this.myUrl.hashCode();
    }
}

