/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageDependencies.ui.PackageDependenciesNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.IconUtil;
import java.awt.Color;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class FileNode
extends PackageDependenciesNode
implements Comparable<FileNode> {
    private final VirtualFile myVFile;
    private final boolean myMarked;

    public FileNode(VirtualFile file2, Project project2, boolean marked) {
        super(project2);
        this.myVFile = file2;
        this.myMarked = marked;
    }

    @Override
    public void fillFiles(Set<PsiFile> set2, boolean recursively) {
        super.fillFiles(set2, recursively);
        PsiFile file2 = this.getFile();
        if (file2 != null && file2.isValid()) {
            set2.add(file2);
        }
    }

    @Override
    public boolean hasUnmarked() {
        return !this.myMarked;
    }

    @Override
    public boolean hasMarked() {
        return this.myMarked;
    }

    @Override
    public String toString() {
        return this.myVFile.getName();
    }

    @Override
    public Icon getIcon() {
        return IconUtil.getIcon((VirtualFile)this.myVFile, (int)3, (Project)this.myProject);
    }

    @Override
    public int getWeight() {
        return 5;
    }

    @Override
    public int getContainingFiles() {
        return 1;
    }

    @Override
    public PsiElement getPsiElement() {
        return this.getFile();
    }

    @Override
    public Color getColor() {
        if (this.myColor == null) {
            this.myColor = FileStatusManager.getInstance((Project)this.myProject).getStatus(this.myVFile).getColor();
            if (this.myColor == null) {
                this.myColor = NOT_CHANGED;
            }
        }
        return this.myColor == NOT_CHANGED ? null : this.myColor;
    }

    public boolean equals(Object o) {
        if (this.isEquals()) {
            return super.equals(o);
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof FileNode)) {
            return false;
        }
        FileNode fileNode = (FileNode)o;
        return this.myVFile.equals(fileNode.myVFile);
    }

    public int hashCode() {
        return this.myVFile.hashCode();
    }

    @Override
    public boolean isValid() {
        return this.myVFile != null && this.myVFile.isValid();
    }

    @Override
    public boolean canSelectInLeftTree(Map<PsiFile, Set<PsiFile>> deps) {
        return deps.containsKey(this.getFile());
    }

    @Nullable
    private PsiFile getFile() {
        return this.myVFile.isValid() && !this.myProject.isDisposed() ? PsiManager.getInstance((Project)this.myProject).findFile(this.myVFile) : null;
    }

    @Override
    public int compareTo(FileNode o) {
        int compare = StringUtil.compare((String)(this.myVFile != null ? this.myVFile.getFileType().getDefaultExtension() : null), o.myVFile != null ? o.myVFile.getFileType().getDefaultExtension() : null, (boolean)true);
        if (compare != 0) {
            return compare;
        }
        return StringUtil.compare((String)this.toString(), (String)o.toString(), (boolean)true);
    }
}

