/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.run;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.ElementsChooser;
import com.intellij.ide.util.MultiStateElementsChooser;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactPointer;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ArtifactChooser
extends ElementsChooser<ArtifactPointer> {
    private static final Comparator<ArtifactPointer> ARTIFACT_COMPARATOR = (o1, o2) -> o1.getArtifactName().compareToIgnoreCase(o2.getArtifactName());
    private static final MultiStateElementsChooser.ElementProperties INVALID_ARTIFACT_PROPERTIES = new MultiStateElementsChooser.ElementProperties(){

        @Override
        public Icon getIcon() {
            return AllIcons.Nodes.Artifact;
        }

        @Override
        public Color getColor() {
            return JBColor.RED;
        }
    };

    public ArtifactChooser(List<ArtifactPointer> pointers) {
        super(pointers, false);
        for (ArtifactPointer pointer : pointers) {
            if (pointer.getArtifact() != null) continue;
            this.setElementProperties(pointer, INVALID_ARTIFACT_PROPERTIES);
        }
        this.sort(ARTIFACT_COMPARATOR);
    }

    @Override
    protected String getItemText(@NotNull ArtifactPointer value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/packaging/impl/run/ArtifactChooser", "getItemText"));
        }
        return value.getArtifactName();
    }

    @Override
    protected Icon getItemIcon(@NotNull ArtifactPointer value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/packaging/impl/run/ArtifactChooser", "getItemIcon"));
        }
        Artifact artifact = value.getArtifact();
        return artifact != null ? artifact.getArtifactType().getIcon() : null;
    }
}

