/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationAdapter;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.StandardProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomManager;
import com.intellij.pom.PomModel;
import com.intellij.pom.PomTransaction;
import com.intellij.pom.event.PomModelEvent;
import com.intellij.pom.impl.PomTransactionBase;
import com.intellij.pom.tree.TreeAspect;
import com.intellij.pom.tree.TreeAspectEvent;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiLock;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.DocumentCommitProcessor;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.PsiToDocumentSynchronizer;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.text.DiffLog;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.ForeignLeafPsiElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.text.BlockSupport;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.BoundedTaskExecutor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSetQueue;
import com.intellij.util.ui.UIUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

public class DocumentCommitThread
implements Runnable,
Disposable,
DocumentCommitProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.DocumentCommitThread");
    private static final String SYNC_COMMIT_REASON = "Sync commit";
    private final ExecutorService executor = new BoundedTaskExecutor("Document committing pool", (Executor)PooledThreadExecutor.INSTANCE, 1, (Disposable)this);
    private final Object lock = new Object();
    private final HashSetQueue<CommitTask> documentsToCommit = new HashSetQueue();
    private final HashSetQueue<CommitTask> documentsToApplyInEDT = new HashSetQueue();
    private final ApplicationEx myApplication;
    private volatile boolean isDisposed;
    private CommitTask currentTask;
    private boolean myEnabled;
    private static final Key<Object> CANCEL_REASON = Key.create((String)"CANCEL_REASON");
    private static final Key<Lock> DOCUMENT_LOCK = Key.create((String)"DOCUMENT_LOCK");

    public static DocumentCommitThread getInstance() {
        return (DocumentCommitThread)ServiceManager.getService(DocumentCommitProcessor.class);
    }

    public DocumentCommitThread(ApplicationEx application) {
        this.myApplication = application;
        application.invokeLater(() -> {
            if (application.isDisposed()) {
                return;
            }
            assert (!application.isWriteAccessAllowed() || application.isUnitTestMode());
            application.addApplicationListener((ApplicationListener)new ApplicationAdapter(){

                public void beforeWriteActionStart(@NotNull Object action) {
                    if (action == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/psi/impl/DocumentCommitThread$1", "beforeWriteActionStart"));
                    }
                    DocumentCommitThread.this.disable("Write action started: " + action);
                }

                public void afterWriteActionFinished(@NotNull Object action) {
                    if (action == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/psi/impl/DocumentCommitThread$1", "afterWriteActionFinished"));
                    }
                    DocumentCommitThread.this.enable("Write action finished: " + action);
                }
            }, this);
            this.enable("Listener installed, started");
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.isDisposed = true;
        Object object = this.lock;
        synchronized (object) {
            this.documentsToCommit.clear();
        }
        this.cancel("Stop thread");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disable(@NonNls @NotNull Object reason) {
        if (reason == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/intellij/psi/impl/DocumentCommitThread", "disable"));
        }
        Object object = this.lock;
        synchronized (object) {
            this.cancel(reason);
            this.myEnabled = false;
        }
        this.log(null, "disabled", null, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enable(@NonNls @NotNull Object reason) {
        if (reason == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/intellij/psi/impl/DocumentCommitThread", "enable"));
        }
        Object object = this.lock;
        synchronized (object) {
            this.myEnabled = true;
            this.wakeUpQueue();
        }
        this.log(null, "enabled", null, reason);
    }

    private void wakeUpQueue() {
        if (!this.isDisposed && !this.documentsToCommit.isEmpty()) {
            this.executor.execute(this);
        }
    }

    private void cancel(@NonNls @NotNull Object reason) {
        if (reason == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/intellij/psi/impl/DocumentCommitThread", "cancel"));
        }
        this.startNewTask(null, reason);
    }

    @Override
    public void commitAsynchronously(@NotNull Project project2, @NotNull Document document, @NonNls @NotNull Object reason, @NotNull ModalityState currentModalityState) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/DocumentCommitThread", "commitAsynchronously"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/DocumentCommitThread", "commitAsynchronously"));
        }
        if (reason == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/intellij/psi/impl/DocumentCommitThread", "commitAsynchronously"));
        }
        if (currentModalityState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentModalityState", "com/intellij/psi/impl/DocumentCommitThread", "commitAsynchronously"));
        }
        assert (!this.isDisposed) : "already disposed";
        if (!project2.isInitialized()) {
            return;
        }
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project2).getCachedPsiFile(document);
        if (psiFile == null) {
            return;
        }
        this.doQueue(project2, document, DocumentCommitThread.getAllFileNodes(psiFile), reason, currentModalityState, PsiDocumentManager.getInstance((Project)project2).getLastCommittedText(document));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doQueue(@NotNull Project project2, @NotNull Document document, @NotNull List<Pair<PsiFileImpl, FileASTNode>> oldFileNodes, @NotNull Object reason, @NotNull ModalityState currentModalityState, @NotNull CharSequence lastCommittedText) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/DocumentCommitThread", "doQueue"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/DocumentCommitThread", "doQueue"));
        }
        if (oldFileNodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldFileNodes", "com/intellij/psi/impl/DocumentCommitThread", "doQueue"));
        }
        if (reason == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/intellij/psi/impl/DocumentCommitThread", "doQueue"));
        }
        if (currentModalityState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentModalityState", "com/intellij/psi/impl/DocumentCommitThread", "doQueue"));
        }
        if (lastCommittedText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lastCommittedText", "com/intellij/psi/impl/DocumentCommitThread", "doQueue"));
        }
        Object object = this.lock;
        synchronized (object) {
            if (!project2.isInitialized()) {
                return;
            }
            CommitTask newTask = this.createNewTaskAndCancelSimilar(project2, document, oldFileNodes, reason, currentModalityState, lastCommittedText);
            this.documentsToCommit.offer((Object)newTask);
            this.log(project2, "Queued", newTask, reason);
            this.wakeUpQueue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private CommitTask createNewTaskAndCancelSimilar(@NotNull Project project2, @NotNull Document document, @NotNull List<Pair<PsiFileImpl, FileASTNode>> oldFileNodes, @NotNull Object reason, @NotNull ModalityState currentModalityState, @NotNull CharSequence lastCommittedText) {
        Pair<PsiFileImpl, FileASTNode> pair;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/DocumentCommitThread", "createNewTaskAndCancelSimilar"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/DocumentCommitThread", "createNewTaskAndCancelSimilar"));
        }
        if (oldFileNodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldFileNodes", "com/intellij/psi/impl/DocumentCommitThread", "createNewTaskAndCancelSimilar"));
        }
        if (reason == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/intellij/psi/impl/DocumentCommitThread", "createNewTaskAndCancelSimilar"));
        }
        if (currentModalityState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentModalityState", "com/intellij/psi/impl/DocumentCommitThread", "createNewTaskAndCancelSimilar"));
        }
        if (lastCommittedText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lastCommittedText", "com/intellij/psi/impl/DocumentCommitThread", "createNewTaskAndCancelSimilar"));
        }
        Object object = this.lock;
        // MONITORENTER : object
        Iterator<Pair<PsiFileImpl, FileASTNode>> iterator = oldFileNodes.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                CommitTask newTask = new CommitTask(project2, document, oldFileNodes, this.createProgressIndicator(), reason, currentModalityState, lastCommittedText);
                this.cancelAndRemoveFromDocsToCommit(newTask, reason);
                this.cancelAndRemoveCurrentTask(newTask, reason);
                this.cancelAndRemoveFromDocsToApplyInEDT(newTask, reason);
                CommitTask commitTask = newTask;
                // MONITOREXIT : object
                if (commitTask != null) return commitTask;
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/DocumentCommitThread", "createNewTaskAndCancelSimilar"));
            }
            pair = iterator.next();
            assert (((PsiFileImpl)pair.first).getProject() == project2);
        }
    }

    public void log(Project project2, @NonNls String msg, @Nullable CommitTask task, Object ... args) {
    }

    private void cancelAll() {
        String reason = "Cancel all in tests";
        this.cancel(reason);
        for (CommitTask commitTask : this.documentsToCommit) {
            commitTask.cancel(reason, this);
            this.log(commitTask.project, "Removed from background queue", commitTask, new Object[0]);
        }
        this.documentsToCommit.clear();
        for (CommitTask commitTask : this.documentsToApplyInEDT) {
            commitTask.cancel(reason, this);
            this.log(commitTask.project, "Removed from EDT apply queue (sync commit called)", commitTask, new Object[0]);
        }
        this.documentsToApplyInEDT.clear();
        CommitTask task = this.currentTask;
        if (task != null) {
            this.cancelAndRemoveFromDocsToCommit(task, reason);
        }
        this.cancel("Sync commit intervened");
        ((BoundedTaskExecutor)this.executor).clearAndCancelAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearQueue() {
        Object object = this.lock;
        synchronized (object) {
            this.cancelAll();
            this.wakeUpQueue();
        }
    }

    private void cancelAndRemoveCurrentTask(@NotNull CommitTask newTask, @NotNull Object reason) {
        if (newTask == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newTask", "com/intellij/psi/impl/DocumentCommitThread", "cancelAndRemoveCurrentTask"));
        }
        if (reason == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/intellij/psi/impl/DocumentCommitThread", "cancelAndRemoveCurrentTask"));
        }
        CommitTask currentTask = this.currentTask;
        if (currentTask != null && currentTask.equals(newTask)) {
            this.cancelAndRemoveFromDocsToCommit(currentTask, reason);
            this.cancel(reason);
        }
    }

    private void cancelAndRemoveFromDocsToApplyInEDT(@NotNull CommitTask newTask, @NotNull Object reason) {
        if (newTask == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newTask", "com/intellij/psi/impl/DocumentCommitThread", "cancelAndRemoveFromDocsToApplyInEDT"));
        }
        if (reason == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/intellij/psi/impl/DocumentCommitThread", "cancelAndRemoveFromDocsToApplyInEDT"));
        }
        boolean removed = this.cancelAndRemoveFromQueue(newTask, this.documentsToApplyInEDT, reason);
        if (removed) {
            this.log(newTask.project, "Removed from EDT apply queue", newTask, new Object[0]);
        }
    }

    private void cancelAndRemoveFromDocsToCommit(@NotNull CommitTask newTask, @NotNull Object reason) {
        if (newTask == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newTask", "com/intellij/psi/impl/DocumentCommitThread", "cancelAndRemoveFromDocsToCommit"));
        }
        if (reason == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/intellij/psi/impl/DocumentCommitThread", "cancelAndRemoveFromDocsToCommit"));
        }
        boolean removed = this.cancelAndRemoveFromQueue(newTask, this.documentsToCommit, reason);
        if (removed) {
            this.log(newTask.project, "Removed from background queue", newTask, new Object[0]);
        }
    }

    private boolean cancelAndRemoveFromQueue(@NotNull CommitTask newTask, @NotNull HashSetQueue<CommitTask> queue, @NotNull Object reason) {
        if (newTask == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newTask", "com/intellij/psi/impl/DocumentCommitThread", "cancelAndRemoveFromQueue"));
        }
        if (queue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queue", "com/intellij/psi/impl/DocumentCommitThread", "cancelAndRemoveFromQueue"));
        }
        if (reason == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/intellij/psi/impl/DocumentCommitThread", "cancelAndRemoveFromQueue"));
        }
        CommitTask queuedTask = (CommitTask)queue.find((Object)newTask);
        if (queuedTask != null) {
            assert (queuedTask != newTask);
            queuedTask.cancel(reason, this);
        }
        return queue.remove((Object)newTask);
    }

    @Override
    public void run() {
        while (!this.isDisposed) {
            try {
                boolean polled = this.pollQueue();
                if (polled) continue;
                break;
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean pollQueue() {
        assert (!this.myApplication.isDispatchThread()) : Thread.currentThread();
        boolean success = false;
        Document document = null;
        Project project2 = null;
        CommitTask task = null;
        Object failureReason = null;
        try {
            ProgressIndicator indicator;
            Object object = this.lock;
            synchronized (object) {
                if (!this.myEnabled || (task = (CommitTask)this.documentsToCommit.poll()) == null) {
                    return false;
                }
                document = task.getDocument();
                indicator = task.indicator;
                project2 = task.project;
                if (project2.isDisposed() || !((PsiDocumentManagerBase)PsiDocumentManager.getInstance((Project)project2)).isInUncommittedSet(document)) {
                    this.log(project2, "Abandon and proceed to next", task, new Object[0]);
                    return true;
                }
                if (indicator.isCanceled()) {
                    return true;
                }
                this.startNewTask(task, "Pulled new task");
                this.documentsToApplyInEDT.add((Object)task);
            }
            if (indicator.isCanceled()) {
                success = false;
            } else {
                CommitTask commitTask = task;
                Ref result2 = new Ref();
                ProgressManager.getInstance().executeProcessUnderProgress(() -> result2.set(this.commitUnderProgress(commitTask, false)), indicator);
                Runnable finishRunnable = (Runnable)((Pair)result2.get()).first;
                success = finishRunnable != null;
                failureReason = ((Pair)result2.get()).second;
                if (success) {
                    assert (!this.myApplication.isDispatchThread());
                    TransactionGuardImpl guard = (TransactionGuardImpl)TransactionGuard.getInstance();
                    guard.submitTransaction((Disposable)project2, guard.getModalityTransaction(task.myCreationModalityState), finishRunnable);
                }
            }
        }
        catch (ProcessCanceledException e) {
            this.cancel((Object)((Object)e) + " (cancel reason: " + ((UserDataHolder)task.indicator).getUserData(CANCEL_REASON) + ")");
            success = false;
            failureReason = e;
        }
        catch (Throwable e) {
            this.cancel(e);
            failureReason = ExceptionUtil.getThrowableText((Throwable)e);
        }
        if (!success && task != null) {
            Project finalProject = project2;
            Document finalDocument = document;
            String finalFailureReason = failureReason;
            CommitTask finalTask = task;
            ReadAction.run(() -> {
                List<Pair<PsiFileImpl, FileASTNode>> oldFileNodes;
                if (finalProject.isDisposed()) {
                    return;
                }
                PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)finalProject);
                if (documentManager.isCommitted(finalDocument)) {
                    return;
                }
                CharSequence lastCommittedText = documentManager.getLastCommittedText(finalDocument);
                PsiFile file2 = documentManager.getPsiFile(finalDocument);
                List<Pair<PsiFileImpl, FileASTNode>> list = oldFileNodes = file2 == null ? null : DocumentCommitThread.getAllFileNodes(file2);
                if (oldFileNodes != null) {
                    this.doQueue(finalProject, finalDocument, oldFileNodes, "re-added on failure: " + finalFailureReason, finalTask.myCreationModalityState, lastCommittedText);
                }
            });
        }
        Object object = this.lock;
        synchronized (object) {
            this.currentTask = null;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commitSynchronously(@NotNull Document document, @NotNull Project project2, @NotNull PsiFile psiFile) {
        CommitTask task;
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/DocumentCommitThread", "commitSynchronously"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/DocumentCommitThread", "commitSynchronously"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/psi/impl/DocumentCommitThread", "commitSynchronously"));
        }
        assert (!this.isDisposed);
        if (!project2.isInitialized() && !project2.isDefault()) {
            String s = project2 + "; Disposed: " + project2.isDisposed() + "; Open: " + project2.isOpen();
            try {
                Disposer.dispose((Disposable)project2);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new RuntimeException(s);
        }
        List<Pair<PsiFileImpl, FileASTNode>> allFileNodes = DocumentCommitThread.getAllFileNodes(psiFile);
        Lock documentLock = DocumentCommitThread.getDocumentLock(document);
        Object object = this.lock;
        synchronized (object) {
            task = this.createNewTaskAndCancelSimilar(project2, document, allFileNodes, SYNC_COMMIT_REASON, ModalityState.current(), PsiDocumentManager.getInstance((Project)project2).getLastCommittedText(document));
            documentLock.lock();
        }
        try {
            assert (!task.indicator.isCanceled());
            Pair<Runnable, Object> result2 = this.commitUnderProgress(task, true);
            Runnable finish = (Runnable)result2.first;
            this.log(project2, "Committed sync", task, finish, task.indicator);
            assert (finish != null);
            finish.run();
        }
        finally {
            documentLock.unlock();
        }
    }

    @NotNull
    private static List<Pair<PsiFileImpl, FileASTNode>> getAllFileNodes(@NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/DocumentCommitThread", "getAllFileNodes"));
        }
        if (!file2.isValid()) {
            throw new PsiInvalidElementAccessException((PsiElement)file2, "File " + file2 + " is invalid, can't commit");
        }
        if (file2 instanceof PsiCompiledFile) {
            throw new IllegalArgumentException("Can't commit ClsFile: " + file2);
        }
        List list = ContainerUtil.map((Collection)file2.getViewProvider().getAllFiles(), root -> Pair.create((Object)((PsiFileImpl)root), (Object)root.getNode()));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/DocumentCommitThread", "getAllFileNodes"));
        }
        return list;
    }

    @NotNull
    protected ProgressIndicator createProgressIndicator() {
        StandardProgressIndicatorBase standardProgressIndicatorBase = new StandardProgressIndicatorBase();
        if (standardProgressIndicatorBase == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/DocumentCommitThread", "createProgressIndicator"));
        }
        return standardProgressIndicatorBase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startNewTask(@Nullable CommitTask task, @NotNull Object reason) {
        if (reason == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/intellij/psi/impl/DocumentCommitThread", "startNewTask"));
        }
        Object object = this.lock;
        synchronized (object) {
            CommitTask cur = this.currentTask;
            if (cur != null) {
                cur.cancel(reason, this);
            }
            this.currentTask = task;
        }
    }

    @NotNull
    private Pair<Runnable, Object> commitUnderProgress(@NotNull CommitTask task, boolean synchronously) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/psi/impl/DocumentCommitThread", "commitUnderProgress"));
        }
        if (synchronously) assert (!task.indicator.isCanceled());
        Document document = task.getDocument();
        Project project2 = task.project;
        PsiDocumentManagerBase documentManager = (PsiDocumentManagerBase)PsiDocumentManager.getInstance((Project)project2);
        SmartList finishProcessors = new SmartList();
        Runnable runnable2 = () -> this.lambda$commitUnderProgress$4(project2, document, task, documentManager, (List)finishProcessors);
        if (synchronously) {
            runnable2.run();
        } else if (!this.myApplication.tryRunReadAction(runnable2)) {
            this.log(project2, "Could not start read action", task, this.myApplication.isReadAccessAllowed(), Thread.currentThread());
            Pair pair = new Pair(null, (Object)"Could not start read action");
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/DocumentCommitThread", "commitUnderProgress"));
            }
            return pair;
        }
        boolean canceled = task.indicator.isCanceled();
        assert (!synchronously || !canceled);
        if (canceled) {
            Pair pair = new Pair(null, (Object)"Indicator was canceled");
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/DocumentCommitThread", "commitUnderProgress"));
            }
            return pair;
        }
        Runnable result2 = this.createEdtRunnable(task, synchronously, (List<Processor<Document>>)finishProcessors);
        Pair pair = Pair.create((Object)result2, null);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/DocumentCommitThread", "commitUnderProgress"));
        }
        return pair;
    }

    @NotNull
    private Runnable createEdtRunnable(@NotNull CommitTask task, boolean synchronously, @NotNull List<Processor<Document>> finishProcessors) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/psi/impl/DocumentCommitThread", "createEdtRunnable"));
        }
        if (finishProcessors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "finishProcessors", "com/intellij/psi/impl/DocumentCommitThread", "createEdtRunnable"));
        }
        Runnable runnable2 = () -> {
            boolean success;
            if (task == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/psi/impl/DocumentCommitThread", "lambda$createEdtRunnable$5"));
            }
            if (finishProcessors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "finishProcessors", "com/intellij/psi/impl/DocumentCommitThread", "lambda$createEdtRunnable$5"));
            }
            this.myApplication.assertIsDispatchThread();
            Document document = task.getDocument();
            Project project2 = task.project;
            PsiDocumentManagerBase documentManager = (PsiDocumentManagerBase)PsiDocumentManager.getInstance((Project)project2);
            boolean committed = project2.isDisposed() || documentManager.isCommitted(document);
            Object object = this.lock;
            synchronized (object) {
                this.documentsToApplyInEDT.remove((Object)task);
                if (committed) {
                    this.log(project2, "Marked as already committed in EDT apply queue, return", task, new Object[0]);
                    return;
                }
            }
            boolean changeStillValid = task.isStillValid();
            boolean bl = success = changeStillValid && documentManager.finishCommit(document, finishProcessors, synchronously, task.reason);
            if (synchronously) assert (success);
            if (!changeStillValid) {
                this.log(project2, "document changed; ignore", task, new Object[0]);
                return;
            }
            if (synchronously || success) assert (!documentManager.isInUncommittedSet(document));
            if (success) {
                this.log(project2, "Commit finished", task, new Object[0]);
            } else {
                this.commitAsynchronously(project2, document, "Re-added back", task.myCreationModalityState);
            }
        };
        if (runnable2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/DocumentCommitThread", "createEdtRunnable"));
        }
        return runnable2;
    }

    @NotNull
    private Processor<Document> handleCommitWithoutPsi(@NotNull PsiDocumentManagerBase documentManager, @NotNull CommitTask task) {
        if (documentManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "documentManager", "com/intellij/psi/impl/DocumentCommitThread", "handleCommitWithoutPsi"));
        }
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/psi/impl/DocumentCommitThread", "handleCommitWithoutPsi"));
        }
        Processor processor2 = document -> {
            if (task == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/psi/impl/DocumentCommitThread", "lambda$handleCommitWithoutPsi$6"));
            }
            if (documentManager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "documentManager", "com/intellij/psi/impl/DocumentCommitThread", "lambda$handleCommitWithoutPsi$6"));
            }
            this.log(task.project, "Finishing without PSI", task, new Object[0]);
            if (!task.isStillValid() || documentManager.getCachedViewProvider((Document)document) != null) {
                return false;
            }
            documentManager.handleCommitWithoutPsi((Document)document);
            return true;
        };
        if (processor2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/DocumentCommitThread", "handleCommitWithoutPsi"));
        }
        return processor2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isEnabled() {
        Object object = this.lock;
        synchronized (object) {
            return this.myEnabled;
        }
    }

    public String toString() {
        return "Document commit thread; application: " + this.myApplication + "; isDisposed: " + this.isDisposed + "; myEnabled: " + this.isEnabled();
    }

    public void waitForAllCommits() throws ExecutionException, InterruptedException, TimeoutException {
        ApplicationManager.getApplication().assertIsDispatchThread();
        assert (!ApplicationManager.getApplication().isWriteAccessAllowed());
        ((BoundedTaskExecutor)this.executor).waitAllTasksExecuted(100L, TimeUnit.SECONDS);
        UIUtil.dispatchAllInvocationEvents();
    }

    @Nullable(value="returns runnable to execute under write action in AWT to finish the commit")
    public Processor<Document> doCommit(@NotNull CommitTask task, @NotNull PsiFile file2, @NotNull FileASTNode oldFileNode) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/psi/impl/DocumentCommitThread", "doCommit"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/DocumentCommitThread", "doCommit"));
        }
        if (oldFileNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldFileNode", "com/intellij/psi/impl/DocumentCommitThread", "doCommit"));
        }
        Document document = task.getDocument();
        CharSequence newDocumentText = document.getImmutableCharSequence();
        TextRange changedPsiRange = DocumentCommitThread.getChangedPsiRange(file2, task.myLastCommittedText, newDocumentText);
        if (changedPsiRange == null) {
            return null;
        }
        Boolean data = (Boolean)document.getUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY);
        if (data != null) {
            document.putUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY, null);
            file2.putUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY, (Object)data);
        }
        BlockSupport blockSupport = BlockSupport.getInstance(file2.getProject());
        DiffLog diffLog = blockSupport.reparseRange(file2, oldFileNode, changedPsiRange, newDocumentText, task.indicator, task.myLastCommittedText);
        return document1 -> {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/DocumentCommitThread", "lambda$doCommit$7"));
            }
            if (task == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/psi/impl/DocumentCommitThread", "lambda$doCommit$7"));
            }
            if (oldFileNode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldFileNode", "com/intellij/psi/impl/DocumentCommitThread", "lambda$doCommit$7"));
            }
            FileViewProvider viewProvider = file2.getViewProvider();
            if (!task.isStillValid() || ((PsiDocumentManagerBase)PsiDocumentManager.getInstance((Project)file2.getProject())).getCachedViewProvider((Document)document1) != viewProvider) {
                return false;
            }
            if (file2.isPhysical() && !ApplicationManager.getApplication().isWriteAccessAllowed()) {
                VirtualFile vFile = viewProvider.getVirtualFile();
                LOG.error("Write action expected; document=" + document1 + "; file=" + file2 + " of " + file2.getClass() + "; file.valid=" + file2.isValid() + "; file.eventSystemEnabled=" + viewProvider.isEventSystemEnabled() + "; viewProvider=" + viewProvider + " of " + viewProvider.getClass() + "; language=" + file2.getLanguage() + "; vFile=" + vFile + " of " + vFile.getClass() + "; free-threaded=" + SingleRootFileViewProvider.isFreeThreaded(viewProvider));
            }
            DocumentCommitThread.doActualPsiChange(file2, diffLog);
            this.assertAfterCommit((Document)document1, file2, (FileElement)oldFileNode);
            return true;
        };
    }

    private static int getLeafMatchingLength(CharSequence leafText, CharSequence pattern, int patternIndex, int finalPatternIndex, int direction) {
        int leafIndex = direction == 1 ? 0 : leafText.length() - 1;
        int finalLeafIndex = direction == 1 ? leafText.length() - 1 : 0;
        int result2 = 0;
        while (leafText.charAt(leafIndex) == pattern.charAt(patternIndex)) {
            ++result2;
            if (leafIndex == finalLeafIndex || patternIndex == finalPatternIndex) break;
            leafIndex += direction;
            patternIndex += direction;
        }
        return result2;
    }

    private static int getMatchingLength(@NotNull FileElement treeElement, @NotNull CharSequence text, boolean fromStart) {
        if (treeElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeElement", "com/intellij/psi/impl/DocumentCommitThread", "getMatchingLength"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/DocumentCommitThread", "getMatchingLength"));
        }
        int patternIndex = fromStart ? 0 : text.length() - 1;
        int finalPatternIndex = fromStart ? text.length() - 1 : 0;
        int direction = fromStart ? 1 : -1;
        ASTNode leaf = fromStart ? TreeUtil.findFirstLeaf(treeElement, false) : TreeUtil.findLastLeaf(treeElement, false);
        int result2 = 0;
        while (leaf != null && (fromStart ? patternIndex <= finalPatternIndex : patternIndex >= finalPatternIndex)) {
            CharSequence chars;
            if (!(leaf instanceof ForeignLeafPsiElement) && (chars = leaf.getChars()).length() > 0) {
                int matchingLength = DocumentCommitThread.getLeafMatchingLength(chars, text, patternIndex, finalPatternIndex, direction);
                result2 += matchingLength;
                if (matchingLength != chars.length()) break;
                patternIndex += fromStart ? matchingLength : -matchingLength;
            }
            leaf = fromStart ? TreeUtil.nextLeaf(leaf, false) : TreeUtil.prevLeaf(leaf, false);
        }
        return result2;
    }

    @Nullable
    public static TextRange getChangedPsiRange(@NotNull PsiFile file2, @NotNull FileElement treeElement, @NotNull CharSequence newDocumentText) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/DocumentCommitThread", "getChangedPsiRange"));
        }
        if (treeElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeElement", "com/intellij/psi/impl/DocumentCommitThread", "getChangedPsiRange"));
        }
        if (newDocumentText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newDocumentText", "com/intellij/psi/impl/DocumentCommitThread", "getChangedPsiRange"));
        }
        int psiLength = treeElement.getTextLength();
        if (!file2.getViewProvider().supportsIncrementalReparse(file2.getLanguage())) {
            return new TextRange(0, psiLength);
        }
        int commonPrefixLength = DocumentCommitThread.getMatchingLength(treeElement, newDocumentText, true);
        if (commonPrefixLength == newDocumentText.length() && newDocumentText.length() == psiLength) {
            return null;
        }
        int commonSuffixLength = Math.min(DocumentCommitThread.getMatchingLength(treeElement, newDocumentText, false), psiLength - commonPrefixLength);
        return new TextRange(commonPrefixLength, psiLength - commonSuffixLength);
    }

    @Nullable
    private static TextRange getChangedPsiRange(@NotNull PsiFile file2, @NotNull CharSequence oldDocumentText, @NotNull CharSequence newDocumentText) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/DocumentCommitThread", "getChangedPsiRange"));
        }
        if (oldDocumentText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldDocumentText", "com/intellij/psi/impl/DocumentCommitThread", "getChangedPsiRange"));
        }
        if (newDocumentText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newDocumentText", "com/intellij/psi/impl/DocumentCommitThread", "getChangedPsiRange"));
        }
        int psiLength = oldDocumentText.length();
        if (!file2.getViewProvider().supportsIncrementalReparse(file2.getLanguage())) {
            return new TextRange(0, psiLength);
        }
        int commonPrefixLength = StringUtil.commonPrefixLength((CharSequence)oldDocumentText, (CharSequence)newDocumentText);
        if (commonPrefixLength == newDocumentText.length() && newDocumentText.length() == psiLength) {
            return null;
        }
        int commonSuffixLength = Math.min(StringUtil.commonSuffixLength((CharSequence)oldDocumentText, (CharSequence)newDocumentText), psiLength - commonPrefixLength);
        return new TextRange(commonPrefixLength, psiLength - commonSuffixLength);
    }

    public static void doActualPsiChange(final @NotNull PsiFile file2, final @NotNull DiffLog diffLog) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/DocumentCommitThread", "doActualPsiChange"));
        }
        if (diffLog == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diffLog", "com/intellij/psi/impl/DocumentCommitThread", "doActualPsiChange"));
        }
        CodeStyleManager.getInstance((Project)file2.getProject()).performActionWithFormatterDisabled(() -> {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/DocumentCommitThread", "lambda$doActualPsiChange$8"));
            }
            if (diffLog == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diffLog", "com/intellij/psi/impl/DocumentCommitThread", "lambda$doActualPsiChange$8"));
            }
            Object object = PsiLock.LOCK;
            synchronized (object) {
                file2.getViewProvider().beforeContentsSynchronized();
                Document document = file2.getViewProvider().getDocument();
                PsiDocumentManagerBase documentManager = (PsiDocumentManagerBase)PsiDocumentManager.getInstance((Project)file2.getProject());
                PsiToDocumentSynchronizer.DocumentChangeTransaction transaction = documentManager.getSynchronizer().getTransaction(document);
                PsiFileImpl fileImpl = (PsiFileImpl)file2;
                if (transaction == null) {
                    final PomModel model = PomManager.getModel((Project)fileImpl.getProject());
                    model.runTransaction((PomTransaction)new PomTransactionBase((PsiElement)fileImpl, model.getModelAspect(TreeAspect.class)){

                        public PomModelEvent runInner() {
                            return new TreeAspectEvent(model, diffLog.performActualPsiChange(file2));
                        }
                    });
                } else {
                    diffLog.performActualPsiChange(file2);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertAfterCommit(@NotNull Document document, @NotNull PsiFile file2, @NotNull FileElement oldFileNode) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/DocumentCommitThread", "assertAfterCommit"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/DocumentCommitThread", "assertAfterCommit"));
        }
        if (oldFileNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldFileNode", "com/intellij/psi/impl/DocumentCommitThread", "assertAfterCommit"));
        }
        if (oldFileNode.getTextLength() != document.getTextLength()) {
            String documentText = document.getText();
            String fileText = file2.getText();
            boolean sameText = Comparing.equal((String)fileText, (String)documentText);
            LOG.error("commitDocument() left PSI inconsistent: " + DebugUtil.diagnosePsiDocumentInconsistency((PsiElement)file2, document) + "; node.length=" + oldFileNode.getTextLength() + "; doc.text" + (sameText ? "==" : "!=") + "file.text; file name:" + file2.getName() + "; type:" + file2.getFileType() + "; lang:" + file2.getLanguage());
            file2.putUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY, (Object)Boolean.TRUE);
            try {
                BlockSupport blockSupport = BlockSupport.getInstance(file2.getProject());
                DiffLog diffLog = blockSupport.reparseRange(file2, file2.getNode(), new TextRange(0, documentText.length()), documentText, this.createProgressIndicator(), oldFileNode.getText());
                DocumentCommitThread.doActualPsiChange(file2, diffLog);
                if (oldFileNode.getTextLength() != document.getTextLength()) {
                    LOG.error("PSI is broken beyond repair in: " + file2);
                }
            }
            finally {
                file2.putUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY, null);
            }
        }
    }

    private static Lock getDocumentLock(Document document) {
        Lock lock = (Lock)document.getUserData(DOCUMENT_LOCK);
        return lock != null ? lock : (Lock)((UserDataHolderEx)document).putUserDataIfAbsent(DOCUMENT_LOCK, (Object)new ReentrantLock());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelTasksOnProjectDispose(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/DocumentCommitThread", "cancelTasksOnProjectDispose"));
        }
        Object object = this.lock;
        synchronized (object) {
            this.cancelTasksOnProjectDispose(project2, this.documentsToCommit);
            this.cancelTasksOnProjectDispose(project2, this.documentsToApplyInEDT);
        }
    }

    private void cancelTasksOnProjectDispose(@NotNull Project project2, @NotNull HashSetQueue<CommitTask> queue) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/DocumentCommitThread", "cancelTasksOnProjectDispose"));
        }
        if (queue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queue", "com/intellij/psi/impl/DocumentCommitThread", "cancelTasksOnProjectDispose"));
        }
        HashSetQueue.PositionalIterator iterator = queue.iterator();
        while (iterator.hasNext()) {
            CommitTask commitTask = (CommitTask)iterator.next();
            if (commitTask.project != project2) continue;
            iterator.remove();
            commitTask.cancel("project is disposed", this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void lambda$commitUnderProgress$4(Project project2, Document document, @NotNull CommitTask task, PsiDocumentManagerBase documentManager, List finishProcessors) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/psi/impl/DocumentCommitThread", "lambda$commitUnderProgress$4"));
        }
        this.myApplication.assertReadAccessAllowed();
        if (project2.isDisposed()) {
            return;
        }
        Lock lock = DocumentCommitThread.getDocumentLock(document);
        if (!lock.tryLock()) {
            task.cancel("Can't obtain document lock", this);
            return;
        }
        boolean canceled = false;
        try {
            if (documentManager.isCommitted(document)) {
                return;
            }
            if (!task.isStillValid()) {
                canceled = true;
                return;
            }
            FileViewProvider viewProvider = documentManager.getCachedViewProvider(document);
            if (viewProvider == null) {
                finishProcessors.add(this.handleCommitWithoutPsi(documentManager, task));
                return;
            }
            for (Pair<PsiFileImpl, FileASTNode> pair : task.myOldFileNodes) {
                PsiFileImpl file2 = (PsiFileImpl)pair.first;
                if (file2.isValid()) {
                    FileASTNode oldFileNode = (FileASTNode)pair.second;
                    Processor<Document> finishProcessor = this.doCommit(task, file2, oldFileNode);
                    if (finishProcessor == null) continue;
                    finishProcessors.add(finishProcessor);
                    continue;
                }
                if (task.reason.equals(SYNC_COMMIT_REASON)) {
                    throw new PsiInvalidElementAccessException((PsiElement)file2, "File " + file2 + " invalidated during sync commit");
                }
                this.commitAsynchronously(project2, document, "File " + file2 + " invalidated during background commit; task: " + task, task.myCreationModalityState);
            }
        }
        finally {
            lock.unlock();
            if (canceled) {
                task.cancel("Task invalidated", this);
            }
        }
    }

    private class CommitTask {
        @NotNull
        private final Document document;
        @NotNull
        final Project project;
        private final int modificationSequence;
        @NotNull
        final ProgressIndicator indicator;
        @NotNull
        final Object reason;
        @NotNull
        final ModalityState myCreationModalityState;
        private final CharSequence myLastCommittedText;
        @NotNull
        final List<Pair<PsiFileImpl, FileASTNode>> myOldFileNodes;

        CommitTask(@NotNull Project project2, @NotNull Document document, @NotNull List<Pair<PsiFileImpl, FileASTNode>> oldFileNodes, @NotNull ProgressIndicator indicator, @NotNull Object reason, @NotNull ModalityState currentModalityState, CharSequence lastCommittedText) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/DocumentCommitThread$CommitTask", "<init>"));
            }
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/DocumentCommitThread$CommitTask", "<init>"));
            }
            if (oldFileNodes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldFileNodes", "com/intellij/psi/impl/DocumentCommitThread$CommitTask", "<init>"));
            }
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/psi/impl/DocumentCommitThread$CommitTask", "<init>"));
            }
            if (reason == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/intellij/psi/impl/DocumentCommitThread$CommitTask", "<init>"));
            }
            if (currentModalityState == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentModalityState", "com/intellij/psi/impl/DocumentCommitThread$CommitTask", "<init>"));
            }
            if (lastCommittedText == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lastCommittedText", "com/intellij/psi/impl/DocumentCommitThread$CommitTask", "<init>"));
            }
            this.document = document;
            this.project = project2;
            this.indicator = indicator;
            this.reason = reason;
            this.myCreationModalityState = currentModalityState;
            this.myLastCommittedText = lastCommittedText;
            this.myOldFileNodes = oldFileNodes;
            this.modificationSequence = ((DocumentEx)document).getModificationSequence();
        }

        @NonNls
        public String toString() {
            Document document = this.getDocument();
            String docInfo = document + " (\"" + StringUtil.first((CharSequence)document.getImmutableCharSequence(), (int)40, (boolean)true).toString().replaceAll("\n", " ") + "\")";
            String indicatorInfo = this.indicator.isCanceled() ? " (Canceled: " + ((UserDataHolder)this.indicator).getUserData(CANCEL_REASON) + ")" : "";
            String reasonInfo = " Reason: " + this.reason + (this.isStillValid() ? "" : "; changed: old seq=" + this.modificationSequence + ", new seq=" + ((DocumentEx)document).getModificationSequence());
            return "Doc: " + docInfo + indicatorInfo + reasonInfo;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CommitTask)) {
                return false;
            }
            CommitTask task = (CommitTask)o;
            return Comparing.equal((Object)this.getDocument(), (Object)task.getDocument()) && this.project.equals(task.project);
        }

        public int hashCode() {
            int result2 = this.getDocument().hashCode();
            result2 = 31 * result2 + this.project.hashCode();
            return result2;
        }

        boolean isStillValid() {
            Document document = this.getDocument();
            return ((DocumentEx)document).getModificationSequence() == this.modificationSequence;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cancel(@NotNull Object reason, @NotNull DocumentCommitThread commitProcessor) {
            if (reason == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/intellij/psi/impl/DocumentCommitThread$CommitTask", "cancel"));
            }
            if (commitProcessor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitProcessor", "com/intellij/psi/impl/DocumentCommitThread$CommitTask", "cancel"));
            }
            if (!this.indicator.isCanceled()) {
                commitProcessor.log(this.project, "indicator cancel", this, new Object[0]);
                this.indicator.cancel();
                ((UserDataHolder)this.indicator).putUserData(CANCEL_REASON, reason);
                Object object = DocumentCommitThread.this.lock;
                synchronized (object) {
                    DocumentCommitThread.this.documentsToCommit.remove((Object)this);
                    DocumentCommitThread.this.documentsToApplyInEDT.remove((Object)this);
                }
            }
        }

        @NotNull
        Document getDocument() {
            Document document = this.document;
            if (document == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/DocumentCommitThread$CommitTask", "getDocument"));
            }
            return document;
        }
    }
}

