/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import com.intellij.psi.impl.compiled.ClsParsingUtil;
import com.intellij.psi.impl.compiled.InnerClassSourceStrategy;
import com.intellij.psi.impl.compiled.OutOfOrderInnerClassException;
import com.intellij.psi.impl.compiled.SignatureParsing;
import com.intellij.psi.impl.java.stubs.JavaClassReferenceListElementType;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiClassStub;
import com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import com.intellij.psi.impl.java.stubs.PsiMethodStub;
import com.intellij.psi.impl.java.stubs.PsiModifierListStub;
import com.intellij.psi.impl.java.stubs.impl.PsiAnnotationStubImpl;
import com.intellij.psi.impl.java.stubs.impl.PsiClassReferenceListStubImpl;
import com.intellij.psi.impl.java.stubs.impl.PsiClassStubImpl;
import com.intellij.psi.impl.java.stubs.impl.PsiFieldStubImpl;
import com.intellij.psi.impl.java.stubs.impl.PsiMethodStubImpl;
import com.intellij.psi.impl.java.stubs.impl.PsiModifierListStubImpl;
import com.intellij.psi.impl.java.stubs.impl.PsiParameterListStubImpl;
import com.intellij.psi.impl.java.stubs.impl.PsiParameterStubImpl;
import com.intellij.psi.impl.java.stubs.impl.PsiTypeParameterListStubImpl;
import com.intellij.psi.impl.java.stubs.impl.PsiTypeParameterStubImpl;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.BitUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.cls.ClsFormatException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.StringRef;
import gnu.trove.THashSet;
import java.io.IOException;
import java.lang.reflect.Array;
import java.text.StringCharacterIterator;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.TypePath;
import org.jetbrains.org.objectweb.asm.TypeReference;

public class StubBuildingVisitor<T>
extends ClassVisitor {
    private static final Logger LOG = Logger.getInstance(StubBuildingVisitor.class);
    private static final String DOUBLE_POSITIVE_INF = "1.0 / 0.0";
    private static final String DOUBLE_NEGATIVE_INF = "-1.0 / 0.0";
    private static final String DOUBLE_NAN = "0.0d / 0.0";
    private static final String FLOAT_POSITIVE_INF = "1.0f / 0.0";
    private static final String FLOAT_NEGATIVE_INF = "-1.0f / 0.0";
    private static final String FLOAT_NAN = "0.0f / 0.0";
    private static final String SYNTHETIC_CLASS_INIT_METHOD = "<clinit>";
    private static final String SYNTHETIC_INIT_METHOD = "<init>";
    private static final int ASM_API = 393216;
    private final T mySource;
    private final InnerClassSourceStrategy<T> myInnersStrategy;
    private final StubElement myParent;
    private final int myAccess;
    private final String myShortName;
    private final Function<String, String> myMapping;
    private String myInternalName;
    private PsiClassStub myResult;
    private PsiModifierListStub myModList;
    private static final String[] parameterNames = new String[]{"p1", "p2", "p3", "p4", "p5", "p6", "p7", "p8", "p9"};
    public static final Function<String, String> GUESSING_MAPPER = internalName -> {
        String canonicalText = internalName;
        if (canonicalText.indexOf(36) >= 0) {
            StringBuilder sb = new StringBuilder(canonicalText);
            boolean updated = false;
            for (int p = 0; p < sb.length(); ++p) {
                char c = sb.charAt(p);
                if (c != '$' || p <= 0 || sb.charAt(p - 1) == '/' || p >= sb.length() - 1 || sb.charAt(p + 1) == '$') continue;
                sb.setCharAt(p, '.');
                updated = true;
            }
            if (updated) {
                canonicalText = sb.toString();
            }
        }
        return canonicalText.replace('/', '.');
    };

    public StubBuildingVisitor(T classSource, InnerClassSourceStrategy<T> innersStrategy, StubElement parent, int access, String shortName) {
        super(393216);
        this.mySource = classSource;
        this.myInnersStrategy = innersStrategy;
        this.myParent = parent;
        this.myAccess = access;
        this.myShortName = shortName;
        this.myMapping = StubBuildingVisitor.createMapping(classSource);
    }

    public PsiClassStub<?> getResult() {
        return this.myResult;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        ClassInfo info;
        block10: {
            this.myInternalName = name;
            String parentName = this.myParent instanceof PsiClassStub ? ((PsiClassStub)this.myParent).getQualifiedName() : (this.myParent instanceof PsiJavaFileStub ? ((PsiJavaFileStub)this.myParent).getPackageName() : null);
            String fqn = this.getFqn(name, this.myShortName, parentName);
            String shortName = this.myShortName != null && name.endsWith(this.myShortName) ? this.myShortName : PsiNameHelper.getShortClassName((String)fqn);
            int flags = this.myAccess | access;
            boolean isDeprecated = BitUtil.isSet((int)flags, (int)131072);
            boolean isInterface = BitUtil.isSet((int)flags, (int)512);
            boolean isEnum = BitUtil.isSet((int)flags, (int)16384);
            boolean isAnnotationType = BitUtil.isSet((int)flags, (int)8192);
            byte stubFlags = PsiClassStubImpl.packFlags(isDeprecated, isInterface, isEnum, false, false, isAnnotationType, false, false);
            this.myResult = new PsiClassStubImpl(JavaStubElementTypes.CLASS, this.myParent, fqn, shortName, null, stubFlags);
            this.myModList = new PsiModifierListStubImpl((StubElement)this.myResult, StubBuildingVisitor.packClassFlags(flags));
            info = null;
            if (signature != null) {
                try {
                    info = this.parseClassSignature(signature);
                }
                catch (ClsFormatException e) {
                    if (!LOG.isDebugEnabled()) break block10;
                    LOG.debug("source=" + this.mySource + " signature=" + signature, (Throwable)e);
                }
            }
        }
        if (info == null) {
            info = this.parseClassDescription(superName, interfaces);
        }
        PsiTypeParameterListStubImpl typeParameterList = new PsiTypeParameterListStubImpl((StubElement)this.myResult);
        for (Pair parameter : info.typeParameters) {
            PsiTypeParameterStubImpl parameterStub = new PsiTypeParameterStubImpl(typeParameterList, StringRef.fromString((String)((String)parameter.first)));
            StubBuildingVisitor.newReferenceList(JavaStubElementTypes.EXTENDS_BOUND_LIST, (StubElement)parameterStub, (String[])parameter.second);
        }
        if (this.myResult.isInterface()) {
            if (info.interfaceNames != null && this.myResult.isAnnotationType()) {
                info.interfaceNames.remove("java.lang.annotation.Annotation");
            }
            StubBuildingVisitor.newReferenceList(JavaStubElementTypes.EXTENDS_LIST, (StubElement)this.myResult, ArrayUtil.toStringArray((Collection)info.interfaceNames));
            StubBuildingVisitor.newReferenceList(JavaStubElementTypes.IMPLEMENTS_LIST, (StubElement)this.myResult, ArrayUtil.EMPTY_STRING_ARRAY);
        } else {
            if (info.superName == null || "java/lang/Object".equals(superName) || this.myResult.isEnum() && "java/lang/Enum".equals(superName)) {
                StubBuildingVisitor.newReferenceList(JavaStubElementTypes.EXTENDS_LIST, (StubElement)this.myResult, ArrayUtil.EMPTY_STRING_ARRAY);
            } else {
                StubBuildingVisitor.newReferenceList(JavaStubElementTypes.EXTENDS_LIST, (StubElement)this.myResult, new String[]{info.superName});
            }
            StubBuildingVisitor.newReferenceList(JavaStubElementTypes.IMPLEMENTS_LIST, (StubElement)this.myResult, ArrayUtil.toStringArray((Collection)info.interfaceNames));
        }
    }

    private String getFqn(@NotNull String internalName, @Nullable String shortName, @Nullable String parentName) {
        if (internalName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "internalName", "com/intellij/psi/impl/compiled/StubBuildingVisitor", "getFqn"));
        }
        if (shortName == null || !internalName.endsWith(shortName)) {
            return (String)this.myMapping.fun((Object)internalName);
        }
        if (internalName.length() == shortName.length()) {
            return shortName;
        }
        if (parentName == null) {
            parentName = (String)this.myMapping.fun((Object)internalName.substring(0, internalName.length() - shortName.length() - 1));
        }
        return parentName + '.' + shortName;
    }

    private ClassInfo parseClassSignature(String signature) throws ClsFormatException {
        ClassInfo result2 = new ClassInfo();
        StringCharacterIterator iterator = new StringCharacterIterator(signature);
        result2.typeParameters = SignatureParsing.parseTypeParametersDeclaration(iterator, this.myMapping);
        result2.superName = SignatureParsing.parseTopLevelClassRefSignature(iterator, this.myMapping);
        while (iterator.current() != '\uffff') {
            String name = SignatureParsing.parseTopLevelClassRefSignature(iterator, this.myMapping);
            if (name == null) {
                throw new ClsFormatException();
            }
            if (result2.interfaceNames == null) {
                result2.interfaceNames = ContainerUtil.newSmartList();
            }
            result2.interfaceNames.add(name);
        }
        return result2;
    }

    private ClassInfo parseClassDescription(String superClass, String[] superInterfaces) {
        ClassInfo result2 = new ClassInfo();
        result2.typeParameters = ContainerUtil.emptyList();
        result2.superName = superClass != null ? (String)this.myMapping.fun((Object)superClass) : null;
        result2.interfaceNames = superInterfaces == null ? null : ContainerUtil.map((Object[])superInterfaces, name -> (String)this.myMapping.fun(name));
        return result2;
    }

    private static void newReferenceList(@NotNull JavaClassReferenceListElementType type, StubElement parent, @NotNull String[] types) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/compiled/StubBuildingVisitor", "newReferenceList"));
        }
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/intellij/psi/impl/compiled/StubBuildingVisitor", "newReferenceList"));
        }
        new PsiClassReferenceListStubImpl(type, parent, types);
    }

    private static int packCommonFlags(int access) {
        int flags = 0;
        flags = BitUtil.isSet((int)access, (int)2) ? (flags |= 2) : (BitUtil.isSet((int)access, (int)4) ? (flags |= 4) : (BitUtil.isSet((int)access, (int)1) ? (flags |= 1) : (flags |= 0x1000)));
        if (BitUtil.isSet((int)access, (int)8)) {
            flags |= 8;
        }
        if (BitUtil.isSet((int)access, (int)16)) {
            flags |= 0x10;
        }
        return flags;
    }

    private static int packClassFlags(int access) {
        int flags = StubBuildingVisitor.packCommonFlags(access);
        if (BitUtil.isSet((int)access, (int)1024)) {
            flags |= 0x400;
        }
        return flags;
    }

    private static int packFieldFlags(int access) {
        int flags = StubBuildingVisitor.packCommonFlags(access);
        if (BitUtil.isSet((int)access, (int)64)) {
            flags |= 0x40;
        }
        if (BitUtil.isSet((int)access, (int)128)) {
            flags |= 0x80;
        }
        return flags;
    }

    private static int packMethodFlags(int access, boolean isInterface) {
        int flags = StubBuildingVisitor.packCommonFlags(access);
        if (BitUtil.isSet((int)access, (int)32)) {
            flags |= 0x20;
        }
        if (BitUtil.isSet((int)access, (int)256)) {
            flags |= 0x100;
        }
        if (BitUtil.isSet((int)access, (int)2048)) {
            flags |= 0x800;
        }
        if (BitUtil.isSet((int)access, (int)1024)) {
            flags |= 0x400;
        } else if (isInterface && !BitUtil.isSet((int)access, (int)8)) {
            flags |= 0x200;
        }
        return flags;
    }

    public void visitSource(String source, String debug) {
        ((PsiClassStubImpl)this.myResult).setSourceFileName(source);
    }

    public void visitOuterClass(String owner, String name, String desc) {
        if (this.myParent instanceof PsiFileStub) {
            throw new OutOfOrderInnerClassException();
        }
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        return new AnnotationTextCollector(desc, this.myMapping, text -> new PsiAnnotationStubImpl(this.myModList, (String)text));
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        T innerClass;
        if (BitUtil.isSet((int)access, (int)4096)) {
            return;
        }
        if (innerName == null || outerName == null) {
            return;
        }
        if (this.myParent instanceof PsiFileStub && this.myInternalName.equals(name)) {
            throw new OutOfOrderInnerClassException();
        }
        if (this.myInternalName.equals(outerName) && (innerClass = this.myInnersStrategy.findInnerClass(innerName, this.mySource)) != null) {
            this.myInnersStrategy.accept(innerClass, new StubBuildingVisitor<T>(innerClass, this.myInnersStrategy, (StubElement)this.myResult, access, innerName));
        }
    }

    @Nullable
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if (BitUtil.isSet((int)access, (int)4096)) {
            return null;
        }
        if (name == null) {
            return null;
        }
        byte flags = PsiFieldStubImpl.packFlags(BitUtil.isSet((int)access, (int)16384), BitUtil.isSet((int)access, (int)131072), false, false);
        TypeInfo type = this.fieldType(desc, signature);
        String initializer = StubBuildingVisitor.constToString(value, type.text, false, this.myMapping);
        PsiFieldStubImpl stub = new PsiFieldStubImpl((StubElement)this.myResult, name, type, initializer, flags);
        PsiModifierListStubImpl modList = new PsiModifierListStubImpl((StubElement)stub, StubBuildingVisitor.packFieldFlags(access));
        return new FieldAnnotationCollectingVisitor(modList, this.myMapping);
    }

    private TypeInfo fieldType(String desc, String signature) {
        String type;
        block4: {
            type = null;
            if (signature != null) {
                try {
                    type = SignatureParsing.parseTypeString(new StringCharacterIterator(signature), this.myMapping);
                }
                catch (ClsFormatException e) {
                    if (!LOG.isDebugEnabled()) break block4;
                    LOG.debug("source=" + this.mySource + " signature=" + signature, (Throwable)e);
                }
            }
        }
        if (type == null) {
            type = StubBuildingVisitor.toJavaType(Type.getType((String)desc), this.myMapping);
        }
        return TypeInfo.fromString(type, false);
    }

    @Nullable
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        int localVarIgnoreCount;
        boolean generic;
        MethodInfo info;
        String canonicalMethodName;
        byte flags;
        boolean isStatic;
        boolean isVarargs;
        boolean isConstructor;
        boolean isEnum;
        block13: {
            if (BitUtil.isSet((int)access, (int)4096)) {
                return null;
            }
            if (name == null) {
                return null;
            }
            if (SYNTHETIC_CLASS_INIT_METHOD.equals(name)) {
                return null;
            }
            isEnum = this.myResult.isEnum();
            if (isEnum) {
                if ("values".equals(name) && desc.startsWith("()")) {
                    return null;
                }
                if ("valueOf".equals(name) && desc.startsWith("(Ljava/lang/String;)")) {
                    return null;
                }
            }
            isConstructor = SYNTHETIC_INIT_METHOD.equals(name);
            boolean isDeprecated = BitUtil.isSet((int)access, (int)131072);
            isVarargs = BitUtil.isSet((int)access, (int)128);
            isStatic = BitUtil.isSet((int)access, (int)8);
            boolean isAnnotationMethod = this.myResult.isAnnotationType();
            flags = PsiMethodStubImpl.packFlags(isConstructor, isAnnotationMethod, isVarargs, isDeprecated, false, false);
            canonicalMethodName = isConstructor ? this.myResult.getName() : name;
            info = null;
            generic = false;
            if (signature != null) {
                try {
                    info = this.parseMethodSignature(signature, exceptions);
                    generic = true;
                }
                catch (ClsFormatException e) {
                    if (!LOG.isDebugEnabled()) break block13;
                    LOG.debug("source=" + this.mySource + " signature=" + signature, (Throwable)e);
                }
            }
        }
        if (info == null) {
            info = this.parseMethodDescription(desc, exceptions);
        }
        PsiMethodStubImpl stub = new PsiMethodStubImpl((StubElement)this.myResult, canonicalMethodName, TypeInfo.fromString(info.returnType, false), flags, null);
        PsiModifierListStubImpl modList = new PsiModifierListStubImpl((StubElement)stub, StubBuildingVisitor.packMethodFlags(access, this.myResult.isInterface()));
        PsiTypeParameterListStubImpl list = new PsiTypeParameterListStubImpl((StubElement)stub);
        for (Pair parameter : info.typeParameters) {
            PsiTypeParameterStubImpl parameterStub = new PsiTypeParameterStubImpl(list, StringRef.fromString((String)((String)parameter.first)));
            StubBuildingVisitor.newReferenceList(JavaStubElementTypes.EXTENDS_BOUND_LIST, (StubElement)parameterStub, (String[])parameter.second);
        }
        boolean isEnumConstructor = isEnum && isConstructor;
        boolean isInnerClassConstructor = isConstructor && !(this.myParent instanceof PsiFileStub) && !BitUtil.isSet((int)this.myModList.getModifiersMask(), (int)8);
        List args = info.argTypes;
        if (!generic && isEnumConstructor && args.size() >= 2 && "java.lang.String".equals(args.get(0)) && "int".equals(args.get(1))) {
            args = args.subList(2, args.size());
        }
        PsiParameterListStubImpl parameterList = new PsiParameterListStubImpl((StubElement)stub);
        int paramCount = args.size();
        PsiParameterStubImpl[] paramStubs = new PsiParameterStubImpl[paramCount];
        for (int i2 = 0; i2 < paramCount; ++i2) {
            PsiParameterStubImpl parameterStub;
            if (i2 == 0 && !generic && isInnerClassConstructor) continue;
            String arg = (String)args.get(i2);
            boolean isEllipsisParam = isVarargs && i2 == paramCount - 1;
            TypeInfo typeInfo = TypeInfo.fromString(arg, isEllipsisParam);
            String paramName = i2 < parameterNames.length ? parameterNames[i2] : "p" + (i2 + 1);
            paramStubs[i2] = parameterStub = new PsiParameterStubImpl(parameterList, paramName, typeInfo, isEllipsisParam, true);
            new PsiModifierListStubImpl((StubElement)parameterStub, 0);
        }
        StubBuildingVisitor.newReferenceList(JavaStubElementTypes.THROWS_LIST, (StubElement)stub, ArrayUtil.toStringArray((Collection)info.throwTypes));
        int n = isStatic ? 0 : (localVarIgnoreCount = isEnumConstructor ? 3 : 1);
        int paramIgnoreCount = isEnumConstructor ? 2 : (isInnerClassConstructor ? 1 : 0);
        return new MethodAnnotationCollectingVisitor(stub, modList, localVarIgnoreCount, paramIgnoreCount, paramCount, paramStubs, this.myMapping);
    }

    private MethodInfo parseMethodSignature(String signature, String[] exceptions) throws ClsFormatException {
        MethodInfo result2 = new MethodInfo();
        StringCharacterIterator iterator = new StringCharacterIterator(signature);
        result2.typeParameters = SignatureParsing.parseTypeParametersDeclaration(iterator, this.myMapping);
        if (iterator.current() != '(') {
            throw new ClsFormatException();
        }
        iterator.next();
        if (iterator.current() == ')') {
            result2.argTypes = ContainerUtil.emptyList();
        } else {
            result2.argTypes = ContainerUtil.newSmartList();
            while (iterator.current() != ')' && iterator.current() != '\uffff') {
                result2.argTypes.add(SignatureParsing.parseTypeString(iterator, this.myMapping));
            }
            if (iterator.current() != ')') {
                throw new ClsFormatException();
            }
        }
        iterator.next();
        result2.returnType = SignatureParsing.parseTypeString(iterator, this.myMapping);
        result2.throwTypes = null;
        while (iterator.current() == '^') {
            iterator.next();
            if (result2.throwTypes == null) {
                result2.throwTypes = ContainerUtil.newSmartList();
            }
            result2.throwTypes.add(SignatureParsing.parseTypeString(iterator, this.myMapping));
        }
        if (exceptions != null && (result2.throwTypes == null || exceptions.length > result2.throwTypes.size())) {
            result2.throwTypes = ContainerUtil.map((Object[])exceptions, name -> (String)this.myMapping.fun(name));
        }
        return result2;
    }

    private MethodInfo parseMethodDescription(String desc, String[] exceptions) {
        MethodInfo result2 = new MethodInfo();
        result2.typeParameters = ContainerUtil.emptyList();
        result2.returnType = StubBuildingVisitor.toJavaType(Type.getReturnType((String)desc), this.myMapping);
        result2.argTypes = ContainerUtil.map((Object[])Type.getArgumentTypes((String)desc), type -> StubBuildingVisitor.toJavaType(type, this.myMapping));
        result2.throwTypes = exceptions == null ? null : ContainerUtil.map((Object[])exceptions, name -> (String)this.myMapping.fun(name));
        return result2;
    }

    @Nullable
    private static String constToString(@Nullable Object value, @Nullable String type, boolean anno, Function<String, String> mapping) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return "\"" + StringUtil.escapeStringCharacters((String)((String)value)) + "\"";
        }
        if (value instanceof Boolean || value instanceof Short || value instanceof Byte) {
            return value.toString();
        }
        if (value instanceof Character) {
            return "'" + StringUtil.escapeCharCharacters((String)value.toString()) + "'";
        }
        if (value instanceof Long) {
            return value.toString() + 'L';
        }
        if (value instanceof Integer) {
            if ("boolean".equals(type)) {
                if (value.equals(0)) {
                    return "false";
                }
                if (value.equals(1)) {
                    return "true";
                }
            }
            if ("char".equals(type)) {
                char ch = (char)((Integer)value).intValue();
                return "'" + StringUtil.escapeCharCharacters((String)String.valueOf(ch)) + "'";
            }
            return value.toString();
        }
        if (value instanceof Double) {
            double d = (Double)value;
            if (Double.isInfinite(d)) {
                return d > 0.0 ? DOUBLE_POSITIVE_INF : DOUBLE_NEGATIVE_INF;
            }
            if (Double.isNaN(d)) {
                return DOUBLE_NAN;
            }
            return Double.toString(d);
        }
        if (value instanceof Float) {
            float v = ((Float)value).floatValue();
            if (Float.isInfinite(v)) {
                return v > 0.0f ? FLOAT_POSITIVE_INF : FLOAT_NEGATIVE_INF;
            }
            if (Float.isNaN(v)) {
                return FLOAT_NAN;
            }
            return Float.toString(v) + 'f';
        }
        if (value.getClass().isArray()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append('{');
            int length = Array.getLength(value);
            for (int i2 = 0; i2 < length; ++i2) {
                if (i2 > 0) {
                    buffer.append(", ");
                }
                buffer.append(StubBuildingVisitor.constToString(Array.get(value, i2), type, anno, mapping));
            }
            buffer.append('}');
            return buffer.toString();
        }
        if (anno && value instanceof Type) {
            return StubBuildingVisitor.toJavaType((Type)value, mapping) + ".class";
        }
        return null;
    }

    private static String toJavaType(Type type, Function<String, String> mapping) {
        String text;
        int dimensions = 0;
        if (type.getSort() == 9) {
            dimensions = type.getDimensions();
            type = type.getElementType();
        }
        String string = text = type.getSort() == 10 ? (String)mapping.fun((Object)type.getInternalName()) : type.getClassName();
        if (dimensions > 0) {
            text = text + StringUtil.repeat((String)"[]", (int)dimensions);
        }
        return text;
    }

    private static Function<String, String> createMapping(Object classSource) {
        Function<String, String> mapping;
        byte[] bytes = null;
        if (classSource instanceof ClsFileImpl.FileContentPair) {
            bytes = ((ClsFileImpl.FileContentPair)((Object)classSource)).getContent();
        } else if (classSource instanceof VirtualFile) {
            try {
                bytes = ((VirtualFile)classSource).contentsToByteArray(false);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (bytes != null && (mapping = StubBuildingVisitor.createMapping(bytes)) != null) {
            return mapping;
        }
        return GUESSING_MAPPER;
    }

    private static Function<String, String> createMapping(byte[] classBytes) {
        final HashMap mapping = ContainerUtil.newHashMap();
        try {
            new ClassReader(classBytes).accept(new ClassVisitor(393216){

                public void visitInnerClass(String name, String outerName, String innerName, int access) {
                    if (outerName != null && innerName != null) {
                        mapping.put(name, Pair.pair((Object)outerName, (Object)innerName));
                    }
                }
            }, ClsFileImpl.EMPTY_ATTRIBUTES, 7);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!mapping.isEmpty()) {
            return new Function<String, String>(){

                public String fun(String internalName) {
                    String className = internalName;
                    if (className.indexOf(36) >= 0) {
                        Pair p = (Pair)mapping.get(className);
                        if (p == null) {
                            return (String)GUESSING_MAPPER.fun((Object)className);
                        }
                        className = (String)p.first;
                        if (p.second != null) {
                            className = this.fun((String)p.first) + '.' + (String)p.second;
                            mapping.put(className, Pair.pair((Object)className, (Object)null));
                        }
                    }
                    return className.replace('/', '.');
                }
            };
        }
        return null;
    }

    public static AnnotationVisitor getAnnotationTextCollector(String desc, Consumer<String> consumer) {
        return new AnnotationTextCollector(desc, GUESSING_MAPPER, consumer);
    }

    private static class MethodAnnotationCollectingVisitor
    extends MethodVisitor {
        private final PsiMethodStub myOwner;
        private final PsiModifierListStub myModList;
        private final int myIgnoreCount;
        private final int myParamIgnoreCount;
        private final int myParamCount;
        private final PsiParameterStubImpl[] myParamStubs;
        private final Function<String, String> myMapping;
        private int myUsedParamSize;
        private int myUsedParamCount;
        private List<Set<String>> myFilters;

        private MethodAnnotationCollectingVisitor(PsiMethodStub owner, PsiModifierListStub modList, int ignoreCount, int paramIgnoreCount, int paramCount, PsiParameterStubImpl[] paramStubs, Function<String, String> mapping) {
            super(393216);
            this.myOwner = owner;
            this.myModList = modList;
            this.myIgnoreCount = ignoreCount;
            this.myParamIgnoreCount = paramIgnoreCount;
            this.myParamCount = paramCount;
            this.myParamStubs = paramStubs;
            this.myMapping = mapping;
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return new AnnotationTextCollector(desc, this.myMapping, text -> {
                this.filter(0, (String)text);
                new PsiAnnotationStubImpl(this.myModList, (String)text);
            });
        }

        @Nullable
        public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
            return parameter < this.myParamIgnoreCount ? null : new AnnotationTextCollector(desc, this.myMapping, text -> {
                int idx = parameter - this.myParamIgnoreCount;
                this.filter(idx + 1, (String)text);
                new PsiAnnotationStubImpl(this.myOwner.findParameter(idx).getModList(), (String)text);
            });
        }

        public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            TypeReference ref = new TypeReference(typeRef);
            return new AnnotationTextCollector(desc, this.myMapping, text -> {
                int idx;
                if (ref.getSort() == 20 && typePath == null && !this.filtered(0, (String)text)) {
                    new PsiAnnotationStubImpl(this.myModList, (String)text);
                } else if (ref.getSort() == 22 && typePath == null && !this.filtered((idx = ref.getFormalParameterIndex()) + 1, (String)text)) {
                    new PsiAnnotationStubImpl(this.myOwner.findParameter(idx).getModList(), (String)text);
                }
            });
        }

        public AnnotationVisitor visitAnnotationDefault() {
            return new AnnotationTextCollector(null, this.myMapping, text -> ((PsiMethodStubImpl)this.myOwner).setDefaultValueText((String)text));
        }

        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
            if (index >= this.myIgnoreCount) {
                PsiParameterStubImpl parameterStub;
                int paramIndex;
                int n = paramIndex = index - this.myIgnoreCount == this.myUsedParamSize ? this.myUsedParamCount : index - this.myIgnoreCount;
                if (paramIndex >= this.myParamCount) {
                    return;
                }
                if (ClsParsingUtil.isJavaIdentifier(name, LanguageLevel.HIGHEST) && (parameterStub = this.myParamStubs[paramIndex]) != null) {
                    parameterStub.setName(name);
                }
                this.myUsedParamCount = paramIndex + 1;
                this.myUsedParamSize += "D".equals(desc) || "J".equals(desc) ? 2 : 1;
            }
        }

        private void filter(int index, String text) {
            THashSet filter;
            if (this.myFilters == null) {
                this.myFilters = ContainerUtil.newArrayListWithCapacity((int)(this.myParamCount + 1));
                for (int i2 = 0; i2 < this.myParamCount + 1; ++i2) {
                    this.myFilters.add(null);
                }
            }
            if ((filter = this.myFilters.get(index)) == null) {
                filter = ContainerUtil.newTroveSet();
                this.myFilters.set(index, (Set<String>)filter);
            }
            filter.add((String)text);
        }

        private boolean filtered(int index, String text) {
            return this.myFilters != null && this.myFilters.get(index) != null && this.myFilters.get(index).contains(text);
        }
    }

    private static class FieldAnnotationCollectingVisitor
    extends FieldVisitor {
        private final PsiModifierListStub myModList;
        private final Function<String, String> myMapping;
        private Set<String> myFilter;

        private FieldAnnotationCollectingVisitor(PsiModifierListStub modList, Function<String, String> mapping) {
            super(393216);
            this.myModList = modList;
            this.myMapping = mapping;
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return new AnnotationTextCollector(desc, this.myMapping, text -> {
                if (this.myFilter == null) {
                    this.myFilter = ContainerUtil.newTroveSet();
                }
                this.myFilter.add((String)text);
                new PsiAnnotationStubImpl(this.myModList, (String)text);
            });
        }

        public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            return new AnnotationTextCollector(desc, this.myMapping, text -> {
                if (!(typePath != null || this.myFilter != null && this.myFilter.contains(text))) {
                    new PsiAnnotationStubImpl(this.myModList, (String)text);
                }
            });
        }
    }

    private static class AnnotationTextCollector
    extends AnnotationVisitor {
        private final StringBuilder myBuilder = new StringBuilder();
        private final Function<String, String> myMapping;
        private final Consumer<String> myCallback;
        private boolean hasPrefix;
        private boolean hasParams;

        private AnnotationTextCollector(@Nullable String desc, Function<String, String> mapping, Consumer<String> callback) {
            super(393216);
            this.myMapping = mapping;
            this.myCallback = callback;
            if (desc != null) {
                this.hasPrefix = true;
                this.myBuilder.append('@').append(StubBuildingVisitor.toJavaType(Type.getType((String)desc), (Function<String, String>)this.myMapping));
            }
        }

        public void visit(String name, Object value) {
            this.valuePairPrefix(name);
            this.myBuilder.append(StubBuildingVisitor.constToString(value, null, true, (Function<String, String>)this.myMapping));
        }

        public void visitEnum(String name, String desc, String value) {
            this.valuePairPrefix(name);
            this.myBuilder.append(StubBuildingVisitor.toJavaType(Type.getType((String)desc), (Function<String, String>)this.myMapping)).append('.').append(value);
        }

        private void valuePairPrefix(String name) {
            if (!this.hasParams) {
                this.hasParams = true;
                if (this.hasPrefix) {
                    this.myBuilder.append('(');
                }
            } else {
                this.myBuilder.append(',');
            }
            if (name != null) {
                this.myBuilder.append(name).append('=');
            }
        }

        public AnnotationVisitor visitAnnotation(String name, String desc) {
            this.valuePairPrefix(name);
            return new AnnotationTextCollector(desc, this.myMapping, (Consumer<String>)((Consumer)text -> this.myBuilder.append((String)text)));
        }

        public AnnotationVisitor visitArray(String name) {
            this.valuePairPrefix(name);
            this.myBuilder.append('{');
            return new AnnotationTextCollector(null, this.myMapping, (Consumer<String>)((Consumer)text -> this.myBuilder.append((String)text).append('}')));
        }

        public void visitEnd() {
            if (this.hasPrefix && this.hasParams) {
                this.myBuilder.append(')');
            }
            this.myCallback.consume((Object)this.myBuilder.toString());
        }
    }

    private static class MethodInfo {
        private List<Pair<String, String[]>> typeParameters;
        private String returnType;
        private List<String> argTypes;
        private List<String> throwTypes;

        private MethodInfo() {
        }
    }

    private static class ClassInfo {
        private List<Pair<String, String[]>> typeParameters;
        private String superName;
        private List<String> interfaceNames;

        private ClassInfo() {
        }
    }
}

