/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.file.impl;

import com.intellij.ProjectTopics;
import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.PackageIndex;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.file.PsiPackageImpl;
import com.intellij.psi.impl.file.impl.JavaFileManager;
import com.intellij.psi.impl.java.stubs.index.JavaAutoModuleNameIndex;
import com.intellij.psi.impl.java.stubs.index.JavaFullClassNameIndex;
import com.intellij.psi.impl.java.stubs.index.JavaModuleNameIndex;
import com.intellij.psi.impl.light.LightJavaModule;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class JavaFileManagerImpl
implements JavaFileManager,
Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.file.impl.JavaFileManagerImpl");
    private final PsiManagerEx myManager;
    private volatile Set<String> myNontrivialPackagePrefixes;
    private boolean myDisposed;
    private final PackageIndex myPackageIndex;

    public JavaFileManagerImpl(Project project2) {
        this.myManager = PsiManagerEx.getInstanceEx(project2);
        this.myPackageIndex = PackageIndex.getInstance((Project)this.myManager.getProject());
        project2.getMessageBus().connect().subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(ModuleRootEvent event) {
                JavaFileManagerImpl.this.myNontrivialPackagePrefixes = null;
            }
        });
    }

    public void dispose() {
        this.myDisposed = true;
    }

    @Override
    @Nullable
    public PsiPackage findPackage(@NotNull String packageName) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/psi/impl/file/impl/JavaFileManagerImpl", "findPackage"));
        }
        Query dirs = this.myPackageIndex.getDirsByPackageName(packageName, true);
        if (dirs.findFirst() == null) {
            return null;
        }
        return new PsiPackageImpl(this.myManager, packageName);
    }

    @Override
    @NotNull
    public PsiClass[] findClasses(@NotNull String qName, @NotNull GlobalSearchScope scope) {
        if (qName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qName", "com/intellij/psi/impl/file/impl/JavaFileManagerImpl", "findClasses"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/file/impl/JavaFileManagerImpl", "findClasses"));
        }
        List<Pair<PsiClass, VirtualFile>> result2 = this.doFindClasses(qName, scope);
        int count = result2.size();
        if (count == 0) {
            if (PsiClass.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/impl/JavaFileManagerImpl", "findClasses"));
            }
            return PsiClass.EMPTY_ARRAY;
        }
        if (count == 1) {
            PsiClass[] psiClassArray = new PsiClass[]{(PsiClass)result2.get(0).getFirst()};
            if (psiClassArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/impl/JavaFileManagerImpl", "findClasses"));
            }
            return psiClassArray;
        }
        ContainerUtil.quickSort(result2, (o1, o2) -> {
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/file/impl/JavaFileManagerImpl", "lambda$findClasses$0"));
            }
            return scope.compare((VirtualFile)o2.getSecond(), (VirtualFile)o1.getSecond());
        });
        PsiClass[] psiClassArray = (PsiClass[])result2.stream().map(p -> (PsiClass)p.getFirst()).toArray(PsiClass[]::new);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/impl/JavaFileManagerImpl", "findClasses"));
        }
        return psiClassArray;
    }

    @NotNull
    private List<Pair<PsiClass, VirtualFile>> doFindClasses(@NotNull String qName, @NotNull GlobalSearchScope scope) {
        if (qName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qName", "com/intellij/psi/impl/file/impl/JavaFileManagerImpl", "doFindClasses"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/file/impl/JavaFileManagerImpl", "doFindClasses"));
        }
        Collection<PsiClass> classes = JavaFullClassNameIndex.getInstance().get(qName.hashCode(), this.myManager.getProject(), scope);
        if (classes.isEmpty()) {
            List<Pair<PsiClass, VirtualFile>> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/impl/JavaFileManagerImpl", "doFindClasses"));
            }
            return list;
        }
        ArrayList<Pair<PsiClass, VirtualFile>> result2 = new ArrayList<Pair<PsiClass, VirtualFile>>(classes.size());
        for (PsiClass aClass : classes) {
            String qualifiedName = aClass.getQualifiedName();
            if (qualifiedName == null || !qualifiedName.equals(qName)) continue;
            PsiFile file2 = aClass.getContainingFile();
            if (file2 == null) {
                throw new AssertionError((Object)("No file for class: " + aClass + " of " + aClass.getClass()));
            }
            boolean valid = file2.isValid();
            VirtualFile vFile = file2.getVirtualFile();
            if (!valid) {
                LOG.error("Invalid file " + file2 + "; virtualFile:" + vFile + (vFile != null && !vFile.isValid() ? " (invalid)" : "") + "; id=" + (vFile == null ? 0 : ((VirtualFileWithId)vFile).getId()), (Throwable)new PsiInvalidElementAccessException((PsiElement)aClass));
                continue;
            }
            if (!this.hasAcceptablePackage(vFile)) continue;
            result2.add((Pair<PsiClass, VirtualFile>)Pair.create((Object)aClass, (Object)vFile));
        }
        ArrayList<Pair<PsiClass, VirtualFile>> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/impl/JavaFileManagerImpl", "doFindClasses"));
        }
        return arrayList;
    }

    @Override
    @Nullable
    public PsiClass findClass(@NotNull String qName, @NotNull GlobalSearchScope scope) {
        if (qName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qName", "com/intellij/psi/impl/file/impl/JavaFileManagerImpl", "findClass"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/file/impl/JavaFileManagerImpl", "findClass"));
        }
        LOG.assertTrue(!this.myDisposed);
        VirtualFile bestFile = null;
        PsiClass bestClass = null;
        List<Pair<PsiClass, VirtualFile>> result2 = this.doFindClasses(qName, scope);
        for (int i = 0; i < result2.size(); ++i) {
            Pair<PsiClass, VirtualFile> pair = result2.get(i);
            VirtualFile vFile = (VirtualFile)pair.getSecond();
            if (bestFile != null && scope.compare(vFile, bestFile) <= 0) continue;
            bestFile = vFile;
            bestClass = (PsiClass)pair.getFirst();
        }
        return bestClass;
    }

    private boolean hasAcceptablePackage(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/psi/impl/file/impl/JavaFileManagerImpl", "hasAcceptablePackage"));
        }
        if (vFile.getFileType() == JavaClassFileType.INSTANCE) {
            VirtualFile root = ProjectRootManager.getInstance((Project)this.myManager.getProject()).getFileIndex().getClassRootForFile(vFile);
            PsiNameHelper nameHelper = PsiNameHelper.getInstance((Project)this.myManager.getProject());
            for (VirtualFile parent = vFile.getParent(); parent != null && !Comparing.equal((Object)parent, (Object)root); parent = parent.getParent()) {
                if (nameHelper.isIdentifier(parent.getName())) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    @NotNull
    public Collection<String> getNonTrivialPackagePrefixes() {
        Set<String> names = this.myNontrivialPackagePrefixes;
        if (names == null) {
            names = new HashSet<String>();
            ProjectRootManager rootManager = ProjectRootManager.getInstance((Project)this.myManager.getProject());
            List sourceRoots = rootManager.getModuleSourceRoots(JavaModuleSourceRootTypes.SOURCES);
            ProjectFileIndex fileIndex = rootManager.getFileIndex();
            for (VirtualFile sourceRoot : sourceRoots) {
                String packageName;
                if (!sourceRoot.isDirectory() || (packageName = fileIndex.getPackageNameByDirectory(sourceRoot)) == null || packageName.isEmpty()) continue;
                names.add(packageName);
            }
            this.myNontrivialPackagePrefixes = names;
        }
        Set<String> set2 = names;
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/impl/JavaFileManagerImpl", "getNonTrivialPackagePrefixes"));
        }
        return set2;
    }

    @Override
    @NotNull
    public Collection<PsiJavaModule> findModules(@NotNull String moduleName, @NotNull GlobalSearchScope scope) {
        List<PsiJavaModule> automatic;
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/intellij/psi/impl/file/impl/JavaFileManagerImpl", "findModules"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/file/impl/JavaFileManagerImpl", "findModules"));
        }
        Collection<PsiJavaModule> named = JavaModuleNameIndex.getInstance().get(moduleName, this.myManager.getProject(), scope);
        if (!named.isEmpty()) {
            Collection<PsiJavaModule> collection = named;
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/impl/JavaFileManagerImpl", "findModules"));
            }
            return collection;
        }
        Collection<VirtualFile> jars = JavaAutoModuleNameIndex.getFilesByKey(moduleName, scope);
        if (!jars.isEmpty() && !(automatic = jars.stream().map(f -> LightJavaModule.getModule(this.myManager, f)).collect(Collectors.toList())).isEmpty()) {
            List<PsiJavaModule> list = automatic;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/impl/JavaFileManagerImpl", "findModules"));
            }
            return list;
        }
        List<PsiJavaModule> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/impl/JavaFileManagerImpl", "findModules"));
        }
        return list;
    }
}

