/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.cache.TodoCacheManager;
import com.intellij.psi.impl.search.IndexPatternSearcher;
import com.intellij.psi.search.IndexPattern;
import com.intellij.psi.search.IndexPatternProvider;
import com.intellij.psi.search.searches.IndexPatternSearch;
import org.jetbrains.annotations.NotNull;

public class IndexPatternSearchImpl
extends IndexPatternSearch {
    public IndexPatternSearchImpl() {
        this.registerExecutor(new IndexPatternSearcher());
    }

    protected int getOccurrencesCountImpl(@NotNull PsiFile file2, @NotNull IndexPatternProvider provider) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/search/IndexPatternSearchImpl", "getOccurrencesCountImpl"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/psi/impl/search/IndexPatternSearchImpl", "getOccurrencesCountImpl"));
        }
        int count = TodoCacheManager.SERVICE.getInstance(file2.getProject()).getTodoCount(file2.getVirtualFile(), provider);
        if (count != -1) {
            return count;
        }
        return IndexPatternSearchImpl.search((PsiFile)file2, (IndexPatternProvider)provider).findAll().size();
    }

    protected int getOccurrencesCountImpl(@NotNull PsiFile file2, @NotNull IndexPattern pattern) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/search/IndexPatternSearchImpl", "getOccurrencesCountImpl"));
        }
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/psi/impl/search/IndexPatternSearchImpl", "getOccurrencesCountImpl"));
        }
        int count = TodoCacheManager.SERVICE.getInstance(file2.getProject()).getTodoCount(file2.getVirtualFile(), pattern);
        if (count != -1) {
            return count;
        }
        return IndexPatternSearchImpl.search((PsiFile)file2, (IndexPattern)pattern).findAll().size();
    }
}

