/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.compiler.CompilerDirectHierarchyInfo;
import com.intellij.compiler.CompilerReferenceService;
import com.intellij.concurrency.JobLauncher;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.impl.java.stubs.index.JavaAnonymousClassBaseRefOccurenceIndex;
import com.intellij.psi.impl.java.stubs.index.JavaSuperClassNameOccurenceIndex;
import com.intellij.psi.impl.search.HighlightingCaches;
import com.intellij.psi.impl.search.JavaClassInheritorsSearcher;
import com.intellij.psi.impl.search.StubHierarchyInheritorSearcher;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopeUtil;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AllClassesSearch;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class JavaDirectInheritorsSearcher
implements QueryExecutor<PsiClass, DirectClassInheritorsSearch.SearchParameters> {
    public boolean execute(@NotNull DirectClassInheritorsSearch.SearchParameters parameters, @NotNull Processor<PsiClass> consumer) {
        SearchScope useScope;
        SearchScope scope;
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "execute"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "execute"));
        }
        PsiClass baseClass = parameters.getClassToProcess();
        assert (parameters.isCheckInheritance());
        Project project2 = PsiUtilCore.getProjectInReadAction((PsiElement)baseClass);
        if (JavaClassInheritorsSearcher.isJavaLangObject(baseClass)) {
            SearchScope useScope2 = (SearchScope)ReadAction.compute(() -> ((PsiClass)baseClass).getUseScope());
            return AllClassesSearch.search((SearchScope)useScope2, (Project)project2).forEach(psiClass -> {
                if (consumer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "lambda$execute$0"));
                }
                ProgressManager.checkCanceled();
                if (psiClass.isInterface()) {
                    return consumer.process(psiClass);
                }
                PsiClass superClass = psiClass.getSuperClass();
                return superClass == null || !JavaClassInheritorsSearcher.isJavaLangObject(superClass) || consumer.process(psiClass);
            });
        }
        CompilerDirectHierarchyInfo info = JavaDirectInheritorsSearcher.performSearchUsingCompilerIndices(parameters, parameters.getScope(), project2);
        if (info == null) {
            scope = parameters.getScope();
            useScope = (SearchScope)ReadAction.compute(() -> ((PsiClass)baseClass).getUseScope());
        } else {
            if (!JavaDirectInheritorsSearcher.processInheritorCandidates(info.getHierarchyChildren(), consumer, parameters.includeAnonymous())) {
                return false;
            }
            scope = (SearchScope)ReadAction.compute(() -> {
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "lambda$execute$1"));
                }
                return parameters.getScope().intersectWith((SearchScope)info.getDirtyScope());
            });
            useScope = (SearchScope)ReadAction.compute(() -> baseClass.getUseScope().intersectWith((SearchScope)info.getDirtyScope()));
        }
        PsiClass[] cache = JavaDirectInheritorsSearcher.getOrCalculateDirectSubClasses(project2, baseClass, useScope);
        if (cache.length == 0) {
            return true;
        }
        VirtualFile baseClassJarFile = null;
        int groupStart = 0;
        boolean sameJarClassFound = false;
        String currentFQN = null;
        boolean[] isOutOfScope = new boolean[cache.length];
        for (int i = 0; i <= cache.length; ++i) {
            String fqn;
            PsiClass subClass;
            ProgressManager.checkCanceled();
            PsiClass psiClass2 = subClass = i == cache.length ? null : cache[i];
            if (subClass instanceof PsiAnonymousClass && !parameters.includeAnonymous()) {
                return true;
            }
            if (i != cache.length && !JavaDirectInheritorsSearcher.isInScope(scope, subClass)) {
                isOutOfScope[i] = true;
                continue;
            }
            String string = fqn = i == cache.length ? null : (String)ReadAction.compute(() -> ((PsiClass)subClass).getQualifiedName());
            if (currentFQN != null && Comparing.equal((String)fqn, (String)currentFQN)) {
                boolean fromSameJar;
                VirtualFile currentJarFile = JavaDirectInheritorsSearcher.getJarFile(subClass);
                if (baseClassJarFile == null) {
                    baseClassJarFile = JavaDirectInheritorsSearcher.getJarFile(baseClass);
                }
                if (!(fromSameJar = Comparing.equal((Object)currentJarFile, (Object)baseClassJarFile))) continue;
                if (!consumer.process((Object)subClass)) {
                    return false;
                }
                sameJarClassFound = true;
                continue;
            }
            currentFQN = fqn;
            if (!sameJarClassFound) {
                for (int g = groupStart; g < i; ++g) {
                    PsiClass subClassCandidate;
                    ProgressManager.checkCanceled();
                    if (isOutOfScope[g] || consumer.process((Object)(subClassCandidate = cache[g]))) continue;
                    return false;
                }
            }
            groupStart = i;
            sameJarClassFound = false;
        }
        return true;
    }

    private static boolean isInScope(@NotNull SearchScope scope, @NotNull PsiClass subClass) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "isInScope"));
        }
        if (subClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subClass", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "isInScope"));
        }
        return (Boolean)ReadAction.compute(() -> {
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "lambda$isInScope$3"));
            }
            if (subClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subClass", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "lambda$isInScope$3"));
            }
            return PsiSearchScopeUtil.isInScope((SearchScope)scope, (PsiElement)subClass);
        });
    }

    @NotNull
    private static PsiClass[] getOrCalculateDirectSubClasses(@NotNull Project project2, @NotNull PsiClass baseClass, @NotNull SearchScope useScope) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "getOrCalculateDirectSubClasses"));
        }
        if (baseClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "getOrCalculateDirectSubClasses"));
        }
        if (useScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "useScope", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "getOrCalculateDirectSubClasses"));
        }
        ConcurrentMap<PsiClass, PsiClass[]> map = HighlightingCaches.getInstance((Project)project2).DIRECT_SUB_CLASSES;
        PsiClass[] cache = (PsiClass[])map.get(baseClass);
        if (cache != null) {
            if (cache == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "getOrCalculateDirectSubClasses"));
            }
            return cache;
        }
        String baseClassName = (String)ReadAction.compute(() -> ((PsiClass)baseClass).getName());
        if (StringUtil.isEmpty((String)baseClassName)) {
            if (PsiClass.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "getOrCalculateDirectSubClasses"));
            }
            return PsiClass.EMPTY_ARRAY;
        }
        cache = JavaDirectInheritorsSearcher.calculateDirectSubClasses(project2, baseClass, baseClassName, useScope);
        if (((Boolean)ReadAction.compute(() -> ((PsiClass)baseClass).isPhysical())).booleanValue()) {
            cache = (PsiClass[])ConcurrencyUtil.cacheOrGet(map, (Object)baseClass, (Object)cache);
        }
        if (cache == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "getOrCalculateDirectSubClasses"));
        }
        return cache;
    }

    private static <T> boolean processConcurrentlyIfTooMany(@NotNull Collection<T> collection, @NotNull Processor<? super T> processor2) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "processConcurrentlyIfTooMany"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "processConcurrentlyIfTooMany"));
        }
        int size = collection.size();
        if (size == 0) {
            return true;
        }
        if (size > 100) {
            return JobLauncher.getInstance().invokeConcurrentlyUnderProgress(new ArrayList<T>(collection), ProgressIndicatorProvider.getGlobalProgressIndicator(), true, processor2);
        }
        return ContainerUtil.process(collection, processor2);
    }

    @NotNull
    private static PsiClass[] calculateDirectSubClasses(@NotNull Project project2, @NotNull PsiClass baseClass, @NotNull String baseClassName, @NotNull SearchScope useScope) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "calculateDirectSubClasses"));
        }
        if (baseClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "calculateDirectSubClasses"));
        }
        if (baseClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClassName", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "calculateDirectSubClasses"));
        }
        if (useScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "useScope", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "calculateDirectSubClasses"));
        }
        DumbService dumbService = DumbService.getInstance((Project)project2);
        GlobalSearchScope globalUseScope = (GlobalSearchScope)dumbService.runReadActionInSmartMode(() -> {
            if (useScope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "useScope", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "lambda$calculateDirectSubClasses$4"));
            }
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "lambda$calculateDirectSubClasses$4"));
            }
            return StubHierarchyInheritorSearcher.restrictScope(GlobalSearchScopeUtil.toGlobalSearchScope(useScope, project2));
        });
        Collection candidates = (Collection)dumbService.runReadActionInSmartMode(() -> {
            if (baseClassName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClassName", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "lambda$calculateDirectSubClasses$5"));
            }
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "lambda$calculateDirectSubClasses$5"));
            }
            return JavaSuperClassNameOccurenceIndex.getInstance().get(baseClassName, project2, globalUseScope);
        });
        HashMap classesWithFqn = new HashMap();
        JavaDirectInheritorsSearcher.processConcurrentlyIfTooMany(candidates, arg_0 -> JavaDirectInheritorsSearcher.lambda$calculateDirectSubClasses$7(baseClass, (Map)classesWithFqn, arg_0));
        ArrayList<Object> result2 = new ArrayList<Object>();
        for (Object value : classesWithFqn.values()) {
            if (value instanceof PsiClass) {
                result2.add((PsiClass)value);
                continue;
            }
            List list = (List)value;
            result2.addAll(list);
        }
        Collection anonymousCandidates = (Collection)dumbService.runReadActionInSmartMode(() -> {
            if (baseClassName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClassName", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "lambda$calculateDirectSubClasses$8"));
            }
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "lambda$calculateDirectSubClasses$8"));
            }
            return JavaAnonymousClassBaseRefOccurenceIndex.getInstance().get(baseClassName, project2, globalUseScope);
        });
        JavaDirectInheritorsSearcher.processConcurrentlyIfTooMany(anonymousCandidates, candidate -> {
            if (baseClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "lambda$calculateDirectSubClasses$10"));
            }
            boolean isInheritor = (Boolean)dumbService.runReadActionInSmartMode(() -> {
                if (baseClass == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "lambda$null$9"));
                }
                return candidate.isInheritor(baseClass, false);
            });
            if (isInheritor) {
                List list = result2;
                synchronized (list) {
                    result2.add(candidate);
                }
            }
            return true;
        });
        boolean isEnum = (Boolean)ReadAction.compute(() -> ((PsiClass)baseClass).isEnum());
        if (isEnum) {
            PsiField[] fields;
            for (PsiField field : fields = (PsiField[])ReadAction.compute(() -> ((PsiClass)baseClass).getFields())) {
                ProgressManager.checkCanceled();
                if (!(field instanceof PsiEnumConstant)) continue;
                PsiEnumConstantInitializer initializingClass = (PsiEnumConstantInitializer)ReadAction.compute(() -> ((PsiEnumConstant)((PsiEnumConstant)field)).getInitializingClass());
                if (initializingClass == null) continue;
                result2.add(initializingClass);
            }
        }
        PsiClass[] psiClassArray = result2.isEmpty() ? PsiClass.EMPTY_ARRAY : result2.toArray(new PsiClass[result2.size()]);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "calculateDirectSubClasses"));
        }
        return psiClassArray;
    }

    private static VirtualFile getJarFile(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "getJarFile"));
        }
        return (VirtualFile)ReadAction.compute(() -> {
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "lambda$getJarFile$11"));
            }
            return PsiUtil.getJarFile((PsiElement)aClass);
        });
    }

    private static CompilerDirectHierarchyInfo performSearchUsingCompilerIndices(@NotNull DirectClassInheritorsSearch.SearchParameters parameters, @NotNull SearchScope useScope, @NotNull Project project2) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "performSearchUsingCompilerIndices"));
        }
        if (useScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "useScope", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "performSearchUsingCompilerIndices"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "performSearchUsingCompilerIndices"));
        }
        if (!(useScope instanceof GlobalSearchScope)) {
            return null;
        }
        SearchScope scope = parameters.getScope();
        if (!(scope instanceof GlobalSearchScope)) {
            return null;
        }
        PsiClass searchClass = (PsiClass)ReadAction.compute(() -> {
            if (parameters == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "lambda$performSearchUsingCompilerIndices$12"));
            }
            return (PsiClass)PsiUtil.preferCompiledElement((PsiModifierListOwner)parameters.getClassToProcess());
        });
        CompilerReferenceService compilerReferenceService = CompilerReferenceService.getInstance(project2);
        return compilerReferenceService.getDirectInheritors((PsiNamedElement)searchClass, (GlobalSearchScope)useScope, (GlobalSearchScope)scope, (FileType)JavaFileType.INSTANCE);
    }

    private static boolean processInheritorCandidates(@NotNull Stream<PsiElement> classStream, @NotNull Processor<PsiClass> consumer, boolean acceptAnonymous) {
        if (classStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classStream", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "processInheritorCandidates"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "processInheritorCandidates"));
        }
        if (!acceptAnonymous) {
            classStream = classStream.filter(c -> !(c instanceof PsiAnonymousClass));
        }
        return ContainerUtil.process(classStream.iterator(), e -> {
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "lambda$processInheritorCandidates$14"));
            }
            ProgressManager.checkCanceled();
            PsiClass c = (PsiClass)e;
            return consumer.process((Object)c);
        });
    }

    private static /* synthetic */ boolean lambda$calculateDirectSubClasses$7(@NotNull PsiClass baseClass, Map classesWithFqn, PsiReferenceList referenceList) {
        if (baseClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "lambda$calculateDirectSubClasses$7"));
        }
        ProgressManager.checkCanceled();
        ApplicationManager.getApplication().runReadAction(() -> {
            if (baseClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher", "lambda$null$6"));
            }
            PsiClass candidate = (PsiClass)referenceList.getParent();
            boolean isInheritor = candidate.isInheritor(baseClass, false);
            if (isInheritor) {
                String fqn = candidate.getQualifiedName();
                Map map = classesWithFqn;
                synchronized (map) {
                    Object value = classesWithFqn.get(fqn);
                    if (value == null) {
                        classesWithFqn.put(fqn, candidate);
                    } else if (value instanceof PsiClass) {
                        ArrayList<PsiClass> list = new ArrayList<PsiClass>();
                        list.add((PsiClass)value);
                        list.add(candidate);
                        classesWithFqn.put(fqn, list);
                    } else {
                        List list = (List)value;
                        list.add(candidate);
                    }
                }
            }
        });
        return true;
    }
}

