/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.StringSearcher;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntProcedure;
import gnu.trove.TObjectHashingStrategy;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LowLevelSearchUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.search.LowLevelSearchUtil");
    private static final ConcurrentMap<CharSequence, Map<StringSearcher, int[]>> cache = ContainerUtil.createConcurrentWeakMap((TObjectHashingStrategy)ContainerUtil.identityStrategy());

    private static Boolean processInjectedFile(PsiElement element, TextOccurenceProcessor processor2, StringSearcher searcher, @NotNull ProgressIndicator progress, InjectedLanguageManager injectedLanguageManager) {
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/psi/impl/search/LowLevelSearchUtil", "processInjectedFile"));
        }
        if (!(element instanceof PsiLanguageInjectionHost)) {
            return null;
        }
        if (injectedLanguageManager == null) {
            return null;
        }
        List list = injectedLanguageManager.getInjectedPsiFiles(element);
        if (list == null) {
            return null;
        }
        for (Pair pair : list) {
            PsiElement injected = (PsiElement)pair.getFirst();
            if (LowLevelSearchUtil.processElementsContainingWordInElement(processor2, injected, searcher, false, progress)) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private static TreeElement processTreeUp(@NotNull Project project2, @NotNull TextOccurenceProcessor processor2, @NotNull PsiElement scope, @NotNull StringSearcher searcher, int offset, boolean processInjectedPsi, @NotNull ProgressIndicator progress, TreeElement lastElement) {
        int start;
        boolean useTree;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/search/LowLevelSearchUtil", "processTreeUp"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/search/LowLevelSearchUtil", "processTreeUp"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/search/LowLevelSearchUtil", "processTreeUp"));
        }
        if (searcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searcher", "com/intellij/psi/impl/search/LowLevelSearchUtil", "processTreeUp"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/psi/impl/search/LowLevelSearchUtil", "processTreeUp"));
        }
        if (scope instanceof PsiCompiledElement) {
            throw new IllegalArgumentException("Scope is compiled, can't scan: " + scope);
        }
        int scopeStartOffset = scope.getTextRange().getStartOffset();
        int patternLength = searcher.getPatternLength();
        ASTNode scopeNode = scope.getNode();
        boolean bl = useTree = scopeNode != null;
        assert (scope.isValid());
        TreeElement leafNode = null;
        PsiElement leafElement = null;
        if (useTree) {
            leafNode = LowLevelSearchUtil.findNextLeafElementAt(scopeNode, lastElement, offset);
            if (leafNode == null) {
                return lastElement;
            }
            start = offset - leafNode.getStartOffset() + scopeStartOffset;
        } else {
            leafElement = scope instanceof PsiFile ? ((PsiFile)scope).getViewProvider().findElementAt(offset, scope.getLanguage()) : scope.findElementAt(offset);
            if (leafElement == null) {
                return lastElement;
            }
            assert (leafElement.isValid());
            start = offset - leafElement.getTextRange().getStartOffset() + scopeStartOffset;
        }
        if (start < 0) {
            throw new AssertionError((Object)("offset=" + offset + "; scopeStartOffset=" + scopeStartOffset + "; leafElement=" + leafElement + ";  scope=" + scope + "; leafElement.isValid(): " + (leafElement == null ? null : Boolean.valueOf(leafElement.isValid()))));
        }
        InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance((Project)project2);
        lastElement = leafNode;
        boolean contains = false;
        PsiElement prev = null;
        TreeElement prevNode = null;
        PsiElement run2 = null;
        while (run2 != scope) {
            progress.checkCanceled();
            if (useTree) {
                start += prevNode == null ? 0 : prevNode.getStartOffsetInParent();
                prevNode = leafNode;
                run2 = leafNode.getPsi();
            } else {
                start += prev == null ? 0 : prev.getStartOffsetInParent();
                prev = run2;
                run2 = leafElement;
            }
            if (!contains) {
                boolean bl2 = contains = run2.getTextLength() - start >= patternLength;
            }
            if (contains) {
                Boolean result2;
                if (processInjectedPsi && (result2 = LowLevelSearchUtil.processInjectedFile(run2, processor2, searcher, progress, injectedLanguageManager)) != null) {
                    return result2 != false ? lastElement : null;
                }
                if (!processor2.execute(run2, start)) {
                    return null;
                }
            }
            if (!(useTree ? (leafNode = leafNode.getTreeParent()) == null : (leafElement = leafElement.getParent()) == null)) continue;
        }
        assert (run2 == scope) : "Malbuilt PSI; scopeNode: " + scope + "; containingFile:" + PsiTreeUtil.getParentOfType((PsiElement)scope, PsiFile.class, (boolean)false) + "; leafNode: " + run2 + "; isAncestor=" + PsiTreeUtil.isAncestor((PsiElement)scope, (PsiElement)run2, (boolean)false) + "; in same file: " + (PsiTreeUtil.getParentOfType((PsiElement)scope, PsiFile.class, (boolean)false) == PsiTreeUtil.getParentOfType((PsiElement)run2, PsiFile.class, (boolean)false));
        return lastElement;
    }

    private static TreeElement findNextLeafElementAt(ASTNode scopeNode, TreeElement last, int offset) {
        int offsetR = offset;
        if (last != null) {
            offsetR -= last.getStartOffset() - scopeNode.getStartOffset() + last.getTextLength();
            while (offsetR >= 0) {
                TreeElement next = last.getTreeNext();
                if (next == null) {
                    last = last.getTreeParent();
                    continue;
                }
                int length = next.getTextLength();
                offsetR -= length;
                last = next;
            }
            scopeNode = last;
            offsetR += scopeNode.getTextLength();
        }
        return (LeafElement)scopeNode.findLeafElementAt(offsetR);
    }

    public static boolean processElementsContainingWordInElement(@NotNull TextOccurenceProcessor processor2, @NotNull PsiElement scope, @NotNull StringSearcher searcher, boolean processInjectedPsi, @NotNull ProgressIndicator progress) {
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/search/LowLevelSearchUtil", "processElementsContainingWordInElement"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/search/LowLevelSearchUtil", "processElementsContainingWordInElement"));
        }
        if (searcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searcher", "com/intellij/psi/impl/search/LowLevelSearchUtil", "processElementsContainingWordInElement"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/psi/impl/search/LowLevelSearchUtil", "processElementsContainingWordInElement"));
        }
        int[] occurrences = LowLevelSearchUtil.getTextOccurrencesInScope(scope, searcher, progress);
        return LowLevelSearchUtil.processElementsAtOffsets(scope, searcher, processInjectedPsi, progress, occurrences, processor2);
    }

    static int[] getTextOccurrencesInScope(@NotNull PsiElement scope, @NotNull StringSearcher searcher, ProgressIndicator progress) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/search/LowLevelSearchUtil", "getTextOccurrencesInScope"));
        }
        if (searcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searcher", "com/intellij/psi/impl/search/LowLevelSearchUtil", "getTextOccurrencesInScope"));
        }
        if (progress != null) {
            progress.checkCanceled();
        }
        PsiFile file2 = scope.getContainingFile();
        FileViewProvider viewProvider = file2.getViewProvider();
        CharSequence buffer = viewProvider.getContents();
        TextRange range = scope.getTextRange();
        if (range == null) {
            LOG.error("Element " + scope + " of class " + scope.getClass() + " has null range");
            return ArrayUtil.EMPTY_INT_ARRAY;
        }
        int startOffset = range.getStartOffset();
        int endOffset = range.getEndOffset();
        if (endOffset > buffer.length()) {
            LowLevelSearchUtil.diagnoseInvalidRange(scope, file2, viewProvider, buffer, range);
            return ArrayUtil.EMPTY_INT_ARRAY;
        }
        int[] offsets = LowLevelSearchUtil.getTextOccurrences(buffer, startOffset, endOffset, searcher, progress);
        int i = 0;
        while (i < offsets.length) {
            int n = i++;
            offsets[n] = offsets[n] - startOffset;
        }
        return offsets;
    }

    static boolean processElementsAtOffsets(@NotNull PsiElement scope, @NotNull StringSearcher searcher, boolean processInjectedPsi, @NotNull ProgressIndicator progress, int[] offsetsInScope, @NotNull TextOccurenceProcessor processor2) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/search/LowLevelSearchUtil", "processElementsAtOffsets"));
        }
        if (searcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searcher", "com/intellij/psi/impl/search/LowLevelSearchUtil", "processElementsAtOffsets"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/psi/impl/search/LowLevelSearchUtil", "processElementsAtOffsets"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/search/LowLevelSearchUtil", "processElementsAtOffsets"));
        }
        if (offsetsInScope.length == 0) {
            return true;
        }
        Project project2 = scope.getProject();
        TreeElement lastElement = null;
        for (int offset : offsetsInScope) {
            progress.checkCanceled();
            lastElement = LowLevelSearchUtil.processTreeUp(project2, processor2, scope, searcher, offset, processInjectedPsi, progress, lastElement);
            if (lastElement != null) continue;
            return false;
        }
        return true;
    }

    private static void diagnoseInvalidRange(@NotNull PsiElement scope, PsiFile file2, FileViewProvider viewProvider, CharSequence buffer, TextRange range) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/search/LowLevelSearchUtil", "diagnoseInvalidRange"));
        }
        String msg = "Range for element: '" + scope + "' = " + range + " is out of file '" + file2 + "' range: " + file2.getTextRange();
        msg = msg + "; file contents length: " + buffer.length();
        msg = msg + "\n file provider: " + viewProvider;
        Document document = viewProvider.getDocument();
        if (document != null) {
            msg = msg + "\n committed=" + PsiDocumentManager.getInstance((Project)file2.getProject()).isCommitted(document);
        }
        for (Language language : viewProvider.getLanguages()) {
            PsiFile root = viewProvider.getPsi(language);
            msg = msg + "\n root " + language + " length=" + root.getTextLength() + (root instanceof PsiFileImpl ? "; contentsLoaded=" + ((PsiFileImpl)root).isContentsLoaded() : "");
        }
        LOG.error(msg);
    }

    public static boolean processTextOccurrences(@NotNull CharSequence text, int startOffset, int endOffset, @NotNull StringSearcher searcher, @Nullable ProgressIndicator progress, @NotNull TIntProcedure processor2) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/search/LowLevelSearchUtil", "processTextOccurrences"));
        }
        if (searcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searcher", "com/intellij/psi/impl/search/LowLevelSearchUtil", "processTextOccurrences"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/search/LowLevelSearchUtil", "processTextOccurrences"));
        }
        for (int offset : LowLevelSearchUtil.getTextOccurrences(text, startOffset, endOffset, searcher, progress)) {
            if (processor2.execute(offset)) continue;
            return false;
        }
        return true;
    }

    private static int[] getTextOccurrences(@NotNull CharSequence text, int startOffset, int endOffset, @NotNull StringSearcher searcher, @Nullable ProgressIndicator progress) {
        int occurrence;
        boolean hasCachedOccurrences;
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/search/LowLevelSearchUtil", "getTextOccurrences"));
        }
        if (searcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searcher", "com/intellij/psi/impl/search/LowLevelSearchUtil", "getTextOccurrences"));
        }
        if (endOffset > text.length()) {
            throw new IllegalArgumentException("end: " + endOffset + " > length: " + text.length());
        }
        Map cachedMap = (Map)cache.get(text);
        int[] cachedOccurrences = cachedMap == null ? null : (int[])cachedMap.get(searcher);
        boolean bl = hasCachedOccurrences = cachedOccurrences != null && cachedOccurrences[0] <= startOffset && cachedOccurrences[1] >= endOffset;
        if (!hasCachedOccurrences) {
            TIntArrayList occurrences = new TIntArrayList();
            int newStart = Math.min(startOffset, cachedOccurrences == null ? startOffset : cachedOccurrences[0]);
            int newEnd = Math.max(endOffset, cachedOccurrences == null ? endOffset : cachedOccurrences[1]);
            occurrences.add(newStart);
            occurrences.add(newEnd);
            for (int index = newStart; index < newEnd; ++index) {
                if (progress != null) {
                    progress.checkCanceled();
                }
                if ((index = searcher.scan(text, index, newEnd)) < 0) break;
                if (!LowLevelSearchUtil.checkJavaIdentifier(text, 0, text.length(), searcher, index)) continue;
                occurrences.add(index);
            }
            cachedOccurrences = occurrences.toNativeArray();
            if (cachedMap == null) {
                cachedMap = (Map)ConcurrencyUtil.cacheOrGet(cache, (Object)text, (Object)ContainerUtil.createConcurrentSoftMap());
            }
            cachedMap.put(searcher, cachedOccurrences);
        }
        TIntArrayList offsets = new TIntArrayList(cachedOccurrences.length - 2);
        for (int i = 2; i < cachedOccurrences.length && (occurrence = cachedOccurrences[i]) <= endOffset - searcher.getPatternLength(); ++i) {
            if (occurrence < startOffset) continue;
            offsets.add(occurrence);
        }
        return offsets.toNativeArray();
    }

    private static boolean checkJavaIdentifier(@NotNull CharSequence text, int startOffset, int endOffset, @NotNull StringSearcher searcher, int index) {
        char c;
        char c2;
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/search/LowLevelSearchUtil", "checkJavaIdentifier"));
        }
        if (searcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searcher", "com/intellij/psi/impl/search/LowLevelSearchUtil", "checkJavaIdentifier"));
        }
        if (!searcher.isJavaIdentifier()) {
            return true;
        }
        if (index > startOffset && (Character.isJavaIdentifierPart(c2 = text.charAt(index - 1)) && c2 != '$' ? !searcher.isHandleEscapeSequences() || index < 2 || LowLevelSearchUtil.isEscapedBackslash(text, startOffset, index - 2) : index > 0 && searcher.isHandleEscapeSequences() && !LowLevelSearchUtil.isEscapedBackslash(text, startOffset, index - 1))) {
            return false;
        }
        int patternLength = searcher.getPattern().length();
        return index + patternLength >= endOffset || !Character.isJavaIdentifierPart(c = text.charAt(index + patternLength)) || c == '$';
    }

    private static boolean isEscapedBackslash(CharSequence text, int startOffset, int index) {
        return StringUtil.isEscapedBackslash((CharSequence)text, (int)startOffset, (int)index);
    }
}

