/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaLookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.pom.PomNamedTarget;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.impl.source.resolve.reference.impl.JavaReflectionReferenceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaLangClassMemberReference
extends PsiReferenceBase<PsiLiteralExpression>
implements InsertHandler<LookupElement> {
    private static final String FIELD = "getField";
    private static final String DECLARED_FIELD = "getDeclaredField";
    private static final String METHOD = "getMethod";
    private static final String DECLARED_METHOD = "getDeclaredMethod";
    private final PsiExpression myContext;

    public JavaLangClassMemberReference(@NotNull PsiLiteralExpression literal, @NotNull PsiExpression context) {
        if (literal == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literal", "com/intellij/psi/impl/source/resolve/reference/impl/JavaLangClassMemberReference", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/impl/source/resolve/reference/impl/JavaLangClassMemberReference", "<init>"));
        }
        super((PsiElement)literal);
        this.myContext = context;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/resolve/reference/impl/JavaLangClassMemberReference", "bindToElement"));
        }
        return element;
    }

    public PsiElement resolve() {
        Object value = ((PsiLiteralExpression)this.myElement).getValue();
        if (value instanceof String) {
            PsiClass psiClass;
            String name = (String)value;
            String type = this.getMemberType();
            if (type != null && (psiClass = this.getPsiClass()) != null) {
                switch (type) {
                    case "getField": {
                        return psiClass.findFieldByName(name, true);
                    }
                    case "getDeclaredField": {
                        PsiField field = psiClass.findFieldByName(name, false);
                        return JavaReflectionReferenceUtil.isPotentiallyAccessible((PsiMember)field, psiClass) ? field : null;
                    }
                    case "getMethod": {
                        Object[] methods = psiClass.findMethodsByName(name, true);
                        PsiMethod publicMethod = (PsiMethod)ContainerUtil.find((Object[])methods, method2 -> JavaReflectionReferenceUtil.isRegularMethod(method2) && JavaReflectionReferenceUtil.isPublic((PsiMember)method2));
                        if (publicMethod != null) {
                            return publicMethod;
                        }
                        return (PsiElement)ContainerUtil.find((Object[])methods, method2 -> JavaReflectionReferenceUtil.isRegularMethod(method2));
                    }
                    case "getDeclaredMethod": {
                        Object[] methods = psiClass.findMethodsByName(name, false);
                        return (PsiElement)ContainerUtil.find((Object[])methods, method2 -> JavaReflectionReferenceUtil.isRegularMethod(method2) && JavaReflectionReferenceUtil.isPotentiallyAccessible((PsiMember)method2, psiClass));
                    }
                }
            }
        }
        return null;
    }

    @Nullable
    private PsiClass getPsiClass() {
        return JavaReflectionReferenceUtil.getReflectiveClass(this.myContext);
    }

    @Nullable
    private String getMemberType() {
        PsiMethodCallExpression methodCall = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, PsiMethodCallExpression.class);
        return methodCall != null ? methodCall.getMethodExpression().getReferenceName() : null;
    }

    @NotNull
    public Object[] getVariants() {
        PsiClass psiClass;
        String type = this.getMemberType();
        if (type != null && (psiClass = this.getPsiClass()) != null) {
            switch (type) {
                case "getDeclaredField": {
                    Object[] objectArray = Arrays.stream(psiClass.getFields()).sorted(Comparator.comparing(PomNamedTarget::getName)).map(field -> JavaLangClassMemberReference.lookupField(field)).toArray();
                    if (objectArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/JavaLangClassMemberReference", "getVariants"));
                    }
                    return objectArray;
                }
                case "getField": {
                    Object[] objectArray = Arrays.stream(psiClass.getAllFields()).filter(field -> JavaReflectionReferenceUtil.isPotentiallyAccessible((PsiMember)field, psiClass)).sorted(Comparator.comparingInt(field -> JavaReflectionReferenceUtil.isPublic((PsiMember)field) ? 0 : 1).thenComparing(PomNamedTarget::getName)).map(field -> JavaReflectionReferenceUtil.withPriority(JavaLangClassMemberReference.lookupField(field), JavaReflectionReferenceUtil.isPublic((PsiMember)field))).toArray();
                    if (objectArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/JavaLangClassMemberReference", "getVariants"));
                    }
                    return objectArray;
                }
                case "getDeclaredMethod": {
                    Object[] objectArray = Arrays.stream(psiClass.getMethods()).filter(method2 -> JavaReflectionReferenceUtil.isRegularMethod(method2)).sorted(Comparator.comparing(PsiMethod::getName)).map(method2 -> this.lookupMethod((PsiMethod)method2)).toArray();
                    if (objectArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/JavaLangClassMemberReference", "getVariants"));
                    }
                    return objectArray;
                }
                case "getMethod": {
                    List methods = ContainerUtil.filter((Object[])psiClass.getAllMethods(), method2 -> JavaReflectionReferenceUtil.isRegularMethod(method2) && JavaReflectionReferenceUtil.isPotentiallyAccessible((PsiMember)method2, psiClass));
                    THashSet superMethods = new THashSet();
                    for (PsiMethod method3 : methods) {
                        ContainerUtil.addAll((Collection)superMethods, (Object[])method3.findSuperMethods());
                    }
                    Object[] objectArray = methods.stream().filter(arg_0 -> JavaLangClassMemberReference.lambda$getVariants$10((Set)superMethods, arg_0)).sorted(Comparator.comparingInt(method2 -> JavaLangClassMemberReference.getMethodSortOrder(method2)).thenComparing(PsiMethod::getName)).map(method2 -> JavaReflectionReferenceUtil.withPriority(this.lookupMethod((PsiMethod)method2), -JavaLangClassMemberReference.getMethodSortOrder(method2))).toArray();
                    if (objectArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/JavaLangClassMemberReference", "getVariants"));
                    }
                    return objectArray;
                }
            }
        }
        if (EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/JavaLangClassMemberReference", "getVariants"));
        }
        return EMPTY_ARRAY;
    }

    private static int getMethodSortOrder(PsiMethod method2) {
        return JavaReflectionReferenceUtil.isJavaLangObject(method2.getContainingClass()) ? 1 : (JavaReflectionReferenceUtil.isPublic((PsiMember)method2) ? -1 : 0);
    }

    @NotNull
    private static LookupElement lookupField(PsiField field) {
        LookupElementBuilder lookupElementBuilder = JavaLookupElementBuilder.forField(field);
        if (lookupElementBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/JavaLangClassMemberReference", "lookupField"));
        }
        return lookupElementBuilder;
    }

    @NotNull
    private LookupElement lookupMethod(PsiMethod method2) {
        LookupElementBuilder lookupElementBuilder = JavaLookupElementBuilder.forMethod(method2, PsiSubstitutor.EMPTY).withInsertHandler((InsertHandler)this);
        if (lookupElementBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/JavaLangClassMemberReference", "lookupMethod"));
        }
        return lookupElementBuilder;
    }

    public void handleInsert(InsertionContext context, LookupElement item) {
        Object object = item.getObject();
        if (object instanceof PsiMethod) {
            PsiElement newElement = PsiUtilCore.getElementAtOffset((PsiFile)context.getFile(), (int)context.getStartOffset());
            int start = newElement.getTextRange().getEndOffset();
            PsiElement params = newElement.getParent().getParent();
            int end = params.getTextRange().getEndOffset() - 1;
            String types = JavaReflectionReferenceUtil.getParameterTypesText((PsiMethod)object);
            if (!types.isEmpty()) {
                types = ", " + types;
            }
            context.getDocument().replaceString(start, end, (CharSequence)types);
            context.commitDocument();
            JavaReflectionReferenceUtil.shortenArgumentsClassReferences(context);
        }
    }

    private static /* synthetic */ boolean lambda$getVariants$10(Set superMethods, PsiMethod method2) {
        return !superMethods.contains(method2);
    }
}

