/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PackageReferenceSet;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.PatternUtil;
import com.intellij.util.Processor;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PatternPackageReferenceSet
extends PackageReferenceSet {
    public PatternPackageReferenceSet(@NotNull String packageName, @NotNull PsiElement element, int startInElement, @NotNull GlobalSearchScope scope) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/psi/impl/source/resolve/reference/impl/providers/PatternPackageReferenceSet", "<init>"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/resolve/reference/impl/providers/PatternPackageReferenceSet", "<init>"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/source/resolve/reference/impl/providers/PatternPackageReferenceSet", "<init>"));
        }
        super(packageName, element, startInElement, scope);
    }

    @Override
    public Collection<PsiPackage> resolvePackageName(@Nullable PsiPackage context, String packageName) {
        if (context == null) {
            return Collections.emptySet();
        }
        if (packageName.contains("*")) {
            LinkedHashSet<PsiPackage> packages = new LinkedHashSet<PsiPackage>();
            int indexOf = packageName.indexOf("*");
            if (indexOf == 0 || context.getQualifiedName().startsWith(packageName.substring(0, indexOf))) {
                Pattern pattern = PatternUtil.fromMask((String)packageName);
                this.processSubPackages(context, (Processor<PsiPackage>)((Processor)psiPackage -> {
                    String name = psiPackage.getName();
                    if (name != null && pattern.matcher(name).matches()) {
                        packages.add((PsiPackage)psiPackage);
                    }
                    return true;
                }));
            }
            return packages;
        }
        return super.resolvePackageName(context, packageName);
    }

    protected boolean processSubPackages(PsiPackage pkg, Processor<PsiPackage> processor2) {
        if (!processor2.process((Object)pkg)) {
            return false;
        }
        for (PsiPackage aPackage : pkg.getSubPackages(this.getResolveScope())) {
            if (this.processSubPackages(aPackage, processor2)) continue;
            return false;
        }
        return true;
    }
}

