/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.scope.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.infos.ClassCandidateInfo;
import com.intellij.psi.scope.JavaScopeProcessorEvent;
import com.intellij.psi.scope.MethodProcessorSetupFailedException;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.processor.MethodsProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiScopesUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.scope.util.PsiScopesUtil");

    private PsiScopesUtil() {
    }

    public static boolean treeWalkUp(@NotNull PsiScopeProcessor processor2, @NotNull PsiElement entrance, @Nullable PsiElement maxScope) {
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/scope/util/PsiScopesUtil", "treeWalkUp"));
        }
        if (entrance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entrance", "com/intellij/psi/scope/util/PsiScopesUtil", "treeWalkUp"));
        }
        return PsiScopesUtil.treeWalkUp(processor2, entrance, maxScope, ResolveState.initial());
    }

    public static boolean treeWalkUp(@NotNull PsiScopeProcessor processor2, @NotNull PsiElement entrance, @Nullable PsiElement maxScope, @NotNull ResolveState state) {
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/scope/util/PsiScopesUtil", "treeWalkUp"));
        }
        if (entrance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entrance", "com/intellij/psi/scope/util/PsiScopesUtil", "treeWalkUp"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/psi/scope/util/PsiScopesUtil", "treeWalkUp"));
        }
        if (!entrance.isValid()) {
            LOG.error((Throwable)new PsiInvalidElementAccessException(entrance));
        }
        PsiElement prevParent = entrance;
        PsiElement scope = entrance;
        while (scope != null) {
            PsiModifierList modifierList;
            ProgressIndicatorProvider.checkCanceled();
            if (scope instanceof PsiClass) {
                processor2.handleEvent((PsiScopeProcessor.Event)JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, (Object)scope);
            }
            if (!scope.processDeclarations(processor2, state, prevParent, entrance)) {
                return false;
            }
            if (scope instanceof PsiModifierListOwner && !(scope instanceof PsiParameter) && (modifierList = ((PsiModifierListOwner)scope).getModifierList()) != null && modifierList.hasModifierProperty("static")) {
                processor2.handleEvent((PsiScopeProcessor.Event)JavaScopeProcessorEvent.START_STATIC, null);
            }
            if (scope == maxScope) break;
            prevParent = scope;
            scope = prevParent.getContext();
            processor2.handleEvent((PsiScopeProcessor.Event)JavaScopeProcessorEvent.CHANGE_LEVEL, null);
        }
        return true;
    }

    public static boolean walkChildrenScopes(@NotNull PsiElement thisElement, @NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, PsiElement lastParent, PsiElement place) {
        if (thisElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thisElement", "com/intellij/psi/scope/util/PsiScopesUtil", "walkChildrenScopes"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/scope/util/PsiScopesUtil", "walkChildrenScopes"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/psi/scope/util/PsiScopesUtil", "walkChildrenScopes"));
        }
        PsiElement child = null;
        if (lastParent != null && lastParent.getParent() == thisElement && (child = lastParent.getPrevSibling()) == null) {
            return true;
        }
        if (child == null) {
            child = thisElement.getLastChild();
        }
        while (child != null) {
            if (!child.processDeclarations(processor2, state, null, place)) {
                return false;
            }
            child = child.getPrevSibling();
        }
        return true;
    }

    public static void processTypeDeclarations(PsiType type, PsiElement place, PsiScopeProcessor processor2) {
        if (type instanceof PsiArrayType) {
            LanguageLevel languageLevel = PsiUtil.getLanguageLevel((PsiElement)place);
            PsiClass arrayClass = JavaPsiFacade.getInstance((Project)place.getProject()).getElementFactory().getArrayClass(languageLevel);
            PsiTypeParameter[] arrayTypeParameters = arrayClass.getTypeParameters();
            PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
            if (arrayTypeParameters.length > 0) {
                substitutor = substitutor.put(arrayTypeParameters[0], ((PsiArrayType)type).getComponentType());
            }
            arrayClass.processDeclarations(processor2, ResolveState.initial().put(PsiSubstitutor.KEY, (Object)substitutor), (PsiElement)arrayClass, place);
        } else if (type instanceof PsiIntersectionType) {
            for (PsiType psiType : ((PsiIntersectionType)type).getConjuncts()) {
                PsiScopesUtil.processTypeDeclarations(psiType, place, processor2);
            }
        } else if (type instanceof PsiDisjunctionType) {
            PsiType lub = ((PsiDisjunctionType)type).getLeastUpperBound();
            PsiScopesUtil.processTypeDeclarations(lub, place, processor2);
        } else if (type instanceof PsiCapturedWildcardType) {
            PsiType classType = PsiScopesUtil.convertToTypeParameter((PsiCapturedWildcardType)type, place);
            if (classType != null) {
                PsiScopesUtil.processTypeDeclarations(classType, place, processor2);
            }
        } else {
            PsiClassType.ClassResolveResult result2 = PsiUtil.resolveGenericsClassInType((PsiType)type);
            PsiClass clazz = (PsiClass)result2.getElement();
            if (clazz != null) {
                clazz.processDeclarations(processor2, ResolveState.initial().put(PsiSubstitutor.KEY, (Object)result2.getSubstitutor()), (PsiElement)clazz, place);
            }
        }
    }

    public static boolean resolveAndWalk(@NotNull PsiScopeProcessor processor2, @NotNull PsiJavaCodeReferenceElement ref, @Nullable PsiElement maxScope) {
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/scope/util/PsiScopesUtil", "resolveAndWalk"));
        }
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/psi/scope/util/PsiScopesUtil", "resolveAndWalk"));
        }
        return PsiScopesUtil.resolveAndWalk(processor2, ref, maxScope, false);
    }

    public static boolean resolveAndWalk(@NotNull PsiScopeProcessor processor2, @NotNull PsiJavaCodeReferenceElement ref, @Nullable PsiElement maxScope, boolean incompleteCode) {
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/scope/util/PsiScopesUtil", "resolveAndWalk"));
        }
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/psi/scope/util/PsiScopesUtil", "resolveAndWalk"));
        }
        PsiElement qualifier = ref.getQualifier();
        PsiElement classNameElement = ref.getReferenceNameElement();
        if (classNameElement == null) {
            return true;
        }
        if (qualifier != null) {
            PsiElement target = null;
            PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
            if (qualifier instanceof PsiExpression || qualifier instanceof PsiJavaCodeReferenceElement) {
                PsiType type = null;
                if (qualifier instanceof PsiExpression) {
                    type = ((PsiExpression)qualifier).getType();
                    if (type != null) assert (type.isValid()) : type.getClass() + "; " + qualifier;
                    PsiScopesUtil.processTypeDeclarations(type, (PsiElement)ref, processor2);
                }
                if (type == null && qualifier instanceof PsiJavaCodeReferenceElement) {
                    PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)qualifier;
                    JavaResolveResult result2 = referenceElement.advancedResolve(incompleteCode);
                    target = result2.getElement();
                    substitutor = result2.getSubstitutor();
                    if (target instanceof PsiVariable) {
                        type = substitutor.substitute(((PsiVariable)target).getType());
                        if (type instanceof PsiClassType) {
                            PsiClassType.ClassResolveResult typeResult = ((PsiClassType)type).resolveGenerics();
                            target = typeResult.getElement();
                            substitutor = substitutor.putAll(typeResult.getSubstitutor());
                        } else {
                            target = null;
                        }
                    } else if (target instanceof PsiMethod) {
                        type = substitutor.substitute(((PsiMethod)target).getReturnType());
                        if (type instanceof PsiClassType) {
                            PsiClassType.ClassResolveResult typeResult = ((PsiClassType)type).resolveGenerics();
                            target = typeResult.getElement();
                            substitutor = substitutor.putAll(typeResult.getSubstitutor());
                        } else {
                            target = null;
                        }
                        PsiType[] types = referenceElement.getTypeParameters();
                        if (target instanceof PsiClass) {
                            substitutor = substitutor.putAll((PsiClass)target, types);
                        }
                    } else if (target instanceof PsiClass) {
                        processor2.handleEvent((PsiScopeProcessor.Event)JavaScopeProcessorEvent.START_STATIC, null);
                    }
                }
            }
            if (target != null) {
                return target.processDeclarations(processor2, ResolveState.initial().put(PsiSubstitutor.KEY, (Object)substitutor), target, (PsiElement)ref);
            }
        } else {
            return PsiScopesUtil.treeWalkUp(processor2, (PsiElement)ref, maxScope);
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setupAndRunProcessor(@NotNull MethodsProcessor processor2, @NotNull PsiCallExpression call, boolean dummyImplicitConstructor) throws MethodProcessorSetupFailedException {
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/scope/util/PsiScopesUtil", "setupAndRunProcessor"));
        }
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/psi/scope/util/PsiScopesUtil", "setupAndRunProcessor"));
        }
        if (call instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)call;
            PsiReferenceExpression ref = methodCall.getMethodExpression();
            processor2.setArgumentList(methodCall.getArgumentList());
            processor2.obtainTypeArguments((PsiCallExpression)methodCall);
            if (!ref.isQualified() || ref.getReferenceNameElement() instanceof PsiKeyword) {
                PsiElement referenceNameElement = ref.getReferenceNameElement();
                if (referenceNameElement == null) {
                    return;
                }
                if (referenceNameElement instanceof PsiKeyword) {
                    PsiKeyword keyword = (PsiKeyword)referenceNameElement;
                    if (keyword.getTokenType() == JavaTokenType.THIS_KEYWORD) {
                        PsiClass aClass = JavaResolveUtil.getContextClass((PsiElement)methodCall);
                        if (aClass == null) {
                            throw new MethodProcessorSetupFailedException("Can't resolve class for this expression");
                        }
                        processor2.setIsConstructor(true);
                        processor2.setAccessClass(aClass);
                        aClass.processDeclarations((PsiScopeProcessor)processor2, ResolveState.initial(), null, (PsiElement)call);
                        if (!dummyImplicitConstructor) return;
                        PsiScopesUtil.processDummyConstructor(processor2, aClass);
                        return;
                    } else if (keyword.getTokenType() == JavaTokenType.SUPER_KEYWORD) {
                        PsiClass aClass = JavaResolveUtil.getContextClass((PsiElement)methodCall);
                        if (aClass == null) {
                            throw new MethodProcessorSetupFailedException("Can't resolve class for super expression");
                        }
                        PsiClass superClass = aClass.getSuperClass();
                        if (superClass == null) return;
                        PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
                        PsiClass runSuper = superClass;
                        ArrayList<PsiSubstitutor> contextSubstitutors = new ArrayList<PsiSubstitutor>();
                        do {
                            if (runSuper != null) {
                                PsiSubstitutor superSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)runSuper, (PsiClass)aClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
                                contextSubstitutors.add(superSubstitutor);
                            }
                            if (aClass.hasModifierProperty("static")) break;
                            if ((aClass = JavaResolveUtil.getContextClass((PsiElement)aClass)) == null) continue;
                            runSuper = aClass.getSuperClass();
                        } while (aClass != null);
                        for (int i = contextSubstitutors.size() - 1; i >= 0; --i) {
                            PsiSubstitutor contextSubstitutor = (PsiSubstitutor)contextSubstitutors.get(i);
                            substitutor = substitutor.putAll(contextSubstitutor);
                        }
                        processor2.setIsConstructor(true);
                        processor2.setAccessClass(null);
                        PsiMethod[] constructors = superClass.getConstructors();
                        ResolveState state = ResolveState.initial().put(PsiSubstitutor.KEY, (Object)substitutor);
                        for (PsiMethod constructor : constructors) {
                            if (processor2.execute((PsiElement)constructor, state)) continue;
                            return;
                        }
                        if (!dummyImplicitConstructor) return;
                        PsiScopesUtil.processDummyConstructor(processor2, superClass);
                        return;
                    } else {
                        LOG.error("Unknown name element " + referenceNameElement + " in reference " + ref.getText() + "(" + ref + ")");
                    }
                    return;
                } else if (referenceNameElement instanceof PsiIdentifier) {
                    processor2.setIsConstructor(false);
                    processor2.setName(referenceNameElement.getText());
                    processor2.setAccessClass(null);
                    PsiScopesUtil.resolveAndWalk(processor2, (PsiJavaCodeReferenceElement)ref, null);
                    return;
                } else {
                    LOG.error("Unknown name element " + referenceNameElement + " in reference " + ref.getText() + "(" + ref + ")");
                }
                return;
            } else {
                PsiElement referenceName = methodCall.getMethodExpression().getReferenceNameElement();
                PsiManager manager = call.getManager();
                PsiElement qualifier = ref.getQualifier();
                if (referenceName == null) {
                    throw new MethodProcessorSetupFailedException("Can't resolve method name for this expression");
                }
                if (referenceName instanceof PsiIdentifier && qualifier instanceof PsiExpression) {
                    PsiType type = ((PsiExpression)qualifier).getType();
                    if (type != null && qualifier instanceof PsiReferenceExpression) {
                        PsiAnonymousClass anonymousClass;
                        PsiExpression initializer;
                        PsiElement resolve2 = ((PsiReferenceExpression)qualifier).resolve();
                        if (resolve2 instanceof PsiEnumConstant) {
                            PsiEnumConstantInitializer initializingClass = ((PsiEnumConstant)resolve2).getInitializingClass();
                            if (PsiScopesUtil.hasDesiredMethod(methodCall, type, (PsiAnonymousClass)initializingClass)) {
                                PsiScopesUtil.processQualifierResult((JavaResolveResult)new ClassCandidateInfo((PsiElement)initializingClass, PsiSubstitutor.EMPTY), processor2, methodCall);
                                return;
                            }
                        } else if (resolve2 instanceof PsiVariable && ((PsiVariable)resolve2).hasModifierProperty("final") && ((PsiVariable)resolve2).hasInitializer() && (initializer = ((PsiVariable)resolve2).getInitializer()) instanceof PsiNewExpression && PsiScopesUtil.hasDesiredMethod(methodCall, type, anonymousClass = ((PsiNewExpression)initializer).getAnonymousClass())) {
                            type = initializer.getType();
                        }
                    }
                    if (type == null) {
                        if (!(qualifier instanceof PsiJavaCodeReferenceElement)) throw new MethodProcessorSetupFailedException("Cant determine qualifier type!");
                        JavaResolveResult result2 = ((PsiJavaCodeReferenceElement)qualifier).advancedResolve(false);
                        if (!(result2.getElement() instanceof PsiClass)) return;
                        processor2.handleEvent((PsiScopeProcessor.Event)JavaScopeProcessorEvent.START_STATIC, null);
                        PsiScopesUtil.processQualifierResult(result2, processor2, methodCall);
                        return;
                    } else if (type instanceof PsiDisjunctionType) {
                        PsiScopesUtil.processQualifierType(((PsiDisjunctionType)type).getLeastUpperBound(), processor2, manager, methodCall);
                        return;
                    } else if (type instanceof PsiCapturedWildcardType) {
                        PsiType psiType = PsiScopesUtil.convertToTypeParameter((PsiCapturedWildcardType)type, (PsiElement)methodCall);
                        if (psiType == null) return;
                        PsiScopesUtil.processQualifierType(psiType, processor2, manager, methodCall);
                        return;
                    } else {
                        PsiScopesUtil.processQualifierType(type, processor2, manager, methodCall);
                    }
                    return;
                } else {
                    LOG.error("ref: " + ref + " (" + ref.getClass() + "), ref.getReferenceNameElement()=" + ref.getReferenceNameElement() + "; methodCall.getMethodExpression().getReferenceNameElement()=" + methodCall.getMethodExpression().getReferenceNameElement() + "; qualifier=" + qualifier);
                }
            }
            return;
        } else {
            LOG.assertTrue(call instanceof PsiNewExpression);
            PsiNewExpression newExpr = (PsiNewExpression)call;
            PsiJavaCodeReferenceElement classRef = newExpr.getClassOrAnonymousClassReference();
            if (classRef == null) {
                throw new MethodProcessorSetupFailedException("Cant get reference to class in new expression");
            }
            JavaResolveResult result3 = classRef.advancedResolve(false);
            PsiClass aClass = (PsiClass)result3.getElement();
            if (aClass == null) {
                throw new MethodProcessorSetupFailedException("Cant resolve class in new expression");
            }
            processor2.setIsConstructor(true);
            processor2.setAccessClass(aClass);
            processor2.setArgumentList(newExpr.getArgumentList());
            processor2.obtainTypeArguments((PsiCallExpression)newExpr);
            aClass.processDeclarations((PsiScopeProcessor)processor2, ResolveState.initial().put(PsiSubstitutor.KEY, (Object)result3.getSubstitutor()), null, (PsiElement)call);
            if (!dummyImplicitConstructor) return;
            PsiScopesUtil.processDummyConstructor(processor2, aClass);
        }
    }

    private static PsiType convertToTypeParameter(PsiCapturedWildcardType type, PsiElement methodCall) {
        GlobalSearchScope placeResolveScope = methodCall.getResolveScope();
        PsiType upperBound = PsiClassImplUtil.correctType(type.getUpperBound(), placeResolveScope);
        while (upperBound instanceof PsiCapturedWildcardType) {
            upperBound = PsiClassImplUtil.correctType(((PsiCapturedWildcardType)upperBound).getUpperBound(), placeResolveScope);
        }
        if (upperBound instanceof PsiArrayType) {
            return upperBound;
        }
        if (upperBound != null) {
            return InferenceSession.createTypeParameterTypeWithUpperBound(upperBound, methodCall);
        }
        return null;
    }

    private static boolean hasDesiredMethod(PsiMethodCallExpression methodCall, PsiType type, PsiAnonymousClass anonymousClass) {
        PsiClass baseClass;
        PsiMethod[] refMethods;
        if (anonymousClass != null && type.equals(anonymousClass.getBaseClassType()) && (refMethods = anonymousClass.findMethodsByName(methodCall.getMethodExpression().getReferenceName(), false)).length > 0 && (baseClass = PsiUtil.resolveClassInType((PsiType)type)) != null && !PsiScopesUtil.hasCovariantOverridingOrNotPublic(baseClass, refMethods)) {
            for (PsiMethod method2 : refMethods) {
                if (method2.findSuperMethods(baseClass).length <= 0) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean hasCovariantOverridingOrNotPublic(PsiClass baseClass, PsiMethod[] refMethods) {
        for (PsiMethod method2 : refMethods) {
            PsiType methodReturnType = method2.getReturnType();
            for (PsiMethod superMethod : method2.findSuperMethods(baseClass)) {
                if (!Comparing.equal((Object)methodReturnType, (Object)superMethod.getReturnType())) {
                    return true;
                }
                if (superMethod.hasModifierProperty("public")) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean processQualifierType(@NotNull PsiType type, MethodsProcessor processor2, PsiManager manager, PsiMethodCallExpression call) throws MethodProcessorSetupFailedException {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/scope/util/PsiScopesUtil", "processQualifierType"));
        }
        LOG.assertTrue(type.isValid());
        if (type instanceof PsiClassType) {
            PsiClassType.ClassResolveResult qualifierResult = ((PsiClassType)type).resolveGenerics();
            return PsiScopesUtil.processQualifierResult((JavaResolveResult)qualifierResult, processor2, call);
        }
        if (type instanceof PsiArrayType) {
            LanguageLevel languageLevel = PsiUtil.getLanguageLevel((PsiElement)call);
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
            PsiClassType.ClassResolveResult qualifierResult = factory.getArrayClassType(((PsiArrayType)type).getComponentType(), languageLevel).resolveGenerics();
            return PsiScopesUtil.processQualifierResult((JavaResolveResult)qualifierResult, processor2, call);
        }
        if (type instanceof PsiIntersectionType) {
            for (PsiType conjunct : ((PsiIntersectionType)type).getConjuncts()) {
                if (PsiScopesUtil.processQualifierType(conjunct, processor2, manager, call)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean processQualifierResult(@NotNull JavaResolveResult qualifierResult, @NotNull MethodsProcessor processor2, @NotNull PsiMethodCallExpression methodCall) throws MethodProcessorSetupFailedException {
        if (qualifierResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierResult", "com/intellij/psi/scope/util/PsiScopesUtil", "processQualifierResult"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/scope/util/PsiScopesUtil", "processQualifierResult"));
        }
        if (methodCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "com/intellij/psi/scope/util/PsiScopesUtil", "processQualifierResult"));
        }
        PsiElement resolve2 = qualifierResult.getElement();
        if (resolve2 == null) {
            throw new MethodProcessorSetupFailedException("Cant determine qualifier class!");
        }
        if (resolve2 instanceof PsiTypeParameter) {
            processor2.setAccessClass((PsiClass)resolve2);
        } else if (resolve2 instanceof PsiClass) {
            PsiExpression qualifier = methodCall.getMethodExpression().getQualifierExpression();
            if (!(qualifier instanceof PsiSuperExpression)) {
                processor2.setAccessClass((PsiClass)PsiUtil.getAccessObjectClass((PsiExpression)qualifier).getElement());
            } else if (((PsiSuperExpression)qualifier).getQualifier() != null && PsiUtil.isLanguageLevel8OrHigher((PsiElement)qualifier) && "java.lang.Cloneable".equals(((PsiClass)resolve2).getQualifiedName()) && ((PsiClass)resolve2).isInterface()) {
                processor2.setAccessClass((PsiClass)resolve2);
            }
        }
        processor2.setIsConstructor(false);
        processor2.setName(methodCall.getMethodExpression().getReferenceName());
        ResolveState state = ResolveState.initial().put(PsiSubstitutor.KEY, (Object)qualifierResult.getSubstitutor());
        return resolve2.processDeclarations((PsiScopeProcessor)processor2, state, (PsiElement)methodCall, (PsiElement)methodCall);
    }

    private static void processDummyConstructor(MethodsProcessor processor2, PsiClass aClass) {
        if (aClass instanceof PsiAnonymousClass) {
            return;
        }
        try {
            PsiMethod[] constructors = aClass.getConstructors();
            if (constructors.length != 0) {
                return;
            }
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)aClass.getProject()).getElementFactory();
            PsiMethod dummyConstructor = factory.createConstructor();
            PsiIdentifier nameIdentifier = aClass.getNameIdentifier();
            if (nameIdentifier != null) {
                dummyConstructor.getNameIdentifier().replace((PsiElement)nameIdentifier);
            }
            processor2.forceAddResult(dummyConstructor);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }
}

