/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubsHierarchy.impl;

import com.intellij.psi.impl.java.stubs.hierarchy.IndexTree;
import com.intellij.psi.stubsHierarchy.impl.AliasedImport;
import com.intellij.psi.stubsHierarchy.impl.Import;
import com.intellij.psi.stubsHierarchy.impl.NameEnvironment;
import com.intellij.psi.stubsHierarchy.impl.UnitInputStream;
import com.intellij.util.BitUtil;
import com.intellij.util.io.DataInputOutputUtil;
import gnu.trove.TIntObjectHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

class Imports {
    public static final Import[] EMPTY_ARRAY = new Import[0];
    private final TIntObjectHashMap<Import> myNonStaticPackageImports = new TIntObjectHashMap();
    private static final int IS_STATIC = 1;
    private static final int IS_ON_DEMAND = 2;
    private static final int HAS_ALIAS = 4;

    Imports() {
    }

    static void writeImports(@NotNull DataOutput out, IndexTree.Unit value) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/psi/stubsHierarchy/impl/Imports", "writeImports"));
        }
        DataInputOutputUtil.writeINT((DataOutput)out, (int)value.imports.length);
        for (IndexTree.Import anImport : value.imports) {
            Imports.writeImport(out, anImport);
        }
    }

    Import[] readImports(UnitInputStream in) throws IOException {
        int importCount = DataInputOutputUtil.readINT((DataInput)in);
        Import[] imports = importCount == 0 ? EMPTY_ARRAY : new Import[importCount];
        for (int i2 = 0; i2 < importCount; ++i2) {
            imports[i2] = this.readImport(in);
        }
        return imports;
    }

    private static void writeImport(@NotNull DataOutput out, IndexTree.Import anImport) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/psi/stubsHierarchy/impl/Imports", "writeImport"));
        }
        out.writeInt(NameEnvironment.fromString(anImport.myQualifier));
        boolean hasAlias = anImport.myAlias != null;
        int flags = 0;
        flags = BitUtil.set((int)flags, (int)1, (boolean)anImport.myStaticImport);
        flags = BitUtil.set((int)flags, (int)2, (boolean)anImport.myOnDemand);
        flags = BitUtil.set((int)flags, (int)4, (boolean)hasAlias);
        out.writeByte(flags);
        if (anImport.myImportedName != null) {
            out.writeInt(NameEnvironment.hashIdentifier(anImport.myImportedName));
        }
        if (hasAlias) {
            out.writeInt(NameEnvironment.hashIdentifier(anImport.myAlias));
        }
    }

    private Import readImport(UnitInputStream in) throws IOException {
        int qualifier = in.readInt();
        byte flags = in.readByte();
        int shortName = BitUtil.isSet((int)flags, (int)2) ? 0 : in.readInt();
        int alias = BitUtil.isSet((int)flags, (int)4) ? in.readInt() : 0;
        return this.obtainImport(qualifier, shortName, alias, BitUtil.isSet((int)flags, (int)1));
    }

    private Import obtainImport(int qualifier, int shortName, int alias, boolean isStatic) {
        Import anImport;
        Import existing;
        boolean shouldIntern;
        boolean bl = shouldIntern = shortName == 0 && alias == 0 && !isStatic;
        if (shouldIntern && (existing = (Import)this.myNonStaticPackageImports.get(qualifier)) != null) {
            return existing;
        }
        Import import_ = anImport = alias != 0 ? new AliasedImport(qualifier, shortName, isStatic, alias) : new Import(qualifier, shortName, isStatic);
        if (shouldIntern) {
            this.myNonStaticPackageImports.put(qualifier, (Object)anImport);
        }
        return anImport;
    }
}

