/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring;

import com.intellij.find.findUsages.PsiElement2UsageTargetAdapter;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.ide.DataManager;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.impl.NonProjectFileWritingAccessProvider;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.impl.status.StatusBarUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.RefactoringHelper;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.listeners.RefactoringEventListener;
import com.intellij.refactoring.listeners.RefactoringListenerManager;
import com.intellij.refactoring.listeners.impl.RefactoringListenerManagerImpl;
import com.intellij.refactoring.listeners.impl.RefactoringTransaction;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.ui.GuiUtils;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageInfoSearcherAdapter;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.rules.PsiElementUsage;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseRefactoringProcessor
implements Runnable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.BaseRefactoringProcessor");
    private static boolean PREVIEW_IN_TESTS = true;
    @NotNull
    protected final Project myProject;
    private RefactoringTransaction myTransaction;
    private boolean myIsPreviewUsages;
    protected Runnable myPrepareSuccessfulSwingThreadCallback;

    protected BaseRefactoringProcessor(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/BaseRefactoringProcessor", "<init>"));
        }
        this(project2, null);
    }

    protected BaseRefactoringProcessor(@NotNull Project project2, @Nullable Runnable prepareSuccessfulCallback) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/BaseRefactoringProcessor", "<init>"));
        }
        this.myPrepareSuccessfulSwingThreadCallback = EmptyRunnable.INSTANCE;
        this.myProject = project2;
        this.myPrepareSuccessfulSwingThreadCallback = prepareSuccessfulCallback;
    }

    @NotNull
    protected abstract UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] var1);

    @NotNull
    protected abstract UsageInfo[] findUsages();

    protected void refreshElements(@NotNull PsiElement[] elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/refactoring/BaseRefactoringProcessor", "refreshElements"));
        }
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refUsages", "com/intellij/refactoring/BaseRefactoringProcessor", "preprocessUsages"));
        }
        this.prepareSuccessful();
        return true;
    }

    protected boolean isPreviewUsages(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/refactoring/BaseRefactoringProcessor", "isPreviewUsages"));
        }
        return this.myIsPreviewUsages;
    }

    protected boolean isPreviewUsages() {
        return this.myIsPreviewUsages;
    }

    public void setPreviewUsages(boolean isPreviewUsages) {
        this.myIsPreviewUsages = isPreviewUsages;
    }

    public void setPrepareSuccessfulSwingThreadCallback(Runnable prepareSuccessfulSwingThreadCallback) {
        this.myPrepareSuccessfulSwingThreadCallback = prepareSuccessfulSwingThreadCallback;
    }

    protected RefactoringTransaction getTransaction() {
        return this.myTransaction;
    }

    protected abstract void performRefactoring(@NotNull UsageInfo[] var1);

    @NotNull
    protected abstract String getCommandName();

    protected void doRun() {
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        final Ref refUsages = new Ref();
        final Ref refErrorLanguage = new Ref();
        final Ref refProcessCanceled = new Ref();
        final Ref anyException = new Ref();
        Runnable findUsagesRunnable = new Runnable(){

            @Override
            public void run() {
                try {
                    refUsages.set(DumbService.getInstance((Project)BaseRefactoringProcessor.this.myProject).runReadActionInSmartMode((Computable)new Computable<UsageInfo[]>(){

                        public UsageInfo[] compute() {
                            return BaseRefactoringProcessor.this.findUsages();
                        }
                    }));
                }
                catch (UnknownReferenceTypeException e) {
                    refErrorLanguage.set((Object)e.getElementLanguage());
                }
                catch (ProcessCanceledException e) {
                    refProcessCanceled.set((Object)Boolean.TRUE);
                }
                catch (Throwable e) {
                    anyException.set((Object)Boolean.TRUE);
                    LOG.error(e);
                }
            }
        };
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(findUsagesRunnable, RefactoringBundle.message((String)"progress.text"), true, this.myProject)) {
            return;
        }
        if (!refErrorLanguage.isNull()) {
            Messages.showErrorDialog((Project)this.myProject, (String)RefactoringBundle.message((String)"unsupported.refs.found", (Object[])new Object[]{((Language)refErrorLanguage.get()).getDisplayName()}), (String)RefactoringBundle.message((String)"error.title"));
            return;
        }
        if (DumbService.isDumb((Project)this.myProject)) {
            DumbService.getInstance((Project)this.myProject).showDumbModeNotification("Refactoring is not available until indices are ready");
            return;
        }
        if (!refProcessCanceled.isNull()) {
            Messages.showErrorDialog((Project)this.myProject, (String)"Index corruption detected. Please retry the refactoring - indexes will be rebuilt automatically", (String)RefactoringBundle.message((String)"error.title"));
            return;
        }
        if (!anyException.isNull()) {
            return;
        }
        assert (!refUsages.isNull()) : "Null usages from processor " + this;
        if (!this.preprocessUsages((Ref<UsageInfo[]>)refUsages)) {
            return;
        }
        UsageInfo[] usages = (UsageInfo[])refUsages.get();
        assert (usages != null);
        UsageViewDescriptor descriptor = this.createUsageViewDescriptor(usages);
        boolean isPreview = this.isPreviewUsages(usages);
        if (!isPreview) {
            boolean bl = isPreview = !this.ensureElementsWritable(usages, descriptor) || UsageViewUtil.hasReadOnlyUsages(usages);
            if (isPreview) {
                StatusBarUtil.setStatusBarInfo(this.myProject, RefactoringBundle.message((String)"readonly.occurences.found"));
            }
        }
        if (isPreview) {
            for (UsageInfo usage : usages) {
                LOG.assertTrue(usage != null, this.getClass());
            }
            this.previewRefactoring(usages);
        } else {
            this.execute(usages);
        }
    }

    public static <T extends Throwable> void runWithDisabledPreview(ThrowableRunnable<T> runnable2) throws T {
        PREVIEW_IN_TESTS = false;
        try {
            runnable2.run();
        }
        finally {
            PREVIEW_IN_TESTS = true;
        }
    }

    protected void previewRefactoring(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/refactoring/BaseRefactoringProcessor", "previewRefactoring"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            if (!PREVIEW_IN_TESTS) {
                throw new RuntimeException("Unexpected preview in tests: " + StringUtil.join((Object[])usages, info -> info.toString(), (String)", "));
            }
            this.ensureElementsWritable(usages, this.createUsageViewDescriptor(usages));
            this.execute(usages);
            return;
        }
        UsageViewDescriptor viewDescriptor = this.createUsageViewDescriptor(usages);
        final PsiElement[] elements = viewDescriptor.getElements();
        final PsiElement2UsageTargetAdapter[] targets = PsiElement2UsageTargetAdapter.convert(elements);
        Factory<UsageSearcher> factory = new Factory<UsageSearcher>(){

            public UsageSearcher create() {
                return new UsageInfoSearcherAdapter(){

                    public void generate(@NotNull Processor<Usage> processor2) {
                        if (processor2 == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/refactoring/BaseRefactoringProcessor$2$1", "generate"));
                        }
                        ApplicationManager.getApplication().runReadAction(new Runnable(){

                            @Override
                            public void run() {
                                for (int i2 = 0; i2 < elements.length; ++i2) {
                                    elements[i2] = targets[i2].getElement();
                                }
                                BaseRefactoringProcessor.this.refreshElements(elements);
                            }
                        });
                        this.processUsages(processor2, BaseRefactoringProcessor.this.myProject);
                    }

                    protected UsageInfo[] findUsages() {
                        return BaseRefactoringProcessor.this.findUsages();
                    }
                };
            }
        };
        this.showUsageView(viewDescriptor, factory, usages);
    }

    protected boolean skipNonCodeUsages() {
        return false;
    }

    private boolean ensureElementsWritable(@NotNull UsageInfo[] usages, @NotNull UsageViewDescriptor descriptor) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/refactoring/BaseRefactoringProcessor", "ensureElementsWritable"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/refactoring/BaseRefactoringProcessor", "ensureElementsWritable"));
        }
        THashSet elements = new THashSet(ContainerUtil.identityStrategy());
        for (UsageInfo usage : usages) {
            PsiElement element;
            assert (usage != null) : "Found null element in usages array";
            if (this.skipNonCodeUsages() && usage.isNonCodeUsage() || (element = usage.getElement()) == null) continue;
            elements.add(element);
        }
        elements.addAll(this.getElementsToWrite(descriptor));
        return BaseRefactoringProcessor.ensureFilesWritable(this.myProject, (Collection<? extends PsiElement>)elements);
    }

    private static boolean ensureFilesWritable(@NotNull Project project2, @NotNull Collection<? extends PsiElement> elements) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/BaseRefactoringProcessor", "ensureFilesWritable"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/refactoring/BaseRefactoringProcessor", "ensureFilesWritable"));
        }
        PsiElement[] psiElements = PsiUtilCore.toPsiElementArray(elements);
        return CommonRefactoringUtil.checkReadOnlyStatus((Project)project2, (PsiElement[])psiElements);
    }

    protected void execute(final @NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/refactoring/BaseRefactoringProcessor", "execute"));
        }
        CommandProcessor.getInstance().executeCommand(this.myProject, new Runnable(){

            @Override
            public void run() {
                LinkedHashSet<UsageInfo> usageInfos = new LinkedHashSet<UsageInfo>(Arrays.asList(usages));
                BaseRefactoringProcessor.this.doRefactoring(usageInfos);
                if (BaseRefactoringProcessor.this.isGlobalUndoAction()) {
                    CommandProcessor.getInstance().markCurrentCommandAsGlobal(BaseRefactoringProcessor.this.myProject);
                }
            }
        }, this.getCommandName(), null, this.getUndoConfirmationPolicy());
    }

    protected boolean isGlobalUndoAction() {
        return CommonDataKeys.EDITOR.getData(DataManager.getInstance().getDataContext()) == null;
    }

    @NotNull
    protected UndoConfirmationPolicy getUndoConfirmationPolicy() {
        UndoConfirmationPolicy undoConfirmationPolicy = UndoConfirmationPolicy.DEFAULT;
        if (undoConfirmationPolicy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/BaseRefactoringProcessor", "getUndoConfirmationPolicy"));
        }
        return undoConfirmationPolicy;
    }

    @NotNull
    private static UsageViewPresentation createPresentation(@NotNull UsageViewDescriptor descriptor, @NotNull Usage[] usages) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/refactoring/BaseRefactoringProcessor", "createPresentation"));
        }
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/refactoring/BaseRefactoringProcessor", "createPresentation"));
        }
        UsageViewPresentation presentation = new UsageViewPresentation();
        presentation.setTabText(RefactoringBundle.message((String)"usageView.tabText"));
        presentation.setTargetsNodeText(descriptor.getProcessedElementsHeader());
        presentation.setShowReadOnlyStatusAsRed(true);
        presentation.setShowCancelButton(true);
        presentation.setUsagesString(RefactoringBundle.message((String)"usageView.usagesText"));
        int codeUsageCount = 0;
        int nonCodeUsageCount = 0;
        int dynamicUsagesCount = 0;
        HashSet codeFiles = new HashSet();
        HashSet nonCodeFiles = new HashSet();
        HashSet dynamicUsagesCodeFiles = new HashSet();
        for (Usage usage : usages) {
            UsageInfo usageInfo;
            PsiElementUsage elementUsage;
            PsiElement element;
            if (!(usage instanceof PsiElementUsage) || (element = (elementUsage = (PsiElementUsage)usage).getElement()) == null) continue;
            PsiFile containingFile = element.getContainingFile();
            if (elementUsage.isNonCodeUsage()) {
                ++nonCodeUsageCount;
                nonCodeFiles.add(containingFile);
            } else {
                ++codeUsageCount;
                codeFiles.add(containingFile);
            }
            if (!(usage instanceof UsageInfo2UsageAdapter) || !((usageInfo = ((UsageInfo2UsageAdapter)usage).getUsageInfo()) instanceof MoveRenameUsageInfo) || !usageInfo.isDynamicUsage()) continue;
            ++dynamicUsagesCount;
            dynamicUsagesCodeFiles.add(containingFile);
        }
        codeFiles.remove(null);
        nonCodeFiles.remove(null);
        dynamicUsagesCodeFiles.remove(null);
        String codeReferencesText = descriptor.getCodeReferencesText(codeUsageCount, codeFiles.size());
        presentation.setCodeUsagesString(codeReferencesText);
        String commentReferencesText = descriptor.getCommentReferencesText(nonCodeUsageCount, nonCodeFiles.size());
        if (commentReferencesText != null) {
            presentation.setNonCodeUsagesString(commentReferencesText);
        }
        presentation.setDynamicUsagesString("Dynamic " + StringUtil.decapitalize((String)descriptor.getCodeReferencesText(dynamicUsagesCount, dynamicUsagesCodeFiles.size())));
        String generatedCodeString = codeReferencesText.contains("in code") ? StringUtil.replace((String)codeReferencesText, (String)"in code", (String)"in generated code") : codeReferencesText + " in generated code";
        presentation.setUsagesInGeneratedCodeString(generatedCodeString);
        UsageViewPresentation usageViewPresentation = presentation;
        if (usageViewPresentation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/BaseRefactoringProcessor", "createPresentation"));
        }
        return usageViewPresentation;
    }

    private void showUsageView(@NotNull UsageViewDescriptor viewDescriptor, Factory<UsageSearcher> factory, final @NotNull UsageInfo[] usageInfos) {
        if (viewDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewDescriptor", "com/intellij/refactoring/BaseRefactoringProcessor", "showUsageView"));
        }
        if (usageInfos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageInfos", "com/intellij/refactoring/BaseRefactoringProcessor", "showUsageView"));
        }
        UsageViewManager viewManager = UsageViewManager.getInstance((Project)this.myProject);
        PsiElement[] initialElements = viewDescriptor.getElements();
        PsiElement2UsageTargetAdapter[] targets = PsiElement2UsageTargetAdapter.convert(initialElements);
        final Ref convertUsagesRef = new Ref();
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runReadAction(new Runnable(){

                    @Override
                    public void run() {
                        convertUsagesRef.set((Object)UsageInfo2UsageAdapter.convert((UsageInfo[])usageInfos));
                    }
                });
            }
        }, "Preprocess usages", true, this.myProject)) {
            return;
        }
        if (convertUsagesRef.isNull()) {
            return;
        }
        Usage[] usages = (Usage[])convertUsagesRef.get();
        UsageViewPresentation presentation = BaseRefactoringProcessor.createPresentation(viewDescriptor, usages);
        UsageView usageView = viewManager.showUsages((UsageTarget[])targets, usages, presentation, factory);
        this.customizeUsagesView(viewDescriptor, usageView);
    }

    protected void customizeUsagesView(@NotNull UsageViewDescriptor viewDescriptor, @NotNull UsageView usageView) {
        if (viewDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewDescriptor", "com/intellij/refactoring/BaseRefactoringProcessor", "customizeUsagesView"));
        }
        if (usageView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageView", "com/intellij/refactoring/BaseRefactoringProcessor", "customizeUsagesView"));
        }
        Runnable refactoringRunnable = () -> {
            if (usageView == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageView", "com/intellij/refactoring/BaseRefactoringProcessor", "lambda$customizeUsagesView$2"));
            }
            if (viewDescriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewDescriptor", "com/intellij/refactoring/BaseRefactoringProcessor", "lambda$customizeUsagesView$2"));
            }
            Set<UsageInfo> usagesToRefactor = UsageViewUtil.getNotExcludedUsageInfos(usageView);
            UsageInfo[] infos = usagesToRefactor.toArray(new UsageInfo[usagesToRefactor.size()]);
            TransactionGuard.getInstance().submitTransactionAndWait(() -> {
                if (viewDescriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewDescriptor", "com/intellij/refactoring/BaseRefactoringProcessor", "lambda$null$1"));
                }
                if (this.ensureElementsWritable(infos, viewDescriptor)) {
                    this.execute(infos);
                }
            });
        };
        String canNotMakeString = RefactoringBundle.message((String)"usageView.need.reRun");
        this.addDoRefactoringAction(usageView, refactoringRunnable, canNotMakeString);
    }

    private void addDoRefactoringAction(@NotNull UsageView usageView, @NotNull Runnable refactoringRunnable, @NotNull String canNotMakeString) {
        if (usageView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageView", "com/intellij/refactoring/BaseRefactoringProcessor", "addDoRefactoringAction"));
        }
        if (refactoringRunnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refactoringRunnable", "com/intellij/refactoring/BaseRefactoringProcessor", "addDoRefactoringAction"));
        }
        if (canNotMakeString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "canNotMakeString", "com/intellij/refactoring/BaseRefactoringProcessor", "addDoRefactoringAction"));
        }
        usageView.addPerformOperationAction(refactoringRunnable, this.getCommandName(), canNotMakeString, RefactoringBundle.message((String)"usageView.doAction"), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRefactoring(@NotNull Collection<UsageInfo> usageInfoSet) {
        if (usageInfoSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageInfoSet", "com/intellij/refactoring/BaseRefactoringProcessor", "doRefactoring"));
        }
        Iterator<UsageInfo> iterator = usageInfoSet.iterator();
        while (iterator.hasNext()) {
            UsageInfo usageInfo = iterator.next();
            PsiElement element = usageInfo.getElement();
            if (element != null && this.isToBeChanged(usageInfo)) continue;
            iterator.remove();
        }
        LocalHistoryAction action = LocalHistory.getInstance().startAction(this.getCommandName());
        final UsageInfo[] writableUsageInfos = usageInfoSet.toArray(new UsageInfo[usageInfoSet.size()]);
        try {
            PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
            RefactoringListenerManagerImpl listenerManager = (RefactoringListenerManagerImpl)RefactoringListenerManager.getInstance((Project)this.myProject);
            this.myTransaction = listenerManager.startTransaction();
            final LinkedHashMap preparedData = new LinkedHashMap();
            Runnable prepareHelpersRunnable = new Runnable(){

                @Override
                public void run() {
                    for (final RefactoringHelper helper : (RefactoringHelper[])Extensions.getExtensions(RefactoringHelper.EP_NAME)) {
                        Object operation = ApplicationManager.getApplication().runReadAction((Computable)new Computable<Object>(){

                            public Object compute() {
                                return helper.prepareOperation(writableUsageInfos);
                            }
                        });
                        preparedData.put(helper, operation);
                    }
                }
            };
            ProgressManager.getInstance().runProcessWithProgressSynchronously(prepareHelpersRunnable, "Prepare ...", false, this.myProject);
            Runnable performRefactoringRunnable = () -> {
                if (usageInfoSet == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageInfoSet", "com/intellij/refactoring/BaseRefactoringProcessor", "lambda$doRefactoring$3"));
                }
                String refactoringId = this.getRefactoringId();
                if (refactoringId != null) {
                    RefactoringEventData data = this.getBeforeData();
                    if (data != null) {
                        data.addUsages(usageInfoSet);
                    }
                    ((RefactoringEventListener)this.myProject.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringStarted(refactoringId, data);
                }
                try {
                    if (refactoringId != null) {
                        UndoRefactoringAction action1 = new UndoRefactoringAction(this.myProject, refactoringId);
                        UndoManager.getInstance((Project)this.myProject).undoableActionPerformed((UndoableAction)action1);
                    }
                    this.performRefactoring(writableUsageInfos);
                }
                finally {
                    if (refactoringId != null) {
                        ((RefactoringEventListener)this.myProject.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringDone(refactoringId, this.getAfterData(writableUsageInfos));
                    }
                }
            };
            ApplicationImpl app = (ApplicationImpl)ApplicationManagerEx.getApplicationEx();
            if (Registry.is((String)"run.refactorings.under.progress")) {
                app.runWriteActionWithProgressInDispatchThread(this.getCommandName(), this.myProject, null, null, (Consumer<ProgressIndicator>)((Consumer)indicator -> performRefactoringRunnable.run()));
            } else {
                app.runWriteAction(performRefactoringRunnable);
            }
            DumbService.getInstance((Project)this.myProject).completeJustSubmittedTasks();
            for (Map.Entry e : preparedData.entrySet()) {
                ((RefactoringHelper)e.getKey()).performOperation(this.myProject, e.getValue());
            }
            this.myTransaction.commit();
            app.runWriteAction(() -> this.performPsiSpoilingRefactoring());
        }
        finally {
            action.finish();
        }
        int count = writableUsageInfos.length;
        if (count > 0) {
            StatusBarUtil.setStatusBarInfo(this.myProject, RefactoringBundle.message((String)"statusBar.refactoring.result", (Object[])new Object[]{count}));
        } else if (!this.isPreviewUsages(writableUsageInfos)) {
            StatusBarUtil.setStatusBarInfo(this.myProject, RefactoringBundle.message((String)"statusBar.noUsages"));
        }
    }

    protected boolean isToBeChanged(@NotNull UsageInfo usageInfo) {
        if (usageInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageInfo", "com/intellij/refactoring/BaseRefactoringProcessor", "isToBeChanged"));
        }
        return usageInfo.isWritable();
    }

    protected void performPsiSpoilingRefactoring() {
    }

    protected void prepareSuccessful() {
        if (this.myPrepareSuccessfulSwingThreadCallback != null) {
            try {
                GuiUtils.runOrInvokeAndWait((Runnable)this.myPrepareSuccessfulSwingThreadCallback);
            }
            catch (InterruptedException | InvocationTargetException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    @Override
    public final void run() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            ApplicationManager.getApplication().assertIsDispatchThread();
            NonProjectFileWritingAccessProvider.disableChecksDuring(this::doRun);
            return;
        }
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            LOG.error("Refactorings should not be started inside write action\n because they start progress inside and any read action from the progress task would cause the deadlock", (Throwable)new Exception());
            DumbService.getInstance((Project)this.myProject).smartInvokeLater(() -> NonProjectFileWritingAccessProvider.disableChecksDuring(this::doRun));
        } else {
            NonProjectFileWritingAccessProvider.disableChecksDuring(this::doRun);
        }
    }

    @Deprecated
    protected boolean showConflicts(@NotNull MultiMap<PsiElement, String> conflicts) {
        if (conflicts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflicts", "com/intellij/refactoring/BaseRefactoringProcessor", "showConflicts"));
        }
        return this.showConflicts(conflicts, null);
    }

    protected boolean showConflicts(@NotNull MultiMap<PsiElement, String> conflicts, @Nullable UsageInfo[] usages) {
        if (conflicts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflicts", "com/intellij/refactoring/BaseRefactoringProcessor", "showConflicts"));
        }
        if (!conflicts.isEmpty() && ApplicationManager.getApplication().isUnitTestMode()) {
            if (!ConflictsInTestsException.isTestIgnore()) {
                throw new ConflictsInTestsException(conflicts.values());
            }
            return true;
        }
        if (this.myPrepareSuccessfulSwingThreadCallback != null && !conflicts.isEmpty()) {
            ConflictsDialog conflictsDialog;
            String refactoringId = this.getRefactoringId();
            if (refactoringId != null) {
                RefactoringEventData conflictUsages = new RefactoringEventData();
                conflictUsages.putUserData(RefactoringEventData.CONFLICTS_KEY, (Object)conflicts.values());
                ((RefactoringEventListener)this.myProject.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).conflictsDetected(refactoringId, conflictUsages);
            }
            if (!(conflictsDialog = this.prepareConflictsDialog(conflicts, usages)).showAndGet()) {
                if (conflictsDialog.isShowConflicts()) {
                    this.prepareSuccessful();
                }
                return false;
            }
        }
        this.prepareSuccessful();
        return true;
    }

    @NotNull
    protected ConflictsDialog prepareConflictsDialog(@NotNull MultiMap<PsiElement, String> conflicts, @Nullable UsageInfo[] usages) {
        if (conflicts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflicts", "com/intellij/refactoring/BaseRefactoringProcessor", "prepareConflictsDialog"));
        }
        ConflictsDialog conflictsDialog = this.createConflictsDialog(conflicts, usages);
        conflictsDialog.setCommandName(this.getCommandName());
        ConflictsDialog conflictsDialog2 = conflictsDialog;
        if (conflictsDialog2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/BaseRefactoringProcessor", "prepareConflictsDialog"));
        }
        return conflictsDialog2;
    }

    @Nullable
    protected RefactoringEventData getBeforeData() {
        return null;
    }

    @Nullable
    protected RefactoringEventData getAfterData(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/refactoring/BaseRefactoringProcessor", "getAfterData"));
        }
        return null;
    }

    @Nullable
    protected String getRefactoringId() {
        return null;
    }

    @NotNull
    protected ConflictsDialog createConflictsDialog(@NotNull MultiMap<PsiElement, String> conflicts, final @Nullable UsageInfo[] usages) {
        if (conflicts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflicts", "com/intellij/refactoring/BaseRefactoringProcessor", "createConflictsDialog"));
        }
        ConflictsDialog conflictsDialog = new ConflictsDialog(this.myProject, conflicts, usages == null ? null : new Runnable(){

            @Override
            public void run() {
                BaseRefactoringProcessor.this.execute(usages);
            }
        }, false, true);
        if (conflictsDialog == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/BaseRefactoringProcessor", "createConflictsDialog"));
        }
        return conflictsDialog;
    }

    @NotNull
    protected Collection<? extends PsiElement> getElementsToWrite(@NotNull UsageViewDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/refactoring/BaseRefactoringProcessor", "getElementsToWrite"));
        }
        List<PsiElement> list = Arrays.asList(descriptor.getElements());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/BaseRefactoringProcessor", "getElementsToWrite"));
        }
        return list;
    }

    private static class UndoRefactoringAction
    extends BasicUndoableAction {
        private final Project myProject;
        private final String myRefactoringId;

        public UndoRefactoringAction(Project project2, String refactoringId) {
            this.myProject = project2;
            this.myRefactoringId = refactoringId;
        }

        public void undo() {
            ((RefactoringEventListener)this.myProject.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).undoRefactoring(this.myRefactoringId);
        }

        public void redo() {
        }
    }

    public static class UnknownReferenceTypeException
    extends RuntimeException {
        private final Language myElementLanguage;

        public UnknownReferenceTypeException(@NotNull Language elementLanguage) {
            if (elementLanguage == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementLanguage", "com/intellij/refactoring/BaseRefactoringProcessor$UnknownReferenceTypeException", "<init>"));
            }
            this.myElementLanguage = elementLanguage;
        }

        @NotNull
        public Language getElementLanguage() {
            Language language = this.myElementLanguage;
            if (language == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/BaseRefactoringProcessor$UnknownReferenceTypeException", "getElementLanguage"));
            }
            return language;
        }
    }

    public static class ConflictsInTestsException
    extends RuntimeException {
        private final Collection<? extends String> messages;
        private static boolean myTestIgnore;

        public ConflictsInTestsException(@NotNull Collection<? extends String> messages) {
            if (messages == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messages", "com/intellij/refactoring/BaseRefactoringProcessor$ConflictsInTestsException", "<init>"));
            }
            this.messages = messages;
        }

        public static void setTestIgnore(boolean myIgnore) {
            myTestIgnore = myIgnore;
        }

        public static boolean isTestIgnore() {
            return myTestIgnore;
        }

        @NotNull
        public Collection<String> getMessages() {
            ArrayList<String> result2 = new ArrayList<String>(this.messages);
            for (int i2 = 0; i2 < this.messages.size(); ++i2) {
                result2.set(i2, ((String)result2.get(i2)).replaceAll("<[^>]+>", ""));
            }
            ArrayList<String> arrayList = result2;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/BaseRefactoringProcessor$ConflictsInTestsException", "getMessages"));
            }
            return arrayList;
        }

        @Override
        public String getMessage() {
            ArrayList<? extends String> result2 = new ArrayList<String>(this.messages);
            Collections.sort(result2);
            return StringUtil.join(result2, (String)"\n");
        }
    }
}

